/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.loan;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.doc.ValidationModel;
import fpml.consolidated.loan.EventPayment;
import fpml.consolidated.loan.meta.AbstractServicingNotificationMeta;
import fpml.consolidated.msg.CorrectableRequestMessage;
import fpml.consolidated.msg.CorrelationAndSequenceModel;
import fpml.consolidated.msg.RequestMessageHeader;
import fpml.consolidated.shared.OnBehalfOfModel;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="AbstractServicingNotification", builder=AbstractServicingNotificationBuilderImpl.class, version="1.1.0")
@RuneDataType(value="AbstractServicingNotification", model="fpml", builder=AbstractServicingNotificationBuilderImpl.class, version="1.1.0")
public interface AbstractServicingNotification
extends CorrectableRequestMessage {
    public static final AbstractServicingNotificationMeta metaData = new AbstractServicingNotificationMeta();

    public ZonedDateTime getNoticeDate();

    public Boolean getIsGlobalOnly();

    public List<? extends EventPayment> getEventPayment();

    @Override
    public AbstractServicingNotification build();

    @Override
    public AbstractServicingNotificationBuilder toBuilder();

    public static AbstractServicingNotificationBuilder builder() {
        return new AbstractServicingNotificationBuilderImpl();
    }

    default public RosettaMetaData<? extends AbstractServicingNotification> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends AbstractServicingNotification> getType() {
        return AbstractServicingNotification.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("fpmlVersion"), String.class, (Object)this.getFpmlVersion(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("expectedBuild"), Integer.class, (Object)this.getExpectedBuild(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("actualBuild"), Integer.class, (Object)this.getActualBuild(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("header"), processor, RequestMessageHeader.class, this.getHeader(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("validationModel"), processor, ValidationModel.class, this.getValidationModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("isCorrection"), Boolean.class, (Object)this.getIsCorrection(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("correlationAndSequenceModel"), processor, CorrelationAndSequenceModel.class, this.getCorrelationAndSequenceModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("onBehalfOfModel"), processor, OnBehalfOfModel.class, this.getOnBehalfOfModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("noticeDate"), ZonedDateTime.class, (Object)this.getNoticeDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("isGlobalOnly"), Boolean.class, (Object)this.getIsGlobalOnly(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("eventPayment"), processor, EventPayment.class, this.getEventPayment(), new AttributeMeta[0]);
    }

    public static class AbstractServicingNotificationBuilderImpl
    extends CorrectableRequestMessage.CorrectableRequestMessageBuilderImpl
    implements AbstractServicingNotificationBuilder {
        protected ZonedDateTime noticeDate;
        protected Boolean isGlobalOnly;
        protected List<EventPayment.EventPaymentBuilder> eventPayment = new ArrayList<EventPayment.EventPaymentBuilder>();

        @Override
        @RosettaAttribute(value="noticeDate", isRequired=true)
        @RuneAttribute(value="noticeDate", isRequired=true)
        public ZonedDateTime getNoticeDate() {
            return this.noticeDate;
        }

        @Override
        @RosettaAttribute(value="isGlobalOnly", isRequired=true)
        @RuneAttribute(value="isGlobalOnly", isRequired=true)
        public Boolean getIsGlobalOnly() {
            return this.isGlobalOnly;
        }

        @Override
        @RosettaAttribute(value="eventPayment")
        @RuneAttribute(value="eventPayment")
        public List<? extends EventPayment.EventPaymentBuilder> getEventPayment() {
            return this.eventPayment;
        }

        @Override
        public EventPayment.EventPaymentBuilder getOrCreateEventPayment(int index) {
            if (this.eventPayment == null) {
                this.eventPayment = new ArrayList<EventPayment.EventPaymentBuilder>();
            }
            return (EventPayment.EventPaymentBuilder)this.getIndex(this.eventPayment, index, () -> {
                EventPayment.EventPaymentBuilder newEventPayment = EventPayment.builder();
                return newEventPayment;
            });
        }

        @Override
        @RosettaAttribute(value="fpmlVersion", isRequired=true)
        @RuneAttribute(value="fpmlVersion", isRequired=true)
        public AbstractServicingNotificationBuilder setFpmlVersion(String _fpmlVersion) {
            this.fpmlVersion = _fpmlVersion == null ? null : _fpmlVersion;
            return this;
        }

        @Override
        @RosettaAttribute(value="expectedBuild")
        @RuneAttribute(value="expectedBuild")
        public AbstractServicingNotificationBuilder setExpectedBuild(Integer _expectedBuild) {
            this.expectedBuild = _expectedBuild == null ? null : _expectedBuild;
            return this;
        }

        @Override
        @RosettaAttribute(value="actualBuild")
        @RuneAttribute(value="actualBuild")
        public AbstractServicingNotificationBuilder setActualBuild(Integer _actualBuild) {
            this.actualBuild = _actualBuild == null ? null : _actualBuild;
            return this;
        }

        @Override
        @RosettaAttribute(value="header")
        @RuneAttribute(value="header")
        public AbstractServicingNotificationBuilder setHeader(RequestMessageHeader _header) {
            this.header = _header == null ? null : _header.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="validationModel", isRequired=true)
        @RuneAttribute(value="validationModel", isRequired=true)
        public AbstractServicingNotificationBuilder setValidationModel(ValidationModel _validationModel) {
            this.validationModel = _validationModel == null ? null : _validationModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="isCorrection")
        @RuneAttribute(value="isCorrection")
        public AbstractServicingNotificationBuilder setIsCorrection(Boolean _isCorrection) {
            this.isCorrection = _isCorrection == null ? null : _isCorrection;
            return this;
        }

        @Override
        @RosettaAttribute(value="correlationAndSequenceModel")
        @RuneAttribute(value="correlationAndSequenceModel")
        public AbstractServicingNotificationBuilder setCorrelationAndSequenceModel(CorrelationAndSequenceModel _correlationAndSequenceModel) {
            this.correlationAndSequenceModel = _correlationAndSequenceModel == null ? null : _correlationAndSequenceModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="onBehalfOfModel")
        @RuneAttribute(value="onBehalfOfModel")
        public AbstractServicingNotificationBuilder setOnBehalfOfModel(OnBehalfOfModel _onBehalfOfModel) {
            this.onBehalfOfModel = _onBehalfOfModel == null ? null : _onBehalfOfModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="noticeDate", isRequired=true)
        @RuneAttribute(value="noticeDate", isRequired=true)
        public AbstractServicingNotificationBuilder setNoticeDate(ZonedDateTime _noticeDate) {
            this.noticeDate = _noticeDate == null ? null : _noticeDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="isGlobalOnly", isRequired=true)
        @RuneAttribute(value="isGlobalOnly", isRequired=true)
        public AbstractServicingNotificationBuilder setIsGlobalOnly(Boolean _isGlobalOnly) {
            this.isGlobalOnly = _isGlobalOnly == null ? null : _isGlobalOnly;
            return this;
        }

        @Override
        @RosettaAttribute(value="eventPayment")
        @RuneAttribute(value="eventPayment")
        public AbstractServicingNotificationBuilder addEventPayment(EventPayment _eventPayment) {
            if (_eventPayment != null) {
                this.eventPayment.add(_eventPayment.toBuilder());
            }
            return this;
        }

        @Override
        public AbstractServicingNotificationBuilder addEventPayment(EventPayment _eventPayment, int idx) {
            this.getIndex(this.eventPayment, idx, () -> _eventPayment.toBuilder());
            return this;
        }

        @Override
        public AbstractServicingNotificationBuilder addEventPayment(List<? extends EventPayment> eventPayments) {
            if (eventPayments != null) {
                for (EventPayment eventPayment : eventPayments) {
                    this.eventPayment.add(eventPayment.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="eventPayment")
        public AbstractServicingNotificationBuilder setEventPayment(List<? extends EventPayment> eventPayments) {
            this.eventPayment = eventPayments == null ? new ArrayList<EventPayment.EventPaymentBuilder>() : (List)eventPayments.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public AbstractServicingNotification build() {
            return new AbstractServicingNotificationImpl(this);
        }

        @Override
        public AbstractServicingNotificationBuilder toBuilder() {
            return this;
        }

        @Override
        public AbstractServicingNotificationBuilder prune() {
            super.prune();
            this.eventPayment = this.eventPayment.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getNoticeDate() != null) {
                return true;
            }
            if (this.getIsGlobalOnly() != null) {
                return true;
            }
            return this.getEventPayment() != null && this.getEventPayment().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        @Override
        public AbstractServicingNotificationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            AbstractServicingNotificationBuilder o = (AbstractServicingNotificationBuilder)other;
            merger.mergeRosetta(this.getEventPayment(), o.getEventPayment(), this::getOrCreateEventPayment);
            merger.mergeBasic((Object)this.getNoticeDate(), (Object)o.getNoticeDate(), this::setNoticeDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getIsGlobalOnly(), (Object)o.getIsGlobalOnly(), this::setIsGlobalOnly, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            AbstractServicingNotification _that = (AbstractServicingNotification)this.getType().cast(o);
            if (!Objects.equals(this.noticeDate, _that.getNoticeDate())) {
                return false;
            }
            if (!Objects.equals(this.isGlobalOnly, _that.getIsGlobalOnly())) {
                return false;
            }
            return ListEquals.listEquals(this.eventPayment, _that.getEventPayment());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.noticeDate != null ? this.noticeDate.hashCode() : 0);
            _result = 31 * _result + (this.isGlobalOnly != null ? this.isGlobalOnly.hashCode() : 0);
            _result = 31 * _result + (this.eventPayment != null ? this.eventPayment.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "AbstractServicingNotificationBuilder {noticeDate=" + this.noticeDate + ", isGlobalOnly=" + this.isGlobalOnly + ", eventPayment=" + this.eventPayment + '}' + " " + super.toString();
        }
    }

    public static interface AbstractServicingNotificationBuilder
    extends AbstractServicingNotification,
    CorrectableRequestMessage.CorrectableRequestMessageBuilder {
        public EventPayment.EventPaymentBuilder getOrCreateEventPayment(int var1);

        public List<? extends EventPayment.EventPaymentBuilder> getEventPayment();

        @Override
        public AbstractServicingNotificationBuilder setFpmlVersion(String var1);

        @Override
        public AbstractServicingNotificationBuilder setExpectedBuild(Integer var1);

        @Override
        public AbstractServicingNotificationBuilder setActualBuild(Integer var1);

        @Override
        public AbstractServicingNotificationBuilder setHeader(RequestMessageHeader var1);

        @Override
        public AbstractServicingNotificationBuilder setValidationModel(ValidationModel var1);

        @Override
        public AbstractServicingNotificationBuilder setIsCorrection(Boolean var1);

        @Override
        public AbstractServicingNotificationBuilder setCorrelationAndSequenceModel(CorrelationAndSequenceModel var1);

        @Override
        public AbstractServicingNotificationBuilder setOnBehalfOfModel(OnBehalfOfModel var1);

        public AbstractServicingNotificationBuilder setNoticeDate(ZonedDateTime var1);

        public AbstractServicingNotificationBuilder setIsGlobalOnly(Boolean var1);

        public AbstractServicingNotificationBuilder addEventPayment(EventPayment var1);

        public AbstractServicingNotificationBuilder addEventPayment(EventPayment var1, int var2);

        public AbstractServicingNotificationBuilder addEventPayment(List<? extends EventPayment> var1);

        public AbstractServicingNotificationBuilder setEventPayment(List<? extends EventPayment> var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("fpmlVersion"), String.class, (Object)this.getFpmlVersion(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("expectedBuild"), Integer.class, (Object)this.getExpectedBuild(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("actualBuild"), Integer.class, (Object)this.getActualBuild(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("header"), processor, RequestMessageHeader.RequestMessageHeaderBuilder.class, (RosettaModelObjectBuilder)this.getHeader(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("validationModel"), processor, ValidationModel.ValidationModelBuilder.class, (RosettaModelObjectBuilder)this.getValidationModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("isCorrection"), Boolean.class, (Object)this.getIsCorrection(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("correlationAndSequenceModel"), processor, CorrelationAndSequenceModel.CorrelationAndSequenceModelBuilder.class, (RosettaModelObjectBuilder)this.getCorrelationAndSequenceModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("onBehalfOfModel"), processor, OnBehalfOfModel.OnBehalfOfModelBuilder.class, (RosettaModelObjectBuilder)this.getOnBehalfOfModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("noticeDate"), ZonedDateTime.class, (Object)this.getNoticeDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("isGlobalOnly"), Boolean.class, (Object)this.getIsGlobalOnly(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("eventPayment"), processor, EventPayment.EventPaymentBuilder.class, this.getEventPayment(), new AttributeMeta[0]);
        }

        @Override
        public AbstractServicingNotificationBuilder prune();
    }

    public static class AbstractServicingNotificationImpl
    extends CorrectableRequestMessage.CorrectableRequestMessageImpl
    implements AbstractServicingNotification {
        private final ZonedDateTime noticeDate;
        private final Boolean isGlobalOnly;
        private final List<? extends EventPayment> eventPayment;

        protected AbstractServicingNotificationImpl(AbstractServicingNotificationBuilder builder) {
            super(builder);
            this.noticeDate = builder.getNoticeDate();
            this.isGlobalOnly = builder.getIsGlobalOnly();
            this.eventPayment = Optional.ofNullable(builder.getEventPayment()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="noticeDate", isRequired=true)
        @RuneAttribute(value="noticeDate", isRequired=true)
        public ZonedDateTime getNoticeDate() {
            return this.noticeDate;
        }

        @Override
        @RosettaAttribute(value="isGlobalOnly", isRequired=true)
        @RuneAttribute(value="isGlobalOnly", isRequired=true)
        public Boolean getIsGlobalOnly() {
            return this.isGlobalOnly;
        }

        @Override
        @RosettaAttribute(value="eventPayment")
        @RuneAttribute(value="eventPayment")
        public List<? extends EventPayment> getEventPayment() {
            return this.eventPayment;
        }

        @Override
        public AbstractServicingNotification build() {
            return this;
        }

        @Override
        public AbstractServicingNotificationBuilder toBuilder() {
            AbstractServicingNotificationBuilder builder = AbstractServicingNotification.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(AbstractServicingNotificationBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getNoticeDate()).ifPresent(builder::setNoticeDate);
            Optional.ofNullable(this.getIsGlobalOnly()).ifPresent(builder::setIsGlobalOnly);
            Optional.ofNullable(this.getEventPayment()).ifPresent(builder::setEventPayment);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            AbstractServicingNotification _that = (AbstractServicingNotification)this.getType().cast(o);
            if (!Objects.equals(this.noticeDate, _that.getNoticeDate())) {
                return false;
            }
            if (!Objects.equals(this.isGlobalOnly, _that.getIsGlobalOnly())) {
                return false;
            }
            return ListEquals.listEquals(this.eventPayment, _that.getEventPayment());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.noticeDate != null ? this.noticeDate.hashCode() : 0);
            _result = 31 * _result + (this.isGlobalOnly != null ? this.isGlobalOnly.hashCode() : 0);
            _result = 31 * _result + (this.eventPayment != null ? this.eventPayment.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "AbstractServicingNotification {noticeDate=" + this.noticeDate + ", isGlobalOnly=" + this.isGlobalOnly + ", eventPayment=" + this.eventPayment + '}' + " " + super.toString();
        }
    }
}

