/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.loan;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.business.events.BusinessEventIdentifier;
import fpml.consolidated.loan.AbstractLoanEventSequence;
import fpml.consolidated.loan.AbstractLoanServicingEvent;
import fpml.consolidated.loan.BusinessEventPartiesModel;
import fpml.consolidated.loan.LenderAndCashDetailsModel;
import fpml.consolidated.loan.LetterOfCreditReference;
import fpml.consolidated.loan.LoanLegalActionReference;
import fpml.consolidated.loan.meta.AbstractLcEventMeta;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="AbstractLcEvent", builder=AbstractLcEventBuilderImpl.class, version="1.1.0")
@RuneDataType(value="AbstractLcEvent", model="fpml", builder=AbstractLcEventBuilderImpl.class, version="1.1.0")
public interface AbstractLcEvent
extends AbstractLoanServicingEvent {
    public static final AbstractLcEventMeta metaData = new AbstractLcEventMeta();

    public LetterOfCreditReference getLetterOfCreditReference();

    @Override
    public AbstractLcEvent build();

    @Override
    public AbstractLcEventBuilder toBuilder();

    public static AbstractLcEventBuilder builder() {
        return new AbstractLcEventBuilderImpl();
    }

    default public RosettaMetaData<? extends AbstractLcEvent> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends AbstractLcEvent> getType() {
        return AbstractLcEvent.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("eventIdentifier"), processor, BusinessEventIdentifier.class, this.getEventIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("abstractLoanEventSequence"), processor, AbstractLoanEventSequence.class, this.getAbstractLoanEventSequence(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("lenderAndCashDetailsModel"), processor, LenderAndCashDetailsModel.class, this.getLenderAndCashDetailsModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("comment"), String.class, (Object)this.getComment(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("businessEventPartiesModel"), processor, BusinessEventPartiesModel.class, this.getBusinessEventPartiesModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("effectiveDate"), ZonedDateTime.class, (Object)this.getEffectiveDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("legalActionReference"), processor, LoanLegalActionReference.class, this.getLegalActionReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("letterOfCreditReference"), processor, LetterOfCreditReference.class, this.getLetterOfCreditReference(), new AttributeMeta[0]);
    }

    public static class AbstractLcEventBuilderImpl
    extends AbstractLoanServicingEvent.AbstractLoanServicingEventBuilderImpl
    implements AbstractLcEventBuilder {
        protected LetterOfCreditReference.LetterOfCreditReferenceBuilder letterOfCreditReference;

        @Override
        @RosettaAttribute(value="letterOfCreditReference", isRequired=true)
        @RuneAttribute(value="letterOfCreditReference", isRequired=true)
        public LetterOfCreditReference.LetterOfCreditReferenceBuilder getLetterOfCreditReference() {
            return this.letterOfCreditReference;
        }

        @Override
        public LetterOfCreditReference.LetterOfCreditReferenceBuilder getOrCreateLetterOfCreditReference() {
            LetterOfCreditReference.LetterOfCreditReferenceBuilder result = this.letterOfCreditReference != null ? this.letterOfCreditReference : (this.letterOfCreditReference = LetterOfCreditReference.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="eventIdentifier", isRequired=true)
        @RuneAttribute(value="eventIdentifier", isRequired=true)
        public AbstractLcEventBuilder addEventIdentifier(BusinessEventIdentifier _eventIdentifier) {
            if (_eventIdentifier != null) {
                this.eventIdentifier.add(_eventIdentifier.toBuilder());
            }
            return this;
        }

        @Override
        public AbstractLcEventBuilder addEventIdentifier(BusinessEventIdentifier _eventIdentifier, int idx) {
            this.getIndex(this.eventIdentifier, idx, () -> _eventIdentifier.toBuilder());
            return this;
        }

        @Override
        public AbstractLcEventBuilder addEventIdentifier(List<? extends BusinessEventIdentifier> eventIdentifiers) {
            if (eventIdentifiers != null) {
                for (BusinessEventIdentifier businessEventIdentifier : eventIdentifiers) {
                    this.eventIdentifier.add(businessEventIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="eventIdentifier")
        public AbstractLcEventBuilder setEventIdentifier(List<? extends BusinessEventIdentifier> eventIdentifiers) {
            this.eventIdentifier = eventIdentifiers == null ? new ArrayList() : (List)eventIdentifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="abstractLoanEventSequence")
        @RuneAttribute(value="abstractLoanEventSequence")
        public AbstractLcEventBuilder setAbstractLoanEventSequence(AbstractLoanEventSequence _abstractLoanEventSequence) {
            this.abstractLoanEventSequence = _abstractLoanEventSequence == null ? null : _abstractLoanEventSequence.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="lenderAndCashDetailsModel")
        @RuneAttribute(value="lenderAndCashDetailsModel")
        public AbstractLcEventBuilder setLenderAndCashDetailsModel(LenderAndCashDetailsModel _lenderAndCashDetailsModel) {
            this.lenderAndCashDetailsModel = _lenderAndCashDetailsModel == null ? null : _lenderAndCashDetailsModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="comment")
        @RuneAttribute(value="comment")
        public AbstractLcEventBuilder setComment(String _comment) {
            this.comment = _comment == null ? null : _comment;
            return this;
        }

        @Override
        @RosettaAttribute(value="businessEventPartiesModel", isRequired=true)
        @RuneAttribute(value="businessEventPartiesModel", isRequired=true)
        public AbstractLcEventBuilder setBusinessEventPartiesModel(BusinessEventPartiesModel _businessEventPartiesModel) {
            this.businessEventPartiesModel = _businessEventPartiesModel == null ? null : _businessEventPartiesModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="effectiveDate", isRequired=true)
        @RuneAttribute(value="effectiveDate", isRequired=true)
        public AbstractLcEventBuilder setEffectiveDate(ZonedDateTime _effectiveDate) {
            this.effectiveDate = _effectiveDate == null ? null : _effectiveDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="legalActionReference")
        @RuneAttribute(value="legalActionReference")
        public AbstractLcEventBuilder setLegalActionReference(LoanLegalActionReference _legalActionReference) {
            this.legalActionReference = _legalActionReference == null ? null : _legalActionReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="letterOfCreditReference", isRequired=true)
        @RuneAttribute(value="letterOfCreditReference", isRequired=true)
        public AbstractLcEventBuilder setLetterOfCreditReference(LetterOfCreditReference _letterOfCreditReference) {
            this.letterOfCreditReference = _letterOfCreditReference == null ? null : _letterOfCreditReference.toBuilder();
            return this;
        }

        @Override
        public AbstractLcEvent build() {
            return new AbstractLcEventImpl(this);
        }

        @Override
        public AbstractLcEventBuilder toBuilder() {
            return this;
        }

        @Override
        public AbstractLcEventBuilder prune() {
            super.prune();
            if (this.letterOfCreditReference != null && !this.letterOfCreditReference.prune().hasData()) {
                this.letterOfCreditReference = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            return this.getLetterOfCreditReference() != null && this.getLetterOfCreditReference().hasData();
        }

        @Override
        public AbstractLcEventBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            AbstractLcEventBuilder o = (AbstractLcEventBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getLetterOfCreditReference(), (RosettaModelObjectBuilder)o.getLetterOfCreditReference(), this::setLetterOfCreditReference);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            AbstractLcEvent _that = (AbstractLcEvent)this.getType().cast(o);
            return Objects.equals(this.letterOfCreditReference, _that.getLetterOfCreditReference());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.letterOfCreditReference != null ? this.letterOfCreditReference.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "AbstractLcEventBuilder {letterOfCreditReference=" + this.letterOfCreditReference + '}' + " " + super.toString();
        }
    }

    public static interface AbstractLcEventBuilder
    extends AbstractLcEvent,
    AbstractLoanServicingEvent.AbstractLoanServicingEventBuilder {
        public LetterOfCreditReference.LetterOfCreditReferenceBuilder getOrCreateLetterOfCreditReference();

        @Override
        public LetterOfCreditReference.LetterOfCreditReferenceBuilder getLetterOfCreditReference();

        @Override
        public AbstractLcEventBuilder addEventIdentifier(BusinessEventIdentifier var1);

        @Override
        public AbstractLcEventBuilder addEventIdentifier(BusinessEventIdentifier var1, int var2);

        @Override
        public AbstractLcEventBuilder addEventIdentifier(List<? extends BusinessEventIdentifier> var1);

        @Override
        public AbstractLcEventBuilder setEventIdentifier(List<? extends BusinessEventIdentifier> var1);

        @Override
        public AbstractLcEventBuilder setAbstractLoanEventSequence(AbstractLoanEventSequence var1);

        @Override
        public AbstractLcEventBuilder setLenderAndCashDetailsModel(LenderAndCashDetailsModel var1);

        @Override
        public AbstractLcEventBuilder setComment(String var1);

        @Override
        public AbstractLcEventBuilder setBusinessEventPartiesModel(BusinessEventPartiesModel var1);

        @Override
        public AbstractLcEventBuilder setEffectiveDate(ZonedDateTime var1);

        @Override
        public AbstractLcEventBuilder setLegalActionReference(LoanLegalActionReference var1);

        public AbstractLcEventBuilder setLetterOfCreditReference(LetterOfCreditReference var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("eventIdentifier"), processor, BusinessEventIdentifier.BusinessEventIdentifierBuilder.class, this.getEventIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("abstractLoanEventSequence"), processor, AbstractLoanEventSequence.AbstractLoanEventSequenceBuilder.class, (RosettaModelObjectBuilder)this.getAbstractLoanEventSequence(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("lenderAndCashDetailsModel"), processor, LenderAndCashDetailsModel.LenderAndCashDetailsModelBuilder.class, (RosettaModelObjectBuilder)this.getLenderAndCashDetailsModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("comment"), String.class, (Object)this.getComment(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("businessEventPartiesModel"), processor, BusinessEventPartiesModel.BusinessEventPartiesModelBuilder.class, (RosettaModelObjectBuilder)this.getBusinessEventPartiesModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("effectiveDate"), ZonedDateTime.class, (Object)this.getEffectiveDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("legalActionReference"), processor, LoanLegalActionReference.LoanLegalActionReferenceBuilder.class, (RosettaModelObjectBuilder)this.getLegalActionReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("letterOfCreditReference"), processor, LetterOfCreditReference.LetterOfCreditReferenceBuilder.class, this.getLetterOfCreditReference(), new AttributeMeta[0]);
        }

        @Override
        public AbstractLcEventBuilder prune();
    }

    public static class AbstractLcEventImpl
    extends AbstractLoanServicingEvent.AbstractLoanServicingEventImpl
    implements AbstractLcEvent {
        private final LetterOfCreditReference letterOfCreditReference;

        protected AbstractLcEventImpl(AbstractLcEventBuilder builder) {
            super(builder);
            this.letterOfCreditReference = Optional.ofNullable(builder.getLetterOfCreditReference()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="letterOfCreditReference", isRequired=true)
        @RuneAttribute(value="letterOfCreditReference", isRequired=true)
        public LetterOfCreditReference getLetterOfCreditReference() {
            return this.letterOfCreditReference;
        }

        @Override
        public AbstractLcEvent build() {
            return this;
        }

        @Override
        public AbstractLcEventBuilder toBuilder() {
            AbstractLcEventBuilder builder = AbstractLcEvent.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(AbstractLcEventBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getLetterOfCreditReference()).ifPresent(builder::setLetterOfCreditReference);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            AbstractLcEvent _that = (AbstractLcEvent)this.getType().cast(o);
            return Objects.equals(this.letterOfCreditReference, _that.getLetterOfCreditReference());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.letterOfCreditReference != null ? this.letterOfCreditReference.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "AbstractLcEvent {letterOfCreditReference=" + this.letterOfCreditReference + '}' + " " + super.toString();
        }
    }
}

