/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.ird;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.ird.CalculationPeriod;
import fpml.consolidated.ird.meta.PaymentCalculationPeriodMeta;
import fpml.consolidated.shared.Money;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="PaymentCalculationPeriod", builder=PaymentCalculationPeriodBuilderImpl.class, version="1.1.0")
@RuneDataType(value="PaymentCalculationPeriod", model="fpml", builder=PaymentCalculationPeriodBuilderImpl.class, version="1.1.0")
public interface PaymentCalculationPeriod
extends RosettaModelObject {
    public static final PaymentCalculationPeriodMeta metaData = new PaymentCalculationPeriodMeta();

    public ZonedDateTime getUnadjustedPaymentDate();

    public ZonedDateTime getAdjustedPaymentDate();

    public List<? extends CalculationPeriod> getCalculationPeriod();

    public BigDecimal getFixedPaymentAmount();

    public BigDecimal getDiscountFactor();

    public Money getForecastPaymentAmount();

    public Money getPresentValueAmount();

    public String getId();

    public String getHref();

    public PaymentCalculationPeriod build();

    public PaymentCalculationPeriodBuilder toBuilder();

    public static PaymentCalculationPeriodBuilder builder() {
        return new PaymentCalculationPeriodBuilderImpl();
    }

    default public RosettaMetaData<? extends PaymentCalculationPeriod> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends PaymentCalculationPeriod> getType() {
        return PaymentCalculationPeriod.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("unadjustedPaymentDate"), ZonedDateTime.class, (Object)this.getUnadjustedPaymentDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("adjustedPaymentDate"), ZonedDateTime.class, (Object)this.getAdjustedPaymentDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("calculationPeriod"), processor, CalculationPeriod.class, this.getCalculationPeriod(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("fixedPaymentAmount"), BigDecimal.class, (Object)this.getFixedPaymentAmount(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("discountFactor"), BigDecimal.class, (Object)this.getDiscountFactor(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("forecastPaymentAmount"), processor, Money.class, this.getForecastPaymentAmount(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("presentValueAmount"), processor, Money.class, this.getPresentValueAmount(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("href"), String.class, (Object)this.getHref(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class PaymentCalculationPeriodBuilderImpl
    implements PaymentCalculationPeriodBuilder {
        protected ZonedDateTime unadjustedPaymentDate;
        protected ZonedDateTime adjustedPaymentDate;
        protected List<CalculationPeriod.CalculationPeriodBuilder> calculationPeriod = new ArrayList<CalculationPeriod.CalculationPeriodBuilder>();
        protected BigDecimal fixedPaymentAmount;
        protected BigDecimal discountFactor;
        protected Money.MoneyBuilder forecastPaymentAmount;
        protected Money.MoneyBuilder presentValueAmount;
        protected String id;
        protected String href;

        @Override
        @RosettaAttribute(value="unadjustedPaymentDate")
        @RuneAttribute(value="unadjustedPaymentDate")
        public ZonedDateTime getUnadjustedPaymentDate() {
            return this.unadjustedPaymentDate;
        }

        @Override
        @RosettaAttribute(value="adjustedPaymentDate")
        @RuneAttribute(value="adjustedPaymentDate")
        public ZonedDateTime getAdjustedPaymentDate() {
            return this.adjustedPaymentDate;
        }

        @Override
        @RosettaAttribute(value="calculationPeriod")
        @RuneAttribute(value="calculationPeriod")
        public List<? extends CalculationPeriod.CalculationPeriodBuilder> getCalculationPeriod() {
            return this.calculationPeriod;
        }

        @Override
        public CalculationPeriod.CalculationPeriodBuilder getOrCreateCalculationPeriod(int index) {
            if (this.calculationPeriod == null) {
                this.calculationPeriod = new ArrayList<CalculationPeriod.CalculationPeriodBuilder>();
            }
            return (CalculationPeriod.CalculationPeriodBuilder)this.getIndex(this.calculationPeriod, index, () -> {
                CalculationPeriod.CalculationPeriodBuilder newCalculationPeriod = CalculationPeriod.builder();
                return newCalculationPeriod;
            });
        }

        @Override
        @RosettaAttribute(value="fixedPaymentAmount")
        @RuneAttribute(value="fixedPaymentAmount")
        public BigDecimal getFixedPaymentAmount() {
            return this.fixedPaymentAmount;
        }

        @Override
        @RosettaAttribute(value="discountFactor")
        @RuneAttribute(value="discountFactor")
        public BigDecimal getDiscountFactor() {
            return this.discountFactor;
        }

        @Override
        @RosettaAttribute(value="forecastPaymentAmount")
        @RuneAttribute(value="forecastPaymentAmount")
        public Money.MoneyBuilder getForecastPaymentAmount() {
            return this.forecastPaymentAmount;
        }

        @Override
        public Money.MoneyBuilder getOrCreateForecastPaymentAmount() {
            Money.MoneyBuilder result = this.forecastPaymentAmount != null ? this.forecastPaymentAmount : (this.forecastPaymentAmount = Money.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="presentValueAmount")
        @RuneAttribute(value="presentValueAmount")
        public Money.MoneyBuilder getPresentValueAmount() {
            return this.presentValueAmount;
        }

        @Override
        public Money.MoneyBuilder getOrCreatePresentValueAmount() {
            Money.MoneyBuilder result = this.presentValueAmount != null ? this.presentValueAmount : (this.presentValueAmount = Money.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public String getId() {
            return this.id;
        }

        @Override
        @RosettaAttribute(value="href")
        @RuneAttribute(value="href")
        public String getHref() {
            return this.href;
        }

        @Override
        @RosettaAttribute(value="unadjustedPaymentDate")
        @RuneAttribute(value="unadjustedPaymentDate")
        public PaymentCalculationPeriodBuilder setUnadjustedPaymentDate(ZonedDateTime _unadjustedPaymentDate) {
            this.unadjustedPaymentDate = _unadjustedPaymentDate == null ? null : _unadjustedPaymentDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="adjustedPaymentDate")
        @RuneAttribute(value="adjustedPaymentDate")
        public PaymentCalculationPeriodBuilder setAdjustedPaymentDate(ZonedDateTime _adjustedPaymentDate) {
            this.adjustedPaymentDate = _adjustedPaymentDate == null ? null : _adjustedPaymentDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="calculationPeriod")
        @RuneAttribute(value="calculationPeriod")
        public PaymentCalculationPeriodBuilder addCalculationPeriod(CalculationPeriod _calculationPeriod) {
            if (_calculationPeriod != null) {
                this.calculationPeriod.add(_calculationPeriod.toBuilder());
            }
            return this;
        }

        @Override
        public PaymentCalculationPeriodBuilder addCalculationPeriod(CalculationPeriod _calculationPeriod, int idx) {
            this.getIndex(this.calculationPeriod, idx, () -> _calculationPeriod.toBuilder());
            return this;
        }

        @Override
        public PaymentCalculationPeriodBuilder addCalculationPeriod(List<? extends CalculationPeriod> calculationPeriods) {
            if (calculationPeriods != null) {
                for (CalculationPeriod calculationPeriod : calculationPeriods) {
                    this.calculationPeriod.add(calculationPeriod.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="calculationPeriod")
        public PaymentCalculationPeriodBuilder setCalculationPeriod(List<? extends CalculationPeriod> calculationPeriods) {
            this.calculationPeriod = calculationPeriods == null ? new ArrayList<CalculationPeriod.CalculationPeriodBuilder>() : (List)calculationPeriods.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="fixedPaymentAmount")
        @RuneAttribute(value="fixedPaymentAmount")
        public PaymentCalculationPeriodBuilder setFixedPaymentAmount(BigDecimal _fixedPaymentAmount) {
            this.fixedPaymentAmount = _fixedPaymentAmount == null ? null : _fixedPaymentAmount;
            return this;
        }

        @Override
        @RosettaAttribute(value="discountFactor")
        @RuneAttribute(value="discountFactor")
        public PaymentCalculationPeriodBuilder setDiscountFactor(BigDecimal _discountFactor) {
            this.discountFactor = _discountFactor == null ? null : _discountFactor;
            return this;
        }

        @Override
        @RosettaAttribute(value="forecastPaymentAmount")
        @RuneAttribute(value="forecastPaymentAmount")
        public PaymentCalculationPeriodBuilder setForecastPaymentAmount(Money _forecastPaymentAmount) {
            this.forecastPaymentAmount = _forecastPaymentAmount == null ? null : _forecastPaymentAmount.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="presentValueAmount")
        @RuneAttribute(value="presentValueAmount")
        public PaymentCalculationPeriodBuilder setPresentValueAmount(Money _presentValueAmount) {
            this.presentValueAmount = _presentValueAmount == null ? null : _presentValueAmount.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public PaymentCalculationPeriodBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="href")
        @RuneAttribute(value="href")
        public PaymentCalculationPeriodBuilder setHref(String _href) {
            this.href = _href == null ? null : _href;
            return this;
        }

        @Override
        public PaymentCalculationPeriod build() {
            return new PaymentCalculationPeriodImpl(this);
        }

        @Override
        public PaymentCalculationPeriodBuilder toBuilder() {
            return this;
        }

        @Override
        public PaymentCalculationPeriodBuilder prune() {
            this.calculationPeriod = this.calculationPeriod.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.forecastPaymentAmount != null && !this.forecastPaymentAmount.prune().hasData()) {
                this.forecastPaymentAmount = null;
            }
            if (this.presentValueAmount != null && !this.presentValueAmount.prune().hasData()) {
                this.presentValueAmount = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getUnadjustedPaymentDate() != null) {
                return true;
            }
            if (this.getAdjustedPaymentDate() != null) {
                return true;
            }
            if (this.getCalculationPeriod() != null && this.getCalculationPeriod().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getFixedPaymentAmount() != null) {
                return true;
            }
            if (this.getDiscountFactor() != null) {
                return true;
            }
            if (this.getForecastPaymentAmount() != null && this.getForecastPaymentAmount().hasData()) {
                return true;
            }
            if (this.getPresentValueAmount() != null && this.getPresentValueAmount().hasData()) {
                return true;
            }
            if (this.getId() != null) {
                return true;
            }
            return this.getHref() != null;
        }

        public PaymentCalculationPeriodBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            PaymentCalculationPeriodBuilder o = (PaymentCalculationPeriodBuilder)other;
            merger.mergeRosetta(this.getCalculationPeriod(), o.getCalculationPeriod(), this::getOrCreateCalculationPeriod);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getForecastPaymentAmount(), (RosettaModelObjectBuilder)o.getForecastPaymentAmount(), this::setForecastPaymentAmount);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPresentValueAmount(), (RosettaModelObjectBuilder)o.getPresentValueAmount(), this::setPresentValueAmount);
            merger.mergeBasic((Object)this.getUnadjustedPaymentDate(), (Object)o.getUnadjustedPaymentDate(), this::setUnadjustedPaymentDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getAdjustedPaymentDate(), (Object)o.getAdjustedPaymentDate(), this::setAdjustedPaymentDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFixedPaymentAmount(), (Object)o.getFixedPaymentAmount(), this::setFixedPaymentAmount, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getDiscountFactor(), (Object)o.getDiscountFactor(), this::setDiscountFactor, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getId(), (Object)o.getId(), this::setId, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getHref(), (Object)o.getHref(), this::setHref, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PaymentCalculationPeriod _that = this.getType().cast(o);
            if (!Objects.equals(this.unadjustedPaymentDate, _that.getUnadjustedPaymentDate())) {
                return false;
            }
            if (!Objects.equals(this.adjustedPaymentDate, _that.getAdjustedPaymentDate())) {
                return false;
            }
            if (!ListEquals.listEquals(this.calculationPeriod, _that.getCalculationPeriod())) {
                return false;
            }
            if (!Objects.equals(this.fixedPaymentAmount, _that.getFixedPaymentAmount())) {
                return false;
            }
            if (!Objects.equals(this.discountFactor, _that.getDiscountFactor())) {
                return false;
            }
            if (!Objects.equals(this.forecastPaymentAmount, _that.getForecastPaymentAmount())) {
                return false;
            }
            if (!Objects.equals(this.presentValueAmount, _that.getPresentValueAmount())) {
                return false;
            }
            if (!Objects.equals(this.id, _that.getId())) {
                return false;
            }
            return Objects.equals(this.href, _that.getHref());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.unadjustedPaymentDate != null ? this.unadjustedPaymentDate.hashCode() : 0);
            _result = 31 * _result + (this.adjustedPaymentDate != null ? this.adjustedPaymentDate.hashCode() : 0);
            _result = 31 * _result + (this.calculationPeriod != null ? this.calculationPeriod.hashCode() : 0);
            _result = 31 * _result + (this.fixedPaymentAmount != null ? this.fixedPaymentAmount.hashCode() : 0);
            _result = 31 * _result + (this.discountFactor != null ? this.discountFactor.hashCode() : 0);
            _result = 31 * _result + (this.forecastPaymentAmount != null ? this.forecastPaymentAmount.hashCode() : 0);
            _result = 31 * _result + (this.presentValueAmount != null ? this.presentValueAmount.hashCode() : 0);
            _result = 31 * _result + (this.id != null ? this.id.hashCode() : 0);
            _result = 31 * _result + (this.href != null ? this.href.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PaymentCalculationPeriodBuilder {unadjustedPaymentDate=" + this.unadjustedPaymentDate + ", adjustedPaymentDate=" + this.adjustedPaymentDate + ", calculationPeriod=" + this.calculationPeriod + ", fixedPaymentAmount=" + this.fixedPaymentAmount + ", discountFactor=" + this.discountFactor + ", forecastPaymentAmount=" + this.forecastPaymentAmount + ", presentValueAmount=" + this.presentValueAmount + ", id=" + this.id + ", href=" + this.href + '}';
        }
    }

    public static interface PaymentCalculationPeriodBuilder
    extends PaymentCalculationPeriod,
    RosettaModelObjectBuilder {
        public CalculationPeriod.CalculationPeriodBuilder getOrCreateCalculationPeriod(int var1);

        public List<? extends CalculationPeriod.CalculationPeriodBuilder> getCalculationPeriod();

        public Money.MoneyBuilder getOrCreateForecastPaymentAmount();

        @Override
        public Money.MoneyBuilder getForecastPaymentAmount();

        public Money.MoneyBuilder getOrCreatePresentValueAmount();

        @Override
        public Money.MoneyBuilder getPresentValueAmount();

        public PaymentCalculationPeriodBuilder setUnadjustedPaymentDate(ZonedDateTime var1);

        public PaymentCalculationPeriodBuilder setAdjustedPaymentDate(ZonedDateTime var1);

        public PaymentCalculationPeriodBuilder addCalculationPeriod(CalculationPeriod var1);

        public PaymentCalculationPeriodBuilder addCalculationPeriod(CalculationPeriod var1, int var2);

        public PaymentCalculationPeriodBuilder addCalculationPeriod(List<? extends CalculationPeriod> var1);

        public PaymentCalculationPeriodBuilder setCalculationPeriod(List<? extends CalculationPeriod> var1);

        public PaymentCalculationPeriodBuilder setFixedPaymentAmount(BigDecimal var1);

        public PaymentCalculationPeriodBuilder setDiscountFactor(BigDecimal var1);

        public PaymentCalculationPeriodBuilder setForecastPaymentAmount(Money var1);

        public PaymentCalculationPeriodBuilder setPresentValueAmount(Money var1);

        public PaymentCalculationPeriodBuilder setId(String var1);

        public PaymentCalculationPeriodBuilder setHref(String var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("unadjustedPaymentDate"), ZonedDateTime.class, (Object)this.getUnadjustedPaymentDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("adjustedPaymentDate"), ZonedDateTime.class, (Object)this.getAdjustedPaymentDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("calculationPeriod"), processor, CalculationPeriod.CalculationPeriodBuilder.class, this.getCalculationPeriod(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("fixedPaymentAmount"), BigDecimal.class, (Object)this.getFixedPaymentAmount(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("discountFactor"), BigDecimal.class, (Object)this.getDiscountFactor(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("forecastPaymentAmount"), processor, Money.MoneyBuilder.class, this.getForecastPaymentAmount(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("presentValueAmount"), processor, Money.MoneyBuilder.class, this.getPresentValueAmount(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("href"), String.class, (Object)this.getHref(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public PaymentCalculationPeriodBuilder prune();
    }

    public static class PaymentCalculationPeriodImpl
    implements PaymentCalculationPeriod {
        private final ZonedDateTime unadjustedPaymentDate;
        private final ZonedDateTime adjustedPaymentDate;
        private final List<? extends CalculationPeriod> calculationPeriod;
        private final BigDecimal fixedPaymentAmount;
        private final BigDecimal discountFactor;
        private final Money forecastPaymentAmount;
        private final Money presentValueAmount;
        private final String id;
        private final String href;

        protected PaymentCalculationPeriodImpl(PaymentCalculationPeriodBuilder builder) {
            this.unadjustedPaymentDate = builder.getUnadjustedPaymentDate();
            this.adjustedPaymentDate = builder.getAdjustedPaymentDate();
            this.calculationPeriod = Optional.ofNullable(builder.getCalculationPeriod()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.fixedPaymentAmount = builder.getFixedPaymentAmount();
            this.discountFactor = builder.getDiscountFactor();
            this.forecastPaymentAmount = Optional.ofNullable(builder.getForecastPaymentAmount()).map(f -> f.build()).orElse(null);
            this.presentValueAmount = Optional.ofNullable(builder.getPresentValueAmount()).map(f -> f.build()).orElse(null);
            this.id = builder.getId();
            this.href = builder.getHref();
        }

        @Override
        @RosettaAttribute(value="unadjustedPaymentDate")
        @RuneAttribute(value="unadjustedPaymentDate")
        public ZonedDateTime getUnadjustedPaymentDate() {
            return this.unadjustedPaymentDate;
        }

        @Override
        @RosettaAttribute(value="adjustedPaymentDate")
        @RuneAttribute(value="adjustedPaymentDate")
        public ZonedDateTime getAdjustedPaymentDate() {
            return this.adjustedPaymentDate;
        }

        @Override
        @RosettaAttribute(value="calculationPeriod")
        @RuneAttribute(value="calculationPeriod")
        public List<? extends CalculationPeriod> getCalculationPeriod() {
            return this.calculationPeriod;
        }

        @Override
        @RosettaAttribute(value="fixedPaymentAmount")
        @RuneAttribute(value="fixedPaymentAmount")
        public BigDecimal getFixedPaymentAmount() {
            return this.fixedPaymentAmount;
        }

        @Override
        @RosettaAttribute(value="discountFactor")
        @RuneAttribute(value="discountFactor")
        public BigDecimal getDiscountFactor() {
            return this.discountFactor;
        }

        @Override
        @RosettaAttribute(value="forecastPaymentAmount")
        @RuneAttribute(value="forecastPaymentAmount")
        public Money getForecastPaymentAmount() {
            return this.forecastPaymentAmount;
        }

        @Override
        @RosettaAttribute(value="presentValueAmount")
        @RuneAttribute(value="presentValueAmount")
        public Money getPresentValueAmount() {
            return this.presentValueAmount;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public String getId() {
            return this.id;
        }

        @Override
        @RosettaAttribute(value="href")
        @RuneAttribute(value="href")
        public String getHref() {
            return this.href;
        }

        @Override
        public PaymentCalculationPeriod build() {
            return this;
        }

        @Override
        public PaymentCalculationPeriodBuilder toBuilder() {
            PaymentCalculationPeriodBuilder builder = PaymentCalculationPeriod.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(PaymentCalculationPeriodBuilder builder) {
            Optional.ofNullable(this.getUnadjustedPaymentDate()).ifPresent(builder::setUnadjustedPaymentDate);
            Optional.ofNullable(this.getAdjustedPaymentDate()).ifPresent(builder::setAdjustedPaymentDate);
            Optional.ofNullable(this.getCalculationPeriod()).ifPresent(builder::setCalculationPeriod);
            Optional.ofNullable(this.getFixedPaymentAmount()).ifPresent(builder::setFixedPaymentAmount);
            Optional.ofNullable(this.getDiscountFactor()).ifPresent(builder::setDiscountFactor);
            Optional.ofNullable(this.getForecastPaymentAmount()).ifPresent(builder::setForecastPaymentAmount);
            Optional.ofNullable(this.getPresentValueAmount()).ifPresent(builder::setPresentValueAmount);
            Optional.ofNullable(this.getId()).ifPresent(builder::setId);
            Optional.ofNullable(this.getHref()).ifPresent(builder::setHref);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PaymentCalculationPeriod _that = this.getType().cast(o);
            if (!Objects.equals(this.unadjustedPaymentDate, _that.getUnadjustedPaymentDate())) {
                return false;
            }
            if (!Objects.equals(this.adjustedPaymentDate, _that.getAdjustedPaymentDate())) {
                return false;
            }
            if (!ListEquals.listEquals(this.calculationPeriod, _that.getCalculationPeriod())) {
                return false;
            }
            if (!Objects.equals(this.fixedPaymentAmount, _that.getFixedPaymentAmount())) {
                return false;
            }
            if (!Objects.equals(this.discountFactor, _that.getDiscountFactor())) {
                return false;
            }
            if (!Objects.equals(this.forecastPaymentAmount, _that.getForecastPaymentAmount())) {
                return false;
            }
            if (!Objects.equals(this.presentValueAmount, _that.getPresentValueAmount())) {
                return false;
            }
            if (!Objects.equals(this.id, _that.getId())) {
                return false;
            }
            return Objects.equals(this.href, _that.getHref());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.unadjustedPaymentDate != null ? this.unadjustedPaymentDate.hashCode() : 0);
            _result = 31 * _result + (this.adjustedPaymentDate != null ? this.adjustedPaymentDate.hashCode() : 0);
            _result = 31 * _result + (this.calculationPeriod != null ? this.calculationPeriod.hashCode() : 0);
            _result = 31 * _result + (this.fixedPaymentAmount != null ? this.fixedPaymentAmount.hashCode() : 0);
            _result = 31 * _result + (this.discountFactor != null ? this.discountFactor.hashCode() : 0);
            _result = 31 * _result + (this.forecastPaymentAmount != null ? this.forecastPaymentAmount.hashCode() : 0);
            _result = 31 * _result + (this.presentValueAmount != null ? this.presentValueAmount.hashCode() : 0);
            _result = 31 * _result + (this.id != null ? this.id.hashCode() : 0);
            _result = 31 * _result + (this.href != null ? this.href.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PaymentCalculationPeriod {unadjustedPaymentDate=" + this.unadjustedPaymentDate + ", adjustedPaymentDate=" + this.adjustedPaymentDate + ", calculationPeriod=" + this.calculationPeriod + ", fixedPaymentAmount=" + this.fixedPaymentAmount + ", discountFactor=" + this.discountFactor + ", forecastPaymentAmount=" + this.forecastPaymentAmount + ", presentValueAmount=" + this.presentValueAmount + ", id=" + this.id + ", href=" + this.href + '}';
        }
    }
}

