/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.ird;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.ird.ValuationPostponement;
import fpml.consolidated.ird.meta.FallbackReferencePriceMeta;
import fpml.consolidated.shared.CalculationAgent;
import fpml.consolidated.shared.Empty;
import fpml.consolidated.shared.SettlementRateOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="FallbackReferencePrice", builder=FallbackReferencePriceBuilderImpl.class, version="1.1.0")
@RuneDataType(value="FallbackReferencePrice", model="fpml", builder=FallbackReferencePriceBuilderImpl.class, version="1.1.0")
public interface FallbackReferencePrice
extends RosettaModelObject {
    public static final FallbackReferencePriceMeta metaData = new FallbackReferencePriceMeta();

    public ValuationPostponement getValuationPostponement();

    public List<? extends SettlementRateOption> getFallbackSettlementRateOption();

    public Empty getFallbackSurveyValuationPostponenment();

    public CalculationAgent getCalculationAgentDetermination();

    public FallbackReferencePrice build();

    public FallbackReferencePriceBuilder toBuilder();

    public static FallbackReferencePriceBuilder builder() {
        return new FallbackReferencePriceBuilderImpl();
    }

    default public RosettaMetaData<? extends FallbackReferencePrice> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends FallbackReferencePrice> getType() {
        return FallbackReferencePrice.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("valuationPostponement"), processor, ValuationPostponement.class, this.getValuationPostponement(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("fallbackSettlementRateOption"), processor, SettlementRateOption.class, this.getFallbackSettlementRateOption(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("fallbackSurveyValuationPostponenment"), processor, Empty.class, this.getFallbackSurveyValuationPostponenment(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("calculationAgentDetermination"), processor, CalculationAgent.class, this.getCalculationAgentDetermination(), new AttributeMeta[0]);
    }

    public static class FallbackReferencePriceBuilderImpl
    implements FallbackReferencePriceBuilder {
        protected ValuationPostponement.ValuationPostponementBuilder valuationPostponement;
        protected List<SettlementRateOption.SettlementRateOptionBuilder> fallbackSettlementRateOption = new ArrayList<SettlementRateOption.SettlementRateOptionBuilder>();
        protected Empty.EmptyBuilder fallbackSurveyValuationPostponenment;
        protected CalculationAgent.CalculationAgentBuilder calculationAgentDetermination;

        @Override
        @RosettaAttribute(value="valuationPostponement")
        @RuneAttribute(value="valuationPostponement")
        public ValuationPostponement.ValuationPostponementBuilder getValuationPostponement() {
            return this.valuationPostponement;
        }

        @Override
        public ValuationPostponement.ValuationPostponementBuilder getOrCreateValuationPostponement() {
            ValuationPostponement.ValuationPostponementBuilder result = this.valuationPostponement != null ? this.valuationPostponement : (this.valuationPostponement = ValuationPostponement.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="fallbackSettlementRateOption")
        @RuneAttribute(value="fallbackSettlementRateOption")
        public List<? extends SettlementRateOption.SettlementRateOptionBuilder> getFallbackSettlementRateOption() {
            return this.fallbackSettlementRateOption;
        }

        @Override
        public SettlementRateOption.SettlementRateOptionBuilder getOrCreateFallbackSettlementRateOption(int index) {
            if (this.fallbackSettlementRateOption == null) {
                this.fallbackSettlementRateOption = new ArrayList<SettlementRateOption.SettlementRateOptionBuilder>();
            }
            return (SettlementRateOption.SettlementRateOptionBuilder)this.getIndex(this.fallbackSettlementRateOption, index, () -> {
                SettlementRateOption.SettlementRateOptionBuilder newFallbackSettlementRateOption = SettlementRateOption.builder();
                return newFallbackSettlementRateOption;
            });
        }

        @Override
        @RosettaAttribute(value="fallbackSurveyValuationPostponenment")
        @RuneAttribute(value="fallbackSurveyValuationPostponenment")
        public Empty.EmptyBuilder getFallbackSurveyValuationPostponenment() {
            return this.fallbackSurveyValuationPostponenment;
        }

        @Override
        public Empty.EmptyBuilder getOrCreateFallbackSurveyValuationPostponenment() {
            Empty.EmptyBuilder result = this.fallbackSurveyValuationPostponenment != null ? this.fallbackSurveyValuationPostponenment : (this.fallbackSurveyValuationPostponenment = Empty.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="calculationAgentDetermination")
        @RuneAttribute(value="calculationAgentDetermination")
        public CalculationAgent.CalculationAgentBuilder getCalculationAgentDetermination() {
            return this.calculationAgentDetermination;
        }

        @Override
        public CalculationAgent.CalculationAgentBuilder getOrCreateCalculationAgentDetermination() {
            CalculationAgent.CalculationAgentBuilder result = this.calculationAgentDetermination != null ? this.calculationAgentDetermination : (this.calculationAgentDetermination = CalculationAgent.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="valuationPostponement")
        @RuneAttribute(value="valuationPostponement")
        public FallbackReferencePriceBuilder setValuationPostponement(ValuationPostponement _valuationPostponement) {
            this.valuationPostponement = _valuationPostponement == null ? null : _valuationPostponement.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="fallbackSettlementRateOption")
        @RuneAttribute(value="fallbackSettlementRateOption")
        public FallbackReferencePriceBuilder addFallbackSettlementRateOption(SettlementRateOption _fallbackSettlementRateOption) {
            if (_fallbackSettlementRateOption != null) {
                this.fallbackSettlementRateOption.add(_fallbackSettlementRateOption.toBuilder());
            }
            return this;
        }

        @Override
        public FallbackReferencePriceBuilder addFallbackSettlementRateOption(SettlementRateOption _fallbackSettlementRateOption, int idx) {
            this.getIndex(this.fallbackSettlementRateOption, idx, () -> _fallbackSettlementRateOption.toBuilder());
            return this;
        }

        @Override
        public FallbackReferencePriceBuilder addFallbackSettlementRateOption(List<? extends SettlementRateOption> fallbackSettlementRateOptions) {
            if (fallbackSettlementRateOptions != null) {
                for (SettlementRateOption settlementRateOption : fallbackSettlementRateOptions) {
                    this.fallbackSettlementRateOption.add(settlementRateOption.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="fallbackSettlementRateOption")
        public FallbackReferencePriceBuilder setFallbackSettlementRateOption(List<? extends SettlementRateOption> fallbackSettlementRateOptions) {
            this.fallbackSettlementRateOption = fallbackSettlementRateOptions == null ? new ArrayList<SettlementRateOption.SettlementRateOptionBuilder>() : (List)fallbackSettlementRateOptions.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="fallbackSurveyValuationPostponenment")
        @RuneAttribute(value="fallbackSurveyValuationPostponenment")
        public FallbackReferencePriceBuilder setFallbackSurveyValuationPostponenment(Empty _fallbackSurveyValuationPostponenment) {
            this.fallbackSurveyValuationPostponenment = _fallbackSurveyValuationPostponenment == null ? null : _fallbackSurveyValuationPostponenment.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="calculationAgentDetermination")
        @RuneAttribute(value="calculationAgentDetermination")
        public FallbackReferencePriceBuilder setCalculationAgentDetermination(CalculationAgent _calculationAgentDetermination) {
            this.calculationAgentDetermination = _calculationAgentDetermination == null ? null : _calculationAgentDetermination.toBuilder();
            return this;
        }

        @Override
        public FallbackReferencePrice build() {
            return new FallbackReferencePriceImpl(this);
        }

        @Override
        public FallbackReferencePriceBuilder toBuilder() {
            return this;
        }

        @Override
        public FallbackReferencePriceBuilder prune() {
            if (this.valuationPostponement != null && !this.valuationPostponement.prune().hasData()) {
                this.valuationPostponement = null;
            }
            this.fallbackSettlementRateOption = this.fallbackSettlementRateOption.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.fallbackSurveyValuationPostponenment != null && !this.fallbackSurveyValuationPostponenment.prune().hasData()) {
                this.fallbackSurveyValuationPostponenment = null;
            }
            if (this.calculationAgentDetermination != null && !this.calculationAgentDetermination.prune().hasData()) {
                this.calculationAgentDetermination = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getValuationPostponement() != null && this.getValuationPostponement().hasData()) {
                return true;
            }
            if (this.getFallbackSettlementRateOption() != null && this.getFallbackSettlementRateOption().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getFallbackSurveyValuationPostponenment() != null && this.getFallbackSurveyValuationPostponenment().hasData()) {
                return true;
            }
            return this.getCalculationAgentDetermination() != null && this.getCalculationAgentDetermination().hasData();
        }

        public FallbackReferencePriceBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            FallbackReferencePriceBuilder o = (FallbackReferencePriceBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getValuationPostponement(), (RosettaModelObjectBuilder)o.getValuationPostponement(), this::setValuationPostponement);
            merger.mergeRosetta(this.getFallbackSettlementRateOption(), o.getFallbackSettlementRateOption(), this::getOrCreateFallbackSettlementRateOption);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFallbackSurveyValuationPostponenment(), (RosettaModelObjectBuilder)o.getFallbackSurveyValuationPostponenment(), this::setFallbackSurveyValuationPostponenment);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCalculationAgentDetermination(), (RosettaModelObjectBuilder)o.getCalculationAgentDetermination(), this::setCalculationAgentDetermination);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            FallbackReferencePrice _that = this.getType().cast(o);
            if (!Objects.equals(this.valuationPostponement, _that.getValuationPostponement())) {
                return false;
            }
            if (!ListEquals.listEquals(this.fallbackSettlementRateOption, _that.getFallbackSettlementRateOption())) {
                return false;
            }
            if (!Objects.equals(this.fallbackSurveyValuationPostponenment, _that.getFallbackSurveyValuationPostponenment())) {
                return false;
            }
            return Objects.equals(this.calculationAgentDetermination, _that.getCalculationAgentDetermination());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.valuationPostponement != null ? this.valuationPostponement.hashCode() : 0);
            _result = 31 * _result + (this.fallbackSettlementRateOption != null ? this.fallbackSettlementRateOption.hashCode() : 0);
            _result = 31 * _result + (this.fallbackSurveyValuationPostponenment != null ? this.fallbackSurveyValuationPostponenment.hashCode() : 0);
            _result = 31 * _result + (this.calculationAgentDetermination != null ? this.calculationAgentDetermination.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "FallbackReferencePriceBuilder {valuationPostponement=" + this.valuationPostponement + ", fallbackSettlementRateOption=" + this.fallbackSettlementRateOption + ", fallbackSurveyValuationPostponenment=" + this.fallbackSurveyValuationPostponenment + ", calculationAgentDetermination=" + this.calculationAgentDetermination + '}';
        }
    }

    public static interface FallbackReferencePriceBuilder
    extends FallbackReferencePrice,
    RosettaModelObjectBuilder {
        public ValuationPostponement.ValuationPostponementBuilder getOrCreateValuationPostponement();

        @Override
        public ValuationPostponement.ValuationPostponementBuilder getValuationPostponement();

        public SettlementRateOption.SettlementRateOptionBuilder getOrCreateFallbackSettlementRateOption(int var1);

        public List<? extends SettlementRateOption.SettlementRateOptionBuilder> getFallbackSettlementRateOption();

        public Empty.EmptyBuilder getOrCreateFallbackSurveyValuationPostponenment();

        @Override
        public Empty.EmptyBuilder getFallbackSurveyValuationPostponenment();

        public CalculationAgent.CalculationAgentBuilder getOrCreateCalculationAgentDetermination();

        @Override
        public CalculationAgent.CalculationAgentBuilder getCalculationAgentDetermination();

        public FallbackReferencePriceBuilder setValuationPostponement(ValuationPostponement var1);

        public FallbackReferencePriceBuilder addFallbackSettlementRateOption(SettlementRateOption var1);

        public FallbackReferencePriceBuilder addFallbackSettlementRateOption(SettlementRateOption var1, int var2);

        public FallbackReferencePriceBuilder addFallbackSettlementRateOption(List<? extends SettlementRateOption> var1);

        public FallbackReferencePriceBuilder setFallbackSettlementRateOption(List<? extends SettlementRateOption> var1);

        public FallbackReferencePriceBuilder setFallbackSurveyValuationPostponenment(Empty var1);

        public FallbackReferencePriceBuilder setCalculationAgentDetermination(CalculationAgent var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("valuationPostponement"), processor, ValuationPostponement.ValuationPostponementBuilder.class, this.getValuationPostponement(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("fallbackSettlementRateOption"), processor, SettlementRateOption.SettlementRateOptionBuilder.class, this.getFallbackSettlementRateOption(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("fallbackSurveyValuationPostponenment"), processor, Empty.EmptyBuilder.class, this.getFallbackSurveyValuationPostponenment(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("calculationAgentDetermination"), processor, CalculationAgent.CalculationAgentBuilder.class, this.getCalculationAgentDetermination(), new AttributeMeta[0]);
        }

        public FallbackReferencePriceBuilder prune();
    }

    public static class FallbackReferencePriceImpl
    implements FallbackReferencePrice {
        private final ValuationPostponement valuationPostponement;
        private final List<? extends SettlementRateOption> fallbackSettlementRateOption;
        private final Empty fallbackSurveyValuationPostponenment;
        private final CalculationAgent calculationAgentDetermination;

        protected FallbackReferencePriceImpl(FallbackReferencePriceBuilder builder) {
            this.valuationPostponement = Optional.ofNullable(builder.getValuationPostponement()).map(f -> f.build()).orElse(null);
            this.fallbackSettlementRateOption = Optional.ofNullable(builder.getFallbackSettlementRateOption()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.fallbackSurveyValuationPostponenment = Optional.ofNullable(builder.getFallbackSurveyValuationPostponenment()).map(f -> f.build()).orElse(null);
            this.calculationAgentDetermination = Optional.ofNullable(builder.getCalculationAgentDetermination()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="valuationPostponement")
        @RuneAttribute(value="valuationPostponement")
        public ValuationPostponement getValuationPostponement() {
            return this.valuationPostponement;
        }

        @Override
        @RosettaAttribute(value="fallbackSettlementRateOption")
        @RuneAttribute(value="fallbackSettlementRateOption")
        public List<? extends SettlementRateOption> getFallbackSettlementRateOption() {
            return this.fallbackSettlementRateOption;
        }

        @Override
        @RosettaAttribute(value="fallbackSurveyValuationPostponenment")
        @RuneAttribute(value="fallbackSurveyValuationPostponenment")
        public Empty getFallbackSurveyValuationPostponenment() {
            return this.fallbackSurveyValuationPostponenment;
        }

        @Override
        @RosettaAttribute(value="calculationAgentDetermination")
        @RuneAttribute(value="calculationAgentDetermination")
        public CalculationAgent getCalculationAgentDetermination() {
            return this.calculationAgentDetermination;
        }

        @Override
        public FallbackReferencePrice build() {
            return this;
        }

        @Override
        public FallbackReferencePriceBuilder toBuilder() {
            FallbackReferencePriceBuilder builder = FallbackReferencePrice.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(FallbackReferencePriceBuilder builder) {
            Optional.ofNullable(this.getValuationPostponement()).ifPresent(builder::setValuationPostponement);
            Optional.ofNullable(this.getFallbackSettlementRateOption()).ifPresent(builder::setFallbackSettlementRateOption);
            Optional.ofNullable(this.getFallbackSurveyValuationPostponenment()).ifPresent(builder::setFallbackSurveyValuationPostponenment);
            Optional.ofNullable(this.getCalculationAgentDetermination()).ifPresent(builder::setCalculationAgentDetermination);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            FallbackReferencePrice _that = this.getType().cast(o);
            if (!Objects.equals(this.valuationPostponement, _that.getValuationPostponement())) {
                return false;
            }
            if (!ListEquals.listEquals(this.fallbackSettlementRateOption, _that.getFallbackSettlementRateOption())) {
                return false;
            }
            if (!Objects.equals(this.fallbackSurveyValuationPostponenment, _that.getFallbackSurveyValuationPostponenment())) {
                return false;
            }
            return Objects.equals(this.calculationAgentDetermination, _that.getCalculationAgentDetermination());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.valuationPostponement != null ? this.valuationPostponement.hashCode() : 0);
            _result = 31 * _result + (this.fallbackSettlementRateOption != null ? this.fallbackSettlementRateOption.hashCode() : 0);
            _result = 31 * _result + (this.fallbackSurveyValuationPostponenment != null ? this.fallbackSurveyValuationPostponenment.hashCode() : 0);
            _result = 31 * _result + (this.calculationAgentDetermination != null ? this.calculationAgentDetermination.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "FallbackReferencePrice {valuationPostponement=" + this.valuationPostponement + ", fallbackSettlementRateOption=" + this.fallbackSettlementRateOption + ", fallbackSurveyValuationPostponenment=" + this.fallbackSurveyValuationPostponenment + ", calculationAgentDetermination=" + this.calculationAgentDetermination + '}';
        }
    }
}

