/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.generic;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.asset.Asset;
import fpml.consolidated.cd.IndexReferenceInformation;
import fpml.consolidated.com.CoalProduct;
import fpml.consolidated.com.ElectricityProduct;
import fpml.consolidated.com.GasProduct;
import fpml.consolidated.com.OilProduct;
import fpml.consolidated.fpmlenum.AveragingMethodEnum;
import fpml.consolidated.generic.BuyerSellerGenericModel;
import fpml.consolidated.generic.GenericProductExchangeRate;
import fpml.consolidated.generic.meta.TradeUnderlyer2Meta;
import fpml.consolidated.shared.BuyerSellerModel;
import fpml.consolidated.shared.DayCountFraction;
import fpml.consolidated.shared.FloatingRate;
import fpml.consolidated.shared.LegalEntity;
import fpml.consolidated.shared.PayerReceiverModel;
import fpml.consolidated.shared.QuotedCurrencyPair;
import fpml.consolidated.shared.Schedule;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="TradeUnderlyer2", builder=TradeUnderlyer2BuilderImpl.class, version="1.1.0")
@RuneDataType(value="TradeUnderlyer2", model="fpml", builder=TradeUnderlyer2BuilderImpl.class, version="1.1.0")
public interface TradeUnderlyer2
extends RosettaModelObject {
    public static final TradeUnderlyer2Meta metaData = new TradeUnderlyer2Meta();

    public FloatingRate getFloatingRate();

    public Schedule getFixedRate();

    public GenericProductExchangeRate getExchangeRate();

    public Asset getUnderlyingAsset();

    public QuotedCurrencyPair getQuotedCurrencyPair();

    public LegalEntity getReferenceEntity();

    public IndexReferenceInformation getIndexReferenceInformation();

    public GasProduct getGas();

    public OilProduct getOil();

    public CoalProduct getCoal();

    public ElectricityProduct getElectricity();

    public AveragingMethodEnum getAveragingMethod();

    public PayerReceiverModel getPayerReceiverModel();

    public BuyerSellerGenericModel getBuyerSellerGenericModel();

    public DayCountFraction getDayCountFraction();

    public String getId();

    public BuyerSellerModel getBuyerSellerModel();

    public TradeUnderlyer2 build();

    public TradeUnderlyer2Builder toBuilder();

    public static TradeUnderlyer2Builder builder() {
        return new TradeUnderlyer2BuilderImpl();
    }

    default public RosettaMetaData<? extends TradeUnderlyer2> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends TradeUnderlyer2> getType() {
        return TradeUnderlyer2.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("floatingRate"), processor, FloatingRate.class, this.getFloatingRate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("fixedRate"), processor, Schedule.class, this.getFixedRate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("exchangeRate"), processor, GenericProductExchangeRate.class, this.getExchangeRate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("underlyingAsset"), processor, Asset.class, this.getUnderlyingAsset(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("quotedCurrencyPair"), processor, QuotedCurrencyPair.class, this.getQuotedCurrencyPair(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("referenceEntity"), processor, LegalEntity.class, this.getReferenceEntity(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("indexReferenceInformation"), processor, IndexReferenceInformation.class, this.getIndexReferenceInformation(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("gas"), processor, GasProduct.class, this.getGas(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("oil"), processor, OilProduct.class, this.getOil(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("coal"), processor, CoalProduct.class, this.getCoal(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("electricity"), processor, ElectricityProduct.class, this.getElectricity(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("averagingMethod"), AveragingMethodEnum.class, (Object)this.getAveragingMethod(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("payerReceiverModel"), processor, PayerReceiverModel.class, this.getPayerReceiverModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("buyerSellerGenericModel"), processor, BuyerSellerGenericModel.class, this.getBuyerSellerGenericModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("dayCountFraction"), processor, DayCountFraction.class, this.getDayCountFraction(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("buyerSellerModel"), processor, BuyerSellerModel.class, this.getBuyerSellerModel(), new AttributeMeta[0]);
    }

    public static class TradeUnderlyer2BuilderImpl
    implements TradeUnderlyer2Builder {
        protected FloatingRate.FloatingRateBuilder floatingRate;
        protected Schedule.ScheduleBuilder fixedRate;
        protected GenericProductExchangeRate.GenericProductExchangeRateBuilder exchangeRate;
        protected Asset.AssetBuilder underlyingAsset;
        protected QuotedCurrencyPair.QuotedCurrencyPairBuilder quotedCurrencyPair;
        protected LegalEntity.LegalEntityBuilder referenceEntity;
        protected IndexReferenceInformation.IndexReferenceInformationBuilder indexReferenceInformation;
        protected GasProduct.GasProductBuilder gas;
        protected OilProduct.OilProductBuilder oil;
        protected CoalProduct.CoalProductBuilder coal;
        protected ElectricityProduct.ElectricityProductBuilder electricity;
        protected AveragingMethodEnum averagingMethod;
        protected PayerReceiverModel.PayerReceiverModelBuilder payerReceiverModel;
        protected BuyerSellerGenericModel.BuyerSellerGenericModelBuilder buyerSellerGenericModel;
        protected DayCountFraction.DayCountFractionBuilder dayCountFraction;
        protected String id;
        protected BuyerSellerModel.BuyerSellerModelBuilder buyerSellerModel;

        @Override
        @RosettaAttribute(value="floatingRate")
        @RuneAttribute(value="floatingRate")
        public FloatingRate.FloatingRateBuilder getFloatingRate() {
            return this.floatingRate;
        }

        @Override
        public FloatingRate.FloatingRateBuilder getOrCreateFloatingRate() {
            FloatingRate.FloatingRateBuilder result = this.floatingRate != null ? this.floatingRate : (this.floatingRate = FloatingRate.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="fixedRate")
        @RuneAttribute(value="fixedRate")
        public Schedule.ScheduleBuilder getFixedRate() {
            return this.fixedRate;
        }

        @Override
        public Schedule.ScheduleBuilder getOrCreateFixedRate() {
            Schedule.ScheduleBuilder result = this.fixedRate != null ? this.fixedRate : (this.fixedRate = Schedule.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="exchangeRate")
        @RuneAttribute(value="exchangeRate")
        public GenericProductExchangeRate.GenericProductExchangeRateBuilder getExchangeRate() {
            return this.exchangeRate;
        }

        @Override
        public GenericProductExchangeRate.GenericProductExchangeRateBuilder getOrCreateExchangeRate() {
            GenericProductExchangeRate.GenericProductExchangeRateBuilder result = this.exchangeRate != null ? this.exchangeRate : (this.exchangeRate = GenericProductExchangeRate.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="underlyingAsset")
        @RuneAttribute(value="underlyingAsset")
        public Asset.AssetBuilder getUnderlyingAsset() {
            return this.underlyingAsset;
        }

        @Override
        public Asset.AssetBuilder getOrCreateUnderlyingAsset() {
            Asset.AssetBuilder result = this.underlyingAsset != null ? this.underlyingAsset : (this.underlyingAsset = Asset.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="quotedCurrencyPair")
        @RuneAttribute(value="quotedCurrencyPair")
        public QuotedCurrencyPair.QuotedCurrencyPairBuilder getQuotedCurrencyPair() {
            return this.quotedCurrencyPair;
        }

        @Override
        public QuotedCurrencyPair.QuotedCurrencyPairBuilder getOrCreateQuotedCurrencyPair() {
            QuotedCurrencyPair.QuotedCurrencyPairBuilder result = this.quotedCurrencyPair != null ? this.quotedCurrencyPair : (this.quotedCurrencyPair = QuotedCurrencyPair.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="referenceEntity")
        @RuneAttribute(value="referenceEntity")
        public LegalEntity.LegalEntityBuilder getReferenceEntity() {
            return this.referenceEntity;
        }

        @Override
        public LegalEntity.LegalEntityBuilder getOrCreateReferenceEntity() {
            LegalEntity.LegalEntityBuilder result = this.referenceEntity != null ? this.referenceEntity : (this.referenceEntity = LegalEntity.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="indexReferenceInformation")
        @RuneAttribute(value="indexReferenceInformation")
        public IndexReferenceInformation.IndexReferenceInformationBuilder getIndexReferenceInformation() {
            return this.indexReferenceInformation;
        }

        @Override
        public IndexReferenceInformation.IndexReferenceInformationBuilder getOrCreateIndexReferenceInformation() {
            IndexReferenceInformation.IndexReferenceInformationBuilder result = this.indexReferenceInformation != null ? this.indexReferenceInformation : (this.indexReferenceInformation = IndexReferenceInformation.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="gas")
        @RuneAttribute(value="gas")
        public GasProduct.GasProductBuilder getGas() {
            return this.gas;
        }

        @Override
        public GasProduct.GasProductBuilder getOrCreateGas() {
            GasProduct.GasProductBuilder result = this.gas != null ? this.gas : (this.gas = GasProduct.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="oil")
        @RuneAttribute(value="oil")
        public OilProduct.OilProductBuilder getOil() {
            return this.oil;
        }

        @Override
        public OilProduct.OilProductBuilder getOrCreateOil() {
            OilProduct.OilProductBuilder result = this.oil != null ? this.oil : (this.oil = OilProduct.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="coal")
        @RuneAttribute(value="coal")
        public CoalProduct.CoalProductBuilder getCoal() {
            return this.coal;
        }

        @Override
        public CoalProduct.CoalProductBuilder getOrCreateCoal() {
            CoalProduct.CoalProductBuilder result = this.coal != null ? this.coal : (this.coal = CoalProduct.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="electricity")
        @RuneAttribute(value="electricity")
        public ElectricityProduct.ElectricityProductBuilder getElectricity() {
            return this.electricity;
        }

        @Override
        public ElectricityProduct.ElectricityProductBuilder getOrCreateElectricity() {
            ElectricityProduct.ElectricityProductBuilder result = this.electricity != null ? this.electricity : (this.electricity = ElectricityProduct.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="averagingMethod")
        @RuneAttribute(value="averagingMethod")
        public AveragingMethodEnum getAveragingMethod() {
            return this.averagingMethod;
        }

        @Override
        @RosettaAttribute(value="payerReceiverModel")
        @RuneAttribute(value="payerReceiverModel")
        public PayerReceiverModel.PayerReceiverModelBuilder getPayerReceiverModel() {
            return this.payerReceiverModel;
        }

        @Override
        public PayerReceiverModel.PayerReceiverModelBuilder getOrCreatePayerReceiverModel() {
            PayerReceiverModel.PayerReceiverModelBuilder result = this.payerReceiverModel != null ? this.payerReceiverModel : (this.payerReceiverModel = PayerReceiverModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="buyerSellerGenericModel")
        @RuneAttribute(value="buyerSellerGenericModel")
        public BuyerSellerGenericModel.BuyerSellerGenericModelBuilder getBuyerSellerGenericModel() {
            return this.buyerSellerGenericModel;
        }

        @Override
        public BuyerSellerGenericModel.BuyerSellerGenericModelBuilder getOrCreateBuyerSellerGenericModel() {
            BuyerSellerGenericModel.BuyerSellerGenericModelBuilder result = this.buyerSellerGenericModel != null ? this.buyerSellerGenericModel : (this.buyerSellerGenericModel = BuyerSellerGenericModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="dayCountFraction")
        @RuneAttribute(value="dayCountFraction")
        public DayCountFraction.DayCountFractionBuilder getDayCountFraction() {
            return this.dayCountFraction;
        }

        @Override
        public DayCountFraction.DayCountFractionBuilder getOrCreateDayCountFraction() {
            DayCountFraction.DayCountFractionBuilder result = this.dayCountFraction != null ? this.dayCountFraction : (this.dayCountFraction = DayCountFraction.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public String getId() {
            return this.id;
        }

        @Override
        @RosettaAttribute(value="buyerSellerModel")
        @RuneAttribute(value="buyerSellerModel")
        public BuyerSellerModel.BuyerSellerModelBuilder getBuyerSellerModel() {
            return this.buyerSellerModel;
        }

        @Override
        public BuyerSellerModel.BuyerSellerModelBuilder getOrCreateBuyerSellerModel() {
            BuyerSellerModel.BuyerSellerModelBuilder result = this.buyerSellerModel != null ? this.buyerSellerModel : (this.buyerSellerModel = BuyerSellerModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="floatingRate")
        @RuneAttribute(value="floatingRate")
        public TradeUnderlyer2Builder setFloatingRate(FloatingRate _floatingRate) {
            this.floatingRate = _floatingRate == null ? null : _floatingRate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="fixedRate")
        @RuneAttribute(value="fixedRate")
        public TradeUnderlyer2Builder setFixedRate(Schedule _fixedRate) {
            this.fixedRate = _fixedRate == null ? null : _fixedRate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="exchangeRate")
        @RuneAttribute(value="exchangeRate")
        public TradeUnderlyer2Builder setExchangeRate(GenericProductExchangeRate _exchangeRate) {
            this.exchangeRate = _exchangeRate == null ? null : _exchangeRate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="underlyingAsset")
        @RuneAttribute(value="underlyingAsset")
        public TradeUnderlyer2Builder setUnderlyingAsset(Asset _underlyingAsset) {
            this.underlyingAsset = _underlyingAsset == null ? null : _underlyingAsset.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="quotedCurrencyPair")
        @RuneAttribute(value="quotedCurrencyPair")
        public TradeUnderlyer2Builder setQuotedCurrencyPair(QuotedCurrencyPair _quotedCurrencyPair) {
            this.quotedCurrencyPair = _quotedCurrencyPair == null ? null : _quotedCurrencyPair.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="referenceEntity")
        @RuneAttribute(value="referenceEntity")
        public TradeUnderlyer2Builder setReferenceEntity(LegalEntity _referenceEntity) {
            this.referenceEntity = _referenceEntity == null ? null : _referenceEntity.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="indexReferenceInformation")
        @RuneAttribute(value="indexReferenceInformation")
        public TradeUnderlyer2Builder setIndexReferenceInformation(IndexReferenceInformation _indexReferenceInformation) {
            this.indexReferenceInformation = _indexReferenceInformation == null ? null : _indexReferenceInformation.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="gas")
        @RuneAttribute(value="gas")
        public TradeUnderlyer2Builder setGas(GasProduct _gas) {
            this.gas = _gas == null ? null : _gas.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="oil")
        @RuneAttribute(value="oil")
        public TradeUnderlyer2Builder setOil(OilProduct _oil) {
            this.oil = _oil == null ? null : _oil.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="coal")
        @RuneAttribute(value="coal")
        public TradeUnderlyer2Builder setCoal(CoalProduct _coal) {
            this.coal = _coal == null ? null : _coal.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="electricity")
        @RuneAttribute(value="electricity")
        public TradeUnderlyer2Builder setElectricity(ElectricityProduct _electricity) {
            this.electricity = _electricity == null ? null : _electricity.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="averagingMethod")
        @RuneAttribute(value="averagingMethod")
        public TradeUnderlyer2Builder setAveragingMethod(AveragingMethodEnum _averagingMethod) {
            this.averagingMethod = _averagingMethod == null ? null : _averagingMethod;
            return this;
        }

        @Override
        @RosettaAttribute(value="payerReceiverModel")
        @RuneAttribute(value="payerReceiverModel")
        public TradeUnderlyer2Builder setPayerReceiverModel(PayerReceiverModel _payerReceiverModel) {
            this.payerReceiverModel = _payerReceiverModel == null ? null : _payerReceiverModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="buyerSellerGenericModel")
        @RuneAttribute(value="buyerSellerGenericModel")
        public TradeUnderlyer2Builder setBuyerSellerGenericModel(BuyerSellerGenericModel _buyerSellerGenericModel) {
            this.buyerSellerGenericModel = _buyerSellerGenericModel == null ? null : _buyerSellerGenericModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="dayCountFraction")
        @RuneAttribute(value="dayCountFraction")
        public TradeUnderlyer2Builder setDayCountFraction(DayCountFraction _dayCountFraction) {
            this.dayCountFraction = _dayCountFraction == null ? null : _dayCountFraction.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public TradeUnderlyer2Builder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="buyerSellerModel")
        @RuneAttribute(value="buyerSellerModel")
        public TradeUnderlyer2Builder setBuyerSellerModel(BuyerSellerModel _buyerSellerModel) {
            this.buyerSellerModel = _buyerSellerModel == null ? null : _buyerSellerModel.toBuilder();
            return this;
        }

        @Override
        public TradeUnderlyer2 build() {
            return new TradeUnderlyer2Impl(this);
        }

        @Override
        public TradeUnderlyer2Builder toBuilder() {
            return this;
        }

        @Override
        public TradeUnderlyer2Builder prune() {
            if (this.floatingRate != null && !this.floatingRate.prune().hasData()) {
                this.floatingRate = null;
            }
            if (this.fixedRate != null && !this.fixedRate.prune().hasData()) {
                this.fixedRate = null;
            }
            if (this.exchangeRate != null && !this.exchangeRate.prune().hasData()) {
                this.exchangeRate = null;
            }
            if (this.underlyingAsset != null && !this.underlyingAsset.prune().hasData()) {
                this.underlyingAsset = null;
            }
            if (this.quotedCurrencyPair != null && !this.quotedCurrencyPair.prune().hasData()) {
                this.quotedCurrencyPair = null;
            }
            if (this.referenceEntity != null && !this.referenceEntity.prune().hasData()) {
                this.referenceEntity = null;
            }
            if (this.indexReferenceInformation != null && !this.indexReferenceInformation.prune().hasData()) {
                this.indexReferenceInformation = null;
            }
            if (this.gas != null && !this.gas.prune().hasData()) {
                this.gas = null;
            }
            if (this.oil != null && !this.oil.prune().hasData()) {
                this.oil = null;
            }
            if (this.coal != null && !this.coal.prune().hasData()) {
                this.coal = null;
            }
            if (this.electricity != null && !this.electricity.prune().hasData()) {
                this.electricity = null;
            }
            if (this.payerReceiverModel != null && !this.payerReceiverModel.prune().hasData()) {
                this.payerReceiverModel = null;
            }
            if (this.buyerSellerGenericModel != null && !this.buyerSellerGenericModel.prune().hasData()) {
                this.buyerSellerGenericModel = null;
            }
            if (this.dayCountFraction != null && !this.dayCountFraction.prune().hasData()) {
                this.dayCountFraction = null;
            }
            if (this.buyerSellerModel != null && !this.buyerSellerModel.prune().hasData()) {
                this.buyerSellerModel = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getFloatingRate() != null && this.getFloatingRate().hasData()) {
                return true;
            }
            if (this.getFixedRate() != null && this.getFixedRate().hasData()) {
                return true;
            }
            if (this.getExchangeRate() != null && this.getExchangeRate().hasData()) {
                return true;
            }
            if (this.getUnderlyingAsset() != null && this.getUnderlyingAsset().hasData()) {
                return true;
            }
            if (this.getQuotedCurrencyPair() != null && this.getQuotedCurrencyPair().hasData()) {
                return true;
            }
            if (this.getReferenceEntity() != null && this.getReferenceEntity().hasData()) {
                return true;
            }
            if (this.getIndexReferenceInformation() != null && this.getIndexReferenceInformation().hasData()) {
                return true;
            }
            if (this.getGas() != null && this.getGas().hasData()) {
                return true;
            }
            if (this.getOil() != null && this.getOil().hasData()) {
                return true;
            }
            if (this.getCoal() != null && this.getCoal().hasData()) {
                return true;
            }
            if (this.getElectricity() != null && this.getElectricity().hasData()) {
                return true;
            }
            if (this.getAveragingMethod() != null) {
                return true;
            }
            if (this.getPayerReceiverModel() != null && this.getPayerReceiverModel().hasData()) {
                return true;
            }
            if (this.getBuyerSellerGenericModel() != null && this.getBuyerSellerGenericModel().hasData()) {
                return true;
            }
            if (this.getDayCountFraction() != null && this.getDayCountFraction().hasData()) {
                return true;
            }
            if (this.getId() != null) {
                return true;
            }
            return this.getBuyerSellerModel() != null && this.getBuyerSellerModel().hasData();
        }

        public TradeUnderlyer2Builder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            TradeUnderlyer2Builder o = (TradeUnderlyer2Builder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFloatingRate(), (RosettaModelObjectBuilder)o.getFloatingRate(), this::setFloatingRate);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFixedRate(), (RosettaModelObjectBuilder)o.getFixedRate(), this::setFixedRate);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getExchangeRate(), (RosettaModelObjectBuilder)o.getExchangeRate(), this::setExchangeRate);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getUnderlyingAsset(), (RosettaModelObjectBuilder)o.getUnderlyingAsset(), this::setUnderlyingAsset);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getQuotedCurrencyPair(), (RosettaModelObjectBuilder)o.getQuotedCurrencyPair(), this::setQuotedCurrencyPair);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getReferenceEntity(), (RosettaModelObjectBuilder)o.getReferenceEntity(), this::setReferenceEntity);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getIndexReferenceInformation(), (RosettaModelObjectBuilder)o.getIndexReferenceInformation(), this::setIndexReferenceInformation);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getGas(), (RosettaModelObjectBuilder)o.getGas(), this::setGas);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getOil(), (RosettaModelObjectBuilder)o.getOil(), this::setOil);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCoal(), (RosettaModelObjectBuilder)o.getCoal(), this::setCoal);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getElectricity(), (RosettaModelObjectBuilder)o.getElectricity(), this::setElectricity);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPayerReceiverModel(), (RosettaModelObjectBuilder)o.getPayerReceiverModel(), this::setPayerReceiverModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getBuyerSellerGenericModel(), (RosettaModelObjectBuilder)o.getBuyerSellerGenericModel(), this::setBuyerSellerGenericModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDayCountFraction(), (RosettaModelObjectBuilder)o.getDayCountFraction(), this::setDayCountFraction);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getBuyerSellerModel(), (RosettaModelObjectBuilder)o.getBuyerSellerModel(), this::setBuyerSellerModel);
            merger.mergeBasic((Object)this.getAveragingMethod(), (Object)o.getAveragingMethod(), this::setAveragingMethod, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getId(), (Object)o.getId(), this::setId, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            TradeUnderlyer2 _that = this.getType().cast(o);
            if (!Objects.equals(this.floatingRate, _that.getFloatingRate())) {
                return false;
            }
            if (!Objects.equals(this.fixedRate, _that.getFixedRate())) {
                return false;
            }
            if (!Objects.equals(this.exchangeRate, _that.getExchangeRate())) {
                return false;
            }
            if (!Objects.equals(this.underlyingAsset, _that.getUnderlyingAsset())) {
                return false;
            }
            if (!Objects.equals(this.quotedCurrencyPair, _that.getQuotedCurrencyPair())) {
                return false;
            }
            if (!Objects.equals(this.referenceEntity, _that.getReferenceEntity())) {
                return false;
            }
            if (!Objects.equals(this.indexReferenceInformation, _that.getIndexReferenceInformation())) {
                return false;
            }
            if (!Objects.equals(this.gas, _that.getGas())) {
                return false;
            }
            if (!Objects.equals(this.oil, _that.getOil())) {
                return false;
            }
            if (!Objects.equals(this.coal, _that.getCoal())) {
                return false;
            }
            if (!Objects.equals(this.electricity, _that.getElectricity())) {
                return false;
            }
            if (!Objects.equals((Object)this.averagingMethod, (Object)_that.getAveragingMethod())) {
                return false;
            }
            if (!Objects.equals(this.payerReceiverModel, _that.getPayerReceiverModel())) {
                return false;
            }
            if (!Objects.equals(this.buyerSellerGenericModel, _that.getBuyerSellerGenericModel())) {
                return false;
            }
            if (!Objects.equals(this.dayCountFraction, _that.getDayCountFraction())) {
                return false;
            }
            if (!Objects.equals(this.id, _that.getId())) {
                return false;
            }
            return Objects.equals(this.buyerSellerModel, _that.getBuyerSellerModel());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.floatingRate != null ? this.floatingRate.hashCode() : 0);
            _result = 31 * _result + (this.fixedRate != null ? this.fixedRate.hashCode() : 0);
            _result = 31 * _result + (this.exchangeRate != null ? this.exchangeRate.hashCode() : 0);
            _result = 31 * _result + (this.underlyingAsset != null ? this.underlyingAsset.hashCode() : 0);
            _result = 31 * _result + (this.quotedCurrencyPair != null ? this.quotedCurrencyPair.hashCode() : 0);
            _result = 31 * _result + (this.referenceEntity != null ? this.referenceEntity.hashCode() : 0);
            _result = 31 * _result + (this.indexReferenceInformation != null ? this.indexReferenceInformation.hashCode() : 0);
            _result = 31 * _result + (this.gas != null ? this.gas.hashCode() : 0);
            _result = 31 * _result + (this.oil != null ? this.oil.hashCode() : 0);
            _result = 31 * _result + (this.coal != null ? this.coal.hashCode() : 0);
            _result = 31 * _result + (this.electricity != null ? this.electricity.hashCode() : 0);
            _result = 31 * _result + (this.averagingMethod != null ? ((Object)((Object)this.averagingMethod)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.payerReceiverModel != null ? this.payerReceiverModel.hashCode() : 0);
            _result = 31 * _result + (this.buyerSellerGenericModel != null ? this.buyerSellerGenericModel.hashCode() : 0);
            _result = 31 * _result + (this.dayCountFraction != null ? this.dayCountFraction.hashCode() : 0);
            _result = 31 * _result + (this.id != null ? this.id.hashCode() : 0);
            _result = 31 * _result + (this.buyerSellerModel != null ? this.buyerSellerModel.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "TradeUnderlyer2Builder {floatingRate=" + this.floatingRate + ", fixedRate=" + this.fixedRate + ", exchangeRate=" + this.exchangeRate + ", underlyingAsset=" + this.underlyingAsset + ", quotedCurrencyPair=" + this.quotedCurrencyPair + ", referenceEntity=" + this.referenceEntity + ", indexReferenceInformation=" + this.indexReferenceInformation + ", gas=" + this.gas + ", oil=" + this.oil + ", coal=" + this.coal + ", electricity=" + this.electricity + ", averagingMethod=" + (Object)((Object)this.averagingMethod) + ", payerReceiverModel=" + this.payerReceiverModel + ", buyerSellerGenericModel=" + this.buyerSellerGenericModel + ", dayCountFraction=" + this.dayCountFraction + ", id=" + this.id + ", buyerSellerModel=" + this.buyerSellerModel + '}';
        }
    }

    public static interface TradeUnderlyer2Builder
    extends TradeUnderlyer2,
    RosettaModelObjectBuilder {
        public FloatingRate.FloatingRateBuilder getOrCreateFloatingRate();

        @Override
        public FloatingRate.FloatingRateBuilder getFloatingRate();

        public Schedule.ScheduleBuilder getOrCreateFixedRate();

        @Override
        public Schedule.ScheduleBuilder getFixedRate();

        public GenericProductExchangeRate.GenericProductExchangeRateBuilder getOrCreateExchangeRate();

        @Override
        public GenericProductExchangeRate.GenericProductExchangeRateBuilder getExchangeRate();

        public Asset.AssetBuilder getOrCreateUnderlyingAsset();

        @Override
        public Asset.AssetBuilder getUnderlyingAsset();

        public QuotedCurrencyPair.QuotedCurrencyPairBuilder getOrCreateQuotedCurrencyPair();

        @Override
        public QuotedCurrencyPair.QuotedCurrencyPairBuilder getQuotedCurrencyPair();

        public LegalEntity.LegalEntityBuilder getOrCreateReferenceEntity();

        @Override
        public LegalEntity.LegalEntityBuilder getReferenceEntity();

        public IndexReferenceInformation.IndexReferenceInformationBuilder getOrCreateIndexReferenceInformation();

        @Override
        public IndexReferenceInformation.IndexReferenceInformationBuilder getIndexReferenceInformation();

        public GasProduct.GasProductBuilder getOrCreateGas();

        @Override
        public GasProduct.GasProductBuilder getGas();

        public OilProduct.OilProductBuilder getOrCreateOil();

        @Override
        public OilProduct.OilProductBuilder getOil();

        public CoalProduct.CoalProductBuilder getOrCreateCoal();

        @Override
        public CoalProduct.CoalProductBuilder getCoal();

        public ElectricityProduct.ElectricityProductBuilder getOrCreateElectricity();

        @Override
        public ElectricityProduct.ElectricityProductBuilder getElectricity();

        public PayerReceiverModel.PayerReceiverModelBuilder getOrCreatePayerReceiverModel();

        @Override
        public PayerReceiverModel.PayerReceiverModelBuilder getPayerReceiverModel();

        public BuyerSellerGenericModel.BuyerSellerGenericModelBuilder getOrCreateBuyerSellerGenericModel();

        @Override
        public BuyerSellerGenericModel.BuyerSellerGenericModelBuilder getBuyerSellerGenericModel();

        public DayCountFraction.DayCountFractionBuilder getOrCreateDayCountFraction();

        @Override
        public DayCountFraction.DayCountFractionBuilder getDayCountFraction();

        public BuyerSellerModel.BuyerSellerModelBuilder getOrCreateBuyerSellerModel();

        @Override
        public BuyerSellerModel.BuyerSellerModelBuilder getBuyerSellerModel();

        public TradeUnderlyer2Builder setFloatingRate(FloatingRate var1);

        public TradeUnderlyer2Builder setFixedRate(Schedule var1);

        public TradeUnderlyer2Builder setExchangeRate(GenericProductExchangeRate var1);

        public TradeUnderlyer2Builder setUnderlyingAsset(Asset var1);

        public TradeUnderlyer2Builder setQuotedCurrencyPair(QuotedCurrencyPair var1);

        public TradeUnderlyer2Builder setReferenceEntity(LegalEntity var1);

        public TradeUnderlyer2Builder setIndexReferenceInformation(IndexReferenceInformation var1);

        public TradeUnderlyer2Builder setGas(GasProduct var1);

        public TradeUnderlyer2Builder setOil(OilProduct var1);

        public TradeUnderlyer2Builder setCoal(CoalProduct var1);

        public TradeUnderlyer2Builder setElectricity(ElectricityProduct var1);

        public TradeUnderlyer2Builder setAveragingMethod(AveragingMethodEnum var1);

        public TradeUnderlyer2Builder setPayerReceiverModel(PayerReceiverModel var1);

        public TradeUnderlyer2Builder setBuyerSellerGenericModel(BuyerSellerGenericModel var1);

        public TradeUnderlyer2Builder setDayCountFraction(DayCountFraction var1);

        public TradeUnderlyer2Builder setId(String var1);

        public TradeUnderlyer2Builder setBuyerSellerModel(BuyerSellerModel var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("floatingRate"), processor, FloatingRate.FloatingRateBuilder.class, this.getFloatingRate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("fixedRate"), processor, Schedule.ScheduleBuilder.class, this.getFixedRate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("exchangeRate"), processor, GenericProductExchangeRate.GenericProductExchangeRateBuilder.class, this.getExchangeRate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("underlyingAsset"), processor, Asset.AssetBuilder.class, this.getUnderlyingAsset(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("quotedCurrencyPair"), processor, QuotedCurrencyPair.QuotedCurrencyPairBuilder.class, this.getQuotedCurrencyPair(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("referenceEntity"), processor, LegalEntity.LegalEntityBuilder.class, this.getReferenceEntity(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("indexReferenceInformation"), processor, IndexReferenceInformation.IndexReferenceInformationBuilder.class, this.getIndexReferenceInformation(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("gas"), processor, GasProduct.GasProductBuilder.class, this.getGas(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("oil"), processor, OilProduct.OilProductBuilder.class, this.getOil(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("coal"), processor, CoalProduct.CoalProductBuilder.class, this.getCoal(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("electricity"), processor, ElectricityProduct.ElectricityProductBuilder.class, this.getElectricity(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("averagingMethod"), AveragingMethodEnum.class, (Object)this.getAveragingMethod(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("payerReceiverModel"), processor, PayerReceiverModel.PayerReceiverModelBuilder.class, this.getPayerReceiverModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("buyerSellerGenericModel"), processor, BuyerSellerGenericModel.BuyerSellerGenericModelBuilder.class, this.getBuyerSellerGenericModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("dayCountFraction"), processor, DayCountFraction.DayCountFractionBuilder.class, this.getDayCountFraction(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("buyerSellerModel"), processor, BuyerSellerModel.BuyerSellerModelBuilder.class, this.getBuyerSellerModel(), new AttributeMeta[0]);
        }

        public TradeUnderlyer2Builder prune();
    }

    public static class TradeUnderlyer2Impl
    implements TradeUnderlyer2 {
        private final FloatingRate floatingRate;
        private final Schedule fixedRate;
        private final GenericProductExchangeRate exchangeRate;
        private final Asset underlyingAsset;
        private final QuotedCurrencyPair quotedCurrencyPair;
        private final LegalEntity referenceEntity;
        private final IndexReferenceInformation indexReferenceInformation;
        private final GasProduct gas;
        private final OilProduct oil;
        private final CoalProduct coal;
        private final ElectricityProduct electricity;
        private final AveragingMethodEnum averagingMethod;
        private final PayerReceiverModel payerReceiverModel;
        private final BuyerSellerGenericModel buyerSellerGenericModel;
        private final DayCountFraction dayCountFraction;
        private final String id;
        private final BuyerSellerModel buyerSellerModel;

        protected TradeUnderlyer2Impl(TradeUnderlyer2Builder builder) {
            this.floatingRate = Optional.ofNullable(builder.getFloatingRate()).map(f -> f.build()).orElse(null);
            this.fixedRate = Optional.ofNullable(builder.getFixedRate()).map(f -> f.build()).orElse(null);
            this.exchangeRate = Optional.ofNullable(builder.getExchangeRate()).map(f -> f.build()).orElse(null);
            this.underlyingAsset = Optional.ofNullable(builder.getUnderlyingAsset()).map(f -> f.build()).orElse(null);
            this.quotedCurrencyPair = Optional.ofNullable(builder.getQuotedCurrencyPair()).map(f -> f.build()).orElse(null);
            this.referenceEntity = Optional.ofNullable(builder.getReferenceEntity()).map(f -> f.build()).orElse(null);
            this.indexReferenceInformation = Optional.ofNullable(builder.getIndexReferenceInformation()).map(f -> f.build()).orElse(null);
            this.gas = Optional.ofNullable(builder.getGas()).map(f -> f.build()).orElse(null);
            this.oil = Optional.ofNullable(builder.getOil()).map(f -> f.build()).orElse(null);
            this.coal = Optional.ofNullable(builder.getCoal()).map(f -> f.build()).orElse(null);
            this.electricity = Optional.ofNullable(builder.getElectricity()).map(f -> f.build()).orElse(null);
            this.averagingMethod = builder.getAveragingMethod();
            this.payerReceiverModel = Optional.ofNullable(builder.getPayerReceiverModel()).map(f -> f.build()).orElse(null);
            this.buyerSellerGenericModel = Optional.ofNullable(builder.getBuyerSellerGenericModel()).map(f -> f.build()).orElse(null);
            this.dayCountFraction = Optional.ofNullable(builder.getDayCountFraction()).map(f -> f.build()).orElse(null);
            this.id = builder.getId();
            this.buyerSellerModel = Optional.ofNullable(builder.getBuyerSellerModel()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="floatingRate")
        @RuneAttribute(value="floatingRate")
        public FloatingRate getFloatingRate() {
            return this.floatingRate;
        }

        @Override
        @RosettaAttribute(value="fixedRate")
        @RuneAttribute(value="fixedRate")
        public Schedule getFixedRate() {
            return this.fixedRate;
        }

        @Override
        @RosettaAttribute(value="exchangeRate")
        @RuneAttribute(value="exchangeRate")
        public GenericProductExchangeRate getExchangeRate() {
            return this.exchangeRate;
        }

        @Override
        @RosettaAttribute(value="underlyingAsset")
        @RuneAttribute(value="underlyingAsset")
        public Asset getUnderlyingAsset() {
            return this.underlyingAsset;
        }

        @Override
        @RosettaAttribute(value="quotedCurrencyPair")
        @RuneAttribute(value="quotedCurrencyPair")
        public QuotedCurrencyPair getQuotedCurrencyPair() {
            return this.quotedCurrencyPair;
        }

        @Override
        @RosettaAttribute(value="referenceEntity")
        @RuneAttribute(value="referenceEntity")
        public LegalEntity getReferenceEntity() {
            return this.referenceEntity;
        }

        @Override
        @RosettaAttribute(value="indexReferenceInformation")
        @RuneAttribute(value="indexReferenceInformation")
        public IndexReferenceInformation getIndexReferenceInformation() {
            return this.indexReferenceInformation;
        }

        @Override
        @RosettaAttribute(value="gas")
        @RuneAttribute(value="gas")
        public GasProduct getGas() {
            return this.gas;
        }

        @Override
        @RosettaAttribute(value="oil")
        @RuneAttribute(value="oil")
        public OilProduct getOil() {
            return this.oil;
        }

        @Override
        @RosettaAttribute(value="coal")
        @RuneAttribute(value="coal")
        public CoalProduct getCoal() {
            return this.coal;
        }

        @Override
        @RosettaAttribute(value="electricity")
        @RuneAttribute(value="electricity")
        public ElectricityProduct getElectricity() {
            return this.electricity;
        }

        @Override
        @RosettaAttribute(value="averagingMethod")
        @RuneAttribute(value="averagingMethod")
        public AveragingMethodEnum getAveragingMethod() {
            return this.averagingMethod;
        }

        @Override
        @RosettaAttribute(value="payerReceiverModel")
        @RuneAttribute(value="payerReceiverModel")
        public PayerReceiverModel getPayerReceiverModel() {
            return this.payerReceiverModel;
        }

        @Override
        @RosettaAttribute(value="buyerSellerGenericModel")
        @RuneAttribute(value="buyerSellerGenericModel")
        public BuyerSellerGenericModel getBuyerSellerGenericModel() {
            return this.buyerSellerGenericModel;
        }

        @Override
        @RosettaAttribute(value="dayCountFraction")
        @RuneAttribute(value="dayCountFraction")
        public DayCountFraction getDayCountFraction() {
            return this.dayCountFraction;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public String getId() {
            return this.id;
        }

        @Override
        @RosettaAttribute(value="buyerSellerModel")
        @RuneAttribute(value="buyerSellerModel")
        public BuyerSellerModel getBuyerSellerModel() {
            return this.buyerSellerModel;
        }

        @Override
        public TradeUnderlyer2 build() {
            return this;
        }

        @Override
        public TradeUnderlyer2Builder toBuilder() {
            TradeUnderlyer2Builder builder = TradeUnderlyer2.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(TradeUnderlyer2Builder builder) {
            Optional.ofNullable(this.getFloatingRate()).ifPresent(builder::setFloatingRate);
            Optional.ofNullable(this.getFixedRate()).ifPresent(builder::setFixedRate);
            Optional.ofNullable(this.getExchangeRate()).ifPresent(builder::setExchangeRate);
            Optional.ofNullable(this.getUnderlyingAsset()).ifPresent(builder::setUnderlyingAsset);
            Optional.ofNullable(this.getQuotedCurrencyPair()).ifPresent(builder::setQuotedCurrencyPair);
            Optional.ofNullable(this.getReferenceEntity()).ifPresent(builder::setReferenceEntity);
            Optional.ofNullable(this.getIndexReferenceInformation()).ifPresent(builder::setIndexReferenceInformation);
            Optional.ofNullable(this.getGas()).ifPresent(builder::setGas);
            Optional.ofNullable(this.getOil()).ifPresent(builder::setOil);
            Optional.ofNullable(this.getCoal()).ifPresent(builder::setCoal);
            Optional.ofNullable(this.getElectricity()).ifPresent(builder::setElectricity);
            Optional.ofNullable(this.getAveragingMethod()).ifPresent(builder::setAveragingMethod);
            Optional.ofNullable(this.getPayerReceiverModel()).ifPresent(builder::setPayerReceiverModel);
            Optional.ofNullable(this.getBuyerSellerGenericModel()).ifPresent(builder::setBuyerSellerGenericModel);
            Optional.ofNullable(this.getDayCountFraction()).ifPresent(builder::setDayCountFraction);
            Optional.ofNullable(this.getId()).ifPresent(builder::setId);
            Optional.ofNullable(this.getBuyerSellerModel()).ifPresent(builder::setBuyerSellerModel);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            TradeUnderlyer2 _that = this.getType().cast(o);
            if (!Objects.equals(this.floatingRate, _that.getFloatingRate())) {
                return false;
            }
            if (!Objects.equals(this.fixedRate, _that.getFixedRate())) {
                return false;
            }
            if (!Objects.equals(this.exchangeRate, _that.getExchangeRate())) {
                return false;
            }
            if (!Objects.equals(this.underlyingAsset, _that.getUnderlyingAsset())) {
                return false;
            }
            if (!Objects.equals(this.quotedCurrencyPair, _that.getQuotedCurrencyPair())) {
                return false;
            }
            if (!Objects.equals(this.referenceEntity, _that.getReferenceEntity())) {
                return false;
            }
            if (!Objects.equals(this.indexReferenceInformation, _that.getIndexReferenceInformation())) {
                return false;
            }
            if (!Objects.equals(this.gas, _that.getGas())) {
                return false;
            }
            if (!Objects.equals(this.oil, _that.getOil())) {
                return false;
            }
            if (!Objects.equals(this.coal, _that.getCoal())) {
                return false;
            }
            if (!Objects.equals(this.electricity, _that.getElectricity())) {
                return false;
            }
            if (!Objects.equals((Object)this.averagingMethod, (Object)_that.getAveragingMethod())) {
                return false;
            }
            if (!Objects.equals(this.payerReceiverModel, _that.getPayerReceiverModel())) {
                return false;
            }
            if (!Objects.equals(this.buyerSellerGenericModel, _that.getBuyerSellerGenericModel())) {
                return false;
            }
            if (!Objects.equals(this.dayCountFraction, _that.getDayCountFraction())) {
                return false;
            }
            if (!Objects.equals(this.id, _that.getId())) {
                return false;
            }
            return Objects.equals(this.buyerSellerModel, _that.getBuyerSellerModel());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.floatingRate != null ? this.floatingRate.hashCode() : 0);
            _result = 31 * _result + (this.fixedRate != null ? this.fixedRate.hashCode() : 0);
            _result = 31 * _result + (this.exchangeRate != null ? this.exchangeRate.hashCode() : 0);
            _result = 31 * _result + (this.underlyingAsset != null ? this.underlyingAsset.hashCode() : 0);
            _result = 31 * _result + (this.quotedCurrencyPair != null ? this.quotedCurrencyPair.hashCode() : 0);
            _result = 31 * _result + (this.referenceEntity != null ? this.referenceEntity.hashCode() : 0);
            _result = 31 * _result + (this.indexReferenceInformation != null ? this.indexReferenceInformation.hashCode() : 0);
            _result = 31 * _result + (this.gas != null ? this.gas.hashCode() : 0);
            _result = 31 * _result + (this.oil != null ? this.oil.hashCode() : 0);
            _result = 31 * _result + (this.coal != null ? this.coal.hashCode() : 0);
            _result = 31 * _result + (this.electricity != null ? this.electricity.hashCode() : 0);
            _result = 31 * _result + (this.averagingMethod != null ? ((Object)((Object)this.averagingMethod)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.payerReceiverModel != null ? this.payerReceiverModel.hashCode() : 0);
            _result = 31 * _result + (this.buyerSellerGenericModel != null ? this.buyerSellerGenericModel.hashCode() : 0);
            _result = 31 * _result + (this.dayCountFraction != null ? this.dayCountFraction.hashCode() : 0);
            _result = 31 * _result + (this.id != null ? this.id.hashCode() : 0);
            _result = 31 * _result + (this.buyerSellerModel != null ? this.buyerSellerModel.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "TradeUnderlyer2 {floatingRate=" + this.floatingRate + ", fixedRate=" + this.fixedRate + ", exchangeRate=" + this.exchangeRate + ", underlyingAsset=" + this.underlyingAsset + ", quotedCurrencyPair=" + this.quotedCurrencyPair + ", referenceEntity=" + this.referenceEntity + ", indexReferenceInformation=" + this.indexReferenceInformation + ", gas=" + this.gas + ", oil=" + this.oil + ", coal=" + this.coal + ", electricity=" + this.electricity + ", averagingMethod=" + (Object)((Object)this.averagingMethod) + ", payerReceiverModel=" + this.payerReceiverModel + ", buyerSellerGenericModel=" + this.buyerSellerGenericModel + ", dayCountFraction=" + this.dayCountFraction + ", id=" + this.id + ", buyerSellerModel=" + this.buyerSellerModel + '}';
        }
    }
}

