/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.fx.targets;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.fx.targets.meta.SettlementPeriodMeta;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="SettlementPeriod", builder=SettlementPeriodBuilderImpl.class, version="1.1.0")
@RuneDataType(value="SettlementPeriod", model="fpml", builder=SettlementPeriodBuilderImpl.class, version="1.1.0")
public interface SettlementPeriod
extends RosettaModelObject {
    public static final SettlementPeriodMeta metaData = new SettlementPeriodMeta();

    public ZonedDateTime getExpiryDate();

    public ZonedDateTime getSettlementDate();

    public BigDecimal getNotionalAmount();

    public SettlementPeriod build();

    public SettlementPeriodBuilder toBuilder();

    public static SettlementPeriodBuilder builder() {
        return new SettlementPeriodBuilderImpl();
    }

    default public RosettaMetaData<? extends SettlementPeriod> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends SettlementPeriod> getType() {
        return SettlementPeriod.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("expiryDate"), ZonedDateTime.class, (Object)this.getExpiryDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("settlementDate"), ZonedDateTime.class, (Object)this.getSettlementDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("notionalAmount"), BigDecimal.class, (Object)this.getNotionalAmount(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class SettlementPeriodBuilderImpl
    implements SettlementPeriodBuilder {
        protected ZonedDateTime expiryDate;
        protected ZonedDateTime settlementDate;
        protected BigDecimal notionalAmount;

        @Override
        @RosettaAttribute(value="expiryDate", isRequired=true)
        @RuneAttribute(value="expiryDate", isRequired=true)
        public ZonedDateTime getExpiryDate() {
            return this.expiryDate;
        }

        @Override
        @RosettaAttribute(value="settlementDate", isRequired=true)
        @RuneAttribute(value="settlementDate", isRequired=true)
        public ZonedDateTime getSettlementDate() {
            return this.settlementDate;
        }

        @Override
        @RosettaAttribute(value="notionalAmount", isRequired=true)
        @RuneAttribute(value="notionalAmount", isRequired=true)
        public BigDecimal getNotionalAmount() {
            return this.notionalAmount;
        }

        @Override
        @RosettaAttribute(value="expiryDate", isRequired=true)
        @RuneAttribute(value="expiryDate", isRequired=true)
        public SettlementPeriodBuilder setExpiryDate(ZonedDateTime _expiryDate) {
            this.expiryDate = _expiryDate == null ? null : _expiryDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="settlementDate", isRequired=true)
        @RuneAttribute(value="settlementDate", isRequired=true)
        public SettlementPeriodBuilder setSettlementDate(ZonedDateTime _settlementDate) {
            this.settlementDate = _settlementDate == null ? null : _settlementDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="notionalAmount", isRequired=true)
        @RuneAttribute(value="notionalAmount", isRequired=true)
        public SettlementPeriodBuilder setNotionalAmount(BigDecimal _notionalAmount) {
            this.notionalAmount = _notionalAmount == null ? null : _notionalAmount;
            return this;
        }

        @Override
        public SettlementPeriod build() {
            return new SettlementPeriodImpl(this);
        }

        @Override
        public SettlementPeriodBuilder toBuilder() {
            return this;
        }

        @Override
        public SettlementPeriodBuilder prune() {
            return this;
        }

        public boolean hasData() {
            if (this.getExpiryDate() != null) {
                return true;
            }
            if (this.getSettlementDate() != null) {
                return true;
            }
            return this.getNotionalAmount() != null;
        }

        public SettlementPeriodBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            SettlementPeriodBuilder o = (SettlementPeriodBuilder)other;
            merger.mergeBasic((Object)this.getExpiryDate(), (Object)o.getExpiryDate(), this::setExpiryDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSettlementDate(), (Object)o.getSettlementDate(), this::setSettlementDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getNotionalAmount(), (Object)o.getNotionalAmount(), this::setNotionalAmount, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            SettlementPeriod _that = this.getType().cast(o);
            if (!Objects.equals(this.expiryDate, _that.getExpiryDate())) {
                return false;
            }
            if (!Objects.equals(this.settlementDate, _that.getSettlementDate())) {
                return false;
            }
            return Objects.equals(this.notionalAmount, _that.getNotionalAmount());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.expiryDate != null ? this.expiryDate.hashCode() : 0);
            _result = 31 * _result + (this.settlementDate != null ? this.settlementDate.hashCode() : 0);
            _result = 31 * _result + (this.notionalAmount != null ? this.notionalAmount.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "SettlementPeriodBuilder {expiryDate=" + this.expiryDate + ", settlementDate=" + this.settlementDate + ", notionalAmount=" + this.notionalAmount + '}';
        }
    }

    public static interface SettlementPeriodBuilder
    extends SettlementPeriod,
    RosettaModelObjectBuilder {
        public SettlementPeriodBuilder setExpiryDate(ZonedDateTime var1);

        public SettlementPeriodBuilder setSettlementDate(ZonedDateTime var1);

        public SettlementPeriodBuilder setNotionalAmount(BigDecimal var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("expiryDate"), ZonedDateTime.class, (Object)this.getExpiryDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("settlementDate"), ZonedDateTime.class, (Object)this.getSettlementDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("notionalAmount"), BigDecimal.class, (Object)this.getNotionalAmount(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public SettlementPeriodBuilder prune();
    }

    public static class SettlementPeriodImpl
    implements SettlementPeriod {
        private final ZonedDateTime expiryDate;
        private final ZonedDateTime settlementDate;
        private final BigDecimal notionalAmount;

        protected SettlementPeriodImpl(SettlementPeriodBuilder builder) {
            this.expiryDate = builder.getExpiryDate();
            this.settlementDate = builder.getSettlementDate();
            this.notionalAmount = builder.getNotionalAmount();
        }

        @Override
        @RosettaAttribute(value="expiryDate", isRequired=true)
        @RuneAttribute(value="expiryDate", isRequired=true)
        public ZonedDateTime getExpiryDate() {
            return this.expiryDate;
        }

        @Override
        @RosettaAttribute(value="settlementDate", isRequired=true)
        @RuneAttribute(value="settlementDate", isRequired=true)
        public ZonedDateTime getSettlementDate() {
            return this.settlementDate;
        }

        @Override
        @RosettaAttribute(value="notionalAmount", isRequired=true)
        @RuneAttribute(value="notionalAmount", isRequired=true)
        public BigDecimal getNotionalAmount() {
            return this.notionalAmount;
        }

        @Override
        public SettlementPeriod build() {
            return this;
        }

        @Override
        public SettlementPeriodBuilder toBuilder() {
            SettlementPeriodBuilder builder = SettlementPeriod.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(SettlementPeriodBuilder builder) {
            Optional.ofNullable(this.getExpiryDate()).ifPresent(builder::setExpiryDate);
            Optional.ofNullable(this.getSettlementDate()).ifPresent(builder::setSettlementDate);
            Optional.ofNullable(this.getNotionalAmount()).ifPresent(builder::setNotionalAmount);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            SettlementPeriod _that = this.getType().cast(o);
            if (!Objects.equals(this.expiryDate, _that.getExpiryDate())) {
                return false;
            }
            if (!Objects.equals(this.settlementDate, _that.getSettlementDate())) {
                return false;
            }
            return Objects.equals(this.notionalAmount, _that.getNotionalAmount());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.expiryDate != null ? this.expiryDate.hashCode() : 0);
            _result = 31 * _result + (this.settlementDate != null ? this.settlementDate.hashCode() : 0);
            _result = 31 * _result + (this.notionalAmount != null ? this.notionalAmount.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "SettlementPeriod {expiryDate=" + this.expiryDate + ", settlementDate=" + this.settlementDate + ", notionalAmount=" + this.notionalAmount + '}';
        }
    }
}

