/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.fx.targets;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.fx.targets.FxCounterCurrencyAmount;
import fpml.consolidated.fx.targets.meta.FxTargetLeverageSequenceMeta;
import fpml.consolidated.shared.NonNegativeAmountSchedule;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="FxTargetLeverageSequence", builder=FxTargetLeverageSequenceBuilderImpl.class, version="1.1.0")
@RuneDataType(value="FxTargetLeverageSequence", model="fpml", builder=FxTargetLeverageSequenceBuilderImpl.class, version="1.1.0")
public interface FxTargetLeverageSequence
extends RosettaModelObject {
    public static final FxTargetLeverageSequenceMeta metaData = new FxTargetLeverageSequenceMeta();

    public NonNegativeAmountSchedule getNotionalAmount();

    public List<? extends FxCounterCurrencyAmount> getCounterCurrencyAmount();

    public FxTargetLeverageSequence build();

    public FxTargetLeverageSequenceBuilder toBuilder();

    public static FxTargetLeverageSequenceBuilder builder() {
        return new FxTargetLeverageSequenceBuilderImpl();
    }

    default public RosettaMetaData<? extends FxTargetLeverageSequence> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends FxTargetLeverageSequence> getType() {
        return FxTargetLeverageSequence.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("notionalAmount"), processor, NonNegativeAmountSchedule.class, this.getNotionalAmount(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("counterCurrencyAmount"), processor, FxCounterCurrencyAmount.class, this.getCounterCurrencyAmount(), new AttributeMeta[0]);
    }

    public static class FxTargetLeverageSequenceBuilderImpl
    implements FxTargetLeverageSequenceBuilder {
        protected NonNegativeAmountSchedule.NonNegativeAmountScheduleBuilder notionalAmount;
        protected List<FxCounterCurrencyAmount.FxCounterCurrencyAmountBuilder> counterCurrencyAmount = new ArrayList<FxCounterCurrencyAmount.FxCounterCurrencyAmountBuilder>();

        @Override
        @RosettaAttribute(value="notionalAmount", isRequired=true)
        @RuneAttribute(value="notionalAmount", isRequired=true)
        public NonNegativeAmountSchedule.NonNegativeAmountScheduleBuilder getNotionalAmount() {
            return this.notionalAmount;
        }

        @Override
        public NonNegativeAmountSchedule.NonNegativeAmountScheduleBuilder getOrCreateNotionalAmount() {
            NonNegativeAmountSchedule.NonNegativeAmountScheduleBuilder result = this.notionalAmount != null ? this.notionalAmount : (this.notionalAmount = NonNegativeAmountSchedule.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="counterCurrencyAmount")
        @RuneAttribute(value="counterCurrencyAmount")
        public List<? extends FxCounterCurrencyAmount.FxCounterCurrencyAmountBuilder> getCounterCurrencyAmount() {
            return this.counterCurrencyAmount;
        }

        @Override
        public FxCounterCurrencyAmount.FxCounterCurrencyAmountBuilder getOrCreateCounterCurrencyAmount(int index) {
            if (this.counterCurrencyAmount == null) {
                this.counterCurrencyAmount = new ArrayList<FxCounterCurrencyAmount.FxCounterCurrencyAmountBuilder>();
            }
            return (FxCounterCurrencyAmount.FxCounterCurrencyAmountBuilder)this.getIndex(this.counterCurrencyAmount, index, () -> {
                FxCounterCurrencyAmount.FxCounterCurrencyAmountBuilder newCounterCurrencyAmount = FxCounterCurrencyAmount.builder();
                return newCounterCurrencyAmount;
            });
        }

        @Override
        @RosettaAttribute(value="notionalAmount", isRequired=true)
        @RuneAttribute(value="notionalAmount", isRequired=true)
        public FxTargetLeverageSequenceBuilder setNotionalAmount(NonNegativeAmountSchedule _notionalAmount) {
            this.notionalAmount = _notionalAmount == null ? null : _notionalAmount.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="counterCurrencyAmount")
        @RuneAttribute(value="counterCurrencyAmount")
        public FxTargetLeverageSequenceBuilder addCounterCurrencyAmount(FxCounterCurrencyAmount _counterCurrencyAmount) {
            if (_counterCurrencyAmount != null) {
                this.counterCurrencyAmount.add(_counterCurrencyAmount.toBuilder());
            }
            return this;
        }

        @Override
        public FxTargetLeverageSequenceBuilder addCounterCurrencyAmount(FxCounterCurrencyAmount _counterCurrencyAmount, int idx) {
            this.getIndex(this.counterCurrencyAmount, idx, () -> _counterCurrencyAmount.toBuilder());
            return this;
        }

        @Override
        public FxTargetLeverageSequenceBuilder addCounterCurrencyAmount(List<? extends FxCounterCurrencyAmount> counterCurrencyAmounts) {
            if (counterCurrencyAmounts != null) {
                for (FxCounterCurrencyAmount fxCounterCurrencyAmount : counterCurrencyAmounts) {
                    this.counterCurrencyAmount.add(fxCounterCurrencyAmount.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="counterCurrencyAmount")
        public FxTargetLeverageSequenceBuilder setCounterCurrencyAmount(List<? extends FxCounterCurrencyAmount> counterCurrencyAmounts) {
            this.counterCurrencyAmount = counterCurrencyAmounts == null ? new ArrayList<FxCounterCurrencyAmount.FxCounterCurrencyAmountBuilder>() : (List)counterCurrencyAmounts.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public FxTargetLeverageSequence build() {
            return new FxTargetLeverageSequenceImpl(this);
        }

        @Override
        public FxTargetLeverageSequenceBuilder toBuilder() {
            return this;
        }

        @Override
        public FxTargetLeverageSequenceBuilder prune() {
            if (this.notionalAmount != null && !this.notionalAmount.prune().hasData()) {
                this.notionalAmount = null;
            }
            this.counterCurrencyAmount = this.counterCurrencyAmount.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getNotionalAmount() != null && this.getNotionalAmount().hasData()) {
                return true;
            }
            return this.getCounterCurrencyAmount() != null && this.getCounterCurrencyAmount().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public FxTargetLeverageSequenceBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            FxTargetLeverageSequenceBuilder o = (FxTargetLeverageSequenceBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getNotionalAmount(), (RosettaModelObjectBuilder)o.getNotionalAmount(), this::setNotionalAmount);
            merger.mergeRosetta(this.getCounterCurrencyAmount(), o.getCounterCurrencyAmount(), this::getOrCreateCounterCurrencyAmount);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            FxTargetLeverageSequence _that = this.getType().cast(o);
            if (!Objects.equals(this.notionalAmount, _that.getNotionalAmount())) {
                return false;
            }
            return ListEquals.listEquals(this.counterCurrencyAmount, _that.getCounterCurrencyAmount());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.notionalAmount != null ? this.notionalAmount.hashCode() : 0);
            _result = 31 * _result + (this.counterCurrencyAmount != null ? this.counterCurrencyAmount.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "FxTargetLeverageSequenceBuilder {notionalAmount=" + this.notionalAmount + ", counterCurrencyAmount=" + this.counterCurrencyAmount + '}';
        }
    }

    public static interface FxTargetLeverageSequenceBuilder
    extends FxTargetLeverageSequence,
    RosettaModelObjectBuilder {
        public NonNegativeAmountSchedule.NonNegativeAmountScheduleBuilder getOrCreateNotionalAmount();

        @Override
        public NonNegativeAmountSchedule.NonNegativeAmountScheduleBuilder getNotionalAmount();

        public FxCounterCurrencyAmount.FxCounterCurrencyAmountBuilder getOrCreateCounterCurrencyAmount(int var1);

        public List<? extends FxCounterCurrencyAmount.FxCounterCurrencyAmountBuilder> getCounterCurrencyAmount();

        public FxTargetLeverageSequenceBuilder setNotionalAmount(NonNegativeAmountSchedule var1);

        public FxTargetLeverageSequenceBuilder addCounterCurrencyAmount(FxCounterCurrencyAmount var1);

        public FxTargetLeverageSequenceBuilder addCounterCurrencyAmount(FxCounterCurrencyAmount var1, int var2);

        public FxTargetLeverageSequenceBuilder addCounterCurrencyAmount(List<? extends FxCounterCurrencyAmount> var1);

        public FxTargetLeverageSequenceBuilder setCounterCurrencyAmount(List<? extends FxCounterCurrencyAmount> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("notionalAmount"), processor, NonNegativeAmountSchedule.NonNegativeAmountScheduleBuilder.class, this.getNotionalAmount(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("counterCurrencyAmount"), processor, FxCounterCurrencyAmount.FxCounterCurrencyAmountBuilder.class, this.getCounterCurrencyAmount(), new AttributeMeta[0]);
        }

        public FxTargetLeverageSequenceBuilder prune();
    }

    public static class FxTargetLeverageSequenceImpl
    implements FxTargetLeverageSequence {
        private final NonNegativeAmountSchedule notionalAmount;
        private final List<? extends FxCounterCurrencyAmount> counterCurrencyAmount;

        protected FxTargetLeverageSequenceImpl(FxTargetLeverageSequenceBuilder builder) {
            this.notionalAmount = Optional.ofNullable(builder.getNotionalAmount()).map(f -> f.build()).orElse(null);
            this.counterCurrencyAmount = Optional.ofNullable(builder.getCounterCurrencyAmount()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="notionalAmount", isRequired=true)
        @RuneAttribute(value="notionalAmount", isRequired=true)
        public NonNegativeAmountSchedule getNotionalAmount() {
            return this.notionalAmount;
        }

        @Override
        @RosettaAttribute(value="counterCurrencyAmount")
        @RuneAttribute(value="counterCurrencyAmount")
        public List<? extends FxCounterCurrencyAmount> getCounterCurrencyAmount() {
            return this.counterCurrencyAmount;
        }

        @Override
        public FxTargetLeverageSequence build() {
            return this;
        }

        @Override
        public FxTargetLeverageSequenceBuilder toBuilder() {
            FxTargetLeverageSequenceBuilder builder = FxTargetLeverageSequence.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(FxTargetLeverageSequenceBuilder builder) {
            Optional.ofNullable(this.getNotionalAmount()).ifPresent(builder::setNotionalAmount);
            Optional.ofNullable(this.getCounterCurrencyAmount()).ifPresent(builder::setCounterCurrencyAmount);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            FxTargetLeverageSequence _that = this.getType().cast(o);
            if (!Objects.equals(this.notionalAmount, _that.getNotionalAmount())) {
                return false;
            }
            return ListEquals.listEquals(this.counterCurrencyAmount, _that.getCounterCurrencyAmount());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.notionalAmount != null ? this.notionalAmount.hashCode() : 0);
            _result = 31 * _result + (this.counterCurrencyAmount != null ? this.counterCurrencyAmount.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "FxTargetLeverageSequence {notionalAmount=" + this.notionalAmount + ", counterCurrencyAmount=" + this.counterCurrencyAmount + '}';
        }
    }
}

