/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.fx.accruals;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.fx.accruals.FxCrossRateObservable;
import fpml.consolidated.fx.accruals.meta.FxRateObservableMeta;
import fpml.consolidated.shared.FxInformationSource;
import fpml.consolidated.shared.QuotedCurrencyPair;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="FxRateObservable", builder=FxRateObservableBuilderImpl.class, version="1.1.0")
@RuneDataType(value="FxRateObservable", model="fpml", builder=FxRateObservableBuilderImpl.class, version="1.1.0")
public interface FxRateObservable
extends RosettaModelObject {
    public static final FxRateObservableMeta metaData = new FxRateObservableMeta();

    public QuotedCurrencyPair getQuotedCurrencyPair();

    public FxInformationSource getInformationSource();

    public List<? extends FxCrossRateObservable> getCrossRate();

    public String getId();

    public FxRateObservable build();

    public FxRateObservableBuilder toBuilder();

    public static FxRateObservableBuilder builder() {
        return new FxRateObservableBuilderImpl();
    }

    default public RosettaMetaData<? extends FxRateObservable> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends FxRateObservable> getType() {
        return FxRateObservable.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("quotedCurrencyPair"), processor, QuotedCurrencyPair.class, this.getQuotedCurrencyPair(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("informationSource"), processor, FxInformationSource.class, this.getInformationSource(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("crossRate"), processor, FxCrossRateObservable.class, this.getCrossRate(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class FxRateObservableBuilderImpl
    implements FxRateObservableBuilder {
        protected QuotedCurrencyPair.QuotedCurrencyPairBuilder quotedCurrencyPair;
        protected FxInformationSource.FxInformationSourceBuilder informationSource;
        protected List<FxCrossRateObservable.FxCrossRateObservableBuilder> crossRate = new ArrayList<FxCrossRateObservable.FxCrossRateObservableBuilder>();
        protected String id;

        @Override
        @RosettaAttribute(value="quotedCurrencyPair", isRequired=true)
        @RuneAttribute(value="quotedCurrencyPair", isRequired=true)
        public QuotedCurrencyPair.QuotedCurrencyPairBuilder getQuotedCurrencyPair() {
            return this.quotedCurrencyPair;
        }

        @Override
        public QuotedCurrencyPair.QuotedCurrencyPairBuilder getOrCreateQuotedCurrencyPair() {
            QuotedCurrencyPair.QuotedCurrencyPairBuilder result = this.quotedCurrencyPair != null ? this.quotedCurrencyPair : (this.quotedCurrencyPair = QuotedCurrencyPair.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="informationSource")
        @RuneAttribute(value="informationSource")
        public FxInformationSource.FxInformationSourceBuilder getInformationSource() {
            return this.informationSource;
        }

        @Override
        public FxInformationSource.FxInformationSourceBuilder getOrCreateInformationSource() {
            FxInformationSource.FxInformationSourceBuilder result = this.informationSource != null ? this.informationSource : (this.informationSource = FxInformationSource.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="crossRate")
        @RuneAttribute(value="crossRate")
        public List<? extends FxCrossRateObservable.FxCrossRateObservableBuilder> getCrossRate() {
            return this.crossRate;
        }

        @Override
        public FxCrossRateObservable.FxCrossRateObservableBuilder getOrCreateCrossRate(int index) {
            if (this.crossRate == null) {
                this.crossRate = new ArrayList<FxCrossRateObservable.FxCrossRateObservableBuilder>();
            }
            return (FxCrossRateObservable.FxCrossRateObservableBuilder)this.getIndex(this.crossRate, index, () -> {
                FxCrossRateObservable.FxCrossRateObservableBuilder newCrossRate = FxCrossRateObservable.builder();
                return newCrossRate;
            });
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public String getId() {
            return this.id;
        }

        @Override
        @RosettaAttribute(value="quotedCurrencyPair", isRequired=true)
        @RuneAttribute(value="quotedCurrencyPair", isRequired=true)
        public FxRateObservableBuilder setQuotedCurrencyPair(QuotedCurrencyPair _quotedCurrencyPair) {
            this.quotedCurrencyPair = _quotedCurrencyPair == null ? null : _quotedCurrencyPair.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="informationSource")
        @RuneAttribute(value="informationSource")
        public FxRateObservableBuilder setInformationSource(FxInformationSource _informationSource) {
            this.informationSource = _informationSource == null ? null : _informationSource.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="crossRate")
        @RuneAttribute(value="crossRate")
        public FxRateObservableBuilder addCrossRate(FxCrossRateObservable _crossRate) {
            if (_crossRate != null) {
                this.crossRate.add(_crossRate.toBuilder());
            }
            return this;
        }

        @Override
        public FxRateObservableBuilder addCrossRate(FxCrossRateObservable _crossRate, int idx) {
            this.getIndex(this.crossRate, idx, () -> _crossRate.toBuilder());
            return this;
        }

        @Override
        public FxRateObservableBuilder addCrossRate(List<? extends FxCrossRateObservable> crossRates) {
            if (crossRates != null) {
                for (FxCrossRateObservable fxCrossRateObservable : crossRates) {
                    this.crossRate.add(fxCrossRateObservable.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="crossRate")
        public FxRateObservableBuilder setCrossRate(List<? extends FxCrossRateObservable> crossRates) {
            this.crossRate = crossRates == null ? new ArrayList<FxCrossRateObservable.FxCrossRateObservableBuilder>() : (List)crossRates.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public FxRateObservableBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        public FxRateObservable build() {
            return new FxRateObservableImpl(this);
        }

        @Override
        public FxRateObservableBuilder toBuilder() {
            return this;
        }

        @Override
        public FxRateObservableBuilder prune() {
            if (this.quotedCurrencyPair != null && !this.quotedCurrencyPair.prune().hasData()) {
                this.quotedCurrencyPair = null;
            }
            if (this.informationSource != null && !this.informationSource.prune().hasData()) {
                this.informationSource = null;
            }
            this.crossRate = this.crossRate.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getQuotedCurrencyPair() != null && this.getQuotedCurrencyPair().hasData()) {
                return true;
            }
            if (this.getInformationSource() != null && this.getInformationSource().hasData()) {
                return true;
            }
            if (this.getCrossRate() != null && this.getCrossRate().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getId() != null;
        }

        public FxRateObservableBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            FxRateObservableBuilder o = (FxRateObservableBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getQuotedCurrencyPair(), (RosettaModelObjectBuilder)o.getQuotedCurrencyPair(), this::setQuotedCurrencyPair);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getInformationSource(), (RosettaModelObjectBuilder)o.getInformationSource(), this::setInformationSource);
            merger.mergeRosetta(this.getCrossRate(), o.getCrossRate(), this::getOrCreateCrossRate);
            merger.mergeBasic((Object)this.getId(), (Object)o.getId(), this::setId, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            FxRateObservable _that = this.getType().cast(o);
            if (!Objects.equals(this.quotedCurrencyPair, _that.getQuotedCurrencyPair())) {
                return false;
            }
            if (!Objects.equals(this.informationSource, _that.getInformationSource())) {
                return false;
            }
            if (!ListEquals.listEquals(this.crossRate, _that.getCrossRate())) {
                return false;
            }
            return Objects.equals(this.id, _that.getId());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.quotedCurrencyPair != null ? this.quotedCurrencyPair.hashCode() : 0);
            _result = 31 * _result + (this.informationSource != null ? this.informationSource.hashCode() : 0);
            _result = 31 * _result + (this.crossRate != null ? this.crossRate.hashCode() : 0);
            _result = 31 * _result + (this.id != null ? this.id.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "FxRateObservableBuilder {quotedCurrencyPair=" + this.quotedCurrencyPair + ", informationSource=" + this.informationSource + ", crossRate=" + this.crossRate + ", id=" + this.id + '}';
        }
    }

    public static interface FxRateObservableBuilder
    extends FxRateObservable,
    RosettaModelObjectBuilder {
        public QuotedCurrencyPair.QuotedCurrencyPairBuilder getOrCreateQuotedCurrencyPair();

        @Override
        public QuotedCurrencyPair.QuotedCurrencyPairBuilder getQuotedCurrencyPair();

        public FxInformationSource.FxInformationSourceBuilder getOrCreateInformationSource();

        @Override
        public FxInformationSource.FxInformationSourceBuilder getInformationSource();

        public FxCrossRateObservable.FxCrossRateObservableBuilder getOrCreateCrossRate(int var1);

        public List<? extends FxCrossRateObservable.FxCrossRateObservableBuilder> getCrossRate();

        public FxRateObservableBuilder setQuotedCurrencyPair(QuotedCurrencyPair var1);

        public FxRateObservableBuilder setInformationSource(FxInformationSource var1);

        public FxRateObservableBuilder addCrossRate(FxCrossRateObservable var1);

        public FxRateObservableBuilder addCrossRate(FxCrossRateObservable var1, int var2);

        public FxRateObservableBuilder addCrossRate(List<? extends FxCrossRateObservable> var1);

        public FxRateObservableBuilder setCrossRate(List<? extends FxCrossRateObservable> var1);

        public FxRateObservableBuilder setId(String var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("quotedCurrencyPair"), processor, QuotedCurrencyPair.QuotedCurrencyPairBuilder.class, this.getQuotedCurrencyPair(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("informationSource"), processor, FxInformationSource.FxInformationSourceBuilder.class, this.getInformationSource(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("crossRate"), processor, FxCrossRateObservable.FxCrossRateObservableBuilder.class, this.getCrossRate(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public FxRateObservableBuilder prune();
    }

    public static class FxRateObservableImpl
    implements FxRateObservable {
        private final QuotedCurrencyPair quotedCurrencyPair;
        private final FxInformationSource informationSource;
        private final List<? extends FxCrossRateObservable> crossRate;
        private final String id;

        protected FxRateObservableImpl(FxRateObservableBuilder builder) {
            this.quotedCurrencyPair = Optional.ofNullable(builder.getQuotedCurrencyPair()).map(f -> f.build()).orElse(null);
            this.informationSource = Optional.ofNullable(builder.getInformationSource()).map(f -> f.build()).orElse(null);
            this.crossRate = Optional.ofNullable(builder.getCrossRate()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.id = builder.getId();
        }

        @Override
        @RosettaAttribute(value="quotedCurrencyPair", isRequired=true)
        @RuneAttribute(value="quotedCurrencyPair", isRequired=true)
        public QuotedCurrencyPair getQuotedCurrencyPair() {
            return this.quotedCurrencyPair;
        }

        @Override
        @RosettaAttribute(value="informationSource")
        @RuneAttribute(value="informationSource")
        public FxInformationSource getInformationSource() {
            return this.informationSource;
        }

        @Override
        @RosettaAttribute(value="crossRate")
        @RuneAttribute(value="crossRate")
        public List<? extends FxCrossRateObservable> getCrossRate() {
            return this.crossRate;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public String getId() {
            return this.id;
        }

        @Override
        public FxRateObservable build() {
            return this;
        }

        @Override
        public FxRateObservableBuilder toBuilder() {
            FxRateObservableBuilder builder = FxRateObservable.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(FxRateObservableBuilder builder) {
            Optional.ofNullable(this.getQuotedCurrencyPair()).ifPresent(builder::setQuotedCurrencyPair);
            Optional.ofNullable(this.getInformationSource()).ifPresent(builder::setInformationSource);
            Optional.ofNullable(this.getCrossRate()).ifPresent(builder::setCrossRate);
            Optional.ofNullable(this.getId()).ifPresent(builder::setId);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            FxRateObservable _that = this.getType().cast(o);
            if (!Objects.equals(this.quotedCurrencyPair, _that.getQuotedCurrencyPair())) {
                return false;
            }
            if (!Objects.equals(this.informationSource, _that.getInformationSource())) {
                return false;
            }
            if (!ListEquals.listEquals(this.crossRate, _that.getCrossRate())) {
                return false;
            }
            return Objects.equals(this.id, _that.getId());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.quotedCurrencyPair != null ? this.quotedCurrencyPair.hashCode() : 0);
            _result = 31 * _result + (this.informationSource != null ? this.informationSource.hashCode() : 0);
            _result = 31 * _result + (this.crossRate != null ? this.crossRate.hashCode() : 0);
            _result = 31 * _result + (this.id != null ? this.id.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "FxRateObservable {quotedCurrencyPair=" + this.quotedCurrencyPair + ", informationSource=" + this.informationSource + ", crossRate=" + this.crossRate + ", id=" + this.id + '}';
        }
    }
}

