/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.fx.accruals;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.fx.FxOptionPremium;
import fpml.consolidated.fx.accruals.FxAccrual;
import fpml.consolidated.fx.accruals.FxAccrualBarrier;
import fpml.consolidated.fx.accruals.FxExpiryDateOrScheduleModel;
import fpml.consolidated.fx.accruals.FxSettlementDateOrScheduleModel;
import fpml.consolidated.fx.accruals.meta.FxRangeAccrualMeta;
import fpml.consolidated.shared.NonNegativeAmountSchedule;
import fpml.consolidated.shared.PayerReceiverModel;
import fpml.consolidated.shared.Product;
import fpml.consolidated.shared.ProductModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="FxRangeAccrual", builder=FxRangeAccrualBuilderImpl.class, version="1.1.0")
@RuneDataType(value="FxRangeAccrual", model="fpml", builder=FxRangeAccrualBuilderImpl.class, version="1.1.0")
public interface FxRangeAccrual
extends Product {
    public static final FxRangeAccrualMeta metaData = new FxRangeAccrualMeta();

    public PayerReceiverModel getPayerReceiverModel();

    public NonNegativeAmountSchedule getNotionalAmount();

    public FxAccrual getAccrual();

    public FxExpiryDateOrScheduleModel getFxExpiryDateOrScheduleModel();

    public FxSettlementDateOrScheduleModel getFxSettlementDateOrScheduleModel();

    public List<? extends FxAccrualBarrier> getBarrier();

    public List<? extends FxOptionPremium> getPremium();

    @Override
    public FxRangeAccrual build();

    @Override
    public FxRangeAccrualBuilder toBuilder();

    public static FxRangeAccrualBuilder builder() {
        return new FxRangeAccrualBuilderImpl();
    }

    default public RosettaMetaData<? extends FxRangeAccrual> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends FxRangeAccrual> getType() {
        return FxRangeAccrual.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("productModel"), processor, ProductModel.class, this.getProductModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("payerReceiverModel"), processor, PayerReceiverModel.class, this.getPayerReceiverModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("notionalAmount"), processor, NonNegativeAmountSchedule.class, this.getNotionalAmount(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("accrual"), processor, FxAccrual.class, this.getAccrual(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("fxExpiryDateOrScheduleModel"), processor, FxExpiryDateOrScheduleModel.class, this.getFxExpiryDateOrScheduleModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("fxSettlementDateOrScheduleModel"), processor, FxSettlementDateOrScheduleModel.class, this.getFxSettlementDateOrScheduleModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("barrier"), processor, FxAccrualBarrier.class, this.getBarrier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("premium"), processor, FxOptionPremium.class, this.getPremium(), new AttributeMeta[0]);
    }

    public static class FxRangeAccrualBuilderImpl
    extends Product.ProductBuilderImpl
    implements FxRangeAccrualBuilder {
        protected PayerReceiverModel.PayerReceiverModelBuilder payerReceiverModel;
        protected NonNegativeAmountSchedule.NonNegativeAmountScheduleBuilder notionalAmount;
        protected FxAccrual.FxAccrualBuilder accrual;
        protected FxExpiryDateOrScheduleModel.FxExpiryDateOrScheduleModelBuilder fxExpiryDateOrScheduleModel;
        protected FxSettlementDateOrScheduleModel.FxSettlementDateOrScheduleModelBuilder fxSettlementDateOrScheduleModel;
        protected List<FxAccrualBarrier.FxAccrualBarrierBuilder> barrier = new ArrayList<FxAccrualBarrier.FxAccrualBarrierBuilder>();
        protected List<FxOptionPremium.FxOptionPremiumBuilder> premium = new ArrayList<FxOptionPremium.FxOptionPremiumBuilder>();

        @Override
        @RosettaAttribute(value="payerReceiverModel", isRequired=true)
        @RuneAttribute(value="payerReceiverModel", isRequired=true)
        public PayerReceiverModel.PayerReceiverModelBuilder getPayerReceiverModel() {
            return this.payerReceiverModel;
        }

        @Override
        public PayerReceiverModel.PayerReceiverModelBuilder getOrCreatePayerReceiverModel() {
            PayerReceiverModel.PayerReceiverModelBuilder result = this.payerReceiverModel != null ? this.payerReceiverModel : (this.payerReceiverModel = PayerReceiverModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="notionalAmount", isRequired=true)
        @RuneAttribute(value="notionalAmount", isRequired=true)
        public NonNegativeAmountSchedule.NonNegativeAmountScheduleBuilder getNotionalAmount() {
            return this.notionalAmount;
        }

        @Override
        public NonNegativeAmountSchedule.NonNegativeAmountScheduleBuilder getOrCreateNotionalAmount() {
            NonNegativeAmountSchedule.NonNegativeAmountScheduleBuilder result = this.notionalAmount != null ? this.notionalAmount : (this.notionalAmount = NonNegativeAmountSchedule.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="accrual", isRequired=true)
        @RuneAttribute(value="accrual", isRequired=true)
        public FxAccrual.FxAccrualBuilder getAccrual() {
            return this.accrual;
        }

        @Override
        public FxAccrual.FxAccrualBuilder getOrCreateAccrual() {
            FxAccrual.FxAccrualBuilder result = this.accrual != null ? this.accrual : (this.accrual = FxAccrual.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="fxExpiryDateOrScheduleModel", isRequired=true)
        @RuneAttribute(value="fxExpiryDateOrScheduleModel", isRequired=true)
        public FxExpiryDateOrScheduleModel.FxExpiryDateOrScheduleModelBuilder getFxExpiryDateOrScheduleModel() {
            return this.fxExpiryDateOrScheduleModel;
        }

        @Override
        public FxExpiryDateOrScheduleModel.FxExpiryDateOrScheduleModelBuilder getOrCreateFxExpiryDateOrScheduleModel() {
            FxExpiryDateOrScheduleModel.FxExpiryDateOrScheduleModelBuilder result = this.fxExpiryDateOrScheduleModel != null ? this.fxExpiryDateOrScheduleModel : (this.fxExpiryDateOrScheduleModel = FxExpiryDateOrScheduleModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="fxSettlementDateOrScheduleModel", isRequired=true)
        @RuneAttribute(value="fxSettlementDateOrScheduleModel", isRequired=true)
        public FxSettlementDateOrScheduleModel.FxSettlementDateOrScheduleModelBuilder getFxSettlementDateOrScheduleModel() {
            return this.fxSettlementDateOrScheduleModel;
        }

        @Override
        public FxSettlementDateOrScheduleModel.FxSettlementDateOrScheduleModelBuilder getOrCreateFxSettlementDateOrScheduleModel() {
            FxSettlementDateOrScheduleModel.FxSettlementDateOrScheduleModelBuilder result = this.fxSettlementDateOrScheduleModel != null ? this.fxSettlementDateOrScheduleModel : (this.fxSettlementDateOrScheduleModel = FxSettlementDateOrScheduleModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="barrier")
        @RuneAttribute(value="barrier")
        public List<? extends FxAccrualBarrier.FxAccrualBarrierBuilder> getBarrier() {
            return this.barrier;
        }

        @Override
        public FxAccrualBarrier.FxAccrualBarrierBuilder getOrCreateBarrier(int index) {
            if (this.barrier == null) {
                this.barrier = new ArrayList<FxAccrualBarrier.FxAccrualBarrierBuilder>();
            }
            return (FxAccrualBarrier.FxAccrualBarrierBuilder)this.getIndex(this.barrier, index, () -> {
                FxAccrualBarrier.FxAccrualBarrierBuilder newBarrier = FxAccrualBarrier.builder();
                return newBarrier;
            });
        }

        @Override
        @RosettaAttribute(value="premium")
        @RuneAttribute(value="premium")
        public List<? extends FxOptionPremium.FxOptionPremiumBuilder> getPremium() {
            return this.premium;
        }

        @Override
        public FxOptionPremium.FxOptionPremiumBuilder getOrCreatePremium(int index) {
            if (this.premium == null) {
                this.premium = new ArrayList<FxOptionPremium.FxOptionPremiumBuilder>();
            }
            return (FxOptionPremium.FxOptionPremiumBuilder)this.getIndex(this.premium, index, () -> {
                FxOptionPremium.FxOptionPremiumBuilder newPremium = FxOptionPremium.builder();
                return newPremium;
            });
        }

        @Override
        @RosettaAttribute(value="productModel")
        @RuneAttribute(value="productModel")
        public FxRangeAccrualBuilder setProductModel(ProductModel _productModel) {
            this.productModel = _productModel == null ? null : _productModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public FxRangeAccrualBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="payerReceiverModel", isRequired=true)
        @RuneAttribute(value="payerReceiverModel", isRequired=true)
        public FxRangeAccrualBuilder setPayerReceiverModel(PayerReceiverModel _payerReceiverModel) {
            this.payerReceiverModel = _payerReceiverModel == null ? null : _payerReceiverModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="notionalAmount", isRequired=true)
        @RuneAttribute(value="notionalAmount", isRequired=true)
        public FxRangeAccrualBuilder setNotionalAmount(NonNegativeAmountSchedule _notionalAmount) {
            this.notionalAmount = _notionalAmount == null ? null : _notionalAmount.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="accrual", isRequired=true)
        @RuneAttribute(value="accrual", isRequired=true)
        public FxRangeAccrualBuilder setAccrual(FxAccrual _accrual) {
            this.accrual = _accrual == null ? null : _accrual.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="fxExpiryDateOrScheduleModel", isRequired=true)
        @RuneAttribute(value="fxExpiryDateOrScheduleModel", isRequired=true)
        public FxRangeAccrualBuilder setFxExpiryDateOrScheduleModel(FxExpiryDateOrScheduleModel _fxExpiryDateOrScheduleModel) {
            this.fxExpiryDateOrScheduleModel = _fxExpiryDateOrScheduleModel == null ? null : _fxExpiryDateOrScheduleModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="fxSettlementDateOrScheduleModel", isRequired=true)
        @RuneAttribute(value="fxSettlementDateOrScheduleModel", isRequired=true)
        public FxRangeAccrualBuilder setFxSettlementDateOrScheduleModel(FxSettlementDateOrScheduleModel _fxSettlementDateOrScheduleModel) {
            this.fxSettlementDateOrScheduleModel = _fxSettlementDateOrScheduleModel == null ? null : _fxSettlementDateOrScheduleModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="barrier")
        @RuneAttribute(value="barrier")
        public FxRangeAccrualBuilder addBarrier(FxAccrualBarrier _barrier) {
            if (_barrier != null) {
                this.barrier.add(_barrier.toBuilder());
            }
            return this;
        }

        @Override
        public FxRangeAccrualBuilder addBarrier(FxAccrualBarrier _barrier, int idx) {
            this.getIndex(this.barrier, idx, () -> _barrier.toBuilder());
            return this;
        }

        @Override
        public FxRangeAccrualBuilder addBarrier(List<? extends FxAccrualBarrier> barriers) {
            if (barriers != null) {
                for (FxAccrualBarrier fxAccrualBarrier : barriers) {
                    this.barrier.add(fxAccrualBarrier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="barrier")
        public FxRangeAccrualBuilder setBarrier(List<? extends FxAccrualBarrier> barriers) {
            this.barrier = barriers == null ? new ArrayList<FxAccrualBarrier.FxAccrualBarrierBuilder>() : (List)barriers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="premium")
        @RuneAttribute(value="premium")
        public FxRangeAccrualBuilder addPremium(FxOptionPremium _premium) {
            if (_premium != null) {
                this.premium.add(_premium.toBuilder());
            }
            return this;
        }

        @Override
        public FxRangeAccrualBuilder addPremium(FxOptionPremium _premium, int idx) {
            this.getIndex(this.premium, idx, () -> _premium.toBuilder());
            return this;
        }

        @Override
        public FxRangeAccrualBuilder addPremium(List<? extends FxOptionPremium> premiums) {
            if (premiums != null) {
                for (FxOptionPremium fxOptionPremium : premiums) {
                    this.premium.add(fxOptionPremium.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="premium")
        public FxRangeAccrualBuilder setPremium(List<? extends FxOptionPremium> premiums) {
            this.premium = premiums == null ? new ArrayList<FxOptionPremium.FxOptionPremiumBuilder>() : (List)premiums.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public FxRangeAccrual build() {
            return new FxRangeAccrualImpl(this);
        }

        @Override
        public FxRangeAccrualBuilder toBuilder() {
            return this;
        }

        @Override
        public FxRangeAccrualBuilder prune() {
            super.prune();
            if (this.payerReceiverModel != null && !this.payerReceiverModel.prune().hasData()) {
                this.payerReceiverModel = null;
            }
            if (this.notionalAmount != null && !this.notionalAmount.prune().hasData()) {
                this.notionalAmount = null;
            }
            if (this.accrual != null && !this.accrual.prune().hasData()) {
                this.accrual = null;
            }
            if (this.fxExpiryDateOrScheduleModel != null && !this.fxExpiryDateOrScheduleModel.prune().hasData()) {
                this.fxExpiryDateOrScheduleModel = null;
            }
            if (this.fxSettlementDateOrScheduleModel != null && !this.fxSettlementDateOrScheduleModel.prune().hasData()) {
                this.fxSettlementDateOrScheduleModel = null;
            }
            this.barrier = this.barrier.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.premium = this.premium.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getPayerReceiverModel() != null && this.getPayerReceiverModel().hasData()) {
                return true;
            }
            if (this.getNotionalAmount() != null && this.getNotionalAmount().hasData()) {
                return true;
            }
            if (this.getAccrual() != null && this.getAccrual().hasData()) {
                return true;
            }
            if (this.getFxExpiryDateOrScheduleModel() != null && this.getFxExpiryDateOrScheduleModel().hasData()) {
                return true;
            }
            if (this.getFxSettlementDateOrScheduleModel() != null && this.getFxSettlementDateOrScheduleModel().hasData()) {
                return true;
            }
            if (this.getBarrier() != null && this.getBarrier().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getPremium() != null && this.getPremium().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        @Override
        public FxRangeAccrualBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            FxRangeAccrualBuilder o = (FxRangeAccrualBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPayerReceiverModel(), (RosettaModelObjectBuilder)o.getPayerReceiverModel(), this::setPayerReceiverModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getNotionalAmount(), (RosettaModelObjectBuilder)o.getNotionalAmount(), this::setNotionalAmount);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAccrual(), (RosettaModelObjectBuilder)o.getAccrual(), this::setAccrual);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFxExpiryDateOrScheduleModel(), (RosettaModelObjectBuilder)o.getFxExpiryDateOrScheduleModel(), this::setFxExpiryDateOrScheduleModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFxSettlementDateOrScheduleModel(), (RosettaModelObjectBuilder)o.getFxSettlementDateOrScheduleModel(), this::setFxSettlementDateOrScheduleModel);
            merger.mergeRosetta(this.getBarrier(), o.getBarrier(), this::getOrCreateBarrier);
            merger.mergeRosetta(this.getPremium(), o.getPremium(), this::getOrCreatePremium);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            FxRangeAccrual _that = (FxRangeAccrual)this.getType().cast(o);
            if (!Objects.equals(this.payerReceiverModel, _that.getPayerReceiverModel())) {
                return false;
            }
            if (!Objects.equals(this.notionalAmount, _that.getNotionalAmount())) {
                return false;
            }
            if (!Objects.equals(this.accrual, _that.getAccrual())) {
                return false;
            }
            if (!Objects.equals(this.fxExpiryDateOrScheduleModel, _that.getFxExpiryDateOrScheduleModel())) {
                return false;
            }
            if (!Objects.equals(this.fxSettlementDateOrScheduleModel, _that.getFxSettlementDateOrScheduleModel())) {
                return false;
            }
            if (!ListEquals.listEquals(this.barrier, _that.getBarrier())) {
                return false;
            }
            return ListEquals.listEquals(this.premium, _that.getPremium());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.payerReceiverModel != null ? this.payerReceiverModel.hashCode() : 0);
            _result = 31 * _result + (this.notionalAmount != null ? this.notionalAmount.hashCode() : 0);
            _result = 31 * _result + (this.accrual != null ? this.accrual.hashCode() : 0);
            _result = 31 * _result + (this.fxExpiryDateOrScheduleModel != null ? this.fxExpiryDateOrScheduleModel.hashCode() : 0);
            _result = 31 * _result + (this.fxSettlementDateOrScheduleModel != null ? this.fxSettlementDateOrScheduleModel.hashCode() : 0);
            _result = 31 * _result + (this.barrier != null ? this.barrier.hashCode() : 0);
            _result = 31 * _result + (this.premium != null ? this.premium.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "FxRangeAccrualBuilder {payerReceiverModel=" + this.payerReceiverModel + ", notionalAmount=" + this.notionalAmount + ", accrual=" + this.accrual + ", fxExpiryDateOrScheduleModel=" + this.fxExpiryDateOrScheduleModel + ", fxSettlementDateOrScheduleModel=" + this.fxSettlementDateOrScheduleModel + ", barrier=" + this.barrier + ", premium=" + this.premium + '}' + " " + super.toString();
        }
    }

    public static interface FxRangeAccrualBuilder
    extends FxRangeAccrual,
    Product.ProductBuilder {
        public PayerReceiverModel.PayerReceiverModelBuilder getOrCreatePayerReceiverModel();

        @Override
        public PayerReceiverModel.PayerReceiverModelBuilder getPayerReceiverModel();

        public NonNegativeAmountSchedule.NonNegativeAmountScheduleBuilder getOrCreateNotionalAmount();

        @Override
        public NonNegativeAmountSchedule.NonNegativeAmountScheduleBuilder getNotionalAmount();

        public FxAccrual.FxAccrualBuilder getOrCreateAccrual();

        @Override
        public FxAccrual.FxAccrualBuilder getAccrual();

        public FxExpiryDateOrScheduleModel.FxExpiryDateOrScheduleModelBuilder getOrCreateFxExpiryDateOrScheduleModel();

        @Override
        public FxExpiryDateOrScheduleModel.FxExpiryDateOrScheduleModelBuilder getFxExpiryDateOrScheduleModel();

        public FxSettlementDateOrScheduleModel.FxSettlementDateOrScheduleModelBuilder getOrCreateFxSettlementDateOrScheduleModel();

        @Override
        public FxSettlementDateOrScheduleModel.FxSettlementDateOrScheduleModelBuilder getFxSettlementDateOrScheduleModel();

        public FxAccrualBarrier.FxAccrualBarrierBuilder getOrCreateBarrier(int var1);

        public List<? extends FxAccrualBarrier.FxAccrualBarrierBuilder> getBarrier();

        public FxOptionPremium.FxOptionPremiumBuilder getOrCreatePremium(int var1);

        public List<? extends FxOptionPremium.FxOptionPremiumBuilder> getPremium();

        @Override
        public FxRangeAccrualBuilder setProductModel(ProductModel var1);

        @Override
        public FxRangeAccrualBuilder setId(String var1);

        public FxRangeAccrualBuilder setPayerReceiverModel(PayerReceiverModel var1);

        public FxRangeAccrualBuilder setNotionalAmount(NonNegativeAmountSchedule var1);

        public FxRangeAccrualBuilder setAccrual(FxAccrual var1);

        public FxRangeAccrualBuilder setFxExpiryDateOrScheduleModel(FxExpiryDateOrScheduleModel var1);

        public FxRangeAccrualBuilder setFxSettlementDateOrScheduleModel(FxSettlementDateOrScheduleModel var1);

        public FxRangeAccrualBuilder addBarrier(FxAccrualBarrier var1);

        public FxRangeAccrualBuilder addBarrier(FxAccrualBarrier var1, int var2);

        public FxRangeAccrualBuilder addBarrier(List<? extends FxAccrualBarrier> var1);

        public FxRangeAccrualBuilder setBarrier(List<? extends FxAccrualBarrier> var1);

        public FxRangeAccrualBuilder addPremium(FxOptionPremium var1);

        public FxRangeAccrualBuilder addPremium(FxOptionPremium var1, int var2);

        public FxRangeAccrualBuilder addPremium(List<? extends FxOptionPremium> var1);

        public FxRangeAccrualBuilder setPremium(List<? extends FxOptionPremium> var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("productModel"), processor, ProductModel.ProductModelBuilder.class, (RosettaModelObjectBuilder)this.getProductModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("payerReceiverModel"), processor, PayerReceiverModel.PayerReceiverModelBuilder.class, this.getPayerReceiverModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("notionalAmount"), processor, NonNegativeAmountSchedule.NonNegativeAmountScheduleBuilder.class, this.getNotionalAmount(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("accrual"), processor, FxAccrual.FxAccrualBuilder.class, this.getAccrual(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("fxExpiryDateOrScheduleModel"), processor, FxExpiryDateOrScheduleModel.FxExpiryDateOrScheduleModelBuilder.class, this.getFxExpiryDateOrScheduleModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("fxSettlementDateOrScheduleModel"), processor, FxSettlementDateOrScheduleModel.FxSettlementDateOrScheduleModelBuilder.class, this.getFxSettlementDateOrScheduleModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("barrier"), processor, FxAccrualBarrier.FxAccrualBarrierBuilder.class, this.getBarrier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("premium"), processor, FxOptionPremium.FxOptionPremiumBuilder.class, this.getPremium(), new AttributeMeta[0]);
        }

        @Override
        public FxRangeAccrualBuilder prune();
    }

    public static class FxRangeAccrualImpl
    extends Product.ProductImpl
    implements FxRangeAccrual {
        private final PayerReceiverModel payerReceiverModel;
        private final NonNegativeAmountSchedule notionalAmount;
        private final FxAccrual accrual;
        private final FxExpiryDateOrScheduleModel fxExpiryDateOrScheduleModel;
        private final FxSettlementDateOrScheduleModel fxSettlementDateOrScheduleModel;
        private final List<? extends FxAccrualBarrier> barrier;
        private final List<? extends FxOptionPremium> premium;

        protected FxRangeAccrualImpl(FxRangeAccrualBuilder builder) {
            super(builder);
            this.payerReceiverModel = Optional.ofNullable(builder.getPayerReceiverModel()).map(f -> f.build()).orElse(null);
            this.notionalAmount = Optional.ofNullable(builder.getNotionalAmount()).map(f -> f.build()).orElse(null);
            this.accrual = Optional.ofNullable(builder.getAccrual()).map(f -> f.build()).orElse(null);
            this.fxExpiryDateOrScheduleModel = Optional.ofNullable(builder.getFxExpiryDateOrScheduleModel()).map(f -> f.build()).orElse(null);
            this.fxSettlementDateOrScheduleModel = Optional.ofNullable(builder.getFxSettlementDateOrScheduleModel()).map(f -> f.build()).orElse(null);
            this.barrier = Optional.ofNullable(builder.getBarrier()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.premium = Optional.ofNullable(builder.getPremium()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="payerReceiverModel", isRequired=true)
        @RuneAttribute(value="payerReceiverModel", isRequired=true)
        public PayerReceiverModel getPayerReceiverModel() {
            return this.payerReceiverModel;
        }

        @Override
        @RosettaAttribute(value="notionalAmount", isRequired=true)
        @RuneAttribute(value="notionalAmount", isRequired=true)
        public NonNegativeAmountSchedule getNotionalAmount() {
            return this.notionalAmount;
        }

        @Override
        @RosettaAttribute(value="accrual", isRequired=true)
        @RuneAttribute(value="accrual", isRequired=true)
        public FxAccrual getAccrual() {
            return this.accrual;
        }

        @Override
        @RosettaAttribute(value="fxExpiryDateOrScheduleModel", isRequired=true)
        @RuneAttribute(value="fxExpiryDateOrScheduleModel", isRequired=true)
        public FxExpiryDateOrScheduleModel getFxExpiryDateOrScheduleModel() {
            return this.fxExpiryDateOrScheduleModel;
        }

        @Override
        @RosettaAttribute(value="fxSettlementDateOrScheduleModel", isRequired=true)
        @RuneAttribute(value="fxSettlementDateOrScheduleModel", isRequired=true)
        public FxSettlementDateOrScheduleModel getFxSettlementDateOrScheduleModel() {
            return this.fxSettlementDateOrScheduleModel;
        }

        @Override
        @RosettaAttribute(value="barrier")
        @RuneAttribute(value="barrier")
        public List<? extends FxAccrualBarrier> getBarrier() {
            return this.barrier;
        }

        @Override
        @RosettaAttribute(value="premium")
        @RuneAttribute(value="premium")
        public List<? extends FxOptionPremium> getPremium() {
            return this.premium;
        }

        @Override
        public FxRangeAccrual build() {
            return this;
        }

        @Override
        public FxRangeAccrualBuilder toBuilder() {
            FxRangeAccrualBuilder builder = FxRangeAccrual.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(FxRangeAccrualBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getPayerReceiverModel()).ifPresent(builder::setPayerReceiverModel);
            Optional.ofNullable(this.getNotionalAmount()).ifPresent(builder::setNotionalAmount);
            Optional.ofNullable(this.getAccrual()).ifPresent(builder::setAccrual);
            Optional.ofNullable(this.getFxExpiryDateOrScheduleModel()).ifPresent(builder::setFxExpiryDateOrScheduleModel);
            Optional.ofNullable(this.getFxSettlementDateOrScheduleModel()).ifPresent(builder::setFxSettlementDateOrScheduleModel);
            Optional.ofNullable(this.getBarrier()).ifPresent(builder::setBarrier);
            Optional.ofNullable(this.getPremium()).ifPresent(builder::setPremium);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            FxRangeAccrual _that = (FxRangeAccrual)this.getType().cast(o);
            if (!Objects.equals(this.payerReceiverModel, _that.getPayerReceiverModel())) {
                return false;
            }
            if (!Objects.equals(this.notionalAmount, _that.getNotionalAmount())) {
                return false;
            }
            if (!Objects.equals(this.accrual, _that.getAccrual())) {
                return false;
            }
            if (!Objects.equals(this.fxExpiryDateOrScheduleModel, _that.getFxExpiryDateOrScheduleModel())) {
                return false;
            }
            if (!Objects.equals(this.fxSettlementDateOrScheduleModel, _that.getFxSettlementDateOrScheduleModel())) {
                return false;
            }
            if (!ListEquals.listEquals(this.barrier, _that.getBarrier())) {
                return false;
            }
            return ListEquals.listEquals(this.premium, _that.getPremium());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.payerReceiverModel != null ? this.payerReceiverModel.hashCode() : 0);
            _result = 31 * _result + (this.notionalAmount != null ? this.notionalAmount.hashCode() : 0);
            _result = 31 * _result + (this.accrual != null ? this.accrual.hashCode() : 0);
            _result = 31 * _result + (this.fxExpiryDateOrScheduleModel != null ? this.fxExpiryDateOrScheduleModel.hashCode() : 0);
            _result = 31 * _result + (this.fxSettlementDateOrScheduleModel != null ? this.fxSettlementDateOrScheduleModel.hashCode() : 0);
            _result = 31 * _result + (this.barrier != null ? this.barrier.hashCode() : 0);
            _result = 31 * _result + (this.premium != null ? this.premium.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "FxRangeAccrual {payerReceiverModel=" + this.payerReceiverModel + ", notionalAmount=" + this.notionalAmount + ", accrual=" + this.accrual + ", fxExpiryDateOrScheduleModel=" + this.fxExpiryDateOrScheduleModel + ", fxSettlementDateOrScheduleModel=" + this.fxSettlementDateOrScheduleModel + ", barrier=" + this.barrier + ", premium=" + this.premium + '}' + " " + super.toString();
        }
    }
}

