/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.fx.accruals;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.fpmlenum.FxAveragingMethodEnum;
import fpml.consolidated.fx.accruals.FxCrossRateObservable;
import fpml.consolidated.fx.accruals.FxRateObservable;
import fpml.consolidated.fx.accruals.FxWeightedFixingSchedule;
import fpml.consolidated.fx.accruals.meta.FxAveragingProcessMeta;
import fpml.consolidated.shared.FxInformationSource;
import fpml.consolidated.shared.QuotedCurrencyPair;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="FxAveragingProcess", builder=FxAveragingProcessBuilderImpl.class, version="1.1.0")
@RuneDataType(value="FxAveragingProcess", model="fpml", builder=FxAveragingProcessBuilderImpl.class, version="1.1.0")
public interface FxAveragingProcess
extends FxRateObservable {
    public static final FxAveragingProcessMeta metaData = new FxAveragingProcessMeta();

    public FxWeightedFixingSchedule getFixingSchedule();

    public FxAveragingMethodEnum getAveragingMethod();

    public Integer getPrecision();

    @Override
    public FxAveragingProcess build();

    @Override
    public FxAveragingProcessBuilder toBuilder();

    public static FxAveragingProcessBuilder builder() {
        return new FxAveragingProcessBuilderImpl();
    }

    default public RosettaMetaData<? extends FxAveragingProcess> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends FxAveragingProcess> getType() {
        return FxAveragingProcess.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("quotedCurrencyPair"), processor, QuotedCurrencyPair.class, this.getQuotedCurrencyPair(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("informationSource"), processor, FxInformationSource.class, this.getInformationSource(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("crossRate"), processor, FxCrossRateObservable.class, this.getCrossRate(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("fixingSchedule"), processor, FxWeightedFixingSchedule.class, this.getFixingSchedule(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("averagingMethod"), FxAveragingMethodEnum.class, (Object)this.getAveragingMethod(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("precision"), Integer.class, (Object)this.getPrecision(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class FxAveragingProcessBuilderImpl
    extends FxRateObservable.FxRateObservableBuilderImpl
    implements FxAveragingProcessBuilder {
        protected FxWeightedFixingSchedule.FxWeightedFixingScheduleBuilder fixingSchedule;
        protected FxAveragingMethodEnum averagingMethod;
        protected Integer precision;

        @Override
        @RosettaAttribute(value="fixingSchedule", isRequired=true)
        @RuneAttribute(value="fixingSchedule", isRequired=true)
        public FxWeightedFixingSchedule.FxWeightedFixingScheduleBuilder getFixingSchedule() {
            return this.fixingSchedule;
        }

        @Override
        public FxWeightedFixingSchedule.FxWeightedFixingScheduleBuilder getOrCreateFixingSchedule() {
            FxWeightedFixingSchedule.FxWeightedFixingScheduleBuilder result = this.fixingSchedule != null ? this.fixingSchedule : (this.fixingSchedule = FxWeightedFixingSchedule.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="averagingMethod", isRequired=true)
        @RuneAttribute(value="averagingMethod", isRequired=true)
        public FxAveragingMethodEnum getAveragingMethod() {
            return this.averagingMethod;
        }

        @Override
        @RosettaAttribute(value="precision")
        @RuneAttribute(value="precision")
        public Integer getPrecision() {
            return this.precision;
        }

        @Override
        @RosettaAttribute(value="quotedCurrencyPair", isRequired=true)
        @RuneAttribute(value="quotedCurrencyPair", isRequired=true)
        public FxAveragingProcessBuilder setQuotedCurrencyPair(QuotedCurrencyPair _quotedCurrencyPair) {
            this.quotedCurrencyPair = _quotedCurrencyPair == null ? null : _quotedCurrencyPair.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="informationSource")
        @RuneAttribute(value="informationSource")
        public FxAveragingProcessBuilder setInformationSource(FxInformationSource _informationSource) {
            this.informationSource = _informationSource == null ? null : _informationSource.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="crossRate")
        @RuneAttribute(value="crossRate")
        public FxAveragingProcessBuilder addCrossRate(FxCrossRateObservable _crossRate) {
            if (_crossRate != null) {
                this.crossRate.add(_crossRate.toBuilder());
            }
            return this;
        }

        @Override
        public FxAveragingProcessBuilder addCrossRate(FxCrossRateObservable _crossRate, int idx) {
            this.getIndex(this.crossRate, idx, () -> _crossRate.toBuilder());
            return this;
        }

        @Override
        public FxAveragingProcessBuilder addCrossRate(List<? extends FxCrossRateObservable> crossRates) {
            if (crossRates != null) {
                for (FxCrossRateObservable fxCrossRateObservable : crossRates) {
                    this.crossRate.add(fxCrossRateObservable.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="crossRate")
        public FxAveragingProcessBuilder setCrossRate(List<? extends FxCrossRateObservable> crossRates) {
            this.crossRate = crossRates == null ? new ArrayList() : (List)crossRates.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public FxAveragingProcessBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="fixingSchedule", isRequired=true)
        @RuneAttribute(value="fixingSchedule", isRequired=true)
        public FxAveragingProcessBuilder setFixingSchedule(FxWeightedFixingSchedule _fixingSchedule) {
            this.fixingSchedule = _fixingSchedule == null ? null : _fixingSchedule.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="averagingMethod", isRequired=true)
        @RuneAttribute(value="averagingMethod", isRequired=true)
        public FxAveragingProcessBuilder setAveragingMethod(FxAveragingMethodEnum _averagingMethod) {
            this.averagingMethod = _averagingMethod == null ? null : _averagingMethod;
            return this;
        }

        @Override
        @RosettaAttribute(value="precision")
        @RuneAttribute(value="precision")
        public FxAveragingProcessBuilder setPrecision(Integer _precision) {
            this.precision = _precision == null ? null : _precision;
            return this;
        }

        @Override
        public FxAveragingProcess build() {
            return new FxAveragingProcessImpl(this);
        }

        @Override
        public FxAveragingProcessBuilder toBuilder() {
            return this;
        }

        @Override
        public FxAveragingProcessBuilder prune() {
            super.prune();
            if (this.fixingSchedule != null && !this.fixingSchedule.prune().hasData()) {
                this.fixingSchedule = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getFixingSchedule() != null && this.getFixingSchedule().hasData()) {
                return true;
            }
            if (this.getAveragingMethod() != null) {
                return true;
            }
            return this.getPrecision() != null;
        }

        @Override
        public FxAveragingProcessBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            FxAveragingProcessBuilder o = (FxAveragingProcessBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFixingSchedule(), (RosettaModelObjectBuilder)o.getFixingSchedule(), this::setFixingSchedule);
            merger.mergeBasic((Object)this.getAveragingMethod(), (Object)o.getAveragingMethod(), this::setAveragingMethod, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPrecision(), (Object)o.getPrecision(), this::setPrecision, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            FxAveragingProcess _that = (FxAveragingProcess)this.getType().cast(o);
            if (!Objects.equals(this.fixingSchedule, _that.getFixingSchedule())) {
                return false;
            }
            if (!Objects.equals((Object)this.averagingMethod, (Object)_that.getAveragingMethod())) {
                return false;
            }
            return Objects.equals(this.precision, _that.getPrecision());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.fixingSchedule != null ? this.fixingSchedule.hashCode() : 0);
            _result = 31 * _result + (this.averagingMethod != null ? ((Object)((Object)this.averagingMethod)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.precision != null ? this.precision.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "FxAveragingProcessBuilder {fixingSchedule=" + this.fixingSchedule + ", averagingMethod=" + (Object)((Object)this.averagingMethod) + ", precision=" + this.precision + '}' + " " + super.toString();
        }
    }

    public static interface FxAveragingProcessBuilder
    extends FxAveragingProcess,
    FxRateObservable.FxRateObservableBuilder {
        public FxWeightedFixingSchedule.FxWeightedFixingScheduleBuilder getOrCreateFixingSchedule();

        @Override
        public FxWeightedFixingSchedule.FxWeightedFixingScheduleBuilder getFixingSchedule();

        @Override
        public FxAveragingProcessBuilder setQuotedCurrencyPair(QuotedCurrencyPair var1);

        @Override
        public FxAveragingProcessBuilder setInformationSource(FxInformationSource var1);

        @Override
        public FxAveragingProcessBuilder addCrossRate(FxCrossRateObservable var1);

        @Override
        public FxAveragingProcessBuilder addCrossRate(FxCrossRateObservable var1, int var2);

        @Override
        public FxAveragingProcessBuilder addCrossRate(List<? extends FxCrossRateObservable> var1);

        @Override
        public FxAveragingProcessBuilder setCrossRate(List<? extends FxCrossRateObservable> var1);

        @Override
        public FxAveragingProcessBuilder setId(String var1);

        public FxAveragingProcessBuilder setFixingSchedule(FxWeightedFixingSchedule var1);

        public FxAveragingProcessBuilder setAveragingMethod(FxAveragingMethodEnum var1);

        public FxAveragingProcessBuilder setPrecision(Integer var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("quotedCurrencyPair"), processor, QuotedCurrencyPair.QuotedCurrencyPairBuilder.class, (RosettaModelObjectBuilder)this.getQuotedCurrencyPair(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("informationSource"), processor, FxInformationSource.FxInformationSourceBuilder.class, (RosettaModelObjectBuilder)this.getInformationSource(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("crossRate"), processor, FxCrossRateObservable.FxCrossRateObservableBuilder.class, this.getCrossRate(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("fixingSchedule"), processor, FxWeightedFixingSchedule.FxWeightedFixingScheduleBuilder.class, this.getFixingSchedule(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("averagingMethod"), FxAveragingMethodEnum.class, (Object)this.getAveragingMethod(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("precision"), Integer.class, (Object)this.getPrecision(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        @Override
        public FxAveragingProcessBuilder prune();
    }

    public static class FxAveragingProcessImpl
    extends FxRateObservable.FxRateObservableImpl
    implements FxAveragingProcess {
        private final FxWeightedFixingSchedule fixingSchedule;
        private final FxAveragingMethodEnum averagingMethod;
        private final Integer precision;

        protected FxAveragingProcessImpl(FxAveragingProcessBuilder builder) {
            super(builder);
            this.fixingSchedule = Optional.ofNullable(builder.getFixingSchedule()).map(f -> f.build()).orElse(null);
            this.averagingMethod = builder.getAveragingMethod();
            this.precision = builder.getPrecision();
        }

        @Override
        @RosettaAttribute(value="fixingSchedule", isRequired=true)
        @RuneAttribute(value="fixingSchedule", isRequired=true)
        public FxWeightedFixingSchedule getFixingSchedule() {
            return this.fixingSchedule;
        }

        @Override
        @RosettaAttribute(value="averagingMethod", isRequired=true)
        @RuneAttribute(value="averagingMethod", isRequired=true)
        public FxAveragingMethodEnum getAveragingMethod() {
            return this.averagingMethod;
        }

        @Override
        @RosettaAttribute(value="precision")
        @RuneAttribute(value="precision")
        public Integer getPrecision() {
            return this.precision;
        }

        @Override
        public FxAveragingProcess build() {
            return this;
        }

        @Override
        public FxAveragingProcessBuilder toBuilder() {
            FxAveragingProcessBuilder builder = FxAveragingProcess.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(FxAveragingProcessBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getFixingSchedule()).ifPresent(builder::setFixingSchedule);
            Optional.ofNullable(this.getAveragingMethod()).ifPresent(builder::setAveragingMethod);
            Optional.ofNullable(this.getPrecision()).ifPresent(builder::setPrecision);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            FxAveragingProcess _that = (FxAveragingProcess)this.getType().cast(o);
            if (!Objects.equals(this.fixingSchedule, _that.getFixingSchedule())) {
                return false;
            }
            if (!Objects.equals((Object)this.averagingMethod, (Object)_that.getAveragingMethod())) {
                return false;
            }
            return Objects.equals(this.precision, _that.getPrecision());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.fixingSchedule != null ? this.fixingSchedule.hashCode() : 0);
            _result = 31 * _result + (this.averagingMethod != null ? ((Object)((Object)this.averagingMethod)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.precision != null ? this.precision.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "FxAveragingProcess {fixingSchedule=" + this.fixingSchedule + ", averagingMethod=" + (Object)((Object)this.averagingMethod) + ", precision=" + this.precision + '}' + " " + super.toString();
        }
    }
}

