/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.fx;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.fpmlenum.QuoteBasisEnum;
import fpml.consolidated.fx.CrossRateSequence;
import fpml.consolidated.fx.meta.CrossRateMeta;
import fpml.consolidated.shared.Currency;
import fpml.consolidated.shared.QuotedCurrencyPair;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="CrossRate", builder=CrossRateBuilderImpl.class, version="1.1.0")
@RuneDataType(value="CrossRate", model="fpml", builder=CrossRateBuilderImpl.class, version="1.1.0")
public interface CrossRate
extends QuotedCurrencyPair {
    public static final CrossRateMeta metaData = new CrossRateMeta();

    public BigDecimal getRate();

    public CrossRateSequence getCrossRateSequence();

    @Override
    public CrossRate build();

    @Override
    public CrossRateBuilder toBuilder();

    public static CrossRateBuilder builder() {
        return new CrossRateBuilderImpl();
    }

    default public RosettaMetaData<? extends CrossRate> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CrossRate> getType() {
        return CrossRate.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("currency1"), processor, Currency.class, this.getCurrency1(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("currency2"), processor, Currency.class, this.getCurrency2(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("quoteBasis"), QuoteBasisEnum.class, (Object)this.getQuoteBasis(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("rate"), BigDecimal.class, (Object)this.getRate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("crossRateSequence"), processor, CrossRateSequence.class, this.getCrossRateSequence(), new AttributeMeta[0]);
    }

    public static class CrossRateBuilderImpl
    extends QuotedCurrencyPair.QuotedCurrencyPairBuilderImpl
    implements CrossRateBuilder {
        protected BigDecimal rate;
        protected CrossRateSequence.CrossRateSequenceBuilder crossRateSequence;

        @Override
        @RosettaAttribute(value="rate")
        @RuneAttribute(value="rate")
        public BigDecimal getRate() {
            return this.rate;
        }

        @Override
        @RosettaAttribute(value="crossRateSequence")
        @RuneAttribute(value="crossRateSequence")
        public CrossRateSequence.CrossRateSequenceBuilder getCrossRateSequence() {
            return this.crossRateSequence;
        }

        @Override
        public CrossRateSequence.CrossRateSequenceBuilder getOrCreateCrossRateSequence() {
            CrossRateSequence.CrossRateSequenceBuilder result = this.crossRateSequence != null ? this.crossRateSequence : (this.crossRateSequence = CrossRateSequence.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="currency1", isRequired=true)
        @RuneAttribute(value="currency1", isRequired=true)
        public CrossRateBuilder setCurrency1(Currency _currency1) {
            this.currency1 = _currency1 == null ? null : _currency1.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="currency2", isRequired=true)
        @RuneAttribute(value="currency2", isRequired=true)
        public CrossRateBuilder setCurrency2(Currency _currency2) {
            this.currency2 = _currency2 == null ? null : _currency2.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="quoteBasis")
        @RuneAttribute(value="quoteBasis")
        public CrossRateBuilder setQuoteBasis(QuoteBasisEnum _quoteBasis) {
            this.quoteBasis = _quoteBasis == null ? null : _quoteBasis;
            return this;
        }

        @Override
        @RosettaAttribute(value="rate")
        @RuneAttribute(value="rate")
        public CrossRateBuilder setRate(BigDecimal _rate) {
            this.rate = _rate == null ? null : _rate;
            return this;
        }

        @Override
        @RosettaAttribute(value="crossRateSequence")
        @RuneAttribute(value="crossRateSequence")
        public CrossRateBuilder setCrossRateSequence(CrossRateSequence _crossRateSequence) {
            this.crossRateSequence = _crossRateSequence == null ? null : _crossRateSequence.toBuilder();
            return this;
        }

        @Override
        public CrossRate build() {
            return new CrossRateImpl(this);
        }

        @Override
        public CrossRateBuilder toBuilder() {
            return this;
        }

        @Override
        public CrossRateBuilder prune() {
            super.prune();
            if (this.crossRateSequence != null && !this.crossRateSequence.prune().hasData()) {
                this.crossRateSequence = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getRate() != null) {
                return true;
            }
            return this.getCrossRateSequence() != null && this.getCrossRateSequence().hasData();
        }

        @Override
        public CrossRateBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            CrossRateBuilder o = (CrossRateBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCrossRateSequence(), (RosettaModelObjectBuilder)o.getCrossRateSequence(), this::setCrossRateSequence);
            merger.mergeBasic((Object)this.getRate(), (Object)o.getRate(), this::setRate, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CrossRate _that = (CrossRate)this.getType().cast(o);
            if (!Objects.equals(this.rate, _that.getRate())) {
                return false;
            }
            return Objects.equals(this.crossRateSequence, _that.getCrossRateSequence());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.rate != null ? this.rate.hashCode() : 0);
            _result = 31 * _result + (this.crossRateSequence != null ? this.crossRateSequence.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "CrossRateBuilder {rate=" + this.rate + ", crossRateSequence=" + this.crossRateSequence + '}' + " " + super.toString();
        }
    }

    public static interface CrossRateBuilder
    extends CrossRate,
    QuotedCurrencyPair.QuotedCurrencyPairBuilder {
        public CrossRateSequence.CrossRateSequenceBuilder getOrCreateCrossRateSequence();

        @Override
        public CrossRateSequence.CrossRateSequenceBuilder getCrossRateSequence();

        @Override
        public CrossRateBuilder setCurrency1(Currency var1);

        @Override
        public CrossRateBuilder setCurrency2(Currency var1);

        @Override
        public CrossRateBuilder setQuoteBasis(QuoteBasisEnum var1);

        public CrossRateBuilder setRate(BigDecimal var1);

        public CrossRateBuilder setCrossRateSequence(CrossRateSequence var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("currency1"), processor, Currency.CurrencyBuilder.class, (RosettaModelObjectBuilder)this.getCurrency1(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("currency2"), processor, Currency.CurrencyBuilder.class, (RosettaModelObjectBuilder)this.getCurrency2(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("quoteBasis"), QuoteBasisEnum.class, (Object)this.getQuoteBasis(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("rate"), BigDecimal.class, (Object)this.getRate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("crossRateSequence"), processor, CrossRateSequence.CrossRateSequenceBuilder.class, this.getCrossRateSequence(), new AttributeMeta[0]);
        }

        @Override
        public CrossRateBuilder prune();
    }

    public static class CrossRateImpl
    extends QuotedCurrencyPair.QuotedCurrencyPairImpl
    implements CrossRate {
        private final BigDecimal rate;
        private final CrossRateSequence crossRateSequence;

        protected CrossRateImpl(CrossRateBuilder builder) {
            super(builder);
            this.rate = builder.getRate();
            this.crossRateSequence = Optional.ofNullable(builder.getCrossRateSequence()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="rate")
        @RuneAttribute(value="rate")
        public BigDecimal getRate() {
            return this.rate;
        }

        @Override
        @RosettaAttribute(value="crossRateSequence")
        @RuneAttribute(value="crossRateSequence")
        public CrossRateSequence getCrossRateSequence() {
            return this.crossRateSequence;
        }

        @Override
        public CrossRate build() {
            return this;
        }

        @Override
        public CrossRateBuilder toBuilder() {
            CrossRateBuilder builder = CrossRate.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CrossRateBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getRate()).ifPresent(builder::setRate);
            Optional.ofNullable(this.getCrossRateSequence()).ifPresent(builder::setCrossRateSequence);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CrossRate _that = (CrossRate)this.getType().cast(o);
            if (!Objects.equals(this.rate, _that.getRate())) {
                return false;
            }
            return Objects.equals(this.crossRateSequence, _that.getCrossRateSequence());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.rate != null ? this.rate.hashCode() : 0);
            _result = 31 * _result + (this.crossRateSequence != null ? this.crossRateSequence.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "CrossRate {rate=" + this.rate + ", crossRateSequence=" + this.crossRateSequence + '}' + " " + super.toString();
        }
    }
}

