/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.eqd;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.eq.shared.EquityValuation;
import fpml.consolidated.eqd.EquityAmericanExercise;
import fpml.consolidated.eqd.EquityBermudaExercise;
import fpml.consolidated.eqd.EquityEuropeanExercise;
import fpml.consolidated.eqd.EquityExerciseValuationSettlementSequence;
import fpml.consolidated.eqd.PrePayment;
import fpml.consolidated.eqd.meta.EquityExerciseValuationSettlementMeta;
import fpml.consolidated.fpmlenum.SettlementTypeEnum;
import fpml.consolidated.shared.AdjustableOrRelativeDate;
import fpml.consolidated.shared.Currency;
import fpml.consolidated.shared.PartyReference;
import fpml.consolidated.shared.SettlementPriceDefaultElection;
import fpml.consolidated.shared.SettlementPriceSource;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="EquityExerciseValuationSettlement", builder=EquityExerciseValuationSettlementBuilderImpl.class, version="1.1.0")
@RuneDataType(value="EquityExerciseValuationSettlement", model="fpml", builder=EquityExerciseValuationSettlementBuilderImpl.class, version="1.1.0")
public interface EquityExerciseValuationSettlement
extends RosettaModelObject {
    public static final EquityExerciseValuationSettlementMeta metaData = new EquityExerciseValuationSettlementMeta();

    public EquityEuropeanExercise getEquityEuropeanExercise();

    public EquityAmericanExercise getEquityAmericanExercise();

    public EquityBermudaExercise getEquityBermudaExercise();

    public EquityExerciseValuationSettlementSequence getEquityExerciseValuationSettlementSequence();

    public PrePayment getPrePayment();

    public EquityValuation getEquityValuation();

    public AdjustableOrRelativeDate getSettlementDate();

    public Currency getSettlementCurrency();

    public SettlementPriceSource getSettlementPriceSource();

    public SettlementTypeEnum getSettlementType();

    public AdjustableOrRelativeDate getSettlementMethodElectionDate();

    public PartyReference getSettlementMethodElectingPartyReference();

    public SettlementPriceDefaultElection getSettlementPriceDefaultElection();

    public EquityExerciseValuationSettlement build();

    public EquityExerciseValuationSettlementBuilder toBuilder();

    public static EquityExerciseValuationSettlementBuilder builder() {
        return new EquityExerciseValuationSettlementBuilderImpl();
    }

    default public RosettaMetaData<? extends EquityExerciseValuationSettlement> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends EquityExerciseValuationSettlement> getType() {
        return EquityExerciseValuationSettlement.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("equityEuropeanExercise"), processor, EquityEuropeanExercise.class, this.getEquityEuropeanExercise(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("equityAmericanExercise"), processor, EquityAmericanExercise.class, this.getEquityAmericanExercise(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("equityBermudaExercise"), processor, EquityBermudaExercise.class, this.getEquityBermudaExercise(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("equityExerciseValuationSettlementSequence"), processor, EquityExerciseValuationSettlementSequence.class, this.getEquityExerciseValuationSettlementSequence(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("prePayment"), processor, PrePayment.class, this.getPrePayment(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("equityValuation"), processor, EquityValuation.class, this.getEquityValuation(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("settlementDate"), processor, AdjustableOrRelativeDate.class, this.getSettlementDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("settlementCurrency"), processor, Currency.class, this.getSettlementCurrency(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("settlementPriceSource"), processor, SettlementPriceSource.class, this.getSettlementPriceSource(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("settlementType"), SettlementTypeEnum.class, (Object)this.getSettlementType(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("settlementMethodElectionDate"), processor, AdjustableOrRelativeDate.class, this.getSettlementMethodElectionDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("settlementMethodElectingPartyReference"), processor, PartyReference.class, this.getSettlementMethodElectingPartyReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("settlementPriceDefaultElection"), processor, SettlementPriceDefaultElection.class, this.getSettlementPriceDefaultElection(), new AttributeMeta[0]);
    }

    public static class EquityExerciseValuationSettlementBuilderImpl
    implements EquityExerciseValuationSettlementBuilder {
        protected EquityEuropeanExercise.EquityEuropeanExerciseBuilder equityEuropeanExercise;
        protected EquityAmericanExercise.EquityAmericanExerciseBuilder equityAmericanExercise;
        protected EquityBermudaExercise.EquityBermudaExerciseBuilder equityBermudaExercise;
        protected EquityExerciseValuationSettlementSequence.EquityExerciseValuationSettlementSequenceBuilder equityExerciseValuationSettlementSequence;
        protected PrePayment.PrePaymentBuilder prePayment;
        protected EquityValuation.EquityValuationBuilder equityValuation;
        protected AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder settlementDate;
        protected Currency.CurrencyBuilder settlementCurrency;
        protected SettlementPriceSource.SettlementPriceSourceBuilder settlementPriceSource;
        protected SettlementTypeEnum settlementType;
        protected AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder settlementMethodElectionDate;
        protected PartyReference.PartyReferenceBuilder settlementMethodElectingPartyReference;
        protected SettlementPriceDefaultElection.SettlementPriceDefaultElectionBuilder settlementPriceDefaultElection;

        @Override
        @RosettaAttribute(value="equityEuropeanExercise")
        @RuneAttribute(value="equityEuropeanExercise")
        public EquityEuropeanExercise.EquityEuropeanExerciseBuilder getEquityEuropeanExercise() {
            return this.equityEuropeanExercise;
        }

        @Override
        public EquityEuropeanExercise.EquityEuropeanExerciseBuilder getOrCreateEquityEuropeanExercise() {
            EquityEuropeanExercise.EquityEuropeanExerciseBuilder result = this.equityEuropeanExercise != null ? this.equityEuropeanExercise : (this.equityEuropeanExercise = EquityEuropeanExercise.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="equityAmericanExercise")
        @RuneAttribute(value="equityAmericanExercise")
        public EquityAmericanExercise.EquityAmericanExerciseBuilder getEquityAmericanExercise() {
            return this.equityAmericanExercise;
        }

        @Override
        public EquityAmericanExercise.EquityAmericanExerciseBuilder getOrCreateEquityAmericanExercise() {
            EquityAmericanExercise.EquityAmericanExerciseBuilder result = this.equityAmericanExercise != null ? this.equityAmericanExercise : (this.equityAmericanExercise = EquityAmericanExercise.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="equityBermudaExercise")
        @RuneAttribute(value="equityBermudaExercise")
        public EquityBermudaExercise.EquityBermudaExerciseBuilder getEquityBermudaExercise() {
            return this.equityBermudaExercise;
        }

        @Override
        public EquityBermudaExercise.EquityBermudaExerciseBuilder getOrCreateEquityBermudaExercise() {
            EquityBermudaExercise.EquityBermudaExerciseBuilder result = this.equityBermudaExercise != null ? this.equityBermudaExercise : (this.equityBermudaExercise = EquityBermudaExercise.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="equityExerciseValuationSettlementSequence")
        @RuneAttribute(value="equityExerciseValuationSettlementSequence")
        public EquityExerciseValuationSettlementSequence.EquityExerciseValuationSettlementSequenceBuilder getEquityExerciseValuationSettlementSequence() {
            return this.equityExerciseValuationSettlementSequence;
        }

        @Override
        public EquityExerciseValuationSettlementSequence.EquityExerciseValuationSettlementSequenceBuilder getOrCreateEquityExerciseValuationSettlementSequence() {
            EquityExerciseValuationSettlementSequence.EquityExerciseValuationSettlementSequenceBuilder result = this.equityExerciseValuationSettlementSequence != null ? this.equityExerciseValuationSettlementSequence : (this.equityExerciseValuationSettlementSequence = EquityExerciseValuationSettlementSequence.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="prePayment")
        @RuneAttribute(value="prePayment")
        public PrePayment.PrePaymentBuilder getPrePayment() {
            return this.prePayment;
        }

        @Override
        public PrePayment.PrePaymentBuilder getOrCreatePrePayment() {
            PrePayment.PrePaymentBuilder result = this.prePayment != null ? this.prePayment : (this.prePayment = PrePayment.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="equityValuation")
        @RuneAttribute(value="equityValuation")
        public EquityValuation.EquityValuationBuilder getEquityValuation() {
            return this.equityValuation;
        }

        @Override
        public EquityValuation.EquityValuationBuilder getOrCreateEquityValuation() {
            EquityValuation.EquityValuationBuilder result = this.equityValuation != null ? this.equityValuation : (this.equityValuation = EquityValuation.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="settlementDate")
        @RuneAttribute(value="settlementDate")
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getSettlementDate() {
            return this.settlementDate;
        }

        @Override
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getOrCreateSettlementDate() {
            AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder result = this.settlementDate != null ? this.settlementDate : (this.settlementDate = AdjustableOrRelativeDate.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="settlementCurrency")
        @RuneAttribute(value="settlementCurrency")
        public Currency.CurrencyBuilder getSettlementCurrency() {
            return this.settlementCurrency;
        }

        @Override
        public Currency.CurrencyBuilder getOrCreateSettlementCurrency() {
            Currency.CurrencyBuilder result = this.settlementCurrency != null ? this.settlementCurrency : (this.settlementCurrency = Currency.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="settlementPriceSource")
        @RuneAttribute(value="settlementPriceSource")
        public SettlementPriceSource.SettlementPriceSourceBuilder getSettlementPriceSource() {
            return this.settlementPriceSource;
        }

        @Override
        public SettlementPriceSource.SettlementPriceSourceBuilder getOrCreateSettlementPriceSource() {
            SettlementPriceSource.SettlementPriceSourceBuilder result = this.settlementPriceSource != null ? this.settlementPriceSource : (this.settlementPriceSource = SettlementPriceSource.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="settlementType")
        @RuneAttribute(value="settlementType")
        public SettlementTypeEnum getSettlementType() {
            return this.settlementType;
        }

        @Override
        @RosettaAttribute(value="settlementMethodElectionDate")
        @RuneAttribute(value="settlementMethodElectionDate")
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getSettlementMethodElectionDate() {
            return this.settlementMethodElectionDate;
        }

        @Override
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getOrCreateSettlementMethodElectionDate() {
            AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder result = this.settlementMethodElectionDate != null ? this.settlementMethodElectionDate : (this.settlementMethodElectionDate = AdjustableOrRelativeDate.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="settlementMethodElectingPartyReference")
        @RuneAttribute(value="settlementMethodElectingPartyReference")
        public PartyReference.PartyReferenceBuilder getSettlementMethodElectingPartyReference() {
            return this.settlementMethodElectingPartyReference;
        }

        @Override
        public PartyReference.PartyReferenceBuilder getOrCreateSettlementMethodElectingPartyReference() {
            PartyReference.PartyReferenceBuilder result = this.settlementMethodElectingPartyReference != null ? this.settlementMethodElectingPartyReference : (this.settlementMethodElectingPartyReference = PartyReference.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="settlementPriceDefaultElection")
        @RuneAttribute(value="settlementPriceDefaultElection")
        public SettlementPriceDefaultElection.SettlementPriceDefaultElectionBuilder getSettlementPriceDefaultElection() {
            return this.settlementPriceDefaultElection;
        }

        @Override
        public SettlementPriceDefaultElection.SettlementPriceDefaultElectionBuilder getOrCreateSettlementPriceDefaultElection() {
            SettlementPriceDefaultElection.SettlementPriceDefaultElectionBuilder result = this.settlementPriceDefaultElection != null ? this.settlementPriceDefaultElection : (this.settlementPriceDefaultElection = SettlementPriceDefaultElection.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="equityEuropeanExercise")
        @RuneAttribute(value="equityEuropeanExercise")
        public EquityExerciseValuationSettlementBuilder setEquityEuropeanExercise(EquityEuropeanExercise _equityEuropeanExercise) {
            this.equityEuropeanExercise = _equityEuropeanExercise == null ? null : _equityEuropeanExercise.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="equityAmericanExercise")
        @RuneAttribute(value="equityAmericanExercise")
        public EquityExerciseValuationSettlementBuilder setEquityAmericanExercise(EquityAmericanExercise _equityAmericanExercise) {
            this.equityAmericanExercise = _equityAmericanExercise == null ? null : _equityAmericanExercise.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="equityBermudaExercise")
        @RuneAttribute(value="equityBermudaExercise")
        public EquityExerciseValuationSettlementBuilder setEquityBermudaExercise(EquityBermudaExercise _equityBermudaExercise) {
            this.equityBermudaExercise = _equityBermudaExercise == null ? null : _equityBermudaExercise.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="equityExerciseValuationSettlementSequence")
        @RuneAttribute(value="equityExerciseValuationSettlementSequence")
        public EquityExerciseValuationSettlementBuilder setEquityExerciseValuationSettlementSequence(EquityExerciseValuationSettlementSequence _equityExerciseValuationSettlementSequence) {
            this.equityExerciseValuationSettlementSequence = _equityExerciseValuationSettlementSequence == null ? null : _equityExerciseValuationSettlementSequence.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="prePayment")
        @RuneAttribute(value="prePayment")
        public EquityExerciseValuationSettlementBuilder setPrePayment(PrePayment _prePayment) {
            this.prePayment = _prePayment == null ? null : _prePayment.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="equityValuation")
        @RuneAttribute(value="equityValuation")
        public EquityExerciseValuationSettlementBuilder setEquityValuation(EquityValuation _equityValuation) {
            this.equityValuation = _equityValuation == null ? null : _equityValuation.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="settlementDate")
        @RuneAttribute(value="settlementDate")
        public EquityExerciseValuationSettlementBuilder setSettlementDate(AdjustableOrRelativeDate _settlementDate) {
            this.settlementDate = _settlementDate == null ? null : _settlementDate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="settlementCurrency")
        @RuneAttribute(value="settlementCurrency")
        public EquityExerciseValuationSettlementBuilder setSettlementCurrency(Currency _settlementCurrency) {
            this.settlementCurrency = _settlementCurrency == null ? null : _settlementCurrency.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="settlementPriceSource")
        @RuneAttribute(value="settlementPriceSource")
        public EquityExerciseValuationSettlementBuilder setSettlementPriceSource(SettlementPriceSource _settlementPriceSource) {
            this.settlementPriceSource = _settlementPriceSource == null ? null : _settlementPriceSource.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="settlementType")
        @RuneAttribute(value="settlementType")
        public EquityExerciseValuationSettlementBuilder setSettlementType(SettlementTypeEnum _settlementType) {
            this.settlementType = _settlementType == null ? null : _settlementType;
            return this;
        }

        @Override
        @RosettaAttribute(value="settlementMethodElectionDate")
        @RuneAttribute(value="settlementMethodElectionDate")
        public EquityExerciseValuationSettlementBuilder setSettlementMethodElectionDate(AdjustableOrRelativeDate _settlementMethodElectionDate) {
            this.settlementMethodElectionDate = _settlementMethodElectionDate == null ? null : _settlementMethodElectionDate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="settlementMethodElectingPartyReference")
        @RuneAttribute(value="settlementMethodElectingPartyReference")
        public EquityExerciseValuationSettlementBuilder setSettlementMethodElectingPartyReference(PartyReference _settlementMethodElectingPartyReference) {
            this.settlementMethodElectingPartyReference = _settlementMethodElectingPartyReference == null ? null : _settlementMethodElectingPartyReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="settlementPriceDefaultElection")
        @RuneAttribute(value="settlementPriceDefaultElection")
        public EquityExerciseValuationSettlementBuilder setSettlementPriceDefaultElection(SettlementPriceDefaultElection _settlementPriceDefaultElection) {
            this.settlementPriceDefaultElection = _settlementPriceDefaultElection == null ? null : _settlementPriceDefaultElection.toBuilder();
            return this;
        }

        @Override
        public EquityExerciseValuationSettlement build() {
            return new EquityExerciseValuationSettlementImpl(this);
        }

        @Override
        public EquityExerciseValuationSettlementBuilder toBuilder() {
            return this;
        }

        @Override
        public EquityExerciseValuationSettlementBuilder prune() {
            if (this.equityEuropeanExercise != null && !this.equityEuropeanExercise.prune().hasData()) {
                this.equityEuropeanExercise = null;
            }
            if (this.equityAmericanExercise != null && !this.equityAmericanExercise.prune().hasData()) {
                this.equityAmericanExercise = null;
            }
            if (this.equityBermudaExercise != null && !this.equityBermudaExercise.prune().hasData()) {
                this.equityBermudaExercise = null;
            }
            if (this.equityExerciseValuationSettlementSequence != null && !this.equityExerciseValuationSettlementSequence.prune().hasData()) {
                this.equityExerciseValuationSettlementSequence = null;
            }
            if (this.prePayment != null && !this.prePayment.prune().hasData()) {
                this.prePayment = null;
            }
            if (this.equityValuation != null && !this.equityValuation.prune().hasData()) {
                this.equityValuation = null;
            }
            if (this.settlementDate != null && !this.settlementDate.prune().hasData()) {
                this.settlementDate = null;
            }
            if (this.settlementCurrency != null && !this.settlementCurrency.prune().hasData()) {
                this.settlementCurrency = null;
            }
            if (this.settlementPriceSource != null && !this.settlementPriceSource.prune().hasData()) {
                this.settlementPriceSource = null;
            }
            if (this.settlementMethodElectionDate != null && !this.settlementMethodElectionDate.prune().hasData()) {
                this.settlementMethodElectionDate = null;
            }
            if (this.settlementMethodElectingPartyReference != null && !this.settlementMethodElectingPartyReference.prune().hasData()) {
                this.settlementMethodElectingPartyReference = null;
            }
            if (this.settlementPriceDefaultElection != null && !this.settlementPriceDefaultElection.prune().hasData()) {
                this.settlementPriceDefaultElection = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getEquityEuropeanExercise() != null && this.getEquityEuropeanExercise().hasData()) {
                return true;
            }
            if (this.getEquityAmericanExercise() != null && this.getEquityAmericanExercise().hasData()) {
                return true;
            }
            if (this.getEquityBermudaExercise() != null && this.getEquityBermudaExercise().hasData()) {
                return true;
            }
            if (this.getEquityExerciseValuationSettlementSequence() != null && this.getEquityExerciseValuationSettlementSequence().hasData()) {
                return true;
            }
            if (this.getPrePayment() != null && this.getPrePayment().hasData()) {
                return true;
            }
            if (this.getEquityValuation() != null && this.getEquityValuation().hasData()) {
                return true;
            }
            if (this.getSettlementDate() != null && this.getSettlementDate().hasData()) {
                return true;
            }
            if (this.getSettlementCurrency() != null && this.getSettlementCurrency().hasData()) {
                return true;
            }
            if (this.getSettlementPriceSource() != null && this.getSettlementPriceSource().hasData()) {
                return true;
            }
            if (this.getSettlementType() != null) {
                return true;
            }
            if (this.getSettlementMethodElectionDate() != null && this.getSettlementMethodElectionDate().hasData()) {
                return true;
            }
            if (this.getSettlementMethodElectingPartyReference() != null && this.getSettlementMethodElectingPartyReference().hasData()) {
                return true;
            }
            return this.getSettlementPriceDefaultElection() != null && this.getSettlementPriceDefaultElection().hasData();
        }

        public EquityExerciseValuationSettlementBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            EquityExerciseValuationSettlementBuilder o = (EquityExerciseValuationSettlementBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getEquityEuropeanExercise(), (RosettaModelObjectBuilder)o.getEquityEuropeanExercise(), this::setEquityEuropeanExercise);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getEquityAmericanExercise(), (RosettaModelObjectBuilder)o.getEquityAmericanExercise(), this::setEquityAmericanExercise);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getEquityBermudaExercise(), (RosettaModelObjectBuilder)o.getEquityBermudaExercise(), this::setEquityBermudaExercise);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getEquityExerciseValuationSettlementSequence(), (RosettaModelObjectBuilder)o.getEquityExerciseValuationSettlementSequence(), this::setEquityExerciseValuationSettlementSequence);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPrePayment(), (RosettaModelObjectBuilder)o.getPrePayment(), this::setPrePayment);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getEquityValuation(), (RosettaModelObjectBuilder)o.getEquityValuation(), this::setEquityValuation);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSettlementDate(), (RosettaModelObjectBuilder)o.getSettlementDate(), this::setSettlementDate);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSettlementCurrency(), (RosettaModelObjectBuilder)o.getSettlementCurrency(), this::setSettlementCurrency);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSettlementPriceSource(), (RosettaModelObjectBuilder)o.getSettlementPriceSource(), this::setSettlementPriceSource);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSettlementMethodElectionDate(), (RosettaModelObjectBuilder)o.getSettlementMethodElectionDate(), this::setSettlementMethodElectionDate);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSettlementMethodElectingPartyReference(), (RosettaModelObjectBuilder)o.getSettlementMethodElectingPartyReference(), this::setSettlementMethodElectingPartyReference);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSettlementPriceDefaultElection(), (RosettaModelObjectBuilder)o.getSettlementPriceDefaultElection(), this::setSettlementPriceDefaultElection);
            merger.mergeBasic((Object)this.getSettlementType(), (Object)o.getSettlementType(), this::setSettlementType, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            EquityExerciseValuationSettlement _that = this.getType().cast(o);
            if (!Objects.equals(this.equityEuropeanExercise, _that.getEquityEuropeanExercise())) {
                return false;
            }
            if (!Objects.equals(this.equityAmericanExercise, _that.getEquityAmericanExercise())) {
                return false;
            }
            if (!Objects.equals(this.equityBermudaExercise, _that.getEquityBermudaExercise())) {
                return false;
            }
            if (!Objects.equals(this.equityExerciseValuationSettlementSequence, _that.getEquityExerciseValuationSettlementSequence())) {
                return false;
            }
            if (!Objects.equals(this.prePayment, _that.getPrePayment())) {
                return false;
            }
            if (!Objects.equals(this.equityValuation, _that.getEquityValuation())) {
                return false;
            }
            if (!Objects.equals(this.settlementDate, _that.getSettlementDate())) {
                return false;
            }
            if (!Objects.equals(this.settlementCurrency, _that.getSettlementCurrency())) {
                return false;
            }
            if (!Objects.equals(this.settlementPriceSource, _that.getSettlementPriceSource())) {
                return false;
            }
            if (!Objects.equals((Object)this.settlementType, (Object)_that.getSettlementType())) {
                return false;
            }
            if (!Objects.equals(this.settlementMethodElectionDate, _that.getSettlementMethodElectionDate())) {
                return false;
            }
            if (!Objects.equals(this.settlementMethodElectingPartyReference, _that.getSettlementMethodElectingPartyReference())) {
                return false;
            }
            return Objects.equals(this.settlementPriceDefaultElection, _that.getSettlementPriceDefaultElection());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.equityEuropeanExercise != null ? this.equityEuropeanExercise.hashCode() : 0);
            _result = 31 * _result + (this.equityAmericanExercise != null ? this.equityAmericanExercise.hashCode() : 0);
            _result = 31 * _result + (this.equityBermudaExercise != null ? this.equityBermudaExercise.hashCode() : 0);
            _result = 31 * _result + (this.equityExerciseValuationSettlementSequence != null ? this.equityExerciseValuationSettlementSequence.hashCode() : 0);
            _result = 31 * _result + (this.prePayment != null ? this.prePayment.hashCode() : 0);
            _result = 31 * _result + (this.equityValuation != null ? this.equityValuation.hashCode() : 0);
            _result = 31 * _result + (this.settlementDate != null ? this.settlementDate.hashCode() : 0);
            _result = 31 * _result + (this.settlementCurrency != null ? this.settlementCurrency.hashCode() : 0);
            _result = 31 * _result + (this.settlementPriceSource != null ? this.settlementPriceSource.hashCode() : 0);
            _result = 31 * _result + (this.settlementType != null ? ((Object)((Object)this.settlementType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.settlementMethodElectionDate != null ? this.settlementMethodElectionDate.hashCode() : 0);
            _result = 31 * _result + (this.settlementMethodElectingPartyReference != null ? this.settlementMethodElectingPartyReference.hashCode() : 0);
            _result = 31 * _result + (this.settlementPriceDefaultElection != null ? this.settlementPriceDefaultElection.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "EquityExerciseValuationSettlementBuilder {equityEuropeanExercise=" + this.equityEuropeanExercise + ", equityAmericanExercise=" + this.equityAmericanExercise + ", equityBermudaExercise=" + this.equityBermudaExercise + ", equityExerciseValuationSettlementSequence=" + this.equityExerciseValuationSettlementSequence + ", prePayment=" + this.prePayment + ", equityValuation=" + this.equityValuation + ", settlementDate=" + this.settlementDate + ", settlementCurrency=" + this.settlementCurrency + ", settlementPriceSource=" + this.settlementPriceSource + ", settlementType=" + (Object)((Object)this.settlementType) + ", settlementMethodElectionDate=" + this.settlementMethodElectionDate + ", settlementMethodElectingPartyReference=" + this.settlementMethodElectingPartyReference + ", settlementPriceDefaultElection=" + this.settlementPriceDefaultElection + '}';
        }
    }

    public static interface EquityExerciseValuationSettlementBuilder
    extends EquityExerciseValuationSettlement,
    RosettaModelObjectBuilder {
        public EquityEuropeanExercise.EquityEuropeanExerciseBuilder getOrCreateEquityEuropeanExercise();

        @Override
        public EquityEuropeanExercise.EquityEuropeanExerciseBuilder getEquityEuropeanExercise();

        public EquityAmericanExercise.EquityAmericanExerciseBuilder getOrCreateEquityAmericanExercise();

        @Override
        public EquityAmericanExercise.EquityAmericanExerciseBuilder getEquityAmericanExercise();

        public EquityBermudaExercise.EquityBermudaExerciseBuilder getOrCreateEquityBermudaExercise();

        @Override
        public EquityBermudaExercise.EquityBermudaExerciseBuilder getEquityBermudaExercise();

        public EquityExerciseValuationSettlementSequence.EquityExerciseValuationSettlementSequenceBuilder getOrCreateEquityExerciseValuationSettlementSequence();

        @Override
        public EquityExerciseValuationSettlementSequence.EquityExerciseValuationSettlementSequenceBuilder getEquityExerciseValuationSettlementSequence();

        public PrePayment.PrePaymentBuilder getOrCreatePrePayment();

        @Override
        public PrePayment.PrePaymentBuilder getPrePayment();

        public EquityValuation.EquityValuationBuilder getOrCreateEquityValuation();

        @Override
        public EquityValuation.EquityValuationBuilder getEquityValuation();

        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getOrCreateSettlementDate();

        @Override
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getSettlementDate();

        public Currency.CurrencyBuilder getOrCreateSettlementCurrency();

        @Override
        public Currency.CurrencyBuilder getSettlementCurrency();

        public SettlementPriceSource.SettlementPriceSourceBuilder getOrCreateSettlementPriceSource();

        @Override
        public SettlementPriceSource.SettlementPriceSourceBuilder getSettlementPriceSource();

        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getOrCreateSettlementMethodElectionDate();

        @Override
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getSettlementMethodElectionDate();

        public PartyReference.PartyReferenceBuilder getOrCreateSettlementMethodElectingPartyReference();

        @Override
        public PartyReference.PartyReferenceBuilder getSettlementMethodElectingPartyReference();

        public SettlementPriceDefaultElection.SettlementPriceDefaultElectionBuilder getOrCreateSettlementPriceDefaultElection();

        @Override
        public SettlementPriceDefaultElection.SettlementPriceDefaultElectionBuilder getSettlementPriceDefaultElection();

        public EquityExerciseValuationSettlementBuilder setEquityEuropeanExercise(EquityEuropeanExercise var1);

        public EquityExerciseValuationSettlementBuilder setEquityAmericanExercise(EquityAmericanExercise var1);

        public EquityExerciseValuationSettlementBuilder setEquityBermudaExercise(EquityBermudaExercise var1);

        public EquityExerciseValuationSettlementBuilder setEquityExerciseValuationSettlementSequence(EquityExerciseValuationSettlementSequence var1);

        public EquityExerciseValuationSettlementBuilder setPrePayment(PrePayment var1);

        public EquityExerciseValuationSettlementBuilder setEquityValuation(EquityValuation var1);

        public EquityExerciseValuationSettlementBuilder setSettlementDate(AdjustableOrRelativeDate var1);

        public EquityExerciseValuationSettlementBuilder setSettlementCurrency(Currency var1);

        public EquityExerciseValuationSettlementBuilder setSettlementPriceSource(SettlementPriceSource var1);

        public EquityExerciseValuationSettlementBuilder setSettlementType(SettlementTypeEnum var1);

        public EquityExerciseValuationSettlementBuilder setSettlementMethodElectionDate(AdjustableOrRelativeDate var1);

        public EquityExerciseValuationSettlementBuilder setSettlementMethodElectingPartyReference(PartyReference var1);

        public EquityExerciseValuationSettlementBuilder setSettlementPriceDefaultElection(SettlementPriceDefaultElection var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("equityEuropeanExercise"), processor, EquityEuropeanExercise.EquityEuropeanExerciseBuilder.class, this.getEquityEuropeanExercise(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("equityAmericanExercise"), processor, EquityAmericanExercise.EquityAmericanExerciseBuilder.class, this.getEquityAmericanExercise(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("equityBermudaExercise"), processor, EquityBermudaExercise.EquityBermudaExerciseBuilder.class, this.getEquityBermudaExercise(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("equityExerciseValuationSettlementSequence"), processor, EquityExerciseValuationSettlementSequence.EquityExerciseValuationSettlementSequenceBuilder.class, this.getEquityExerciseValuationSettlementSequence(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("prePayment"), processor, PrePayment.PrePaymentBuilder.class, this.getPrePayment(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("equityValuation"), processor, EquityValuation.EquityValuationBuilder.class, this.getEquityValuation(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("settlementDate"), processor, AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder.class, this.getSettlementDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("settlementCurrency"), processor, Currency.CurrencyBuilder.class, this.getSettlementCurrency(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("settlementPriceSource"), processor, SettlementPriceSource.SettlementPriceSourceBuilder.class, this.getSettlementPriceSource(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("settlementType"), SettlementTypeEnum.class, (Object)this.getSettlementType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("settlementMethodElectionDate"), processor, AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder.class, this.getSettlementMethodElectionDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("settlementMethodElectingPartyReference"), processor, PartyReference.PartyReferenceBuilder.class, this.getSettlementMethodElectingPartyReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("settlementPriceDefaultElection"), processor, SettlementPriceDefaultElection.SettlementPriceDefaultElectionBuilder.class, this.getSettlementPriceDefaultElection(), new AttributeMeta[0]);
        }

        public EquityExerciseValuationSettlementBuilder prune();
    }

    public static class EquityExerciseValuationSettlementImpl
    implements EquityExerciseValuationSettlement {
        private final EquityEuropeanExercise equityEuropeanExercise;
        private final EquityAmericanExercise equityAmericanExercise;
        private final EquityBermudaExercise equityBermudaExercise;
        private final EquityExerciseValuationSettlementSequence equityExerciseValuationSettlementSequence;
        private final PrePayment prePayment;
        private final EquityValuation equityValuation;
        private final AdjustableOrRelativeDate settlementDate;
        private final Currency settlementCurrency;
        private final SettlementPriceSource settlementPriceSource;
        private final SettlementTypeEnum settlementType;
        private final AdjustableOrRelativeDate settlementMethodElectionDate;
        private final PartyReference settlementMethodElectingPartyReference;
        private final SettlementPriceDefaultElection settlementPriceDefaultElection;

        protected EquityExerciseValuationSettlementImpl(EquityExerciseValuationSettlementBuilder builder) {
            this.equityEuropeanExercise = Optional.ofNullable(builder.getEquityEuropeanExercise()).map(f -> f.build()).orElse(null);
            this.equityAmericanExercise = Optional.ofNullable(builder.getEquityAmericanExercise()).map(f -> f.build()).orElse(null);
            this.equityBermudaExercise = Optional.ofNullable(builder.getEquityBermudaExercise()).map(f -> f.build()).orElse(null);
            this.equityExerciseValuationSettlementSequence = Optional.ofNullable(builder.getEquityExerciseValuationSettlementSequence()).map(f -> f.build()).orElse(null);
            this.prePayment = Optional.ofNullable(builder.getPrePayment()).map(f -> f.build()).orElse(null);
            this.equityValuation = Optional.ofNullable(builder.getEquityValuation()).map(f -> f.build()).orElse(null);
            this.settlementDate = Optional.ofNullable(builder.getSettlementDate()).map(f -> f.build()).orElse(null);
            this.settlementCurrency = Optional.ofNullable(builder.getSettlementCurrency()).map(f -> f.build()).orElse(null);
            this.settlementPriceSource = Optional.ofNullable(builder.getSettlementPriceSource()).map(f -> f.build()).orElse(null);
            this.settlementType = builder.getSettlementType();
            this.settlementMethodElectionDate = Optional.ofNullable(builder.getSettlementMethodElectionDate()).map(f -> f.build()).orElse(null);
            this.settlementMethodElectingPartyReference = Optional.ofNullable(builder.getSettlementMethodElectingPartyReference()).map(f -> f.build()).orElse(null);
            this.settlementPriceDefaultElection = Optional.ofNullable(builder.getSettlementPriceDefaultElection()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="equityEuropeanExercise")
        @RuneAttribute(value="equityEuropeanExercise")
        public EquityEuropeanExercise getEquityEuropeanExercise() {
            return this.equityEuropeanExercise;
        }

        @Override
        @RosettaAttribute(value="equityAmericanExercise")
        @RuneAttribute(value="equityAmericanExercise")
        public EquityAmericanExercise getEquityAmericanExercise() {
            return this.equityAmericanExercise;
        }

        @Override
        @RosettaAttribute(value="equityBermudaExercise")
        @RuneAttribute(value="equityBermudaExercise")
        public EquityBermudaExercise getEquityBermudaExercise() {
            return this.equityBermudaExercise;
        }

        @Override
        @RosettaAttribute(value="equityExerciseValuationSettlementSequence")
        @RuneAttribute(value="equityExerciseValuationSettlementSequence")
        public EquityExerciseValuationSettlementSequence getEquityExerciseValuationSettlementSequence() {
            return this.equityExerciseValuationSettlementSequence;
        }

        @Override
        @RosettaAttribute(value="prePayment")
        @RuneAttribute(value="prePayment")
        public PrePayment getPrePayment() {
            return this.prePayment;
        }

        @Override
        @RosettaAttribute(value="equityValuation")
        @RuneAttribute(value="equityValuation")
        public EquityValuation getEquityValuation() {
            return this.equityValuation;
        }

        @Override
        @RosettaAttribute(value="settlementDate")
        @RuneAttribute(value="settlementDate")
        public AdjustableOrRelativeDate getSettlementDate() {
            return this.settlementDate;
        }

        @Override
        @RosettaAttribute(value="settlementCurrency")
        @RuneAttribute(value="settlementCurrency")
        public Currency getSettlementCurrency() {
            return this.settlementCurrency;
        }

        @Override
        @RosettaAttribute(value="settlementPriceSource")
        @RuneAttribute(value="settlementPriceSource")
        public SettlementPriceSource getSettlementPriceSource() {
            return this.settlementPriceSource;
        }

        @Override
        @RosettaAttribute(value="settlementType")
        @RuneAttribute(value="settlementType")
        public SettlementTypeEnum getSettlementType() {
            return this.settlementType;
        }

        @Override
        @RosettaAttribute(value="settlementMethodElectionDate")
        @RuneAttribute(value="settlementMethodElectionDate")
        public AdjustableOrRelativeDate getSettlementMethodElectionDate() {
            return this.settlementMethodElectionDate;
        }

        @Override
        @RosettaAttribute(value="settlementMethodElectingPartyReference")
        @RuneAttribute(value="settlementMethodElectingPartyReference")
        public PartyReference getSettlementMethodElectingPartyReference() {
            return this.settlementMethodElectingPartyReference;
        }

        @Override
        @RosettaAttribute(value="settlementPriceDefaultElection")
        @RuneAttribute(value="settlementPriceDefaultElection")
        public SettlementPriceDefaultElection getSettlementPriceDefaultElection() {
            return this.settlementPriceDefaultElection;
        }

        @Override
        public EquityExerciseValuationSettlement build() {
            return this;
        }

        @Override
        public EquityExerciseValuationSettlementBuilder toBuilder() {
            EquityExerciseValuationSettlementBuilder builder = EquityExerciseValuationSettlement.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(EquityExerciseValuationSettlementBuilder builder) {
            Optional.ofNullable(this.getEquityEuropeanExercise()).ifPresent(builder::setEquityEuropeanExercise);
            Optional.ofNullable(this.getEquityAmericanExercise()).ifPresent(builder::setEquityAmericanExercise);
            Optional.ofNullable(this.getEquityBermudaExercise()).ifPresent(builder::setEquityBermudaExercise);
            Optional.ofNullable(this.getEquityExerciseValuationSettlementSequence()).ifPresent(builder::setEquityExerciseValuationSettlementSequence);
            Optional.ofNullable(this.getPrePayment()).ifPresent(builder::setPrePayment);
            Optional.ofNullable(this.getEquityValuation()).ifPresent(builder::setEquityValuation);
            Optional.ofNullable(this.getSettlementDate()).ifPresent(builder::setSettlementDate);
            Optional.ofNullable(this.getSettlementCurrency()).ifPresent(builder::setSettlementCurrency);
            Optional.ofNullable(this.getSettlementPriceSource()).ifPresent(builder::setSettlementPriceSource);
            Optional.ofNullable(this.getSettlementType()).ifPresent(builder::setSettlementType);
            Optional.ofNullable(this.getSettlementMethodElectionDate()).ifPresent(builder::setSettlementMethodElectionDate);
            Optional.ofNullable(this.getSettlementMethodElectingPartyReference()).ifPresent(builder::setSettlementMethodElectingPartyReference);
            Optional.ofNullable(this.getSettlementPriceDefaultElection()).ifPresent(builder::setSettlementPriceDefaultElection);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            EquityExerciseValuationSettlement _that = this.getType().cast(o);
            if (!Objects.equals(this.equityEuropeanExercise, _that.getEquityEuropeanExercise())) {
                return false;
            }
            if (!Objects.equals(this.equityAmericanExercise, _that.getEquityAmericanExercise())) {
                return false;
            }
            if (!Objects.equals(this.equityBermudaExercise, _that.getEquityBermudaExercise())) {
                return false;
            }
            if (!Objects.equals(this.equityExerciseValuationSettlementSequence, _that.getEquityExerciseValuationSettlementSequence())) {
                return false;
            }
            if (!Objects.equals(this.prePayment, _that.getPrePayment())) {
                return false;
            }
            if (!Objects.equals(this.equityValuation, _that.getEquityValuation())) {
                return false;
            }
            if (!Objects.equals(this.settlementDate, _that.getSettlementDate())) {
                return false;
            }
            if (!Objects.equals(this.settlementCurrency, _that.getSettlementCurrency())) {
                return false;
            }
            if (!Objects.equals(this.settlementPriceSource, _that.getSettlementPriceSource())) {
                return false;
            }
            if (!Objects.equals((Object)this.settlementType, (Object)_that.getSettlementType())) {
                return false;
            }
            if (!Objects.equals(this.settlementMethodElectionDate, _that.getSettlementMethodElectionDate())) {
                return false;
            }
            if (!Objects.equals(this.settlementMethodElectingPartyReference, _that.getSettlementMethodElectingPartyReference())) {
                return false;
            }
            return Objects.equals(this.settlementPriceDefaultElection, _that.getSettlementPriceDefaultElection());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.equityEuropeanExercise != null ? this.equityEuropeanExercise.hashCode() : 0);
            _result = 31 * _result + (this.equityAmericanExercise != null ? this.equityAmericanExercise.hashCode() : 0);
            _result = 31 * _result + (this.equityBermudaExercise != null ? this.equityBermudaExercise.hashCode() : 0);
            _result = 31 * _result + (this.equityExerciseValuationSettlementSequence != null ? this.equityExerciseValuationSettlementSequence.hashCode() : 0);
            _result = 31 * _result + (this.prePayment != null ? this.prePayment.hashCode() : 0);
            _result = 31 * _result + (this.equityValuation != null ? this.equityValuation.hashCode() : 0);
            _result = 31 * _result + (this.settlementDate != null ? this.settlementDate.hashCode() : 0);
            _result = 31 * _result + (this.settlementCurrency != null ? this.settlementCurrency.hashCode() : 0);
            _result = 31 * _result + (this.settlementPriceSource != null ? this.settlementPriceSource.hashCode() : 0);
            _result = 31 * _result + (this.settlementType != null ? ((Object)((Object)this.settlementType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.settlementMethodElectionDate != null ? this.settlementMethodElectionDate.hashCode() : 0);
            _result = 31 * _result + (this.settlementMethodElectingPartyReference != null ? this.settlementMethodElectingPartyReference.hashCode() : 0);
            _result = 31 * _result + (this.settlementPriceDefaultElection != null ? this.settlementPriceDefaultElection.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "EquityExerciseValuationSettlement {equityEuropeanExercise=" + this.equityEuropeanExercise + ", equityAmericanExercise=" + this.equityAmericanExercise + ", equityBermudaExercise=" + this.equityBermudaExercise + ", equityExerciseValuationSettlementSequence=" + this.equityExerciseValuationSettlementSequence + ", prePayment=" + this.prePayment + ", equityValuation=" + this.equityValuation + ", settlementDate=" + this.settlementDate + ", settlementCurrency=" + this.settlementCurrency + ", settlementPriceSource=" + this.settlementPriceSource + ", settlementType=" + (Object)((Object)this.settlementType) + ", settlementMethodElectionDate=" + this.settlementMethodElectionDate + ", settlementMethodElectingPartyReference=" + this.settlementMethodElectingPartyReference + ", settlementPriceDefaultElection=" + this.settlementPriceDefaultElection + '}';
        }
    }
}

