/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.eq.shared;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.asset.ExchangeTradedContract;
import fpml.consolidated.eq.shared.ReturnLegValuationPrice;
import fpml.consolidated.eq.shared.ReturnSwapPaymentDates;
import fpml.consolidated.eq.shared.meta.ReturnLegValuationMeta;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="ReturnLegValuation", builder=ReturnLegValuationBuilderImpl.class, version="1.1.0")
@RuneDataType(value="ReturnLegValuation", model="fpml", builder=ReturnLegValuationBuilderImpl.class, version="1.1.0")
public interface ReturnLegValuation
extends RosettaModelObject {
    public static final ReturnLegValuationMeta metaData = new ReturnLegValuationMeta();

    public ReturnLegValuationPrice getInitialPrice();

    public Boolean getNotionalReset();

    public ReturnLegValuationPrice getValuationPriceInterim();

    public ReturnLegValuationPrice getValuationPriceFinal();

    public ReturnSwapPaymentDates getPaymentDates();

    public ExchangeTradedContract getExchangeTradedContractNearest();

    public ReturnLegValuation build();

    public ReturnLegValuationBuilder toBuilder();

    public static ReturnLegValuationBuilder builder() {
        return new ReturnLegValuationBuilderImpl();
    }

    default public RosettaMetaData<? extends ReturnLegValuation> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends ReturnLegValuation> getType() {
        return ReturnLegValuation.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("initialPrice"), processor, ReturnLegValuationPrice.class, this.getInitialPrice(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("notionalReset"), Boolean.class, (Object)this.getNotionalReset(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("valuationPriceInterim"), processor, ReturnLegValuationPrice.class, this.getValuationPriceInterim(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("valuationPriceFinal"), processor, ReturnLegValuationPrice.class, this.getValuationPriceFinal(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("paymentDates"), processor, ReturnSwapPaymentDates.class, this.getPaymentDates(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("exchangeTradedContractNearest"), processor, ExchangeTradedContract.class, this.getExchangeTradedContractNearest(), new AttributeMeta[0]);
    }

    public static class ReturnLegValuationBuilderImpl
    implements ReturnLegValuationBuilder {
        protected ReturnLegValuationPrice.ReturnLegValuationPriceBuilder initialPrice;
        protected Boolean notionalReset;
        protected ReturnLegValuationPrice.ReturnLegValuationPriceBuilder valuationPriceInterim;
        protected ReturnLegValuationPrice.ReturnLegValuationPriceBuilder valuationPriceFinal;
        protected ReturnSwapPaymentDates.ReturnSwapPaymentDatesBuilder paymentDates;
        protected ExchangeTradedContract.ExchangeTradedContractBuilder exchangeTradedContractNearest;

        @Override
        @RosettaAttribute(value="initialPrice")
        @RuneAttribute(value="initialPrice")
        public ReturnLegValuationPrice.ReturnLegValuationPriceBuilder getInitialPrice() {
            return this.initialPrice;
        }

        @Override
        public ReturnLegValuationPrice.ReturnLegValuationPriceBuilder getOrCreateInitialPrice() {
            ReturnLegValuationPrice.ReturnLegValuationPriceBuilder result = this.initialPrice != null ? this.initialPrice : (this.initialPrice = ReturnLegValuationPrice.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="notionalReset")
        @RuneAttribute(value="notionalReset")
        public Boolean getNotionalReset() {
            return this.notionalReset;
        }

        @Override
        @RosettaAttribute(value="valuationPriceInterim")
        @RuneAttribute(value="valuationPriceInterim")
        public ReturnLegValuationPrice.ReturnLegValuationPriceBuilder getValuationPriceInterim() {
            return this.valuationPriceInterim;
        }

        @Override
        public ReturnLegValuationPrice.ReturnLegValuationPriceBuilder getOrCreateValuationPriceInterim() {
            ReturnLegValuationPrice.ReturnLegValuationPriceBuilder result = this.valuationPriceInterim != null ? this.valuationPriceInterim : (this.valuationPriceInterim = ReturnLegValuationPrice.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="valuationPriceFinal")
        @RuneAttribute(value="valuationPriceFinal")
        public ReturnLegValuationPrice.ReturnLegValuationPriceBuilder getValuationPriceFinal() {
            return this.valuationPriceFinal;
        }

        @Override
        public ReturnLegValuationPrice.ReturnLegValuationPriceBuilder getOrCreateValuationPriceFinal() {
            ReturnLegValuationPrice.ReturnLegValuationPriceBuilder result = this.valuationPriceFinal != null ? this.valuationPriceFinal : (this.valuationPriceFinal = ReturnLegValuationPrice.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="paymentDates")
        @RuneAttribute(value="paymentDates")
        public ReturnSwapPaymentDates.ReturnSwapPaymentDatesBuilder getPaymentDates() {
            return this.paymentDates;
        }

        @Override
        public ReturnSwapPaymentDates.ReturnSwapPaymentDatesBuilder getOrCreatePaymentDates() {
            ReturnSwapPaymentDates.ReturnSwapPaymentDatesBuilder result = this.paymentDates != null ? this.paymentDates : (this.paymentDates = ReturnSwapPaymentDates.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="exchangeTradedContractNearest")
        @RuneAttribute(value="exchangeTradedContractNearest")
        public ExchangeTradedContract.ExchangeTradedContractBuilder getExchangeTradedContractNearest() {
            return this.exchangeTradedContractNearest;
        }

        @Override
        public ExchangeTradedContract.ExchangeTradedContractBuilder getOrCreateExchangeTradedContractNearest() {
            ExchangeTradedContract.ExchangeTradedContractBuilder result = this.exchangeTradedContractNearest != null ? this.exchangeTradedContractNearest : (this.exchangeTradedContractNearest = ExchangeTradedContract.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="initialPrice")
        @RuneAttribute(value="initialPrice")
        public ReturnLegValuationBuilder setInitialPrice(ReturnLegValuationPrice _initialPrice) {
            this.initialPrice = _initialPrice == null ? null : _initialPrice.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="notionalReset")
        @RuneAttribute(value="notionalReset")
        public ReturnLegValuationBuilder setNotionalReset(Boolean _notionalReset) {
            this.notionalReset = _notionalReset == null ? null : _notionalReset;
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationPriceInterim")
        @RuneAttribute(value="valuationPriceInterim")
        public ReturnLegValuationBuilder setValuationPriceInterim(ReturnLegValuationPrice _valuationPriceInterim) {
            this.valuationPriceInterim = _valuationPriceInterim == null ? null : _valuationPriceInterim.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationPriceFinal")
        @RuneAttribute(value="valuationPriceFinal")
        public ReturnLegValuationBuilder setValuationPriceFinal(ReturnLegValuationPrice _valuationPriceFinal) {
            this.valuationPriceFinal = _valuationPriceFinal == null ? null : _valuationPriceFinal.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="paymentDates")
        @RuneAttribute(value="paymentDates")
        public ReturnLegValuationBuilder setPaymentDates(ReturnSwapPaymentDates _paymentDates) {
            this.paymentDates = _paymentDates == null ? null : _paymentDates.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="exchangeTradedContractNearest")
        @RuneAttribute(value="exchangeTradedContractNearest")
        public ReturnLegValuationBuilder setExchangeTradedContractNearest(ExchangeTradedContract _exchangeTradedContractNearest) {
            this.exchangeTradedContractNearest = _exchangeTradedContractNearest == null ? null : _exchangeTradedContractNearest.toBuilder();
            return this;
        }

        @Override
        public ReturnLegValuation build() {
            return new ReturnLegValuationImpl(this);
        }

        @Override
        public ReturnLegValuationBuilder toBuilder() {
            return this;
        }

        @Override
        public ReturnLegValuationBuilder prune() {
            if (this.initialPrice != null && !this.initialPrice.prune().hasData()) {
                this.initialPrice = null;
            }
            if (this.valuationPriceInterim != null && !this.valuationPriceInterim.prune().hasData()) {
                this.valuationPriceInterim = null;
            }
            if (this.valuationPriceFinal != null && !this.valuationPriceFinal.prune().hasData()) {
                this.valuationPriceFinal = null;
            }
            if (this.paymentDates != null && !this.paymentDates.prune().hasData()) {
                this.paymentDates = null;
            }
            if (this.exchangeTradedContractNearest != null && !this.exchangeTradedContractNearest.prune().hasData()) {
                this.exchangeTradedContractNearest = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getInitialPrice() != null && this.getInitialPrice().hasData()) {
                return true;
            }
            if (this.getNotionalReset() != null) {
                return true;
            }
            if (this.getValuationPriceInterim() != null && this.getValuationPriceInterim().hasData()) {
                return true;
            }
            if (this.getValuationPriceFinal() != null && this.getValuationPriceFinal().hasData()) {
                return true;
            }
            if (this.getPaymentDates() != null && this.getPaymentDates().hasData()) {
                return true;
            }
            return this.getExchangeTradedContractNearest() != null && this.getExchangeTradedContractNearest().hasData();
        }

        public ReturnLegValuationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            ReturnLegValuationBuilder o = (ReturnLegValuationBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getInitialPrice(), (RosettaModelObjectBuilder)o.getInitialPrice(), this::setInitialPrice);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getValuationPriceInterim(), (RosettaModelObjectBuilder)o.getValuationPriceInterim(), this::setValuationPriceInterim);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getValuationPriceFinal(), (RosettaModelObjectBuilder)o.getValuationPriceFinal(), this::setValuationPriceFinal);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPaymentDates(), (RosettaModelObjectBuilder)o.getPaymentDates(), this::setPaymentDates);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getExchangeTradedContractNearest(), (RosettaModelObjectBuilder)o.getExchangeTradedContractNearest(), this::setExchangeTradedContractNearest);
            merger.mergeBasic((Object)this.getNotionalReset(), (Object)o.getNotionalReset(), this::setNotionalReset, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ReturnLegValuation _that = this.getType().cast(o);
            if (!Objects.equals(this.initialPrice, _that.getInitialPrice())) {
                return false;
            }
            if (!Objects.equals(this.notionalReset, _that.getNotionalReset())) {
                return false;
            }
            if (!Objects.equals(this.valuationPriceInterim, _that.getValuationPriceInterim())) {
                return false;
            }
            if (!Objects.equals(this.valuationPriceFinal, _that.getValuationPriceFinal())) {
                return false;
            }
            if (!Objects.equals(this.paymentDates, _that.getPaymentDates())) {
                return false;
            }
            return Objects.equals(this.exchangeTradedContractNearest, _that.getExchangeTradedContractNearest());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.initialPrice != null ? this.initialPrice.hashCode() : 0);
            _result = 31 * _result + (this.notionalReset != null ? this.notionalReset.hashCode() : 0);
            _result = 31 * _result + (this.valuationPriceInterim != null ? this.valuationPriceInterim.hashCode() : 0);
            _result = 31 * _result + (this.valuationPriceFinal != null ? this.valuationPriceFinal.hashCode() : 0);
            _result = 31 * _result + (this.paymentDates != null ? this.paymentDates.hashCode() : 0);
            _result = 31 * _result + (this.exchangeTradedContractNearest != null ? this.exchangeTradedContractNearest.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ReturnLegValuationBuilder {initialPrice=" + this.initialPrice + ", notionalReset=" + this.notionalReset + ", valuationPriceInterim=" + this.valuationPriceInterim + ", valuationPriceFinal=" + this.valuationPriceFinal + ", paymentDates=" + this.paymentDates + ", exchangeTradedContractNearest=" + this.exchangeTradedContractNearest + '}';
        }
    }

    public static interface ReturnLegValuationBuilder
    extends ReturnLegValuation,
    RosettaModelObjectBuilder {
        public ReturnLegValuationPrice.ReturnLegValuationPriceBuilder getOrCreateInitialPrice();

        @Override
        public ReturnLegValuationPrice.ReturnLegValuationPriceBuilder getInitialPrice();

        public ReturnLegValuationPrice.ReturnLegValuationPriceBuilder getOrCreateValuationPriceInterim();

        @Override
        public ReturnLegValuationPrice.ReturnLegValuationPriceBuilder getValuationPriceInterim();

        public ReturnLegValuationPrice.ReturnLegValuationPriceBuilder getOrCreateValuationPriceFinal();

        @Override
        public ReturnLegValuationPrice.ReturnLegValuationPriceBuilder getValuationPriceFinal();

        public ReturnSwapPaymentDates.ReturnSwapPaymentDatesBuilder getOrCreatePaymentDates();

        @Override
        public ReturnSwapPaymentDates.ReturnSwapPaymentDatesBuilder getPaymentDates();

        public ExchangeTradedContract.ExchangeTradedContractBuilder getOrCreateExchangeTradedContractNearest();

        @Override
        public ExchangeTradedContract.ExchangeTradedContractBuilder getExchangeTradedContractNearest();

        public ReturnLegValuationBuilder setInitialPrice(ReturnLegValuationPrice var1);

        public ReturnLegValuationBuilder setNotionalReset(Boolean var1);

        public ReturnLegValuationBuilder setValuationPriceInterim(ReturnLegValuationPrice var1);

        public ReturnLegValuationBuilder setValuationPriceFinal(ReturnLegValuationPrice var1);

        public ReturnLegValuationBuilder setPaymentDates(ReturnSwapPaymentDates var1);

        public ReturnLegValuationBuilder setExchangeTradedContractNearest(ExchangeTradedContract var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("initialPrice"), processor, ReturnLegValuationPrice.ReturnLegValuationPriceBuilder.class, this.getInitialPrice(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("notionalReset"), Boolean.class, (Object)this.getNotionalReset(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("valuationPriceInterim"), processor, ReturnLegValuationPrice.ReturnLegValuationPriceBuilder.class, this.getValuationPriceInterim(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("valuationPriceFinal"), processor, ReturnLegValuationPrice.ReturnLegValuationPriceBuilder.class, this.getValuationPriceFinal(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("paymentDates"), processor, ReturnSwapPaymentDates.ReturnSwapPaymentDatesBuilder.class, this.getPaymentDates(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("exchangeTradedContractNearest"), processor, ExchangeTradedContract.ExchangeTradedContractBuilder.class, this.getExchangeTradedContractNearest(), new AttributeMeta[0]);
        }

        public ReturnLegValuationBuilder prune();
    }

    public static class ReturnLegValuationImpl
    implements ReturnLegValuation {
        private final ReturnLegValuationPrice initialPrice;
        private final Boolean notionalReset;
        private final ReturnLegValuationPrice valuationPriceInterim;
        private final ReturnLegValuationPrice valuationPriceFinal;
        private final ReturnSwapPaymentDates paymentDates;
        private final ExchangeTradedContract exchangeTradedContractNearest;

        protected ReturnLegValuationImpl(ReturnLegValuationBuilder builder) {
            this.initialPrice = Optional.ofNullable(builder.getInitialPrice()).map(f -> f.build()).orElse(null);
            this.notionalReset = builder.getNotionalReset();
            this.valuationPriceInterim = Optional.ofNullable(builder.getValuationPriceInterim()).map(f -> f.build()).orElse(null);
            this.valuationPriceFinal = Optional.ofNullable(builder.getValuationPriceFinal()).map(f -> f.build()).orElse(null);
            this.paymentDates = Optional.ofNullable(builder.getPaymentDates()).map(f -> f.build()).orElse(null);
            this.exchangeTradedContractNearest = Optional.ofNullable(builder.getExchangeTradedContractNearest()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="initialPrice")
        @RuneAttribute(value="initialPrice")
        public ReturnLegValuationPrice getInitialPrice() {
            return this.initialPrice;
        }

        @Override
        @RosettaAttribute(value="notionalReset")
        @RuneAttribute(value="notionalReset")
        public Boolean getNotionalReset() {
            return this.notionalReset;
        }

        @Override
        @RosettaAttribute(value="valuationPriceInterim")
        @RuneAttribute(value="valuationPriceInterim")
        public ReturnLegValuationPrice getValuationPriceInterim() {
            return this.valuationPriceInterim;
        }

        @Override
        @RosettaAttribute(value="valuationPriceFinal")
        @RuneAttribute(value="valuationPriceFinal")
        public ReturnLegValuationPrice getValuationPriceFinal() {
            return this.valuationPriceFinal;
        }

        @Override
        @RosettaAttribute(value="paymentDates")
        @RuneAttribute(value="paymentDates")
        public ReturnSwapPaymentDates getPaymentDates() {
            return this.paymentDates;
        }

        @Override
        @RosettaAttribute(value="exchangeTradedContractNearest")
        @RuneAttribute(value="exchangeTradedContractNearest")
        public ExchangeTradedContract getExchangeTradedContractNearest() {
            return this.exchangeTradedContractNearest;
        }

        @Override
        public ReturnLegValuation build() {
            return this;
        }

        @Override
        public ReturnLegValuationBuilder toBuilder() {
            ReturnLegValuationBuilder builder = ReturnLegValuation.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ReturnLegValuationBuilder builder) {
            Optional.ofNullable(this.getInitialPrice()).ifPresent(builder::setInitialPrice);
            Optional.ofNullable(this.getNotionalReset()).ifPresent(builder::setNotionalReset);
            Optional.ofNullable(this.getValuationPriceInterim()).ifPresent(builder::setValuationPriceInterim);
            Optional.ofNullable(this.getValuationPriceFinal()).ifPresent(builder::setValuationPriceFinal);
            Optional.ofNullable(this.getPaymentDates()).ifPresent(builder::setPaymentDates);
            Optional.ofNullable(this.getExchangeTradedContractNearest()).ifPresent(builder::setExchangeTradedContractNearest);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ReturnLegValuation _that = this.getType().cast(o);
            if (!Objects.equals(this.initialPrice, _that.getInitialPrice())) {
                return false;
            }
            if (!Objects.equals(this.notionalReset, _that.getNotionalReset())) {
                return false;
            }
            if (!Objects.equals(this.valuationPriceInterim, _that.getValuationPriceInterim())) {
                return false;
            }
            if (!Objects.equals(this.valuationPriceFinal, _that.getValuationPriceFinal())) {
                return false;
            }
            if (!Objects.equals(this.paymentDates, _that.getPaymentDates())) {
                return false;
            }
            return Objects.equals(this.exchangeTradedContractNearest, _that.getExchangeTradedContractNearest());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.initialPrice != null ? this.initialPrice.hashCode() : 0);
            _result = 31 * _result + (this.notionalReset != null ? this.notionalReset.hashCode() : 0);
            _result = 31 * _result + (this.valuationPriceInterim != null ? this.valuationPriceInterim.hashCode() : 0);
            _result = 31 * _result + (this.valuationPriceFinal != null ? this.valuationPriceFinal.hashCode() : 0);
            _result = 31 * _result + (this.paymentDates != null ? this.paymentDates.hashCode() : 0);
            _result = 31 * _result + (this.exchangeTradedContractNearest != null ? this.exchangeTradedContractNearest.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ReturnLegValuation {initialPrice=" + this.initialPrice + ", notionalReset=" + this.notionalReset + ", valuationPriceInterim=" + this.valuationPriceInterim + ", valuationPriceFinal=" + this.valuationPriceFinal + ", paymentDates=" + this.paymentDates + ", exchangeTradedContractNearest=" + this.exchangeTradedContractNearest + '}';
        }
    }
}

