/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.eq.shared;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.asset.AssetReference;
import fpml.consolidated.eq.shared.DividendPeriod;
import fpml.consolidated.eq.shared.meta.DividendPeriodDividendMeta;
import fpml.consolidated.shared.BusinessDayAdjustments;
import fpml.consolidated.shared.IdentifiedDate;
import fpml.consolidated.shared.NonNegativeMoney;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="DividendPeriodDividend", builder=DividendPeriodDividendBuilderImpl.class, version="1.1.0")
@RuneDataType(value="DividendPeriodDividend", model="fpml", builder=DividendPeriodDividendBuilderImpl.class, version="1.1.0")
public interface DividendPeriodDividend
extends DividendPeriod {
    public static final DividendPeriodDividendMeta metaData = new DividendPeriodDividendMeta();

    public NonNegativeMoney getDividend();

    public BigDecimal getMultiplier();

    @Override
    public DividendPeriodDividend build();

    @Override
    public DividendPeriodDividendBuilder toBuilder();

    public static DividendPeriodDividendBuilder builder() {
        return new DividendPeriodDividendBuilderImpl();
    }

    default public RosettaMetaData<? extends DividendPeriodDividend> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends DividendPeriodDividend> getType() {
        return DividendPeriodDividend.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("unadjustedStartDate"), processor, IdentifiedDate.class, this.getUnadjustedStartDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("unadjustedEndDate"), processor, IdentifiedDate.class, this.getUnadjustedEndDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("dateAdjustments"), processor, BusinessDayAdjustments.class, this.getDateAdjustments(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("underlyerReference"), processor, AssetReference.class, this.getUnderlyerReference(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("dividend"), processor, NonNegativeMoney.class, this.getDividend(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("multiplier"), BigDecimal.class, (Object)this.getMultiplier(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class DividendPeriodDividendBuilderImpl
    extends DividendPeriod.DividendPeriodBuilderImpl
    implements DividendPeriodDividendBuilder {
        protected NonNegativeMoney.NonNegativeMoneyBuilder dividend;
        protected BigDecimal multiplier;

        @Override
        @RosettaAttribute(value="dividend")
        @RuneAttribute(value="dividend")
        public NonNegativeMoney.NonNegativeMoneyBuilder getDividend() {
            return this.dividend;
        }

        @Override
        public NonNegativeMoney.NonNegativeMoneyBuilder getOrCreateDividend() {
            NonNegativeMoney.NonNegativeMoneyBuilder result = this.dividend != null ? this.dividend : (this.dividend = NonNegativeMoney.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="multiplier")
        @RuneAttribute(value="multiplier")
        public BigDecimal getMultiplier() {
            return this.multiplier;
        }

        @Override
        @RosettaAttribute(value="unadjustedStartDate")
        @RuneAttribute(value="unadjustedStartDate")
        public DividendPeriodDividendBuilder setUnadjustedStartDate(IdentifiedDate _unadjustedStartDate) {
            this.unadjustedStartDate = _unadjustedStartDate == null ? null : _unadjustedStartDate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="unadjustedEndDate")
        @RuneAttribute(value="unadjustedEndDate")
        public DividendPeriodDividendBuilder setUnadjustedEndDate(IdentifiedDate _unadjustedEndDate) {
            this.unadjustedEndDate = _unadjustedEndDate == null ? null : _unadjustedEndDate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="dateAdjustments")
        @RuneAttribute(value="dateAdjustments")
        public DividendPeriodDividendBuilder setDateAdjustments(BusinessDayAdjustments _dateAdjustments) {
            this.dateAdjustments = _dateAdjustments == null ? null : _dateAdjustments.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="underlyerReference")
        @RuneAttribute(value="underlyerReference")
        public DividendPeriodDividendBuilder setUnderlyerReference(AssetReference _underlyerReference) {
            this.underlyerReference = _underlyerReference == null ? null : _underlyerReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public DividendPeriodDividendBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="dividend")
        @RuneAttribute(value="dividend")
        public DividendPeriodDividendBuilder setDividend(NonNegativeMoney _dividend) {
            this.dividend = _dividend == null ? null : _dividend.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="multiplier")
        @RuneAttribute(value="multiplier")
        public DividendPeriodDividendBuilder setMultiplier(BigDecimal _multiplier) {
            this.multiplier = _multiplier == null ? null : _multiplier;
            return this;
        }

        @Override
        public DividendPeriodDividend build() {
            return new DividendPeriodDividendImpl(this);
        }

        @Override
        public DividendPeriodDividendBuilder toBuilder() {
            return this;
        }

        @Override
        public DividendPeriodDividendBuilder prune() {
            super.prune();
            if (this.dividend != null && !this.dividend.prune().hasData()) {
                this.dividend = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getDividend() != null && this.getDividend().hasData()) {
                return true;
            }
            return this.getMultiplier() != null;
        }

        @Override
        public DividendPeriodDividendBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            DividendPeriodDividendBuilder o = (DividendPeriodDividendBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDividend(), (RosettaModelObjectBuilder)o.getDividend(), this::setDividend);
            merger.mergeBasic((Object)this.getMultiplier(), (Object)o.getMultiplier(), this::setMultiplier, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            DividendPeriodDividend _that = (DividendPeriodDividend)this.getType().cast(o);
            if (!Objects.equals(this.dividend, _that.getDividend())) {
                return false;
            }
            return Objects.equals(this.multiplier, _that.getMultiplier());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.dividend != null ? this.dividend.hashCode() : 0);
            _result = 31 * _result + (this.multiplier != null ? this.multiplier.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "DividendPeriodDividendBuilder {dividend=" + this.dividend + ", multiplier=" + this.multiplier + '}' + " " + super.toString();
        }
    }

    public static interface DividendPeriodDividendBuilder
    extends DividendPeriodDividend,
    DividendPeriod.DividendPeriodBuilder {
        public NonNegativeMoney.NonNegativeMoneyBuilder getOrCreateDividend();

        @Override
        public NonNegativeMoney.NonNegativeMoneyBuilder getDividend();

        @Override
        public DividendPeriodDividendBuilder setUnadjustedStartDate(IdentifiedDate var1);

        @Override
        public DividendPeriodDividendBuilder setUnadjustedEndDate(IdentifiedDate var1);

        @Override
        public DividendPeriodDividendBuilder setDateAdjustments(BusinessDayAdjustments var1);

        @Override
        public DividendPeriodDividendBuilder setUnderlyerReference(AssetReference var1);

        @Override
        public DividendPeriodDividendBuilder setId(String var1);

        public DividendPeriodDividendBuilder setDividend(NonNegativeMoney var1);

        public DividendPeriodDividendBuilder setMultiplier(BigDecimal var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("unadjustedStartDate"), processor, IdentifiedDate.IdentifiedDateBuilder.class, (RosettaModelObjectBuilder)this.getUnadjustedStartDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("unadjustedEndDate"), processor, IdentifiedDate.IdentifiedDateBuilder.class, (RosettaModelObjectBuilder)this.getUnadjustedEndDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("dateAdjustments"), processor, BusinessDayAdjustments.BusinessDayAdjustmentsBuilder.class, (RosettaModelObjectBuilder)this.getDateAdjustments(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("underlyerReference"), processor, AssetReference.AssetReferenceBuilder.class, (RosettaModelObjectBuilder)this.getUnderlyerReference(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("dividend"), processor, NonNegativeMoney.NonNegativeMoneyBuilder.class, this.getDividend(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("multiplier"), BigDecimal.class, (Object)this.getMultiplier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        @Override
        public DividendPeriodDividendBuilder prune();
    }

    public static class DividendPeriodDividendImpl
    extends DividendPeriod.DividendPeriodImpl
    implements DividendPeriodDividend {
        private final NonNegativeMoney dividend;
        private final BigDecimal multiplier;

        protected DividendPeriodDividendImpl(DividendPeriodDividendBuilder builder) {
            super(builder);
            this.dividend = Optional.ofNullable(builder.getDividend()).map(f -> f.build()).orElse(null);
            this.multiplier = builder.getMultiplier();
        }

        @Override
        @RosettaAttribute(value="dividend")
        @RuneAttribute(value="dividend")
        public NonNegativeMoney getDividend() {
            return this.dividend;
        }

        @Override
        @RosettaAttribute(value="multiplier")
        @RuneAttribute(value="multiplier")
        public BigDecimal getMultiplier() {
            return this.multiplier;
        }

        @Override
        public DividendPeriodDividend build() {
            return this;
        }

        @Override
        public DividendPeriodDividendBuilder toBuilder() {
            DividendPeriodDividendBuilder builder = DividendPeriodDividend.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(DividendPeriodDividendBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getDividend()).ifPresent(builder::setDividend);
            Optional.ofNullable(this.getMultiplier()).ifPresent(builder::setMultiplier);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            DividendPeriodDividend _that = (DividendPeriodDividend)this.getType().cast(o);
            if (!Objects.equals(this.dividend, _that.getDividend())) {
                return false;
            }
            return Objects.equals(this.multiplier, _that.getMultiplier());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.dividend != null ? this.dividend.hashCode() : 0);
            _result = 31 * _result + (this.multiplier != null ? this.multiplier.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "DividendPeriodDividend {dividend=" + this.dividend + ", multiplier=" + this.multiplier + '}' + " " + super.toString();
        }
    }
}

