/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.eq.shared;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.eq.shared.CurrencyAndDeterminationMethodModel;
import fpml.consolidated.eq.shared.DeclaredCashAndCashEquivalentDividendPercentageModel;
import fpml.consolidated.eq.shared.DividendConditionsSequence;
import fpml.consolidated.eq.shared.DividendPaymentDate;
import fpml.consolidated.eq.shared.meta.DividendConditionsMeta;
import fpml.consolidated.fpmlenum.DividendAmountTypeEnum;
import fpml.consolidated.fpmlenum.DividendCompositionEnum;
import fpml.consolidated.fpmlenum.DividendEntitlementEnum;
import fpml.consolidated.fpmlenum.DividendPeriodEnum;
import fpml.consolidated.fpmlenum.NonCashDividendTreatmentEnum;
import fpml.consolidated.shared.InterestAccrualsCompoundingMethod;
import fpml.consolidated.shared.PartyReference;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="DividendConditions", builder=DividendConditionsBuilderImpl.class, version="1.1.0")
@RuneDataType(value="DividendConditions", model="fpml", builder=DividendConditionsBuilderImpl.class, version="1.1.0")
public interface DividendConditions
extends RosettaModelObject {
    public static final DividendConditionsMeta metaData = new DividendConditionsMeta();

    public Boolean getDividendReinvestment();

    public DividendEntitlementEnum getDividendEntitlement();

    public DividendAmountTypeEnum getDividendAmount();

    public DividendPaymentDate getDividendPaymentDate();

    public DividendConditionsSequence getDividendConditionsSequence();

    public DividendPeriodEnum getDividendPeriod();

    public PartyReference getExtraOrdinaryDividends();

    public DividendAmountTypeEnum getExcessDividendAmount();

    public CurrencyAndDeterminationMethodModel getCurrencyAndDeterminationMethodModel();

    public DividendPaymentDate getDividendFxTriggerDate();

    public InterestAccrualsCompoundingMethod getInterestAccrualsMethod();

    public BigDecimal getNumberOfIndexUnits();

    public DeclaredCashAndCashEquivalentDividendPercentageModel getDeclaredCashAndCashEquivalentDividendPercentageModel();

    public NonCashDividendTreatmentEnum getNonCashDividendTreatment();

    public DividendCompositionEnum getDividendComposition();

    public Boolean getSpecialDividends();

    public DividendConditions build();

    public DividendConditionsBuilder toBuilder();

    public static DividendConditionsBuilder builder() {
        return new DividendConditionsBuilderImpl();
    }

    default public RosettaMetaData<? extends DividendConditions> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends DividendConditions> getType() {
        return DividendConditions.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("dividendReinvestment"), Boolean.class, (Object)this.getDividendReinvestment(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("dividendEntitlement"), DividendEntitlementEnum.class, (Object)this.getDividendEntitlement(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("dividendAmount"), DividendAmountTypeEnum.class, (Object)this.getDividendAmount(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("dividendPaymentDate"), processor, DividendPaymentDate.class, this.getDividendPaymentDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("dividendConditionsSequence"), processor, DividendConditionsSequence.class, this.getDividendConditionsSequence(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("dividendPeriod"), DividendPeriodEnum.class, (Object)this.getDividendPeriod(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("extraOrdinaryDividends"), processor, PartyReference.class, this.getExtraOrdinaryDividends(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("excessDividendAmount"), DividendAmountTypeEnum.class, (Object)this.getExcessDividendAmount(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("currencyAndDeterminationMethodModel"), processor, CurrencyAndDeterminationMethodModel.class, this.getCurrencyAndDeterminationMethodModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("dividendFxTriggerDate"), processor, DividendPaymentDate.class, this.getDividendFxTriggerDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("interestAccrualsMethod"), processor, InterestAccrualsCompoundingMethod.class, this.getInterestAccrualsMethod(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("numberOfIndexUnits"), BigDecimal.class, (Object)this.getNumberOfIndexUnits(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("declaredCashAndCashEquivalentDividendPercentageModel"), processor, DeclaredCashAndCashEquivalentDividendPercentageModel.class, this.getDeclaredCashAndCashEquivalentDividendPercentageModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("nonCashDividendTreatment"), NonCashDividendTreatmentEnum.class, (Object)this.getNonCashDividendTreatment(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("dividendComposition"), DividendCompositionEnum.class, (Object)this.getDividendComposition(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("specialDividends"), Boolean.class, (Object)this.getSpecialDividends(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class DividendConditionsBuilderImpl
    implements DividendConditionsBuilder {
        protected Boolean dividendReinvestment;
        protected DividendEntitlementEnum dividendEntitlement;
        protected DividendAmountTypeEnum dividendAmount;
        protected DividendPaymentDate.DividendPaymentDateBuilder dividendPaymentDate;
        protected DividendConditionsSequence.DividendConditionsSequenceBuilder dividendConditionsSequence;
        protected DividendPeriodEnum dividendPeriod;
        protected PartyReference.PartyReferenceBuilder extraOrdinaryDividends;
        protected DividendAmountTypeEnum excessDividendAmount;
        protected CurrencyAndDeterminationMethodModel.CurrencyAndDeterminationMethodModelBuilder currencyAndDeterminationMethodModel;
        protected DividendPaymentDate.DividendPaymentDateBuilder dividendFxTriggerDate;
        protected InterestAccrualsCompoundingMethod.InterestAccrualsCompoundingMethodBuilder interestAccrualsMethod;
        protected BigDecimal numberOfIndexUnits;
        protected DeclaredCashAndCashEquivalentDividendPercentageModel.DeclaredCashAndCashEquivalentDividendPercentageModelBuilder declaredCashAndCashEquivalentDividendPercentageModel;
        protected NonCashDividendTreatmentEnum nonCashDividendTreatment;
        protected DividendCompositionEnum dividendComposition;
        protected Boolean specialDividends;

        @Override
        @RosettaAttribute(value="dividendReinvestment")
        @RuneAttribute(value="dividendReinvestment")
        public Boolean getDividendReinvestment() {
            return this.dividendReinvestment;
        }

        @Override
        @RosettaAttribute(value="dividendEntitlement")
        @RuneAttribute(value="dividendEntitlement")
        public DividendEntitlementEnum getDividendEntitlement() {
            return this.dividendEntitlement;
        }

        @Override
        @RosettaAttribute(value="dividendAmount")
        @RuneAttribute(value="dividendAmount")
        public DividendAmountTypeEnum getDividendAmount() {
            return this.dividendAmount;
        }

        @Override
        @RosettaAttribute(value="dividendPaymentDate")
        @RuneAttribute(value="dividendPaymentDate")
        public DividendPaymentDate.DividendPaymentDateBuilder getDividendPaymentDate() {
            return this.dividendPaymentDate;
        }

        @Override
        public DividendPaymentDate.DividendPaymentDateBuilder getOrCreateDividendPaymentDate() {
            DividendPaymentDate.DividendPaymentDateBuilder result = this.dividendPaymentDate != null ? this.dividendPaymentDate : (this.dividendPaymentDate = DividendPaymentDate.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="dividendConditionsSequence")
        @RuneAttribute(value="dividendConditionsSequence")
        public DividendConditionsSequence.DividendConditionsSequenceBuilder getDividendConditionsSequence() {
            return this.dividendConditionsSequence;
        }

        @Override
        public DividendConditionsSequence.DividendConditionsSequenceBuilder getOrCreateDividendConditionsSequence() {
            DividendConditionsSequence.DividendConditionsSequenceBuilder result = this.dividendConditionsSequence != null ? this.dividendConditionsSequence : (this.dividendConditionsSequence = DividendConditionsSequence.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="dividendPeriod")
        @RuneAttribute(value="dividendPeriod")
        public DividendPeriodEnum getDividendPeriod() {
            return this.dividendPeriod;
        }

        @Override
        @RosettaAttribute(value="extraOrdinaryDividends")
        @RuneAttribute(value="extraOrdinaryDividends")
        public PartyReference.PartyReferenceBuilder getExtraOrdinaryDividends() {
            return this.extraOrdinaryDividends;
        }

        @Override
        public PartyReference.PartyReferenceBuilder getOrCreateExtraOrdinaryDividends() {
            PartyReference.PartyReferenceBuilder result = this.extraOrdinaryDividends != null ? this.extraOrdinaryDividends : (this.extraOrdinaryDividends = PartyReference.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="excessDividendAmount")
        @RuneAttribute(value="excessDividendAmount")
        public DividendAmountTypeEnum getExcessDividendAmount() {
            return this.excessDividendAmount;
        }

        @Override
        @RosettaAttribute(value="currencyAndDeterminationMethodModel")
        @RuneAttribute(value="currencyAndDeterminationMethodModel")
        public CurrencyAndDeterminationMethodModel.CurrencyAndDeterminationMethodModelBuilder getCurrencyAndDeterminationMethodModel() {
            return this.currencyAndDeterminationMethodModel;
        }

        @Override
        public CurrencyAndDeterminationMethodModel.CurrencyAndDeterminationMethodModelBuilder getOrCreateCurrencyAndDeterminationMethodModel() {
            CurrencyAndDeterminationMethodModel.CurrencyAndDeterminationMethodModelBuilder result = this.currencyAndDeterminationMethodModel != null ? this.currencyAndDeterminationMethodModel : (this.currencyAndDeterminationMethodModel = CurrencyAndDeterminationMethodModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="dividendFxTriggerDate")
        @RuneAttribute(value="dividendFxTriggerDate")
        public DividendPaymentDate.DividendPaymentDateBuilder getDividendFxTriggerDate() {
            return this.dividendFxTriggerDate;
        }

        @Override
        public DividendPaymentDate.DividendPaymentDateBuilder getOrCreateDividendFxTriggerDate() {
            DividendPaymentDate.DividendPaymentDateBuilder result = this.dividendFxTriggerDate != null ? this.dividendFxTriggerDate : (this.dividendFxTriggerDate = DividendPaymentDate.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="interestAccrualsMethod")
        @RuneAttribute(value="interestAccrualsMethod")
        public InterestAccrualsCompoundingMethod.InterestAccrualsCompoundingMethodBuilder getInterestAccrualsMethod() {
            return this.interestAccrualsMethod;
        }

        @Override
        public InterestAccrualsCompoundingMethod.InterestAccrualsCompoundingMethodBuilder getOrCreateInterestAccrualsMethod() {
            InterestAccrualsCompoundingMethod.InterestAccrualsCompoundingMethodBuilder result = this.interestAccrualsMethod != null ? this.interestAccrualsMethod : (this.interestAccrualsMethod = InterestAccrualsCompoundingMethod.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="numberOfIndexUnits")
        @RuneAttribute(value="numberOfIndexUnits")
        public BigDecimal getNumberOfIndexUnits() {
            return this.numberOfIndexUnits;
        }

        @Override
        @RosettaAttribute(value="declaredCashAndCashEquivalentDividendPercentageModel", isRequired=true)
        @RuneAttribute(value="declaredCashAndCashEquivalentDividendPercentageModel", isRequired=true)
        public DeclaredCashAndCashEquivalentDividendPercentageModel.DeclaredCashAndCashEquivalentDividendPercentageModelBuilder getDeclaredCashAndCashEquivalentDividendPercentageModel() {
            return this.declaredCashAndCashEquivalentDividendPercentageModel;
        }

        @Override
        public DeclaredCashAndCashEquivalentDividendPercentageModel.DeclaredCashAndCashEquivalentDividendPercentageModelBuilder getOrCreateDeclaredCashAndCashEquivalentDividendPercentageModel() {
            DeclaredCashAndCashEquivalentDividendPercentageModel.DeclaredCashAndCashEquivalentDividendPercentageModelBuilder result = this.declaredCashAndCashEquivalentDividendPercentageModel != null ? this.declaredCashAndCashEquivalentDividendPercentageModel : (this.declaredCashAndCashEquivalentDividendPercentageModel = DeclaredCashAndCashEquivalentDividendPercentageModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="nonCashDividendTreatment")
        @RuneAttribute(value="nonCashDividendTreatment")
        public NonCashDividendTreatmentEnum getNonCashDividendTreatment() {
            return this.nonCashDividendTreatment;
        }

        @Override
        @RosettaAttribute(value="dividendComposition")
        @RuneAttribute(value="dividendComposition")
        public DividendCompositionEnum getDividendComposition() {
            return this.dividendComposition;
        }

        @Override
        @RosettaAttribute(value="specialDividends")
        @RuneAttribute(value="specialDividends")
        public Boolean getSpecialDividends() {
            return this.specialDividends;
        }

        @Override
        @RosettaAttribute(value="dividendReinvestment")
        @RuneAttribute(value="dividendReinvestment")
        public DividendConditionsBuilder setDividendReinvestment(Boolean _dividendReinvestment) {
            this.dividendReinvestment = _dividendReinvestment == null ? null : _dividendReinvestment;
            return this;
        }

        @Override
        @RosettaAttribute(value="dividendEntitlement")
        @RuneAttribute(value="dividendEntitlement")
        public DividendConditionsBuilder setDividendEntitlement(DividendEntitlementEnum _dividendEntitlement) {
            this.dividendEntitlement = _dividendEntitlement == null ? null : _dividendEntitlement;
            return this;
        }

        @Override
        @RosettaAttribute(value="dividendAmount")
        @RuneAttribute(value="dividendAmount")
        public DividendConditionsBuilder setDividendAmount(DividendAmountTypeEnum _dividendAmount) {
            this.dividendAmount = _dividendAmount == null ? null : _dividendAmount;
            return this;
        }

        @Override
        @RosettaAttribute(value="dividendPaymentDate")
        @RuneAttribute(value="dividendPaymentDate")
        public DividendConditionsBuilder setDividendPaymentDate(DividendPaymentDate _dividendPaymentDate) {
            this.dividendPaymentDate = _dividendPaymentDate == null ? null : _dividendPaymentDate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="dividendConditionsSequence")
        @RuneAttribute(value="dividendConditionsSequence")
        public DividendConditionsBuilder setDividendConditionsSequence(DividendConditionsSequence _dividendConditionsSequence) {
            this.dividendConditionsSequence = _dividendConditionsSequence == null ? null : _dividendConditionsSequence.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="dividendPeriod")
        @RuneAttribute(value="dividendPeriod")
        public DividendConditionsBuilder setDividendPeriod(DividendPeriodEnum _dividendPeriod) {
            this.dividendPeriod = _dividendPeriod == null ? null : _dividendPeriod;
            return this;
        }

        @Override
        @RosettaAttribute(value="extraOrdinaryDividends")
        @RuneAttribute(value="extraOrdinaryDividends")
        public DividendConditionsBuilder setExtraOrdinaryDividends(PartyReference _extraOrdinaryDividends) {
            this.extraOrdinaryDividends = _extraOrdinaryDividends == null ? null : _extraOrdinaryDividends.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="excessDividendAmount")
        @RuneAttribute(value="excessDividendAmount")
        public DividendConditionsBuilder setExcessDividendAmount(DividendAmountTypeEnum _excessDividendAmount) {
            this.excessDividendAmount = _excessDividendAmount == null ? null : _excessDividendAmount;
            return this;
        }

        @Override
        @RosettaAttribute(value="currencyAndDeterminationMethodModel")
        @RuneAttribute(value="currencyAndDeterminationMethodModel")
        public DividendConditionsBuilder setCurrencyAndDeterminationMethodModel(CurrencyAndDeterminationMethodModel _currencyAndDeterminationMethodModel) {
            this.currencyAndDeterminationMethodModel = _currencyAndDeterminationMethodModel == null ? null : _currencyAndDeterminationMethodModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="dividendFxTriggerDate")
        @RuneAttribute(value="dividendFxTriggerDate")
        public DividendConditionsBuilder setDividendFxTriggerDate(DividendPaymentDate _dividendFxTriggerDate) {
            this.dividendFxTriggerDate = _dividendFxTriggerDate == null ? null : _dividendFxTriggerDate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="interestAccrualsMethod")
        @RuneAttribute(value="interestAccrualsMethod")
        public DividendConditionsBuilder setInterestAccrualsMethod(InterestAccrualsCompoundingMethod _interestAccrualsMethod) {
            this.interestAccrualsMethod = _interestAccrualsMethod == null ? null : _interestAccrualsMethod.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="numberOfIndexUnits")
        @RuneAttribute(value="numberOfIndexUnits")
        public DividendConditionsBuilder setNumberOfIndexUnits(BigDecimal _numberOfIndexUnits) {
            this.numberOfIndexUnits = _numberOfIndexUnits == null ? null : _numberOfIndexUnits;
            return this;
        }

        @Override
        @RosettaAttribute(value="declaredCashAndCashEquivalentDividendPercentageModel", isRequired=true)
        @RuneAttribute(value="declaredCashAndCashEquivalentDividendPercentageModel", isRequired=true)
        public DividendConditionsBuilder setDeclaredCashAndCashEquivalentDividendPercentageModel(DeclaredCashAndCashEquivalentDividendPercentageModel _declaredCashAndCashEquivalentDividendPercentageModel) {
            this.declaredCashAndCashEquivalentDividendPercentageModel = _declaredCashAndCashEquivalentDividendPercentageModel == null ? null : _declaredCashAndCashEquivalentDividendPercentageModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="nonCashDividendTreatment")
        @RuneAttribute(value="nonCashDividendTreatment")
        public DividendConditionsBuilder setNonCashDividendTreatment(NonCashDividendTreatmentEnum _nonCashDividendTreatment) {
            this.nonCashDividendTreatment = _nonCashDividendTreatment == null ? null : _nonCashDividendTreatment;
            return this;
        }

        @Override
        @RosettaAttribute(value="dividendComposition")
        @RuneAttribute(value="dividendComposition")
        public DividendConditionsBuilder setDividendComposition(DividendCompositionEnum _dividendComposition) {
            this.dividendComposition = _dividendComposition == null ? null : _dividendComposition;
            return this;
        }

        @Override
        @RosettaAttribute(value="specialDividends")
        @RuneAttribute(value="specialDividends")
        public DividendConditionsBuilder setSpecialDividends(Boolean _specialDividends) {
            this.specialDividends = _specialDividends == null ? null : _specialDividends;
            return this;
        }

        @Override
        public DividendConditions build() {
            return new DividendConditionsImpl(this);
        }

        @Override
        public DividendConditionsBuilder toBuilder() {
            return this;
        }

        @Override
        public DividendConditionsBuilder prune() {
            if (this.dividendPaymentDate != null && !this.dividendPaymentDate.prune().hasData()) {
                this.dividendPaymentDate = null;
            }
            if (this.dividendConditionsSequence != null && !this.dividendConditionsSequence.prune().hasData()) {
                this.dividendConditionsSequence = null;
            }
            if (this.extraOrdinaryDividends != null && !this.extraOrdinaryDividends.prune().hasData()) {
                this.extraOrdinaryDividends = null;
            }
            if (this.currencyAndDeterminationMethodModel != null && !this.currencyAndDeterminationMethodModel.prune().hasData()) {
                this.currencyAndDeterminationMethodModel = null;
            }
            if (this.dividendFxTriggerDate != null && !this.dividendFxTriggerDate.prune().hasData()) {
                this.dividendFxTriggerDate = null;
            }
            if (this.interestAccrualsMethod != null && !this.interestAccrualsMethod.prune().hasData()) {
                this.interestAccrualsMethod = null;
            }
            if (this.declaredCashAndCashEquivalentDividendPercentageModel != null && !this.declaredCashAndCashEquivalentDividendPercentageModel.prune().hasData()) {
                this.declaredCashAndCashEquivalentDividendPercentageModel = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getDividendReinvestment() != null) {
                return true;
            }
            if (this.getDividendEntitlement() != null) {
                return true;
            }
            if (this.getDividendAmount() != null) {
                return true;
            }
            if (this.getDividendPaymentDate() != null && this.getDividendPaymentDate().hasData()) {
                return true;
            }
            if (this.getDividendConditionsSequence() != null && this.getDividendConditionsSequence().hasData()) {
                return true;
            }
            if (this.getDividendPeriod() != null) {
                return true;
            }
            if (this.getExtraOrdinaryDividends() != null && this.getExtraOrdinaryDividends().hasData()) {
                return true;
            }
            if (this.getExcessDividendAmount() != null) {
                return true;
            }
            if (this.getCurrencyAndDeterminationMethodModel() != null && this.getCurrencyAndDeterminationMethodModel().hasData()) {
                return true;
            }
            if (this.getDividendFxTriggerDate() != null && this.getDividendFxTriggerDate().hasData()) {
                return true;
            }
            if (this.getInterestAccrualsMethod() != null && this.getInterestAccrualsMethod().hasData()) {
                return true;
            }
            if (this.getNumberOfIndexUnits() != null) {
                return true;
            }
            if (this.getDeclaredCashAndCashEquivalentDividendPercentageModel() != null && this.getDeclaredCashAndCashEquivalentDividendPercentageModel().hasData()) {
                return true;
            }
            if (this.getNonCashDividendTreatment() != null) {
                return true;
            }
            if (this.getDividendComposition() != null) {
                return true;
            }
            return this.getSpecialDividends() != null;
        }

        public DividendConditionsBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            DividendConditionsBuilder o = (DividendConditionsBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDividendPaymentDate(), (RosettaModelObjectBuilder)o.getDividendPaymentDate(), this::setDividendPaymentDate);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDividendConditionsSequence(), (RosettaModelObjectBuilder)o.getDividendConditionsSequence(), this::setDividendConditionsSequence);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getExtraOrdinaryDividends(), (RosettaModelObjectBuilder)o.getExtraOrdinaryDividends(), this::setExtraOrdinaryDividends);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCurrencyAndDeterminationMethodModel(), (RosettaModelObjectBuilder)o.getCurrencyAndDeterminationMethodModel(), this::setCurrencyAndDeterminationMethodModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDividendFxTriggerDate(), (RosettaModelObjectBuilder)o.getDividendFxTriggerDate(), this::setDividendFxTriggerDate);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getInterestAccrualsMethod(), (RosettaModelObjectBuilder)o.getInterestAccrualsMethod(), this::setInterestAccrualsMethod);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDeclaredCashAndCashEquivalentDividendPercentageModel(), (RosettaModelObjectBuilder)o.getDeclaredCashAndCashEquivalentDividendPercentageModel(), this::setDeclaredCashAndCashEquivalentDividendPercentageModel);
            merger.mergeBasic((Object)this.getDividendReinvestment(), (Object)o.getDividendReinvestment(), this::setDividendReinvestment, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getDividendEntitlement(), (Object)o.getDividendEntitlement(), this::setDividendEntitlement, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getDividendAmount(), (Object)o.getDividendAmount(), this::setDividendAmount, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getDividendPeriod(), (Object)o.getDividendPeriod(), this::setDividendPeriod, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getExcessDividendAmount(), (Object)o.getExcessDividendAmount(), this::setExcessDividendAmount, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getNumberOfIndexUnits(), (Object)o.getNumberOfIndexUnits(), this::setNumberOfIndexUnits, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getNonCashDividendTreatment(), (Object)o.getNonCashDividendTreatment(), this::setNonCashDividendTreatment, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getDividendComposition(), (Object)o.getDividendComposition(), this::setDividendComposition, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSpecialDividends(), (Object)o.getSpecialDividends(), this::setSpecialDividends, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            DividendConditions _that = this.getType().cast(o);
            if (!Objects.equals(this.dividendReinvestment, _that.getDividendReinvestment())) {
                return false;
            }
            if (!Objects.equals((Object)this.dividendEntitlement, (Object)_that.getDividendEntitlement())) {
                return false;
            }
            if (!Objects.equals((Object)this.dividendAmount, (Object)_that.getDividendAmount())) {
                return false;
            }
            if (!Objects.equals(this.dividendPaymentDate, _that.getDividendPaymentDate())) {
                return false;
            }
            if (!Objects.equals(this.dividendConditionsSequence, _that.getDividendConditionsSequence())) {
                return false;
            }
            if (!Objects.equals((Object)this.dividendPeriod, (Object)_that.getDividendPeriod())) {
                return false;
            }
            if (!Objects.equals(this.extraOrdinaryDividends, _that.getExtraOrdinaryDividends())) {
                return false;
            }
            if (!Objects.equals((Object)this.excessDividendAmount, (Object)_that.getExcessDividendAmount())) {
                return false;
            }
            if (!Objects.equals(this.currencyAndDeterminationMethodModel, _that.getCurrencyAndDeterminationMethodModel())) {
                return false;
            }
            if (!Objects.equals(this.dividendFxTriggerDate, _that.getDividendFxTriggerDate())) {
                return false;
            }
            if (!Objects.equals(this.interestAccrualsMethod, _that.getInterestAccrualsMethod())) {
                return false;
            }
            if (!Objects.equals(this.numberOfIndexUnits, _that.getNumberOfIndexUnits())) {
                return false;
            }
            if (!Objects.equals(this.declaredCashAndCashEquivalentDividendPercentageModel, _that.getDeclaredCashAndCashEquivalentDividendPercentageModel())) {
                return false;
            }
            if (!Objects.equals((Object)this.nonCashDividendTreatment, (Object)_that.getNonCashDividendTreatment())) {
                return false;
            }
            if (!Objects.equals((Object)this.dividendComposition, (Object)_that.getDividendComposition())) {
                return false;
            }
            return Objects.equals(this.specialDividends, _that.getSpecialDividends());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.dividendReinvestment != null ? this.dividendReinvestment.hashCode() : 0);
            _result = 31 * _result + (this.dividendEntitlement != null ? ((Object)((Object)this.dividendEntitlement)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.dividendAmount != null ? ((Object)((Object)this.dividendAmount)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.dividendPaymentDate != null ? this.dividendPaymentDate.hashCode() : 0);
            _result = 31 * _result + (this.dividendConditionsSequence != null ? this.dividendConditionsSequence.hashCode() : 0);
            _result = 31 * _result + (this.dividendPeriod != null ? ((Object)((Object)this.dividendPeriod)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.extraOrdinaryDividends != null ? this.extraOrdinaryDividends.hashCode() : 0);
            _result = 31 * _result + (this.excessDividendAmount != null ? ((Object)((Object)this.excessDividendAmount)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.currencyAndDeterminationMethodModel != null ? this.currencyAndDeterminationMethodModel.hashCode() : 0);
            _result = 31 * _result + (this.dividendFxTriggerDate != null ? this.dividendFxTriggerDate.hashCode() : 0);
            _result = 31 * _result + (this.interestAccrualsMethod != null ? this.interestAccrualsMethod.hashCode() : 0);
            _result = 31 * _result + (this.numberOfIndexUnits != null ? this.numberOfIndexUnits.hashCode() : 0);
            _result = 31 * _result + (this.declaredCashAndCashEquivalentDividendPercentageModel != null ? this.declaredCashAndCashEquivalentDividendPercentageModel.hashCode() : 0);
            _result = 31 * _result + (this.nonCashDividendTreatment != null ? ((Object)((Object)this.nonCashDividendTreatment)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.dividendComposition != null ? ((Object)((Object)this.dividendComposition)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.specialDividends != null ? this.specialDividends.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "DividendConditionsBuilder {dividendReinvestment=" + this.dividendReinvestment + ", dividendEntitlement=" + (Object)((Object)this.dividendEntitlement) + ", dividendAmount=" + (Object)((Object)this.dividendAmount) + ", dividendPaymentDate=" + this.dividendPaymentDate + ", dividendConditionsSequence=" + this.dividendConditionsSequence + ", dividendPeriod=" + (Object)((Object)this.dividendPeriod) + ", extraOrdinaryDividends=" + this.extraOrdinaryDividends + ", excessDividendAmount=" + (Object)((Object)this.excessDividendAmount) + ", currencyAndDeterminationMethodModel=" + this.currencyAndDeterminationMethodModel + ", dividendFxTriggerDate=" + this.dividendFxTriggerDate + ", interestAccrualsMethod=" + this.interestAccrualsMethod + ", numberOfIndexUnits=" + this.numberOfIndexUnits + ", declaredCashAndCashEquivalentDividendPercentageModel=" + this.declaredCashAndCashEquivalentDividendPercentageModel + ", nonCashDividendTreatment=" + (Object)((Object)this.nonCashDividendTreatment) + ", dividendComposition=" + (Object)((Object)this.dividendComposition) + ", specialDividends=" + this.specialDividends + '}';
        }
    }

    public static interface DividendConditionsBuilder
    extends DividendConditions,
    RosettaModelObjectBuilder {
        public DividendPaymentDate.DividendPaymentDateBuilder getOrCreateDividendPaymentDate();

        @Override
        public DividendPaymentDate.DividendPaymentDateBuilder getDividendPaymentDate();

        public DividendConditionsSequence.DividendConditionsSequenceBuilder getOrCreateDividendConditionsSequence();

        @Override
        public DividendConditionsSequence.DividendConditionsSequenceBuilder getDividendConditionsSequence();

        public PartyReference.PartyReferenceBuilder getOrCreateExtraOrdinaryDividends();

        @Override
        public PartyReference.PartyReferenceBuilder getExtraOrdinaryDividends();

        public CurrencyAndDeterminationMethodModel.CurrencyAndDeterminationMethodModelBuilder getOrCreateCurrencyAndDeterminationMethodModel();

        @Override
        public CurrencyAndDeterminationMethodModel.CurrencyAndDeterminationMethodModelBuilder getCurrencyAndDeterminationMethodModel();

        public DividendPaymentDate.DividendPaymentDateBuilder getOrCreateDividendFxTriggerDate();

        @Override
        public DividendPaymentDate.DividendPaymentDateBuilder getDividendFxTriggerDate();

        public InterestAccrualsCompoundingMethod.InterestAccrualsCompoundingMethodBuilder getOrCreateInterestAccrualsMethod();

        @Override
        public InterestAccrualsCompoundingMethod.InterestAccrualsCompoundingMethodBuilder getInterestAccrualsMethod();

        public DeclaredCashAndCashEquivalentDividendPercentageModel.DeclaredCashAndCashEquivalentDividendPercentageModelBuilder getOrCreateDeclaredCashAndCashEquivalentDividendPercentageModel();

        @Override
        public DeclaredCashAndCashEquivalentDividendPercentageModel.DeclaredCashAndCashEquivalentDividendPercentageModelBuilder getDeclaredCashAndCashEquivalentDividendPercentageModel();

        public DividendConditionsBuilder setDividendReinvestment(Boolean var1);

        public DividendConditionsBuilder setDividendEntitlement(DividendEntitlementEnum var1);

        public DividendConditionsBuilder setDividendAmount(DividendAmountTypeEnum var1);

        public DividendConditionsBuilder setDividendPaymentDate(DividendPaymentDate var1);

        public DividendConditionsBuilder setDividendConditionsSequence(DividendConditionsSequence var1);

        public DividendConditionsBuilder setDividendPeriod(DividendPeriodEnum var1);

        public DividendConditionsBuilder setExtraOrdinaryDividends(PartyReference var1);

        public DividendConditionsBuilder setExcessDividendAmount(DividendAmountTypeEnum var1);

        public DividendConditionsBuilder setCurrencyAndDeterminationMethodModel(CurrencyAndDeterminationMethodModel var1);

        public DividendConditionsBuilder setDividendFxTriggerDate(DividendPaymentDate var1);

        public DividendConditionsBuilder setInterestAccrualsMethod(InterestAccrualsCompoundingMethod var1);

        public DividendConditionsBuilder setNumberOfIndexUnits(BigDecimal var1);

        public DividendConditionsBuilder setDeclaredCashAndCashEquivalentDividendPercentageModel(DeclaredCashAndCashEquivalentDividendPercentageModel var1);

        public DividendConditionsBuilder setNonCashDividendTreatment(NonCashDividendTreatmentEnum var1);

        public DividendConditionsBuilder setDividendComposition(DividendCompositionEnum var1);

        public DividendConditionsBuilder setSpecialDividends(Boolean var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("dividendReinvestment"), Boolean.class, (Object)this.getDividendReinvestment(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("dividendEntitlement"), DividendEntitlementEnum.class, (Object)this.getDividendEntitlement(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("dividendAmount"), DividendAmountTypeEnum.class, (Object)this.getDividendAmount(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("dividendPaymentDate"), processor, DividendPaymentDate.DividendPaymentDateBuilder.class, this.getDividendPaymentDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("dividendConditionsSequence"), processor, DividendConditionsSequence.DividendConditionsSequenceBuilder.class, this.getDividendConditionsSequence(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("dividendPeriod"), DividendPeriodEnum.class, (Object)this.getDividendPeriod(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("extraOrdinaryDividends"), processor, PartyReference.PartyReferenceBuilder.class, this.getExtraOrdinaryDividends(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("excessDividendAmount"), DividendAmountTypeEnum.class, (Object)this.getExcessDividendAmount(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("currencyAndDeterminationMethodModel"), processor, CurrencyAndDeterminationMethodModel.CurrencyAndDeterminationMethodModelBuilder.class, this.getCurrencyAndDeterminationMethodModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("dividendFxTriggerDate"), processor, DividendPaymentDate.DividendPaymentDateBuilder.class, this.getDividendFxTriggerDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("interestAccrualsMethod"), processor, InterestAccrualsCompoundingMethod.InterestAccrualsCompoundingMethodBuilder.class, this.getInterestAccrualsMethod(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("numberOfIndexUnits"), BigDecimal.class, (Object)this.getNumberOfIndexUnits(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("declaredCashAndCashEquivalentDividendPercentageModel"), processor, DeclaredCashAndCashEquivalentDividendPercentageModel.DeclaredCashAndCashEquivalentDividendPercentageModelBuilder.class, this.getDeclaredCashAndCashEquivalentDividendPercentageModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("nonCashDividendTreatment"), NonCashDividendTreatmentEnum.class, (Object)this.getNonCashDividendTreatment(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("dividendComposition"), DividendCompositionEnum.class, (Object)this.getDividendComposition(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("specialDividends"), Boolean.class, (Object)this.getSpecialDividends(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public DividendConditionsBuilder prune();
    }

    public static class DividendConditionsImpl
    implements DividendConditions {
        private final Boolean dividendReinvestment;
        private final DividendEntitlementEnum dividendEntitlement;
        private final DividendAmountTypeEnum dividendAmount;
        private final DividendPaymentDate dividendPaymentDate;
        private final DividendConditionsSequence dividendConditionsSequence;
        private final DividendPeriodEnum dividendPeriod;
        private final PartyReference extraOrdinaryDividends;
        private final DividendAmountTypeEnum excessDividendAmount;
        private final CurrencyAndDeterminationMethodModel currencyAndDeterminationMethodModel;
        private final DividendPaymentDate dividendFxTriggerDate;
        private final InterestAccrualsCompoundingMethod interestAccrualsMethod;
        private final BigDecimal numberOfIndexUnits;
        private final DeclaredCashAndCashEquivalentDividendPercentageModel declaredCashAndCashEquivalentDividendPercentageModel;
        private final NonCashDividendTreatmentEnum nonCashDividendTreatment;
        private final DividendCompositionEnum dividendComposition;
        private final Boolean specialDividends;

        protected DividendConditionsImpl(DividendConditionsBuilder builder) {
            this.dividendReinvestment = builder.getDividendReinvestment();
            this.dividendEntitlement = builder.getDividendEntitlement();
            this.dividendAmount = builder.getDividendAmount();
            this.dividendPaymentDate = Optional.ofNullable(builder.getDividendPaymentDate()).map(f -> f.build()).orElse(null);
            this.dividendConditionsSequence = Optional.ofNullable(builder.getDividendConditionsSequence()).map(f -> f.build()).orElse(null);
            this.dividendPeriod = builder.getDividendPeriod();
            this.extraOrdinaryDividends = Optional.ofNullable(builder.getExtraOrdinaryDividends()).map(f -> f.build()).orElse(null);
            this.excessDividendAmount = builder.getExcessDividendAmount();
            this.currencyAndDeterminationMethodModel = Optional.ofNullable(builder.getCurrencyAndDeterminationMethodModel()).map(f -> f.build()).orElse(null);
            this.dividendFxTriggerDate = Optional.ofNullable(builder.getDividendFxTriggerDate()).map(f -> f.build()).orElse(null);
            this.interestAccrualsMethod = Optional.ofNullable(builder.getInterestAccrualsMethod()).map(f -> f.build()).orElse(null);
            this.numberOfIndexUnits = builder.getNumberOfIndexUnits();
            this.declaredCashAndCashEquivalentDividendPercentageModel = Optional.ofNullable(builder.getDeclaredCashAndCashEquivalentDividendPercentageModel()).map(f -> f.build()).orElse(null);
            this.nonCashDividendTreatment = builder.getNonCashDividendTreatment();
            this.dividendComposition = builder.getDividendComposition();
            this.specialDividends = builder.getSpecialDividends();
        }

        @Override
        @RosettaAttribute(value="dividendReinvestment")
        @RuneAttribute(value="dividendReinvestment")
        public Boolean getDividendReinvestment() {
            return this.dividendReinvestment;
        }

        @Override
        @RosettaAttribute(value="dividendEntitlement")
        @RuneAttribute(value="dividendEntitlement")
        public DividendEntitlementEnum getDividendEntitlement() {
            return this.dividendEntitlement;
        }

        @Override
        @RosettaAttribute(value="dividendAmount")
        @RuneAttribute(value="dividendAmount")
        public DividendAmountTypeEnum getDividendAmount() {
            return this.dividendAmount;
        }

        @Override
        @RosettaAttribute(value="dividendPaymentDate")
        @RuneAttribute(value="dividendPaymentDate")
        public DividendPaymentDate getDividendPaymentDate() {
            return this.dividendPaymentDate;
        }

        @Override
        @RosettaAttribute(value="dividendConditionsSequence")
        @RuneAttribute(value="dividendConditionsSequence")
        public DividendConditionsSequence getDividendConditionsSequence() {
            return this.dividendConditionsSequence;
        }

        @Override
        @RosettaAttribute(value="dividendPeriod")
        @RuneAttribute(value="dividendPeriod")
        public DividendPeriodEnum getDividendPeriod() {
            return this.dividendPeriod;
        }

        @Override
        @RosettaAttribute(value="extraOrdinaryDividends")
        @RuneAttribute(value="extraOrdinaryDividends")
        public PartyReference getExtraOrdinaryDividends() {
            return this.extraOrdinaryDividends;
        }

        @Override
        @RosettaAttribute(value="excessDividendAmount")
        @RuneAttribute(value="excessDividendAmount")
        public DividendAmountTypeEnum getExcessDividendAmount() {
            return this.excessDividendAmount;
        }

        @Override
        @RosettaAttribute(value="currencyAndDeterminationMethodModel")
        @RuneAttribute(value="currencyAndDeterminationMethodModel")
        public CurrencyAndDeterminationMethodModel getCurrencyAndDeterminationMethodModel() {
            return this.currencyAndDeterminationMethodModel;
        }

        @Override
        @RosettaAttribute(value="dividendFxTriggerDate")
        @RuneAttribute(value="dividendFxTriggerDate")
        public DividendPaymentDate getDividendFxTriggerDate() {
            return this.dividendFxTriggerDate;
        }

        @Override
        @RosettaAttribute(value="interestAccrualsMethod")
        @RuneAttribute(value="interestAccrualsMethod")
        public InterestAccrualsCompoundingMethod getInterestAccrualsMethod() {
            return this.interestAccrualsMethod;
        }

        @Override
        @RosettaAttribute(value="numberOfIndexUnits")
        @RuneAttribute(value="numberOfIndexUnits")
        public BigDecimal getNumberOfIndexUnits() {
            return this.numberOfIndexUnits;
        }

        @Override
        @RosettaAttribute(value="declaredCashAndCashEquivalentDividendPercentageModel", isRequired=true)
        @RuneAttribute(value="declaredCashAndCashEquivalentDividendPercentageModel", isRequired=true)
        public DeclaredCashAndCashEquivalentDividendPercentageModel getDeclaredCashAndCashEquivalentDividendPercentageModel() {
            return this.declaredCashAndCashEquivalentDividendPercentageModel;
        }

        @Override
        @RosettaAttribute(value="nonCashDividendTreatment")
        @RuneAttribute(value="nonCashDividendTreatment")
        public NonCashDividendTreatmentEnum getNonCashDividendTreatment() {
            return this.nonCashDividendTreatment;
        }

        @Override
        @RosettaAttribute(value="dividendComposition")
        @RuneAttribute(value="dividendComposition")
        public DividendCompositionEnum getDividendComposition() {
            return this.dividendComposition;
        }

        @Override
        @RosettaAttribute(value="specialDividends")
        @RuneAttribute(value="specialDividends")
        public Boolean getSpecialDividends() {
            return this.specialDividends;
        }

        @Override
        public DividendConditions build() {
            return this;
        }

        @Override
        public DividendConditionsBuilder toBuilder() {
            DividendConditionsBuilder builder = DividendConditions.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(DividendConditionsBuilder builder) {
            Optional.ofNullable(this.getDividendReinvestment()).ifPresent(builder::setDividendReinvestment);
            Optional.ofNullable(this.getDividendEntitlement()).ifPresent(builder::setDividendEntitlement);
            Optional.ofNullable(this.getDividendAmount()).ifPresent(builder::setDividendAmount);
            Optional.ofNullable(this.getDividendPaymentDate()).ifPresent(builder::setDividendPaymentDate);
            Optional.ofNullable(this.getDividendConditionsSequence()).ifPresent(builder::setDividendConditionsSequence);
            Optional.ofNullable(this.getDividendPeriod()).ifPresent(builder::setDividendPeriod);
            Optional.ofNullable(this.getExtraOrdinaryDividends()).ifPresent(builder::setExtraOrdinaryDividends);
            Optional.ofNullable(this.getExcessDividendAmount()).ifPresent(builder::setExcessDividendAmount);
            Optional.ofNullable(this.getCurrencyAndDeterminationMethodModel()).ifPresent(builder::setCurrencyAndDeterminationMethodModel);
            Optional.ofNullable(this.getDividendFxTriggerDate()).ifPresent(builder::setDividendFxTriggerDate);
            Optional.ofNullable(this.getInterestAccrualsMethod()).ifPresent(builder::setInterestAccrualsMethod);
            Optional.ofNullable(this.getNumberOfIndexUnits()).ifPresent(builder::setNumberOfIndexUnits);
            Optional.ofNullable(this.getDeclaredCashAndCashEquivalentDividendPercentageModel()).ifPresent(builder::setDeclaredCashAndCashEquivalentDividendPercentageModel);
            Optional.ofNullable(this.getNonCashDividendTreatment()).ifPresent(builder::setNonCashDividendTreatment);
            Optional.ofNullable(this.getDividendComposition()).ifPresent(builder::setDividendComposition);
            Optional.ofNullable(this.getSpecialDividends()).ifPresent(builder::setSpecialDividends);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            DividendConditions _that = this.getType().cast(o);
            if (!Objects.equals(this.dividendReinvestment, _that.getDividendReinvestment())) {
                return false;
            }
            if (!Objects.equals((Object)this.dividendEntitlement, (Object)_that.getDividendEntitlement())) {
                return false;
            }
            if (!Objects.equals((Object)this.dividendAmount, (Object)_that.getDividendAmount())) {
                return false;
            }
            if (!Objects.equals(this.dividendPaymentDate, _that.getDividendPaymentDate())) {
                return false;
            }
            if (!Objects.equals(this.dividendConditionsSequence, _that.getDividendConditionsSequence())) {
                return false;
            }
            if (!Objects.equals((Object)this.dividendPeriod, (Object)_that.getDividendPeriod())) {
                return false;
            }
            if (!Objects.equals(this.extraOrdinaryDividends, _that.getExtraOrdinaryDividends())) {
                return false;
            }
            if (!Objects.equals((Object)this.excessDividendAmount, (Object)_that.getExcessDividendAmount())) {
                return false;
            }
            if (!Objects.equals(this.currencyAndDeterminationMethodModel, _that.getCurrencyAndDeterminationMethodModel())) {
                return false;
            }
            if (!Objects.equals(this.dividendFxTriggerDate, _that.getDividendFxTriggerDate())) {
                return false;
            }
            if (!Objects.equals(this.interestAccrualsMethod, _that.getInterestAccrualsMethod())) {
                return false;
            }
            if (!Objects.equals(this.numberOfIndexUnits, _that.getNumberOfIndexUnits())) {
                return false;
            }
            if (!Objects.equals(this.declaredCashAndCashEquivalentDividendPercentageModel, _that.getDeclaredCashAndCashEquivalentDividendPercentageModel())) {
                return false;
            }
            if (!Objects.equals((Object)this.nonCashDividendTreatment, (Object)_that.getNonCashDividendTreatment())) {
                return false;
            }
            if (!Objects.equals((Object)this.dividendComposition, (Object)_that.getDividendComposition())) {
                return false;
            }
            return Objects.equals(this.specialDividends, _that.getSpecialDividends());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.dividendReinvestment != null ? this.dividendReinvestment.hashCode() : 0);
            _result = 31 * _result + (this.dividendEntitlement != null ? ((Object)((Object)this.dividendEntitlement)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.dividendAmount != null ? ((Object)((Object)this.dividendAmount)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.dividendPaymentDate != null ? this.dividendPaymentDate.hashCode() : 0);
            _result = 31 * _result + (this.dividendConditionsSequence != null ? this.dividendConditionsSequence.hashCode() : 0);
            _result = 31 * _result + (this.dividendPeriod != null ? ((Object)((Object)this.dividendPeriod)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.extraOrdinaryDividends != null ? this.extraOrdinaryDividends.hashCode() : 0);
            _result = 31 * _result + (this.excessDividendAmount != null ? ((Object)((Object)this.excessDividendAmount)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.currencyAndDeterminationMethodModel != null ? this.currencyAndDeterminationMethodModel.hashCode() : 0);
            _result = 31 * _result + (this.dividendFxTriggerDate != null ? this.dividendFxTriggerDate.hashCode() : 0);
            _result = 31 * _result + (this.interestAccrualsMethod != null ? this.interestAccrualsMethod.hashCode() : 0);
            _result = 31 * _result + (this.numberOfIndexUnits != null ? this.numberOfIndexUnits.hashCode() : 0);
            _result = 31 * _result + (this.declaredCashAndCashEquivalentDividendPercentageModel != null ? this.declaredCashAndCashEquivalentDividendPercentageModel.hashCode() : 0);
            _result = 31 * _result + (this.nonCashDividendTreatment != null ? ((Object)((Object)this.nonCashDividendTreatment)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.dividendComposition != null ? ((Object)((Object)this.dividendComposition)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.specialDividends != null ? this.specialDividends.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "DividendConditions {dividendReinvestment=" + this.dividendReinvestment + ", dividendEntitlement=" + (Object)((Object)this.dividendEntitlement) + ", dividendAmount=" + (Object)((Object)this.dividendAmount) + ", dividendPaymentDate=" + this.dividendPaymentDate + ", dividendConditionsSequence=" + this.dividendConditionsSequence + ", dividendPeriod=" + (Object)((Object)this.dividendPeriod) + ", extraOrdinaryDividends=" + this.extraOrdinaryDividends + ", excessDividendAmount=" + (Object)((Object)this.excessDividendAmount) + ", currencyAndDeterminationMethodModel=" + this.currencyAndDeterminationMethodModel + ", dividendFxTriggerDate=" + this.dividendFxTriggerDate + ", interestAccrualsMethod=" + this.interestAccrualsMethod + ", numberOfIndexUnits=" + this.numberOfIndexUnits + ", declaredCashAndCashEquivalentDividendPercentageModel=" + this.declaredCashAndCashEquivalentDividendPercentageModel + ", nonCashDividendTreatment=" + (Object)((Object)this.nonCashDividendTreatment) + ", dividendComposition=" + (Object)((Object)this.dividendComposition) + ", specialDividends=" + this.specialDividends + '}';
        }
    }
}

