/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.doc;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.doc.PackageSummary;
import fpml.consolidated.doc.PartyTradeInformation;
import fpml.consolidated.doc.ProductSummary;
import fpml.consolidated.doc.TradeIdentifiersModel;
import fpml.consolidated.doc.TradeSummary;
import fpml.consolidated.doc.meta.TradeHeaderMeta;
import fpml.consolidated.shared.IdentifiedDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="TradeHeader", builder=TradeHeaderBuilderImpl.class, version="1.1.0")
@RuneDataType(value="TradeHeader", model="fpml", builder=TradeHeaderBuilderImpl.class, version="1.1.0")
public interface TradeHeader
extends RosettaModelObject {
    public static final TradeHeaderMeta metaData = new TradeHeaderMeta();

    public TradeIdentifiersModel getTradeIdentifiersModel();

    public List<? extends PartyTradeInformation> getPartyTradeInformation();

    public TradeSummary getTradeSummary();

    public ProductSummary getProductSummary();

    public PackageSummary getOriginatingPackage();

    public IdentifiedDate getTradeDate();

    public IdentifiedDate getClearedDate();

    public TradeHeader build();

    public TradeHeaderBuilder toBuilder();

    public static TradeHeaderBuilder builder() {
        return new TradeHeaderBuilderImpl();
    }

    default public RosettaMetaData<? extends TradeHeader> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends TradeHeader> getType() {
        return TradeHeader.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("tradeIdentifiersModel"), processor, TradeIdentifiersModel.class, this.getTradeIdentifiersModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("partyTradeInformation"), processor, PartyTradeInformation.class, this.getPartyTradeInformation(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("tradeSummary"), processor, TradeSummary.class, this.getTradeSummary(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("productSummary"), processor, ProductSummary.class, this.getProductSummary(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("originatingPackage"), processor, PackageSummary.class, this.getOriginatingPackage(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("tradeDate"), processor, IdentifiedDate.class, this.getTradeDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("clearedDate"), processor, IdentifiedDate.class, this.getClearedDate(), new AttributeMeta[0]);
    }

    public static class TradeHeaderBuilderImpl
    implements TradeHeaderBuilder {
        protected TradeIdentifiersModel.TradeIdentifiersModelBuilder tradeIdentifiersModel;
        protected List<PartyTradeInformation.PartyTradeInformationBuilder> partyTradeInformation = new ArrayList<PartyTradeInformation.PartyTradeInformationBuilder>();
        protected TradeSummary.TradeSummaryBuilder tradeSummary;
        protected ProductSummary.ProductSummaryBuilder productSummary;
        protected PackageSummary.PackageSummaryBuilder originatingPackage;
        protected IdentifiedDate.IdentifiedDateBuilder tradeDate;
        protected IdentifiedDate.IdentifiedDateBuilder clearedDate;

        @Override
        @RosettaAttribute(value="tradeIdentifiersModel", isRequired=true)
        @RuneAttribute(value="tradeIdentifiersModel", isRequired=true)
        public TradeIdentifiersModel.TradeIdentifiersModelBuilder getTradeIdentifiersModel() {
            return this.tradeIdentifiersModel;
        }

        @Override
        public TradeIdentifiersModel.TradeIdentifiersModelBuilder getOrCreateTradeIdentifiersModel() {
            TradeIdentifiersModel.TradeIdentifiersModelBuilder result = this.tradeIdentifiersModel != null ? this.tradeIdentifiersModel : (this.tradeIdentifiersModel = TradeIdentifiersModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="partyTradeInformation")
        @RuneAttribute(value="partyTradeInformation")
        public List<? extends PartyTradeInformation.PartyTradeInformationBuilder> getPartyTradeInformation() {
            return this.partyTradeInformation;
        }

        @Override
        public PartyTradeInformation.PartyTradeInformationBuilder getOrCreatePartyTradeInformation(int index) {
            if (this.partyTradeInformation == null) {
                this.partyTradeInformation = new ArrayList<PartyTradeInformation.PartyTradeInformationBuilder>();
            }
            return (PartyTradeInformation.PartyTradeInformationBuilder)this.getIndex(this.partyTradeInformation, index, () -> {
                PartyTradeInformation.PartyTradeInformationBuilder newPartyTradeInformation = PartyTradeInformation.builder();
                return newPartyTradeInformation;
            });
        }

        @Override
        @RosettaAttribute(value="tradeSummary")
        @RuneAttribute(value="tradeSummary")
        public TradeSummary.TradeSummaryBuilder getTradeSummary() {
            return this.tradeSummary;
        }

        @Override
        public TradeSummary.TradeSummaryBuilder getOrCreateTradeSummary() {
            TradeSummary.TradeSummaryBuilder result = this.tradeSummary != null ? this.tradeSummary : (this.tradeSummary = TradeSummary.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="productSummary")
        @RuneAttribute(value="productSummary")
        public ProductSummary.ProductSummaryBuilder getProductSummary() {
            return this.productSummary;
        }

        @Override
        public ProductSummary.ProductSummaryBuilder getOrCreateProductSummary() {
            ProductSummary.ProductSummaryBuilder result = this.productSummary != null ? this.productSummary : (this.productSummary = ProductSummary.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="originatingPackage")
        @RuneAttribute(value="originatingPackage")
        public PackageSummary.PackageSummaryBuilder getOriginatingPackage() {
            return this.originatingPackage;
        }

        @Override
        public PackageSummary.PackageSummaryBuilder getOrCreateOriginatingPackage() {
            PackageSummary.PackageSummaryBuilder result = this.originatingPackage != null ? this.originatingPackage : (this.originatingPackage = PackageSummary.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="tradeDate")
        @RuneAttribute(value="tradeDate")
        public IdentifiedDate.IdentifiedDateBuilder getTradeDate() {
            return this.tradeDate;
        }

        @Override
        public IdentifiedDate.IdentifiedDateBuilder getOrCreateTradeDate() {
            IdentifiedDate.IdentifiedDateBuilder result = this.tradeDate != null ? this.tradeDate : (this.tradeDate = IdentifiedDate.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="clearedDate")
        @RuneAttribute(value="clearedDate")
        public IdentifiedDate.IdentifiedDateBuilder getClearedDate() {
            return this.clearedDate;
        }

        @Override
        public IdentifiedDate.IdentifiedDateBuilder getOrCreateClearedDate() {
            IdentifiedDate.IdentifiedDateBuilder result = this.clearedDate != null ? this.clearedDate : (this.clearedDate = IdentifiedDate.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="tradeIdentifiersModel", isRequired=true)
        @RuneAttribute(value="tradeIdentifiersModel", isRequired=true)
        public TradeHeaderBuilder setTradeIdentifiersModel(TradeIdentifiersModel _tradeIdentifiersModel) {
            this.tradeIdentifiersModel = _tradeIdentifiersModel == null ? null : _tradeIdentifiersModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="partyTradeInformation")
        @RuneAttribute(value="partyTradeInformation")
        public TradeHeaderBuilder addPartyTradeInformation(PartyTradeInformation _partyTradeInformation) {
            if (_partyTradeInformation != null) {
                this.partyTradeInformation.add(_partyTradeInformation.toBuilder());
            }
            return this;
        }

        @Override
        public TradeHeaderBuilder addPartyTradeInformation(PartyTradeInformation _partyTradeInformation, int idx) {
            this.getIndex(this.partyTradeInformation, idx, () -> _partyTradeInformation.toBuilder());
            return this;
        }

        @Override
        public TradeHeaderBuilder addPartyTradeInformation(List<? extends PartyTradeInformation> partyTradeInformations) {
            if (partyTradeInformations != null) {
                for (PartyTradeInformation partyTradeInformation : partyTradeInformations) {
                    this.partyTradeInformation.add(partyTradeInformation.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="partyTradeInformation")
        public TradeHeaderBuilder setPartyTradeInformation(List<? extends PartyTradeInformation> partyTradeInformations) {
            this.partyTradeInformation = partyTradeInformations == null ? new ArrayList<PartyTradeInformation.PartyTradeInformationBuilder>() : (List)partyTradeInformations.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="tradeSummary")
        @RuneAttribute(value="tradeSummary")
        public TradeHeaderBuilder setTradeSummary(TradeSummary _tradeSummary) {
            this.tradeSummary = _tradeSummary == null ? null : _tradeSummary.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="productSummary")
        @RuneAttribute(value="productSummary")
        public TradeHeaderBuilder setProductSummary(ProductSummary _productSummary) {
            this.productSummary = _productSummary == null ? null : _productSummary.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="originatingPackage")
        @RuneAttribute(value="originatingPackage")
        public TradeHeaderBuilder setOriginatingPackage(PackageSummary _originatingPackage) {
            this.originatingPackage = _originatingPackage == null ? null : _originatingPackage.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="tradeDate")
        @RuneAttribute(value="tradeDate")
        public TradeHeaderBuilder setTradeDate(IdentifiedDate _tradeDate) {
            this.tradeDate = _tradeDate == null ? null : _tradeDate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="clearedDate")
        @RuneAttribute(value="clearedDate")
        public TradeHeaderBuilder setClearedDate(IdentifiedDate _clearedDate) {
            this.clearedDate = _clearedDate == null ? null : _clearedDate.toBuilder();
            return this;
        }

        @Override
        public TradeHeader build() {
            return new TradeHeaderImpl(this);
        }

        @Override
        public TradeHeaderBuilder toBuilder() {
            return this;
        }

        @Override
        public TradeHeaderBuilder prune() {
            if (this.tradeIdentifiersModel != null && !this.tradeIdentifiersModel.prune().hasData()) {
                this.tradeIdentifiersModel = null;
            }
            this.partyTradeInformation = this.partyTradeInformation.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.tradeSummary != null && !this.tradeSummary.prune().hasData()) {
                this.tradeSummary = null;
            }
            if (this.productSummary != null && !this.productSummary.prune().hasData()) {
                this.productSummary = null;
            }
            if (this.originatingPackage != null && !this.originatingPackage.prune().hasData()) {
                this.originatingPackage = null;
            }
            if (this.tradeDate != null && !this.tradeDate.prune().hasData()) {
                this.tradeDate = null;
            }
            if (this.clearedDate != null && !this.clearedDate.prune().hasData()) {
                this.clearedDate = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getTradeIdentifiersModel() != null && this.getTradeIdentifiersModel().hasData()) {
                return true;
            }
            if (this.getPartyTradeInformation() != null && this.getPartyTradeInformation().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getTradeSummary() != null && this.getTradeSummary().hasData()) {
                return true;
            }
            if (this.getProductSummary() != null && this.getProductSummary().hasData()) {
                return true;
            }
            if (this.getOriginatingPackage() != null && this.getOriginatingPackage().hasData()) {
                return true;
            }
            if (this.getTradeDate() != null && this.getTradeDate().hasData()) {
                return true;
            }
            return this.getClearedDate() != null && this.getClearedDate().hasData();
        }

        public TradeHeaderBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            TradeHeaderBuilder o = (TradeHeaderBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getTradeIdentifiersModel(), (RosettaModelObjectBuilder)o.getTradeIdentifiersModel(), this::setTradeIdentifiersModel);
            merger.mergeRosetta(this.getPartyTradeInformation(), o.getPartyTradeInformation(), this::getOrCreatePartyTradeInformation);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getTradeSummary(), (RosettaModelObjectBuilder)o.getTradeSummary(), this::setTradeSummary);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getProductSummary(), (RosettaModelObjectBuilder)o.getProductSummary(), this::setProductSummary);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getOriginatingPackage(), (RosettaModelObjectBuilder)o.getOriginatingPackage(), this::setOriginatingPackage);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getTradeDate(), (RosettaModelObjectBuilder)o.getTradeDate(), this::setTradeDate);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getClearedDate(), (RosettaModelObjectBuilder)o.getClearedDate(), this::setClearedDate);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            TradeHeader _that = this.getType().cast(o);
            if (!Objects.equals(this.tradeIdentifiersModel, _that.getTradeIdentifiersModel())) {
                return false;
            }
            if (!ListEquals.listEquals(this.partyTradeInformation, _that.getPartyTradeInformation())) {
                return false;
            }
            if (!Objects.equals(this.tradeSummary, _that.getTradeSummary())) {
                return false;
            }
            if (!Objects.equals(this.productSummary, _that.getProductSummary())) {
                return false;
            }
            if (!Objects.equals(this.originatingPackage, _that.getOriginatingPackage())) {
                return false;
            }
            if (!Objects.equals(this.tradeDate, _that.getTradeDate())) {
                return false;
            }
            return Objects.equals(this.clearedDate, _that.getClearedDate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.tradeIdentifiersModel != null ? this.tradeIdentifiersModel.hashCode() : 0);
            _result = 31 * _result + (this.partyTradeInformation != null ? this.partyTradeInformation.hashCode() : 0);
            _result = 31 * _result + (this.tradeSummary != null ? this.tradeSummary.hashCode() : 0);
            _result = 31 * _result + (this.productSummary != null ? this.productSummary.hashCode() : 0);
            _result = 31 * _result + (this.originatingPackage != null ? this.originatingPackage.hashCode() : 0);
            _result = 31 * _result + (this.tradeDate != null ? this.tradeDate.hashCode() : 0);
            _result = 31 * _result + (this.clearedDate != null ? this.clearedDate.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "TradeHeaderBuilder {tradeIdentifiersModel=" + this.tradeIdentifiersModel + ", partyTradeInformation=" + this.partyTradeInformation + ", tradeSummary=" + this.tradeSummary + ", productSummary=" + this.productSummary + ", originatingPackage=" + this.originatingPackage + ", tradeDate=" + this.tradeDate + ", clearedDate=" + this.clearedDate + '}';
        }
    }

    public static interface TradeHeaderBuilder
    extends TradeHeader,
    RosettaModelObjectBuilder {
        public TradeIdentifiersModel.TradeIdentifiersModelBuilder getOrCreateTradeIdentifiersModel();

        @Override
        public TradeIdentifiersModel.TradeIdentifiersModelBuilder getTradeIdentifiersModel();

        public PartyTradeInformation.PartyTradeInformationBuilder getOrCreatePartyTradeInformation(int var1);

        public List<? extends PartyTradeInformation.PartyTradeInformationBuilder> getPartyTradeInformation();

        public TradeSummary.TradeSummaryBuilder getOrCreateTradeSummary();

        @Override
        public TradeSummary.TradeSummaryBuilder getTradeSummary();

        public ProductSummary.ProductSummaryBuilder getOrCreateProductSummary();

        @Override
        public ProductSummary.ProductSummaryBuilder getProductSummary();

        public PackageSummary.PackageSummaryBuilder getOrCreateOriginatingPackage();

        @Override
        public PackageSummary.PackageSummaryBuilder getOriginatingPackage();

        public IdentifiedDate.IdentifiedDateBuilder getOrCreateTradeDate();

        @Override
        public IdentifiedDate.IdentifiedDateBuilder getTradeDate();

        public IdentifiedDate.IdentifiedDateBuilder getOrCreateClearedDate();

        @Override
        public IdentifiedDate.IdentifiedDateBuilder getClearedDate();

        public TradeHeaderBuilder setTradeIdentifiersModel(TradeIdentifiersModel var1);

        public TradeHeaderBuilder addPartyTradeInformation(PartyTradeInformation var1);

        public TradeHeaderBuilder addPartyTradeInformation(PartyTradeInformation var1, int var2);

        public TradeHeaderBuilder addPartyTradeInformation(List<? extends PartyTradeInformation> var1);

        public TradeHeaderBuilder setPartyTradeInformation(List<? extends PartyTradeInformation> var1);

        public TradeHeaderBuilder setTradeSummary(TradeSummary var1);

        public TradeHeaderBuilder setProductSummary(ProductSummary var1);

        public TradeHeaderBuilder setOriginatingPackage(PackageSummary var1);

        public TradeHeaderBuilder setTradeDate(IdentifiedDate var1);

        public TradeHeaderBuilder setClearedDate(IdentifiedDate var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("tradeIdentifiersModel"), processor, TradeIdentifiersModel.TradeIdentifiersModelBuilder.class, this.getTradeIdentifiersModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("partyTradeInformation"), processor, PartyTradeInformation.PartyTradeInformationBuilder.class, this.getPartyTradeInformation(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("tradeSummary"), processor, TradeSummary.TradeSummaryBuilder.class, this.getTradeSummary(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("productSummary"), processor, ProductSummary.ProductSummaryBuilder.class, this.getProductSummary(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("originatingPackage"), processor, PackageSummary.PackageSummaryBuilder.class, this.getOriginatingPackage(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("tradeDate"), processor, IdentifiedDate.IdentifiedDateBuilder.class, this.getTradeDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("clearedDate"), processor, IdentifiedDate.IdentifiedDateBuilder.class, this.getClearedDate(), new AttributeMeta[0]);
        }

        public TradeHeaderBuilder prune();
    }

    public static class TradeHeaderImpl
    implements TradeHeader {
        private final TradeIdentifiersModel tradeIdentifiersModel;
        private final List<? extends PartyTradeInformation> partyTradeInformation;
        private final TradeSummary tradeSummary;
        private final ProductSummary productSummary;
        private final PackageSummary originatingPackage;
        private final IdentifiedDate tradeDate;
        private final IdentifiedDate clearedDate;

        protected TradeHeaderImpl(TradeHeaderBuilder builder) {
            this.tradeIdentifiersModel = Optional.ofNullable(builder.getTradeIdentifiersModel()).map(f -> f.build()).orElse(null);
            this.partyTradeInformation = Optional.ofNullable(builder.getPartyTradeInformation()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.tradeSummary = Optional.ofNullable(builder.getTradeSummary()).map(f -> f.build()).orElse(null);
            this.productSummary = Optional.ofNullable(builder.getProductSummary()).map(f -> f.build()).orElse(null);
            this.originatingPackage = Optional.ofNullable(builder.getOriginatingPackage()).map(f -> f.build()).orElse(null);
            this.tradeDate = Optional.ofNullable(builder.getTradeDate()).map(f -> f.build()).orElse(null);
            this.clearedDate = Optional.ofNullable(builder.getClearedDate()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="tradeIdentifiersModel", isRequired=true)
        @RuneAttribute(value="tradeIdentifiersModel", isRequired=true)
        public TradeIdentifiersModel getTradeIdentifiersModel() {
            return this.tradeIdentifiersModel;
        }

        @Override
        @RosettaAttribute(value="partyTradeInformation")
        @RuneAttribute(value="partyTradeInformation")
        public List<? extends PartyTradeInformation> getPartyTradeInformation() {
            return this.partyTradeInformation;
        }

        @Override
        @RosettaAttribute(value="tradeSummary")
        @RuneAttribute(value="tradeSummary")
        public TradeSummary getTradeSummary() {
            return this.tradeSummary;
        }

        @Override
        @RosettaAttribute(value="productSummary")
        @RuneAttribute(value="productSummary")
        public ProductSummary getProductSummary() {
            return this.productSummary;
        }

        @Override
        @RosettaAttribute(value="originatingPackage")
        @RuneAttribute(value="originatingPackage")
        public PackageSummary getOriginatingPackage() {
            return this.originatingPackage;
        }

        @Override
        @RosettaAttribute(value="tradeDate")
        @RuneAttribute(value="tradeDate")
        public IdentifiedDate getTradeDate() {
            return this.tradeDate;
        }

        @Override
        @RosettaAttribute(value="clearedDate")
        @RuneAttribute(value="clearedDate")
        public IdentifiedDate getClearedDate() {
            return this.clearedDate;
        }

        @Override
        public TradeHeader build() {
            return this;
        }

        @Override
        public TradeHeaderBuilder toBuilder() {
            TradeHeaderBuilder builder = TradeHeader.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(TradeHeaderBuilder builder) {
            Optional.ofNullable(this.getTradeIdentifiersModel()).ifPresent(builder::setTradeIdentifiersModel);
            Optional.ofNullable(this.getPartyTradeInformation()).ifPresent(builder::setPartyTradeInformation);
            Optional.ofNullable(this.getTradeSummary()).ifPresent(builder::setTradeSummary);
            Optional.ofNullable(this.getProductSummary()).ifPresent(builder::setProductSummary);
            Optional.ofNullable(this.getOriginatingPackage()).ifPresent(builder::setOriginatingPackage);
            Optional.ofNullable(this.getTradeDate()).ifPresent(builder::setTradeDate);
            Optional.ofNullable(this.getClearedDate()).ifPresent(builder::setClearedDate);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            TradeHeader _that = this.getType().cast(o);
            if (!Objects.equals(this.tradeIdentifiersModel, _that.getTradeIdentifiersModel())) {
                return false;
            }
            if (!ListEquals.listEquals(this.partyTradeInformation, _that.getPartyTradeInformation())) {
                return false;
            }
            if (!Objects.equals(this.tradeSummary, _that.getTradeSummary())) {
                return false;
            }
            if (!Objects.equals(this.productSummary, _that.getProductSummary())) {
                return false;
            }
            if (!Objects.equals(this.originatingPackage, _that.getOriginatingPackage())) {
                return false;
            }
            if (!Objects.equals(this.tradeDate, _that.getTradeDate())) {
                return false;
            }
            return Objects.equals(this.clearedDate, _that.getClearedDate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.tradeIdentifiersModel != null ? this.tradeIdentifiersModel.hashCode() : 0);
            _result = 31 * _result + (this.partyTradeInformation != null ? this.partyTradeInformation.hashCode() : 0);
            _result = 31 * _result + (this.tradeSummary != null ? this.tradeSummary.hashCode() : 0);
            _result = 31 * _result + (this.productSummary != null ? this.productSummary.hashCode() : 0);
            _result = 31 * _result + (this.originatingPackage != null ? this.originatingPackage.hashCode() : 0);
            _result = 31 * _result + (this.tradeDate != null ? this.tradeDate.hashCode() : 0);
            _result = 31 * _result + (this.clearedDate != null ? this.clearedDate.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "TradeHeader {tradeIdentifiersModel=" + this.tradeIdentifiersModel + ", partyTradeInformation=" + this.partyTradeInformation + ", tradeSummary=" + this.tradeSummary + ", productSummary=" + this.productSummary + ", originatingPackage=" + this.originatingPackage + ", tradeDate=" + this.tradeDate + ", clearedDate=" + this.clearedDate + '}';
        }
    }
}

