/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.doc;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.doc.meta.StrategyComponentIdentificationMeta;
import fpml.consolidated.shared.PartyTradeIdentifierReference;
import fpml.consolidated.shared.ProductReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="StrategyComponentIdentification", builder=StrategyComponentIdentificationBuilderImpl.class, version="1.1.0")
@RuneDataType(value="StrategyComponentIdentification", model="fpml", builder=StrategyComponentIdentificationBuilderImpl.class, version="1.1.0")
public interface StrategyComponentIdentification
extends RosettaModelObject {
    public static final StrategyComponentIdentificationMeta metaData = new StrategyComponentIdentificationMeta();

    public List<? extends PartyTradeIdentifierReference> getTradeIdentifierReference();

    public ProductReference getComponentReference();

    public StrategyComponentIdentification build();

    public StrategyComponentIdentificationBuilder toBuilder();

    public static StrategyComponentIdentificationBuilder builder() {
        return new StrategyComponentIdentificationBuilderImpl();
    }

    default public RosettaMetaData<? extends StrategyComponentIdentification> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends StrategyComponentIdentification> getType() {
        return StrategyComponentIdentification.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("tradeIdentifierReference"), processor, PartyTradeIdentifierReference.class, this.getTradeIdentifierReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("componentReference"), processor, ProductReference.class, this.getComponentReference(), new AttributeMeta[0]);
    }

    public static class StrategyComponentIdentificationBuilderImpl
    implements StrategyComponentIdentificationBuilder {
        protected List<PartyTradeIdentifierReference.PartyTradeIdentifierReferenceBuilder> tradeIdentifierReference = new ArrayList<PartyTradeIdentifierReference.PartyTradeIdentifierReferenceBuilder>();
        protected ProductReference.ProductReferenceBuilder componentReference;

        @Override
        @RosettaAttribute(value="tradeIdentifierReference")
        @RuneAttribute(value="tradeIdentifierReference")
        public List<? extends PartyTradeIdentifierReference.PartyTradeIdentifierReferenceBuilder> getTradeIdentifierReference() {
            return this.tradeIdentifierReference;
        }

        @Override
        public PartyTradeIdentifierReference.PartyTradeIdentifierReferenceBuilder getOrCreateTradeIdentifierReference(int index) {
            if (this.tradeIdentifierReference == null) {
                this.tradeIdentifierReference = new ArrayList<PartyTradeIdentifierReference.PartyTradeIdentifierReferenceBuilder>();
            }
            return (PartyTradeIdentifierReference.PartyTradeIdentifierReferenceBuilder)this.getIndex(this.tradeIdentifierReference, index, () -> {
                PartyTradeIdentifierReference.PartyTradeIdentifierReferenceBuilder newTradeIdentifierReference = PartyTradeIdentifierReference.builder();
                return newTradeIdentifierReference;
            });
        }

        @Override
        @RosettaAttribute(value="componentReference")
        @RuneAttribute(value="componentReference")
        public ProductReference.ProductReferenceBuilder getComponentReference() {
            return this.componentReference;
        }

        @Override
        public ProductReference.ProductReferenceBuilder getOrCreateComponentReference() {
            ProductReference.ProductReferenceBuilder result = this.componentReference != null ? this.componentReference : (this.componentReference = ProductReference.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="tradeIdentifierReference")
        @RuneAttribute(value="tradeIdentifierReference")
        public StrategyComponentIdentificationBuilder addTradeIdentifierReference(PartyTradeIdentifierReference _tradeIdentifierReference) {
            if (_tradeIdentifierReference != null) {
                this.tradeIdentifierReference.add(_tradeIdentifierReference.toBuilder());
            }
            return this;
        }

        @Override
        public StrategyComponentIdentificationBuilder addTradeIdentifierReference(PartyTradeIdentifierReference _tradeIdentifierReference, int idx) {
            this.getIndex(this.tradeIdentifierReference, idx, () -> _tradeIdentifierReference.toBuilder());
            return this;
        }

        @Override
        public StrategyComponentIdentificationBuilder addTradeIdentifierReference(List<? extends PartyTradeIdentifierReference> tradeIdentifierReferences) {
            if (tradeIdentifierReferences != null) {
                for (PartyTradeIdentifierReference partyTradeIdentifierReference : tradeIdentifierReferences) {
                    this.tradeIdentifierReference.add(partyTradeIdentifierReference.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="tradeIdentifierReference")
        public StrategyComponentIdentificationBuilder setTradeIdentifierReference(List<? extends PartyTradeIdentifierReference> tradeIdentifierReferences) {
            this.tradeIdentifierReference = tradeIdentifierReferences == null ? new ArrayList<PartyTradeIdentifierReference.PartyTradeIdentifierReferenceBuilder>() : (List)tradeIdentifierReferences.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="componentReference")
        @RuneAttribute(value="componentReference")
        public StrategyComponentIdentificationBuilder setComponentReference(ProductReference _componentReference) {
            this.componentReference = _componentReference == null ? null : _componentReference.toBuilder();
            return this;
        }

        @Override
        public StrategyComponentIdentification build() {
            return new StrategyComponentIdentificationImpl(this);
        }

        @Override
        public StrategyComponentIdentificationBuilder toBuilder() {
            return this;
        }

        @Override
        public StrategyComponentIdentificationBuilder prune() {
            this.tradeIdentifierReference = this.tradeIdentifierReference.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.componentReference != null && !this.componentReference.prune().hasData()) {
                this.componentReference = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getTradeIdentifierReference() != null && this.getTradeIdentifierReference().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getComponentReference() != null && this.getComponentReference().hasData();
        }

        public StrategyComponentIdentificationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            StrategyComponentIdentificationBuilder o = (StrategyComponentIdentificationBuilder)other;
            merger.mergeRosetta(this.getTradeIdentifierReference(), o.getTradeIdentifierReference(), this::getOrCreateTradeIdentifierReference);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getComponentReference(), (RosettaModelObjectBuilder)o.getComponentReference(), this::setComponentReference);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            StrategyComponentIdentification _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.tradeIdentifierReference, _that.getTradeIdentifierReference())) {
                return false;
            }
            return Objects.equals(this.componentReference, _that.getComponentReference());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.tradeIdentifierReference != null ? this.tradeIdentifierReference.hashCode() : 0);
            _result = 31 * _result + (this.componentReference != null ? this.componentReference.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "StrategyComponentIdentificationBuilder {tradeIdentifierReference=" + this.tradeIdentifierReference + ", componentReference=" + this.componentReference + '}';
        }
    }

    public static interface StrategyComponentIdentificationBuilder
    extends StrategyComponentIdentification,
    RosettaModelObjectBuilder {
        public PartyTradeIdentifierReference.PartyTradeIdentifierReferenceBuilder getOrCreateTradeIdentifierReference(int var1);

        public List<? extends PartyTradeIdentifierReference.PartyTradeIdentifierReferenceBuilder> getTradeIdentifierReference();

        public ProductReference.ProductReferenceBuilder getOrCreateComponentReference();

        @Override
        public ProductReference.ProductReferenceBuilder getComponentReference();

        public StrategyComponentIdentificationBuilder addTradeIdentifierReference(PartyTradeIdentifierReference var1);

        public StrategyComponentIdentificationBuilder addTradeIdentifierReference(PartyTradeIdentifierReference var1, int var2);

        public StrategyComponentIdentificationBuilder addTradeIdentifierReference(List<? extends PartyTradeIdentifierReference> var1);

        public StrategyComponentIdentificationBuilder setTradeIdentifierReference(List<? extends PartyTradeIdentifierReference> var1);

        public StrategyComponentIdentificationBuilder setComponentReference(ProductReference var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("tradeIdentifierReference"), processor, PartyTradeIdentifierReference.PartyTradeIdentifierReferenceBuilder.class, this.getTradeIdentifierReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("componentReference"), processor, ProductReference.ProductReferenceBuilder.class, this.getComponentReference(), new AttributeMeta[0]);
        }

        public StrategyComponentIdentificationBuilder prune();
    }

    public static class StrategyComponentIdentificationImpl
    implements StrategyComponentIdentification {
        private final List<? extends PartyTradeIdentifierReference> tradeIdentifierReference;
        private final ProductReference componentReference;

        protected StrategyComponentIdentificationImpl(StrategyComponentIdentificationBuilder builder) {
            this.tradeIdentifierReference = Optional.ofNullable(builder.getTradeIdentifierReference()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.componentReference = Optional.ofNullable(builder.getComponentReference()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="tradeIdentifierReference")
        @RuneAttribute(value="tradeIdentifierReference")
        public List<? extends PartyTradeIdentifierReference> getTradeIdentifierReference() {
            return this.tradeIdentifierReference;
        }

        @Override
        @RosettaAttribute(value="componentReference")
        @RuneAttribute(value="componentReference")
        public ProductReference getComponentReference() {
            return this.componentReference;
        }

        @Override
        public StrategyComponentIdentification build() {
            return this;
        }

        @Override
        public StrategyComponentIdentificationBuilder toBuilder() {
            StrategyComponentIdentificationBuilder builder = StrategyComponentIdentification.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(StrategyComponentIdentificationBuilder builder) {
            Optional.ofNullable(this.getTradeIdentifierReference()).ifPresent(builder::setTradeIdentifierReference);
            Optional.ofNullable(this.getComponentReference()).ifPresent(builder::setComponentReference);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            StrategyComponentIdentification _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.tradeIdentifierReference, _that.getTradeIdentifierReference())) {
                return false;
            }
            return Objects.equals(this.componentReference, _that.getComponentReference());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.tradeIdentifierReference != null ? this.tradeIdentifierReference.hashCode() : 0);
            _result = 31 * _result + (this.componentReference != null ? this.componentReference.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "StrategyComponentIdentification {tradeIdentifierReference=" + this.tradeIdentifierReference + ", componentReference=" + this.componentReference + '}';
        }
    }
}

