/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.dividend.swaps;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.dividend.swaps.FixedPaymentAmount;
import fpml.consolidated.dividend.swaps.meta.FixedPaymentLegMeta;
import fpml.consolidated.shared.AdjustableOrRelativeDate;
import fpml.consolidated.shared.DirectionalLeg;
import fpml.consolidated.shared.LegIdentifier;
import fpml.consolidated.shared.PayerReceiverModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="FixedPaymentLeg", builder=FixedPaymentLegBuilderImpl.class, version="1.1.0")
@RuneDataType(value="FixedPaymentLeg", model="fpml", builder=FixedPaymentLegBuilderImpl.class, version="1.1.0")
public interface FixedPaymentLeg
extends DirectionalLeg {
    public static final FixedPaymentLegMeta metaData = new FixedPaymentLegMeta();

    public List<? extends FixedPaymentAmount> getFixedPayment();

    @Override
    public FixedPaymentLeg build();

    @Override
    public FixedPaymentLegBuilder toBuilder();

    public static FixedPaymentLegBuilder builder() {
        return new FixedPaymentLegBuilderImpl();
    }

    default public RosettaMetaData<? extends FixedPaymentLeg> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends FixedPaymentLeg> getType() {
        return FixedPaymentLeg.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("legIdentifier"), processor, LegIdentifier.class, this.getLegIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("payerReceiverModel"), processor, PayerReceiverModel.class, this.getPayerReceiverModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("effectiveDate"), processor, AdjustableOrRelativeDate.class, this.getEffectiveDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("terminationDate"), processor, AdjustableOrRelativeDate.class, this.getTerminationDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("fixedPayment"), processor, FixedPaymentAmount.class, this.getFixedPayment(), new AttributeMeta[0]);
    }

    public static class FixedPaymentLegBuilderImpl
    extends DirectionalLeg.DirectionalLegBuilderImpl
    implements FixedPaymentLegBuilder {
        protected List<FixedPaymentAmount.FixedPaymentAmountBuilder> fixedPayment = new ArrayList<FixedPaymentAmount.FixedPaymentAmountBuilder>();

        @Override
        @RosettaAttribute(value="fixedPayment")
        @RuneAttribute(value="fixedPayment")
        public List<? extends FixedPaymentAmount.FixedPaymentAmountBuilder> getFixedPayment() {
            return this.fixedPayment;
        }

        @Override
        public FixedPaymentAmount.FixedPaymentAmountBuilder getOrCreateFixedPayment(int index) {
            if (this.fixedPayment == null) {
                this.fixedPayment = new ArrayList<FixedPaymentAmount.FixedPaymentAmountBuilder>();
            }
            return (FixedPaymentAmount.FixedPaymentAmountBuilder)this.getIndex(this.fixedPayment, index, () -> {
                FixedPaymentAmount.FixedPaymentAmountBuilder newFixedPayment = FixedPaymentAmount.builder();
                return newFixedPayment;
            });
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public FixedPaymentLegBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="legIdentifier")
        @RuneAttribute(value="legIdentifier")
        public FixedPaymentLegBuilder addLegIdentifier(LegIdentifier _legIdentifier) {
            if (_legIdentifier != null) {
                this.legIdentifier.add(_legIdentifier.toBuilder());
            }
            return this;
        }

        @Override
        public FixedPaymentLegBuilder addLegIdentifier(LegIdentifier _legIdentifier, int idx) {
            this.getIndex(this.legIdentifier, idx, () -> _legIdentifier.toBuilder());
            return this;
        }

        @Override
        public FixedPaymentLegBuilder addLegIdentifier(List<? extends LegIdentifier> legIdentifiers) {
            if (legIdentifiers != null) {
                for (LegIdentifier legIdentifier : legIdentifiers) {
                    this.legIdentifier.add(legIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="legIdentifier")
        public FixedPaymentLegBuilder setLegIdentifier(List<? extends LegIdentifier> legIdentifiers) {
            this.legIdentifier = legIdentifiers == null ? new ArrayList() : (List)legIdentifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="payerReceiverModel", isRequired=true)
        @RuneAttribute(value="payerReceiverModel", isRequired=true)
        public FixedPaymentLegBuilder setPayerReceiverModel(PayerReceiverModel _payerReceiverModel) {
            this.payerReceiverModel = _payerReceiverModel == null ? null : _payerReceiverModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="effectiveDate")
        @RuneAttribute(value="effectiveDate")
        public FixedPaymentLegBuilder setEffectiveDate(AdjustableOrRelativeDate _effectiveDate) {
            this.effectiveDate = _effectiveDate == null ? null : _effectiveDate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="terminationDate")
        @RuneAttribute(value="terminationDate")
        public FixedPaymentLegBuilder setTerminationDate(AdjustableOrRelativeDate _terminationDate) {
            this.terminationDate = _terminationDate == null ? null : _terminationDate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="fixedPayment")
        @RuneAttribute(value="fixedPayment")
        public FixedPaymentLegBuilder addFixedPayment(FixedPaymentAmount _fixedPayment) {
            if (_fixedPayment != null) {
                this.fixedPayment.add(_fixedPayment.toBuilder());
            }
            return this;
        }

        @Override
        public FixedPaymentLegBuilder addFixedPayment(FixedPaymentAmount _fixedPayment, int idx) {
            this.getIndex(this.fixedPayment, idx, () -> _fixedPayment.toBuilder());
            return this;
        }

        @Override
        public FixedPaymentLegBuilder addFixedPayment(List<? extends FixedPaymentAmount> fixedPayments) {
            if (fixedPayments != null) {
                for (FixedPaymentAmount fixedPaymentAmount : fixedPayments) {
                    this.fixedPayment.add(fixedPaymentAmount.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="fixedPayment")
        public FixedPaymentLegBuilder setFixedPayment(List<? extends FixedPaymentAmount> fixedPayments) {
            this.fixedPayment = fixedPayments == null ? new ArrayList<FixedPaymentAmount.FixedPaymentAmountBuilder>() : (List)fixedPayments.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public FixedPaymentLeg build() {
            return new FixedPaymentLegImpl(this);
        }

        @Override
        public FixedPaymentLegBuilder toBuilder() {
            return this;
        }

        @Override
        public FixedPaymentLegBuilder prune() {
            super.prune();
            this.fixedPayment = this.fixedPayment.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            return this.getFixedPayment() != null && this.getFixedPayment().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        @Override
        public FixedPaymentLegBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            FixedPaymentLegBuilder o = (FixedPaymentLegBuilder)other;
            merger.mergeRosetta(this.getFixedPayment(), o.getFixedPayment(), this::getOrCreateFixedPayment);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            FixedPaymentLeg _that = (FixedPaymentLeg)this.getType().cast(o);
            return ListEquals.listEquals(this.fixedPayment, _that.getFixedPayment());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.fixedPayment != null ? this.fixedPayment.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "FixedPaymentLegBuilder {fixedPayment=" + this.fixedPayment + '}' + " " + super.toString();
        }
    }

    public static interface FixedPaymentLegBuilder
    extends FixedPaymentLeg,
    DirectionalLeg.DirectionalLegBuilder {
        public FixedPaymentAmount.FixedPaymentAmountBuilder getOrCreateFixedPayment(int var1);

        public List<? extends FixedPaymentAmount.FixedPaymentAmountBuilder> getFixedPayment();

        @Override
        public FixedPaymentLegBuilder setId(String var1);

        @Override
        public FixedPaymentLegBuilder addLegIdentifier(LegIdentifier var1);

        @Override
        public FixedPaymentLegBuilder addLegIdentifier(LegIdentifier var1, int var2);

        @Override
        public FixedPaymentLegBuilder addLegIdentifier(List<? extends LegIdentifier> var1);

        @Override
        public FixedPaymentLegBuilder setLegIdentifier(List<? extends LegIdentifier> var1);

        @Override
        public FixedPaymentLegBuilder setPayerReceiverModel(PayerReceiverModel var1);

        @Override
        public FixedPaymentLegBuilder setEffectiveDate(AdjustableOrRelativeDate var1);

        @Override
        public FixedPaymentLegBuilder setTerminationDate(AdjustableOrRelativeDate var1);

        public FixedPaymentLegBuilder addFixedPayment(FixedPaymentAmount var1);

        public FixedPaymentLegBuilder addFixedPayment(FixedPaymentAmount var1, int var2);

        public FixedPaymentLegBuilder addFixedPayment(List<? extends FixedPaymentAmount> var1);

        public FixedPaymentLegBuilder setFixedPayment(List<? extends FixedPaymentAmount> var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("legIdentifier"), processor, LegIdentifier.LegIdentifierBuilder.class, this.getLegIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("payerReceiverModel"), processor, PayerReceiverModel.PayerReceiverModelBuilder.class, (RosettaModelObjectBuilder)this.getPayerReceiverModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("effectiveDate"), processor, AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder.class, (RosettaModelObjectBuilder)this.getEffectiveDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("terminationDate"), processor, AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder.class, (RosettaModelObjectBuilder)this.getTerminationDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("fixedPayment"), processor, FixedPaymentAmount.FixedPaymentAmountBuilder.class, this.getFixedPayment(), new AttributeMeta[0]);
        }

        @Override
        public FixedPaymentLegBuilder prune();
    }

    public static class FixedPaymentLegImpl
    extends DirectionalLeg.DirectionalLegImpl
    implements FixedPaymentLeg {
        private final List<? extends FixedPaymentAmount> fixedPayment;

        protected FixedPaymentLegImpl(FixedPaymentLegBuilder builder) {
            super(builder);
            this.fixedPayment = Optional.ofNullable(builder.getFixedPayment()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="fixedPayment")
        @RuneAttribute(value="fixedPayment")
        public List<? extends FixedPaymentAmount> getFixedPayment() {
            return this.fixedPayment;
        }

        @Override
        public FixedPaymentLeg build() {
            return this;
        }

        @Override
        public FixedPaymentLegBuilder toBuilder() {
            FixedPaymentLegBuilder builder = FixedPaymentLeg.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(FixedPaymentLegBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getFixedPayment()).ifPresent(builder::setFixedPayment);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            FixedPaymentLeg _that = (FixedPaymentLeg)this.getType().cast(o);
            return ListEquals.listEquals(this.fixedPayment, _that.getFixedPayment());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.fixedPayment != null ? this.fixedPayment.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "FixedPaymentLeg {fixedPayment=" + this.fixedPayment + '}' + " " + super.toString();
        }
    }
}

