/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.confirmation.processes;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.business.events.OptionExercise;
import fpml.consolidated.business.events.TradingEventsModel;
import fpml.consolidated.confirmation.processes.meta.RequestExecutionMeta;
import fpml.consolidated.doc.ValidationModel;
import fpml.consolidated.msg.CorrectableRequestMessage;
import fpml.consolidated.msg.CorrelationAndSequenceModel;
import fpml.consolidated.msg.RequestMessageHeader;
import fpml.consolidated.shared.OnBehalfOfModel;
import fpml.consolidated.shared.PartiesAndAccountsModel;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="RequestExecution", builder=RequestExecutionBuilderImpl.class, version="1.1.0")
@RuneDataType(value="RequestExecution", model="fpml", builder=RequestExecutionBuilderImpl.class, version="1.1.0")
public interface RequestExecution
extends CorrectableRequestMessage {
    public static final RequestExecutionMeta metaData = new RequestExecutionMeta();

    public TradingEventsModel getTradingEventsModel();

    public OptionExercise getOptionExercise();

    public PartiesAndAccountsModel getPartiesAndAccountsModel();

    @Override
    public RequestExecution build();

    @Override
    public RequestExecutionBuilder toBuilder();

    public static RequestExecutionBuilder builder() {
        return new RequestExecutionBuilderImpl();
    }

    default public RosettaMetaData<? extends RequestExecution> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends RequestExecution> getType() {
        return RequestExecution.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("fpmlVersion"), String.class, (Object)this.getFpmlVersion(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("expectedBuild"), Integer.class, (Object)this.getExpectedBuild(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("actualBuild"), Integer.class, (Object)this.getActualBuild(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("header"), processor, RequestMessageHeader.class, this.getHeader(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("validationModel"), processor, ValidationModel.class, this.getValidationModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("isCorrection"), Boolean.class, (Object)this.getIsCorrection(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("correlationAndSequenceModel"), processor, CorrelationAndSequenceModel.class, this.getCorrelationAndSequenceModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("onBehalfOfModel"), processor, OnBehalfOfModel.class, this.getOnBehalfOfModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("tradingEventsModel"), processor, TradingEventsModel.class, this.getTradingEventsModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("optionExercise"), processor, OptionExercise.class, this.getOptionExercise(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("partiesAndAccountsModel"), processor, PartiesAndAccountsModel.class, this.getPartiesAndAccountsModel(), new AttributeMeta[0]);
    }

    public static class RequestExecutionBuilderImpl
    extends CorrectableRequestMessage.CorrectableRequestMessageBuilderImpl
    implements RequestExecutionBuilder {
        protected TradingEventsModel.TradingEventsModelBuilder tradingEventsModel;
        protected OptionExercise.OptionExerciseBuilder optionExercise;
        protected PartiesAndAccountsModel.PartiesAndAccountsModelBuilder partiesAndAccountsModel;

        @Override
        @RosettaAttribute(value="tradingEventsModel")
        @RuneAttribute(value="tradingEventsModel")
        public TradingEventsModel.TradingEventsModelBuilder getTradingEventsModel() {
            return this.tradingEventsModel;
        }

        @Override
        public TradingEventsModel.TradingEventsModelBuilder getOrCreateTradingEventsModel() {
            TradingEventsModel.TradingEventsModelBuilder result = this.tradingEventsModel != null ? this.tradingEventsModel : (this.tradingEventsModel = TradingEventsModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="optionExercise")
        @RuneAttribute(value="optionExercise")
        public OptionExercise.OptionExerciseBuilder getOptionExercise() {
            return this.optionExercise;
        }

        @Override
        public OptionExercise.OptionExerciseBuilder getOrCreateOptionExercise() {
            OptionExercise.OptionExerciseBuilder result = this.optionExercise != null ? this.optionExercise : (this.optionExercise = OptionExercise.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="partiesAndAccountsModel", isRequired=true)
        @RuneAttribute(value="partiesAndAccountsModel", isRequired=true)
        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getPartiesAndAccountsModel() {
            return this.partiesAndAccountsModel;
        }

        @Override
        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getOrCreatePartiesAndAccountsModel() {
            PartiesAndAccountsModel.PartiesAndAccountsModelBuilder result = this.partiesAndAccountsModel != null ? this.partiesAndAccountsModel : (this.partiesAndAccountsModel = PartiesAndAccountsModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="fpmlVersion", isRequired=true)
        @RuneAttribute(value="fpmlVersion", isRequired=true)
        public RequestExecutionBuilder setFpmlVersion(String _fpmlVersion) {
            this.fpmlVersion = _fpmlVersion == null ? null : _fpmlVersion;
            return this;
        }

        @Override
        @RosettaAttribute(value="expectedBuild")
        @RuneAttribute(value="expectedBuild")
        public RequestExecutionBuilder setExpectedBuild(Integer _expectedBuild) {
            this.expectedBuild = _expectedBuild == null ? null : _expectedBuild;
            return this;
        }

        @Override
        @RosettaAttribute(value="actualBuild")
        @RuneAttribute(value="actualBuild")
        public RequestExecutionBuilder setActualBuild(Integer _actualBuild) {
            this.actualBuild = _actualBuild == null ? null : _actualBuild;
            return this;
        }

        @Override
        @RosettaAttribute(value="header")
        @RuneAttribute(value="header")
        public RequestExecutionBuilder setHeader(RequestMessageHeader _header) {
            this.header = _header == null ? null : _header.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="validationModel", isRequired=true)
        @RuneAttribute(value="validationModel", isRequired=true)
        public RequestExecutionBuilder setValidationModel(ValidationModel _validationModel) {
            this.validationModel = _validationModel == null ? null : _validationModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="isCorrection")
        @RuneAttribute(value="isCorrection")
        public RequestExecutionBuilder setIsCorrection(Boolean _isCorrection) {
            this.isCorrection = _isCorrection == null ? null : _isCorrection;
            return this;
        }

        @Override
        @RosettaAttribute(value="correlationAndSequenceModel")
        @RuneAttribute(value="correlationAndSequenceModel")
        public RequestExecutionBuilder setCorrelationAndSequenceModel(CorrelationAndSequenceModel _correlationAndSequenceModel) {
            this.correlationAndSequenceModel = _correlationAndSequenceModel == null ? null : _correlationAndSequenceModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="onBehalfOfModel")
        @RuneAttribute(value="onBehalfOfModel")
        public RequestExecutionBuilder setOnBehalfOfModel(OnBehalfOfModel _onBehalfOfModel) {
            this.onBehalfOfModel = _onBehalfOfModel == null ? null : _onBehalfOfModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="tradingEventsModel")
        @RuneAttribute(value="tradingEventsModel")
        public RequestExecutionBuilder setTradingEventsModel(TradingEventsModel _tradingEventsModel) {
            this.tradingEventsModel = _tradingEventsModel == null ? null : _tradingEventsModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="optionExercise")
        @RuneAttribute(value="optionExercise")
        public RequestExecutionBuilder setOptionExercise(OptionExercise _optionExercise) {
            this.optionExercise = _optionExercise == null ? null : _optionExercise.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="partiesAndAccountsModel", isRequired=true)
        @RuneAttribute(value="partiesAndAccountsModel", isRequired=true)
        public RequestExecutionBuilder setPartiesAndAccountsModel(PartiesAndAccountsModel _partiesAndAccountsModel) {
            this.partiesAndAccountsModel = _partiesAndAccountsModel == null ? null : _partiesAndAccountsModel.toBuilder();
            return this;
        }

        @Override
        public RequestExecution build() {
            return new RequestExecutionImpl(this);
        }

        @Override
        public RequestExecutionBuilder toBuilder() {
            return this;
        }

        @Override
        public RequestExecutionBuilder prune() {
            super.prune();
            if (this.tradingEventsModel != null && !this.tradingEventsModel.prune().hasData()) {
                this.tradingEventsModel = null;
            }
            if (this.optionExercise != null && !this.optionExercise.prune().hasData()) {
                this.optionExercise = null;
            }
            if (this.partiesAndAccountsModel != null && !this.partiesAndAccountsModel.prune().hasData()) {
                this.partiesAndAccountsModel = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getTradingEventsModel() != null && this.getTradingEventsModel().hasData()) {
                return true;
            }
            if (this.getOptionExercise() != null && this.getOptionExercise().hasData()) {
                return true;
            }
            return this.getPartiesAndAccountsModel() != null && this.getPartiesAndAccountsModel().hasData();
        }

        @Override
        public RequestExecutionBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            RequestExecutionBuilder o = (RequestExecutionBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getTradingEventsModel(), (RosettaModelObjectBuilder)o.getTradingEventsModel(), this::setTradingEventsModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getOptionExercise(), (RosettaModelObjectBuilder)o.getOptionExercise(), this::setOptionExercise);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPartiesAndAccountsModel(), (RosettaModelObjectBuilder)o.getPartiesAndAccountsModel(), this::setPartiesAndAccountsModel);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            RequestExecution _that = (RequestExecution)this.getType().cast(o);
            if (!Objects.equals(this.tradingEventsModel, _that.getTradingEventsModel())) {
                return false;
            }
            if (!Objects.equals(this.optionExercise, _that.getOptionExercise())) {
                return false;
            }
            return Objects.equals(this.partiesAndAccountsModel, _that.getPartiesAndAccountsModel());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.tradingEventsModel != null ? this.tradingEventsModel.hashCode() : 0);
            _result = 31 * _result + (this.optionExercise != null ? this.optionExercise.hashCode() : 0);
            _result = 31 * _result + (this.partiesAndAccountsModel != null ? this.partiesAndAccountsModel.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "RequestExecutionBuilder {tradingEventsModel=" + this.tradingEventsModel + ", optionExercise=" + this.optionExercise + ", partiesAndAccountsModel=" + this.partiesAndAccountsModel + '}' + " " + super.toString();
        }
    }

    public static interface RequestExecutionBuilder
    extends RequestExecution,
    CorrectableRequestMessage.CorrectableRequestMessageBuilder {
        public TradingEventsModel.TradingEventsModelBuilder getOrCreateTradingEventsModel();

        @Override
        public TradingEventsModel.TradingEventsModelBuilder getTradingEventsModel();

        public OptionExercise.OptionExerciseBuilder getOrCreateOptionExercise();

        @Override
        public OptionExercise.OptionExerciseBuilder getOptionExercise();

        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getOrCreatePartiesAndAccountsModel();

        @Override
        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getPartiesAndAccountsModel();

        @Override
        public RequestExecutionBuilder setFpmlVersion(String var1);

        @Override
        public RequestExecutionBuilder setExpectedBuild(Integer var1);

        @Override
        public RequestExecutionBuilder setActualBuild(Integer var1);

        @Override
        public RequestExecutionBuilder setHeader(RequestMessageHeader var1);

        @Override
        public RequestExecutionBuilder setValidationModel(ValidationModel var1);

        @Override
        public RequestExecutionBuilder setIsCorrection(Boolean var1);

        @Override
        public RequestExecutionBuilder setCorrelationAndSequenceModel(CorrelationAndSequenceModel var1);

        @Override
        public RequestExecutionBuilder setOnBehalfOfModel(OnBehalfOfModel var1);

        public RequestExecutionBuilder setTradingEventsModel(TradingEventsModel var1);

        public RequestExecutionBuilder setOptionExercise(OptionExercise var1);

        public RequestExecutionBuilder setPartiesAndAccountsModel(PartiesAndAccountsModel var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("fpmlVersion"), String.class, (Object)this.getFpmlVersion(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("expectedBuild"), Integer.class, (Object)this.getExpectedBuild(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("actualBuild"), Integer.class, (Object)this.getActualBuild(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("header"), processor, RequestMessageHeader.RequestMessageHeaderBuilder.class, (RosettaModelObjectBuilder)this.getHeader(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("validationModel"), processor, ValidationModel.ValidationModelBuilder.class, (RosettaModelObjectBuilder)this.getValidationModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("isCorrection"), Boolean.class, (Object)this.getIsCorrection(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("correlationAndSequenceModel"), processor, CorrelationAndSequenceModel.CorrelationAndSequenceModelBuilder.class, (RosettaModelObjectBuilder)this.getCorrelationAndSequenceModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("onBehalfOfModel"), processor, OnBehalfOfModel.OnBehalfOfModelBuilder.class, (RosettaModelObjectBuilder)this.getOnBehalfOfModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("tradingEventsModel"), processor, TradingEventsModel.TradingEventsModelBuilder.class, this.getTradingEventsModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("optionExercise"), processor, OptionExercise.OptionExerciseBuilder.class, this.getOptionExercise(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("partiesAndAccountsModel"), processor, PartiesAndAccountsModel.PartiesAndAccountsModelBuilder.class, this.getPartiesAndAccountsModel(), new AttributeMeta[0]);
        }

        @Override
        public RequestExecutionBuilder prune();
    }

    public static class RequestExecutionImpl
    extends CorrectableRequestMessage.CorrectableRequestMessageImpl
    implements RequestExecution {
        private final TradingEventsModel tradingEventsModel;
        private final OptionExercise optionExercise;
        private final PartiesAndAccountsModel partiesAndAccountsModel;

        protected RequestExecutionImpl(RequestExecutionBuilder builder) {
            super(builder);
            this.tradingEventsModel = Optional.ofNullable(builder.getTradingEventsModel()).map(f -> f.build()).orElse(null);
            this.optionExercise = Optional.ofNullable(builder.getOptionExercise()).map(f -> f.build()).orElse(null);
            this.partiesAndAccountsModel = Optional.ofNullable(builder.getPartiesAndAccountsModel()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="tradingEventsModel")
        @RuneAttribute(value="tradingEventsModel")
        public TradingEventsModel getTradingEventsModel() {
            return this.tradingEventsModel;
        }

        @Override
        @RosettaAttribute(value="optionExercise")
        @RuneAttribute(value="optionExercise")
        public OptionExercise getOptionExercise() {
            return this.optionExercise;
        }

        @Override
        @RosettaAttribute(value="partiesAndAccountsModel", isRequired=true)
        @RuneAttribute(value="partiesAndAccountsModel", isRequired=true)
        public PartiesAndAccountsModel getPartiesAndAccountsModel() {
            return this.partiesAndAccountsModel;
        }

        @Override
        public RequestExecution build() {
            return this;
        }

        @Override
        public RequestExecutionBuilder toBuilder() {
            RequestExecutionBuilder builder = RequestExecution.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(RequestExecutionBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getTradingEventsModel()).ifPresent(builder::setTradingEventsModel);
            Optional.ofNullable(this.getOptionExercise()).ifPresent(builder::setOptionExercise);
            Optional.ofNullable(this.getPartiesAndAccountsModel()).ifPresent(builder::setPartiesAndAccountsModel);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            RequestExecution _that = (RequestExecution)this.getType().cast(o);
            if (!Objects.equals(this.tradingEventsModel, _that.getTradingEventsModel())) {
                return false;
            }
            if (!Objects.equals(this.optionExercise, _that.getOptionExercise())) {
                return false;
            }
            return Objects.equals(this.partiesAndAccountsModel, _that.getPartiesAndAccountsModel());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.tradingEventsModel != null ? this.tradingEventsModel.hashCode() : 0);
            _result = 31 * _result + (this.optionExercise != null ? this.optionExercise.hashCode() : 0);
            _result = 31 * _result + (this.partiesAndAccountsModel != null ? this.partiesAndAccountsModel.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "RequestExecution {tradingEventsModel=" + this.tradingEventsModel + ", optionExercise=" + this.optionExercise + ", partiesAndAccountsModel=" + this.partiesAndAccountsModel + '}' + " " + super.toString();
        }
    }
}

