/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.confirmation.processes;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.confirmation.processes.RequestedCollateralAllocationAction;
import fpml.consolidated.confirmation.processes.meta.RequestCollateralAllocationMeta;
import fpml.consolidated.doc.ValidationModel;
import fpml.consolidated.msg.CorrectableRequestMessage;
import fpml.consolidated.msg.CorrelationAndSequenceModel;
import fpml.consolidated.msg.RequestMessageHeader;
import fpml.consolidated.shared.OnBehalfOfModel;
import fpml.consolidated.shared.PartiesAndAccountsModel;
import fpml.consolidated.shared.PartyReference;
import fpml.consolidated.shared.ProposedCollateralAllocation;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="RequestCollateralAllocation", builder=RequestCollateralAllocationBuilderImpl.class, version="1.1.0")
@RuneDataType(value="RequestCollateralAllocation", model="fpml", builder=RequestCollateralAllocationBuilderImpl.class, version="1.1.0")
public interface RequestCollateralAllocation
extends CorrectableRequestMessage {
    public static final RequestCollateralAllocationMeta metaData = new RequestCollateralAllocationMeta();

    public String getServiceName();

    public RequestedCollateralAllocationAction getRequestedAction();

    public PartyReference getCollateralGiverPartyReference();

    public List<? extends ProposedCollateralAllocation> getCollateralAllocation();

    public PartiesAndAccountsModel getPartiesAndAccountsModel();

    @Override
    public RequestCollateralAllocation build();

    @Override
    public RequestCollateralAllocationBuilder toBuilder();

    public static RequestCollateralAllocationBuilder builder() {
        return new RequestCollateralAllocationBuilderImpl();
    }

    default public RosettaMetaData<? extends RequestCollateralAllocation> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends RequestCollateralAllocation> getType() {
        return RequestCollateralAllocation.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("fpmlVersion"), String.class, (Object)this.getFpmlVersion(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("expectedBuild"), Integer.class, (Object)this.getExpectedBuild(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("actualBuild"), Integer.class, (Object)this.getActualBuild(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("header"), processor, RequestMessageHeader.class, this.getHeader(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("validationModel"), processor, ValidationModel.class, this.getValidationModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("isCorrection"), Boolean.class, (Object)this.getIsCorrection(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("correlationAndSequenceModel"), processor, CorrelationAndSequenceModel.class, this.getCorrelationAndSequenceModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("onBehalfOfModel"), processor, OnBehalfOfModel.class, this.getOnBehalfOfModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("serviceName"), String.class, (Object)this.getServiceName(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("requestedAction"), processor, RequestedCollateralAllocationAction.class, this.getRequestedAction(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("collateralGiverPartyReference"), processor, PartyReference.class, this.getCollateralGiverPartyReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("collateralAllocation"), processor, ProposedCollateralAllocation.class, this.getCollateralAllocation(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("partiesAndAccountsModel"), processor, PartiesAndAccountsModel.class, this.getPartiesAndAccountsModel(), new AttributeMeta[0]);
    }

    public static class RequestCollateralAllocationBuilderImpl
    extends CorrectableRequestMessage.CorrectableRequestMessageBuilderImpl
    implements RequestCollateralAllocationBuilder {
        protected String serviceName;
        protected RequestedCollateralAllocationAction.RequestedCollateralAllocationActionBuilder requestedAction;
        protected PartyReference.PartyReferenceBuilder collateralGiverPartyReference;
        protected List<ProposedCollateralAllocation.ProposedCollateralAllocationBuilder> collateralAllocation = new ArrayList<ProposedCollateralAllocation.ProposedCollateralAllocationBuilder>();
        protected PartiesAndAccountsModel.PartiesAndAccountsModelBuilder partiesAndAccountsModel;

        @Override
        @RosettaAttribute(value="serviceName")
        @RuneAttribute(value="serviceName")
        public String getServiceName() {
            return this.serviceName;
        }

        @Override
        @RosettaAttribute(value="requestedAction")
        @RuneAttribute(value="requestedAction")
        public RequestedCollateralAllocationAction.RequestedCollateralAllocationActionBuilder getRequestedAction() {
            return this.requestedAction;
        }

        @Override
        public RequestedCollateralAllocationAction.RequestedCollateralAllocationActionBuilder getOrCreateRequestedAction() {
            RequestedCollateralAllocationAction.RequestedCollateralAllocationActionBuilder result = this.requestedAction != null ? this.requestedAction : (this.requestedAction = RequestedCollateralAllocationAction.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="collateralGiverPartyReference", isRequired=true)
        @RuneAttribute(value="collateralGiverPartyReference", isRequired=true)
        public PartyReference.PartyReferenceBuilder getCollateralGiverPartyReference() {
            return this.collateralGiverPartyReference;
        }

        @Override
        public PartyReference.PartyReferenceBuilder getOrCreateCollateralGiverPartyReference() {
            PartyReference.PartyReferenceBuilder result = this.collateralGiverPartyReference != null ? this.collateralGiverPartyReference : (this.collateralGiverPartyReference = PartyReference.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="collateralAllocation", isRequired=true)
        @RuneAttribute(value="collateralAllocation", isRequired=true)
        public List<? extends ProposedCollateralAllocation.ProposedCollateralAllocationBuilder> getCollateralAllocation() {
            return this.collateralAllocation;
        }

        @Override
        public ProposedCollateralAllocation.ProposedCollateralAllocationBuilder getOrCreateCollateralAllocation(int index) {
            if (this.collateralAllocation == null) {
                this.collateralAllocation = new ArrayList<ProposedCollateralAllocation.ProposedCollateralAllocationBuilder>();
            }
            return (ProposedCollateralAllocation.ProposedCollateralAllocationBuilder)this.getIndex(this.collateralAllocation, index, () -> {
                ProposedCollateralAllocation.ProposedCollateralAllocationBuilder newCollateralAllocation = ProposedCollateralAllocation.builder();
                return newCollateralAllocation;
            });
        }

        @Override
        @RosettaAttribute(value="partiesAndAccountsModel", isRequired=true)
        @RuneAttribute(value="partiesAndAccountsModel", isRequired=true)
        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getPartiesAndAccountsModel() {
            return this.partiesAndAccountsModel;
        }

        @Override
        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getOrCreatePartiesAndAccountsModel() {
            PartiesAndAccountsModel.PartiesAndAccountsModelBuilder result = this.partiesAndAccountsModel != null ? this.partiesAndAccountsModel : (this.partiesAndAccountsModel = PartiesAndAccountsModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="fpmlVersion", isRequired=true)
        @RuneAttribute(value="fpmlVersion", isRequired=true)
        public RequestCollateralAllocationBuilder setFpmlVersion(String _fpmlVersion) {
            this.fpmlVersion = _fpmlVersion == null ? null : _fpmlVersion;
            return this;
        }

        @Override
        @RosettaAttribute(value="expectedBuild")
        @RuneAttribute(value="expectedBuild")
        public RequestCollateralAllocationBuilder setExpectedBuild(Integer _expectedBuild) {
            this.expectedBuild = _expectedBuild == null ? null : _expectedBuild;
            return this;
        }

        @Override
        @RosettaAttribute(value="actualBuild")
        @RuneAttribute(value="actualBuild")
        public RequestCollateralAllocationBuilder setActualBuild(Integer _actualBuild) {
            this.actualBuild = _actualBuild == null ? null : _actualBuild;
            return this;
        }

        @Override
        @RosettaAttribute(value="header")
        @RuneAttribute(value="header")
        public RequestCollateralAllocationBuilder setHeader(RequestMessageHeader _header) {
            this.header = _header == null ? null : _header.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="validationModel", isRequired=true)
        @RuneAttribute(value="validationModel", isRequired=true)
        public RequestCollateralAllocationBuilder setValidationModel(ValidationModel _validationModel) {
            this.validationModel = _validationModel == null ? null : _validationModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="isCorrection")
        @RuneAttribute(value="isCorrection")
        public RequestCollateralAllocationBuilder setIsCorrection(Boolean _isCorrection) {
            this.isCorrection = _isCorrection == null ? null : _isCorrection;
            return this;
        }

        @Override
        @RosettaAttribute(value="correlationAndSequenceModel")
        @RuneAttribute(value="correlationAndSequenceModel")
        public RequestCollateralAllocationBuilder setCorrelationAndSequenceModel(CorrelationAndSequenceModel _correlationAndSequenceModel) {
            this.correlationAndSequenceModel = _correlationAndSequenceModel == null ? null : _correlationAndSequenceModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="onBehalfOfModel")
        @RuneAttribute(value="onBehalfOfModel")
        public RequestCollateralAllocationBuilder setOnBehalfOfModel(OnBehalfOfModel _onBehalfOfModel) {
            this.onBehalfOfModel = _onBehalfOfModel == null ? null : _onBehalfOfModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="serviceName")
        @RuneAttribute(value="serviceName")
        public RequestCollateralAllocationBuilder setServiceName(String _serviceName) {
            this.serviceName = _serviceName == null ? null : _serviceName;
            return this;
        }

        @Override
        @RosettaAttribute(value="requestedAction")
        @RuneAttribute(value="requestedAction")
        public RequestCollateralAllocationBuilder setRequestedAction(RequestedCollateralAllocationAction _requestedAction) {
            this.requestedAction = _requestedAction == null ? null : _requestedAction.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="collateralGiverPartyReference", isRequired=true)
        @RuneAttribute(value="collateralGiverPartyReference", isRequired=true)
        public RequestCollateralAllocationBuilder setCollateralGiverPartyReference(PartyReference _collateralGiverPartyReference) {
            this.collateralGiverPartyReference = _collateralGiverPartyReference == null ? null : _collateralGiverPartyReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="collateralAllocation", isRequired=true)
        @RuneAttribute(value="collateralAllocation", isRequired=true)
        public RequestCollateralAllocationBuilder addCollateralAllocation(ProposedCollateralAllocation _collateralAllocation) {
            if (_collateralAllocation != null) {
                this.collateralAllocation.add(_collateralAllocation.toBuilder());
            }
            return this;
        }

        @Override
        public RequestCollateralAllocationBuilder addCollateralAllocation(ProposedCollateralAllocation _collateralAllocation, int idx) {
            this.getIndex(this.collateralAllocation, idx, () -> _collateralAllocation.toBuilder());
            return this;
        }

        @Override
        public RequestCollateralAllocationBuilder addCollateralAllocation(List<? extends ProposedCollateralAllocation> collateralAllocations) {
            if (collateralAllocations != null) {
                for (ProposedCollateralAllocation proposedCollateralAllocation : collateralAllocations) {
                    this.collateralAllocation.add(proposedCollateralAllocation.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="collateralAllocation")
        public RequestCollateralAllocationBuilder setCollateralAllocation(List<? extends ProposedCollateralAllocation> collateralAllocations) {
            this.collateralAllocation = collateralAllocations == null ? new ArrayList<ProposedCollateralAllocation.ProposedCollateralAllocationBuilder>() : (List)collateralAllocations.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="partiesAndAccountsModel", isRequired=true)
        @RuneAttribute(value="partiesAndAccountsModel", isRequired=true)
        public RequestCollateralAllocationBuilder setPartiesAndAccountsModel(PartiesAndAccountsModel _partiesAndAccountsModel) {
            this.partiesAndAccountsModel = _partiesAndAccountsModel == null ? null : _partiesAndAccountsModel.toBuilder();
            return this;
        }

        @Override
        public RequestCollateralAllocation build() {
            return new RequestCollateralAllocationImpl(this);
        }

        @Override
        public RequestCollateralAllocationBuilder toBuilder() {
            return this;
        }

        @Override
        public RequestCollateralAllocationBuilder prune() {
            super.prune();
            if (this.requestedAction != null && !this.requestedAction.prune().hasData()) {
                this.requestedAction = null;
            }
            if (this.collateralGiverPartyReference != null && !this.collateralGiverPartyReference.prune().hasData()) {
                this.collateralGiverPartyReference = null;
            }
            this.collateralAllocation = this.collateralAllocation.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.partiesAndAccountsModel != null && !this.partiesAndAccountsModel.prune().hasData()) {
                this.partiesAndAccountsModel = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getServiceName() != null) {
                return true;
            }
            if (this.getRequestedAction() != null && this.getRequestedAction().hasData()) {
                return true;
            }
            if (this.getCollateralGiverPartyReference() != null && this.getCollateralGiverPartyReference().hasData()) {
                return true;
            }
            if (this.getCollateralAllocation() != null && this.getCollateralAllocation().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getPartiesAndAccountsModel() != null && this.getPartiesAndAccountsModel().hasData();
        }

        @Override
        public RequestCollateralAllocationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            RequestCollateralAllocationBuilder o = (RequestCollateralAllocationBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getRequestedAction(), (RosettaModelObjectBuilder)o.getRequestedAction(), this::setRequestedAction);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCollateralGiverPartyReference(), (RosettaModelObjectBuilder)o.getCollateralGiverPartyReference(), this::setCollateralGiverPartyReference);
            merger.mergeRosetta(this.getCollateralAllocation(), o.getCollateralAllocation(), this::getOrCreateCollateralAllocation);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPartiesAndAccountsModel(), (RosettaModelObjectBuilder)o.getPartiesAndAccountsModel(), this::setPartiesAndAccountsModel);
            merger.mergeBasic((Object)this.getServiceName(), (Object)o.getServiceName(), this::setServiceName, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            RequestCollateralAllocation _that = (RequestCollateralAllocation)this.getType().cast(o);
            if (!Objects.equals(this.serviceName, _that.getServiceName())) {
                return false;
            }
            if (!Objects.equals(this.requestedAction, _that.getRequestedAction())) {
                return false;
            }
            if (!Objects.equals(this.collateralGiverPartyReference, _that.getCollateralGiverPartyReference())) {
                return false;
            }
            if (!ListEquals.listEquals(this.collateralAllocation, _that.getCollateralAllocation())) {
                return false;
            }
            return Objects.equals(this.partiesAndAccountsModel, _that.getPartiesAndAccountsModel());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.serviceName != null ? this.serviceName.hashCode() : 0);
            _result = 31 * _result + (this.requestedAction != null ? this.requestedAction.hashCode() : 0);
            _result = 31 * _result + (this.collateralGiverPartyReference != null ? this.collateralGiverPartyReference.hashCode() : 0);
            _result = 31 * _result + (this.collateralAllocation != null ? this.collateralAllocation.hashCode() : 0);
            _result = 31 * _result + (this.partiesAndAccountsModel != null ? this.partiesAndAccountsModel.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "RequestCollateralAllocationBuilder {serviceName=" + this.serviceName + ", requestedAction=" + this.requestedAction + ", collateralGiverPartyReference=" + this.collateralGiverPartyReference + ", collateralAllocation=" + this.collateralAllocation + ", partiesAndAccountsModel=" + this.partiesAndAccountsModel + '}' + " " + super.toString();
        }
    }

    public static interface RequestCollateralAllocationBuilder
    extends RequestCollateralAllocation,
    CorrectableRequestMessage.CorrectableRequestMessageBuilder {
        public RequestedCollateralAllocationAction.RequestedCollateralAllocationActionBuilder getOrCreateRequestedAction();

        @Override
        public RequestedCollateralAllocationAction.RequestedCollateralAllocationActionBuilder getRequestedAction();

        public PartyReference.PartyReferenceBuilder getOrCreateCollateralGiverPartyReference();

        @Override
        public PartyReference.PartyReferenceBuilder getCollateralGiverPartyReference();

        public ProposedCollateralAllocation.ProposedCollateralAllocationBuilder getOrCreateCollateralAllocation(int var1);

        public List<? extends ProposedCollateralAllocation.ProposedCollateralAllocationBuilder> getCollateralAllocation();

        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getOrCreatePartiesAndAccountsModel();

        @Override
        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getPartiesAndAccountsModel();

        @Override
        public RequestCollateralAllocationBuilder setFpmlVersion(String var1);

        @Override
        public RequestCollateralAllocationBuilder setExpectedBuild(Integer var1);

        @Override
        public RequestCollateralAllocationBuilder setActualBuild(Integer var1);

        @Override
        public RequestCollateralAllocationBuilder setHeader(RequestMessageHeader var1);

        @Override
        public RequestCollateralAllocationBuilder setValidationModel(ValidationModel var1);

        @Override
        public RequestCollateralAllocationBuilder setIsCorrection(Boolean var1);

        @Override
        public RequestCollateralAllocationBuilder setCorrelationAndSequenceModel(CorrelationAndSequenceModel var1);

        @Override
        public RequestCollateralAllocationBuilder setOnBehalfOfModel(OnBehalfOfModel var1);

        public RequestCollateralAllocationBuilder setServiceName(String var1);

        public RequestCollateralAllocationBuilder setRequestedAction(RequestedCollateralAllocationAction var1);

        public RequestCollateralAllocationBuilder setCollateralGiverPartyReference(PartyReference var1);

        public RequestCollateralAllocationBuilder addCollateralAllocation(ProposedCollateralAllocation var1);

        public RequestCollateralAllocationBuilder addCollateralAllocation(ProposedCollateralAllocation var1, int var2);

        public RequestCollateralAllocationBuilder addCollateralAllocation(List<? extends ProposedCollateralAllocation> var1);

        public RequestCollateralAllocationBuilder setCollateralAllocation(List<? extends ProposedCollateralAllocation> var1);

        public RequestCollateralAllocationBuilder setPartiesAndAccountsModel(PartiesAndAccountsModel var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("fpmlVersion"), String.class, (Object)this.getFpmlVersion(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("expectedBuild"), Integer.class, (Object)this.getExpectedBuild(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("actualBuild"), Integer.class, (Object)this.getActualBuild(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("header"), processor, RequestMessageHeader.RequestMessageHeaderBuilder.class, (RosettaModelObjectBuilder)this.getHeader(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("validationModel"), processor, ValidationModel.ValidationModelBuilder.class, (RosettaModelObjectBuilder)this.getValidationModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("isCorrection"), Boolean.class, (Object)this.getIsCorrection(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("correlationAndSequenceModel"), processor, CorrelationAndSequenceModel.CorrelationAndSequenceModelBuilder.class, (RosettaModelObjectBuilder)this.getCorrelationAndSequenceModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("onBehalfOfModel"), processor, OnBehalfOfModel.OnBehalfOfModelBuilder.class, (RosettaModelObjectBuilder)this.getOnBehalfOfModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("serviceName"), String.class, (Object)this.getServiceName(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("requestedAction"), processor, RequestedCollateralAllocationAction.RequestedCollateralAllocationActionBuilder.class, this.getRequestedAction(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("collateralGiverPartyReference"), processor, PartyReference.PartyReferenceBuilder.class, this.getCollateralGiverPartyReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("collateralAllocation"), processor, ProposedCollateralAllocation.ProposedCollateralAllocationBuilder.class, this.getCollateralAllocation(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("partiesAndAccountsModel"), processor, PartiesAndAccountsModel.PartiesAndAccountsModelBuilder.class, this.getPartiesAndAccountsModel(), new AttributeMeta[0]);
        }

        @Override
        public RequestCollateralAllocationBuilder prune();
    }

    public static class RequestCollateralAllocationImpl
    extends CorrectableRequestMessage.CorrectableRequestMessageImpl
    implements RequestCollateralAllocation {
        private final String serviceName;
        private final RequestedCollateralAllocationAction requestedAction;
        private final PartyReference collateralGiverPartyReference;
        private final List<? extends ProposedCollateralAllocation> collateralAllocation;
        private final PartiesAndAccountsModel partiesAndAccountsModel;

        protected RequestCollateralAllocationImpl(RequestCollateralAllocationBuilder builder) {
            super(builder);
            this.serviceName = builder.getServiceName();
            this.requestedAction = Optional.ofNullable(builder.getRequestedAction()).map(f -> f.build()).orElse(null);
            this.collateralGiverPartyReference = Optional.ofNullable(builder.getCollateralGiverPartyReference()).map(f -> f.build()).orElse(null);
            this.collateralAllocation = Optional.ofNullable(builder.getCollateralAllocation()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.partiesAndAccountsModel = Optional.ofNullable(builder.getPartiesAndAccountsModel()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="serviceName")
        @RuneAttribute(value="serviceName")
        public String getServiceName() {
            return this.serviceName;
        }

        @Override
        @RosettaAttribute(value="requestedAction")
        @RuneAttribute(value="requestedAction")
        public RequestedCollateralAllocationAction getRequestedAction() {
            return this.requestedAction;
        }

        @Override
        @RosettaAttribute(value="collateralGiverPartyReference", isRequired=true)
        @RuneAttribute(value="collateralGiverPartyReference", isRequired=true)
        public PartyReference getCollateralGiverPartyReference() {
            return this.collateralGiverPartyReference;
        }

        @Override
        @RosettaAttribute(value="collateralAllocation", isRequired=true)
        @RuneAttribute(value="collateralAllocation", isRequired=true)
        public List<? extends ProposedCollateralAllocation> getCollateralAllocation() {
            return this.collateralAllocation;
        }

        @Override
        @RosettaAttribute(value="partiesAndAccountsModel", isRequired=true)
        @RuneAttribute(value="partiesAndAccountsModel", isRequired=true)
        public PartiesAndAccountsModel getPartiesAndAccountsModel() {
            return this.partiesAndAccountsModel;
        }

        @Override
        public RequestCollateralAllocation build() {
            return this;
        }

        @Override
        public RequestCollateralAllocationBuilder toBuilder() {
            RequestCollateralAllocationBuilder builder = RequestCollateralAllocation.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(RequestCollateralAllocationBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getServiceName()).ifPresent(builder::setServiceName);
            Optional.ofNullable(this.getRequestedAction()).ifPresent(builder::setRequestedAction);
            Optional.ofNullable(this.getCollateralGiverPartyReference()).ifPresent(builder::setCollateralGiverPartyReference);
            Optional.ofNullable(this.getCollateralAllocation()).ifPresent(builder::setCollateralAllocation);
            Optional.ofNullable(this.getPartiesAndAccountsModel()).ifPresent(builder::setPartiesAndAccountsModel);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            RequestCollateralAllocation _that = (RequestCollateralAllocation)this.getType().cast(o);
            if (!Objects.equals(this.serviceName, _that.getServiceName())) {
                return false;
            }
            if (!Objects.equals(this.requestedAction, _that.getRequestedAction())) {
                return false;
            }
            if (!Objects.equals(this.collateralGiverPartyReference, _that.getCollateralGiverPartyReference())) {
                return false;
            }
            if (!ListEquals.listEquals(this.collateralAllocation, _that.getCollateralAllocation())) {
                return false;
            }
            return Objects.equals(this.partiesAndAccountsModel, _that.getPartiesAndAccountsModel());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.serviceName != null ? this.serviceName.hashCode() : 0);
            _result = 31 * _result + (this.requestedAction != null ? this.requestedAction.hashCode() : 0);
            _result = 31 * _result + (this.collateralGiverPartyReference != null ? this.collateralGiverPartyReference.hashCode() : 0);
            _result = 31 * _result + (this.collateralAllocation != null ? this.collateralAllocation.hashCode() : 0);
            _result = 31 * _result + (this.partiesAndAccountsModel != null ? this.partiesAndAccountsModel.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "RequestCollateralAllocation {serviceName=" + this.serviceName + ", requestedAction=" + this.requestedAction + ", collateralGiverPartyReference=" + this.collateralGiverPartyReference + ", collateralAllocation=" + this.collateralAllocation + ", partiesAndAccountsModel=" + this.partiesAndAccountsModel + '}' + " " + super.toString();
        }
    }
}

