/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.confirmation.processes;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.business.events.DeClear;
import fpml.consolidated.business.events.EventValuationModel;
import fpml.consolidated.business.events.TradingEventsModel;
import fpml.consolidated.confirmation.processes.meta.RequestClearingMeta;
import fpml.consolidated.doc.ValidationModel;
import fpml.consolidated.msg.CorrectableRequestMessage;
import fpml.consolidated.msg.CorrelationAndSequenceModel;
import fpml.consolidated.msg.PortfolioReferenceModel;
import fpml.consolidated.msg.RequestMessageHeader;
import fpml.consolidated.shared.OnBehalfOfModel;
import fpml.consolidated.shared.PartiesAndAccountsModel;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="RequestClearing", builder=RequestClearingBuilderImpl.class, version="1.1.0")
@RuneDataType(value="RequestClearing", model="fpml", builder=RequestClearingBuilderImpl.class, version="1.1.0")
public interface RequestClearing
extends CorrectableRequestMessage {
    public static final RequestClearingMeta metaData = new RequestClearingMeta();

    public PortfolioReferenceModel getPortfolioReferenceModel();

    public TradingEventsModel getTradingEventsModel();

    public DeClear getDeClear();

    public EventValuationModel getEventValuationModel();

    public PartiesAndAccountsModel getPartiesAndAccountsModel();

    @Override
    public RequestClearing build();

    @Override
    public RequestClearingBuilder toBuilder();

    public static RequestClearingBuilder builder() {
        return new RequestClearingBuilderImpl();
    }

    default public RosettaMetaData<? extends RequestClearing> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends RequestClearing> getType() {
        return RequestClearing.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("fpmlVersion"), String.class, (Object)this.getFpmlVersion(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("expectedBuild"), Integer.class, (Object)this.getExpectedBuild(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("actualBuild"), Integer.class, (Object)this.getActualBuild(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("header"), processor, RequestMessageHeader.class, this.getHeader(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("validationModel"), processor, ValidationModel.class, this.getValidationModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("isCorrection"), Boolean.class, (Object)this.getIsCorrection(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("correlationAndSequenceModel"), processor, CorrelationAndSequenceModel.class, this.getCorrelationAndSequenceModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("onBehalfOfModel"), processor, OnBehalfOfModel.class, this.getOnBehalfOfModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("portfolioReferenceModel"), processor, PortfolioReferenceModel.class, this.getPortfolioReferenceModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("tradingEventsModel"), processor, TradingEventsModel.class, this.getTradingEventsModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("deClear"), processor, DeClear.class, this.getDeClear(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("eventValuationModel"), processor, EventValuationModel.class, this.getEventValuationModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("partiesAndAccountsModel"), processor, PartiesAndAccountsModel.class, this.getPartiesAndAccountsModel(), new AttributeMeta[0]);
    }

    public static class RequestClearingBuilderImpl
    extends CorrectableRequestMessage.CorrectableRequestMessageBuilderImpl
    implements RequestClearingBuilder {
        protected PortfolioReferenceModel.PortfolioReferenceModelBuilder portfolioReferenceModel;
        protected TradingEventsModel.TradingEventsModelBuilder tradingEventsModel;
        protected DeClear.DeClearBuilder deClear;
        protected EventValuationModel.EventValuationModelBuilder eventValuationModel;
        protected PartiesAndAccountsModel.PartiesAndAccountsModelBuilder partiesAndAccountsModel;

        @Override
        @RosettaAttribute(value="portfolioReferenceModel")
        @RuneAttribute(value="portfolioReferenceModel")
        public PortfolioReferenceModel.PortfolioReferenceModelBuilder getPortfolioReferenceModel() {
            return this.portfolioReferenceModel;
        }

        @Override
        public PortfolioReferenceModel.PortfolioReferenceModelBuilder getOrCreatePortfolioReferenceModel() {
            PortfolioReferenceModel.PortfolioReferenceModelBuilder result = this.portfolioReferenceModel != null ? this.portfolioReferenceModel : (this.portfolioReferenceModel = PortfolioReferenceModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="tradingEventsModel")
        @RuneAttribute(value="tradingEventsModel")
        public TradingEventsModel.TradingEventsModelBuilder getTradingEventsModel() {
            return this.tradingEventsModel;
        }

        @Override
        public TradingEventsModel.TradingEventsModelBuilder getOrCreateTradingEventsModel() {
            TradingEventsModel.TradingEventsModelBuilder result = this.tradingEventsModel != null ? this.tradingEventsModel : (this.tradingEventsModel = TradingEventsModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="deClear")
        @RuneAttribute(value="deClear")
        public DeClear.DeClearBuilder getDeClear() {
            return this.deClear;
        }

        @Override
        public DeClear.DeClearBuilder getOrCreateDeClear() {
            DeClear.DeClearBuilder result = this.deClear != null ? this.deClear : (this.deClear = DeClear.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="eventValuationModel")
        @RuneAttribute(value="eventValuationModel")
        public EventValuationModel.EventValuationModelBuilder getEventValuationModel() {
            return this.eventValuationModel;
        }

        @Override
        public EventValuationModel.EventValuationModelBuilder getOrCreateEventValuationModel() {
            EventValuationModel.EventValuationModelBuilder result = this.eventValuationModel != null ? this.eventValuationModel : (this.eventValuationModel = EventValuationModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="partiesAndAccountsModel", isRequired=true)
        @RuneAttribute(value="partiesAndAccountsModel", isRequired=true)
        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getPartiesAndAccountsModel() {
            return this.partiesAndAccountsModel;
        }

        @Override
        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getOrCreatePartiesAndAccountsModel() {
            PartiesAndAccountsModel.PartiesAndAccountsModelBuilder result = this.partiesAndAccountsModel != null ? this.partiesAndAccountsModel : (this.partiesAndAccountsModel = PartiesAndAccountsModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="fpmlVersion", isRequired=true)
        @RuneAttribute(value="fpmlVersion", isRequired=true)
        public RequestClearingBuilder setFpmlVersion(String _fpmlVersion) {
            this.fpmlVersion = _fpmlVersion == null ? null : _fpmlVersion;
            return this;
        }

        @Override
        @RosettaAttribute(value="expectedBuild")
        @RuneAttribute(value="expectedBuild")
        public RequestClearingBuilder setExpectedBuild(Integer _expectedBuild) {
            this.expectedBuild = _expectedBuild == null ? null : _expectedBuild;
            return this;
        }

        @Override
        @RosettaAttribute(value="actualBuild")
        @RuneAttribute(value="actualBuild")
        public RequestClearingBuilder setActualBuild(Integer _actualBuild) {
            this.actualBuild = _actualBuild == null ? null : _actualBuild;
            return this;
        }

        @Override
        @RosettaAttribute(value="header")
        @RuneAttribute(value="header")
        public RequestClearingBuilder setHeader(RequestMessageHeader _header) {
            this.header = _header == null ? null : _header.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="validationModel", isRequired=true)
        @RuneAttribute(value="validationModel", isRequired=true)
        public RequestClearingBuilder setValidationModel(ValidationModel _validationModel) {
            this.validationModel = _validationModel == null ? null : _validationModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="isCorrection")
        @RuneAttribute(value="isCorrection")
        public RequestClearingBuilder setIsCorrection(Boolean _isCorrection) {
            this.isCorrection = _isCorrection == null ? null : _isCorrection;
            return this;
        }

        @Override
        @RosettaAttribute(value="correlationAndSequenceModel")
        @RuneAttribute(value="correlationAndSequenceModel")
        public RequestClearingBuilder setCorrelationAndSequenceModel(CorrelationAndSequenceModel _correlationAndSequenceModel) {
            this.correlationAndSequenceModel = _correlationAndSequenceModel == null ? null : _correlationAndSequenceModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="onBehalfOfModel")
        @RuneAttribute(value="onBehalfOfModel")
        public RequestClearingBuilder setOnBehalfOfModel(OnBehalfOfModel _onBehalfOfModel) {
            this.onBehalfOfModel = _onBehalfOfModel == null ? null : _onBehalfOfModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="portfolioReferenceModel")
        @RuneAttribute(value="portfolioReferenceModel")
        public RequestClearingBuilder setPortfolioReferenceModel(PortfolioReferenceModel _portfolioReferenceModel) {
            this.portfolioReferenceModel = _portfolioReferenceModel == null ? null : _portfolioReferenceModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="tradingEventsModel")
        @RuneAttribute(value="tradingEventsModel")
        public RequestClearingBuilder setTradingEventsModel(TradingEventsModel _tradingEventsModel) {
            this.tradingEventsModel = _tradingEventsModel == null ? null : _tradingEventsModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="deClear")
        @RuneAttribute(value="deClear")
        public RequestClearingBuilder setDeClear(DeClear _deClear) {
            this.deClear = _deClear == null ? null : _deClear.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="eventValuationModel")
        @RuneAttribute(value="eventValuationModel")
        public RequestClearingBuilder setEventValuationModel(EventValuationModel _eventValuationModel) {
            this.eventValuationModel = _eventValuationModel == null ? null : _eventValuationModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="partiesAndAccountsModel", isRequired=true)
        @RuneAttribute(value="partiesAndAccountsModel", isRequired=true)
        public RequestClearingBuilder setPartiesAndAccountsModel(PartiesAndAccountsModel _partiesAndAccountsModel) {
            this.partiesAndAccountsModel = _partiesAndAccountsModel == null ? null : _partiesAndAccountsModel.toBuilder();
            return this;
        }

        @Override
        public RequestClearing build() {
            return new RequestClearingImpl(this);
        }

        @Override
        public RequestClearingBuilder toBuilder() {
            return this;
        }

        @Override
        public RequestClearingBuilder prune() {
            super.prune();
            if (this.portfolioReferenceModel != null && !this.portfolioReferenceModel.prune().hasData()) {
                this.portfolioReferenceModel = null;
            }
            if (this.tradingEventsModel != null && !this.tradingEventsModel.prune().hasData()) {
                this.tradingEventsModel = null;
            }
            if (this.deClear != null && !this.deClear.prune().hasData()) {
                this.deClear = null;
            }
            if (this.eventValuationModel != null && !this.eventValuationModel.prune().hasData()) {
                this.eventValuationModel = null;
            }
            if (this.partiesAndAccountsModel != null && !this.partiesAndAccountsModel.prune().hasData()) {
                this.partiesAndAccountsModel = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getPortfolioReferenceModel() != null && this.getPortfolioReferenceModel().hasData()) {
                return true;
            }
            if (this.getTradingEventsModel() != null && this.getTradingEventsModel().hasData()) {
                return true;
            }
            if (this.getDeClear() != null && this.getDeClear().hasData()) {
                return true;
            }
            if (this.getEventValuationModel() != null && this.getEventValuationModel().hasData()) {
                return true;
            }
            return this.getPartiesAndAccountsModel() != null && this.getPartiesAndAccountsModel().hasData();
        }

        @Override
        public RequestClearingBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            RequestClearingBuilder o = (RequestClearingBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPortfolioReferenceModel(), (RosettaModelObjectBuilder)o.getPortfolioReferenceModel(), this::setPortfolioReferenceModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getTradingEventsModel(), (RosettaModelObjectBuilder)o.getTradingEventsModel(), this::setTradingEventsModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDeClear(), (RosettaModelObjectBuilder)o.getDeClear(), this::setDeClear);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getEventValuationModel(), (RosettaModelObjectBuilder)o.getEventValuationModel(), this::setEventValuationModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPartiesAndAccountsModel(), (RosettaModelObjectBuilder)o.getPartiesAndAccountsModel(), this::setPartiesAndAccountsModel);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            RequestClearing _that = (RequestClearing)this.getType().cast(o);
            if (!Objects.equals(this.portfolioReferenceModel, _that.getPortfolioReferenceModel())) {
                return false;
            }
            if (!Objects.equals(this.tradingEventsModel, _that.getTradingEventsModel())) {
                return false;
            }
            if (!Objects.equals(this.deClear, _that.getDeClear())) {
                return false;
            }
            if (!Objects.equals(this.eventValuationModel, _that.getEventValuationModel())) {
                return false;
            }
            return Objects.equals(this.partiesAndAccountsModel, _that.getPartiesAndAccountsModel());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.portfolioReferenceModel != null ? this.portfolioReferenceModel.hashCode() : 0);
            _result = 31 * _result + (this.tradingEventsModel != null ? this.tradingEventsModel.hashCode() : 0);
            _result = 31 * _result + (this.deClear != null ? this.deClear.hashCode() : 0);
            _result = 31 * _result + (this.eventValuationModel != null ? this.eventValuationModel.hashCode() : 0);
            _result = 31 * _result + (this.partiesAndAccountsModel != null ? this.partiesAndAccountsModel.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "RequestClearingBuilder {portfolioReferenceModel=" + this.portfolioReferenceModel + ", tradingEventsModel=" + this.tradingEventsModel + ", deClear=" + this.deClear + ", eventValuationModel=" + this.eventValuationModel + ", partiesAndAccountsModel=" + this.partiesAndAccountsModel + '}' + " " + super.toString();
        }
    }

    public static interface RequestClearingBuilder
    extends RequestClearing,
    CorrectableRequestMessage.CorrectableRequestMessageBuilder {
        public PortfolioReferenceModel.PortfolioReferenceModelBuilder getOrCreatePortfolioReferenceModel();

        @Override
        public PortfolioReferenceModel.PortfolioReferenceModelBuilder getPortfolioReferenceModel();

        public TradingEventsModel.TradingEventsModelBuilder getOrCreateTradingEventsModel();

        @Override
        public TradingEventsModel.TradingEventsModelBuilder getTradingEventsModel();

        public DeClear.DeClearBuilder getOrCreateDeClear();

        @Override
        public DeClear.DeClearBuilder getDeClear();

        public EventValuationModel.EventValuationModelBuilder getOrCreateEventValuationModel();

        @Override
        public EventValuationModel.EventValuationModelBuilder getEventValuationModel();

        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getOrCreatePartiesAndAccountsModel();

        @Override
        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getPartiesAndAccountsModel();

        @Override
        public RequestClearingBuilder setFpmlVersion(String var1);

        @Override
        public RequestClearingBuilder setExpectedBuild(Integer var1);

        @Override
        public RequestClearingBuilder setActualBuild(Integer var1);

        @Override
        public RequestClearingBuilder setHeader(RequestMessageHeader var1);

        @Override
        public RequestClearingBuilder setValidationModel(ValidationModel var1);

        @Override
        public RequestClearingBuilder setIsCorrection(Boolean var1);

        @Override
        public RequestClearingBuilder setCorrelationAndSequenceModel(CorrelationAndSequenceModel var1);

        @Override
        public RequestClearingBuilder setOnBehalfOfModel(OnBehalfOfModel var1);

        public RequestClearingBuilder setPortfolioReferenceModel(PortfolioReferenceModel var1);

        public RequestClearingBuilder setTradingEventsModel(TradingEventsModel var1);

        public RequestClearingBuilder setDeClear(DeClear var1);

        public RequestClearingBuilder setEventValuationModel(EventValuationModel var1);

        public RequestClearingBuilder setPartiesAndAccountsModel(PartiesAndAccountsModel var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("fpmlVersion"), String.class, (Object)this.getFpmlVersion(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("expectedBuild"), Integer.class, (Object)this.getExpectedBuild(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("actualBuild"), Integer.class, (Object)this.getActualBuild(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("header"), processor, RequestMessageHeader.RequestMessageHeaderBuilder.class, (RosettaModelObjectBuilder)this.getHeader(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("validationModel"), processor, ValidationModel.ValidationModelBuilder.class, (RosettaModelObjectBuilder)this.getValidationModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("isCorrection"), Boolean.class, (Object)this.getIsCorrection(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("correlationAndSequenceModel"), processor, CorrelationAndSequenceModel.CorrelationAndSequenceModelBuilder.class, (RosettaModelObjectBuilder)this.getCorrelationAndSequenceModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("onBehalfOfModel"), processor, OnBehalfOfModel.OnBehalfOfModelBuilder.class, (RosettaModelObjectBuilder)this.getOnBehalfOfModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("portfolioReferenceModel"), processor, PortfolioReferenceModel.PortfolioReferenceModelBuilder.class, this.getPortfolioReferenceModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("tradingEventsModel"), processor, TradingEventsModel.TradingEventsModelBuilder.class, this.getTradingEventsModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("deClear"), processor, DeClear.DeClearBuilder.class, this.getDeClear(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("eventValuationModel"), processor, EventValuationModel.EventValuationModelBuilder.class, this.getEventValuationModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("partiesAndAccountsModel"), processor, PartiesAndAccountsModel.PartiesAndAccountsModelBuilder.class, this.getPartiesAndAccountsModel(), new AttributeMeta[0]);
        }

        @Override
        public RequestClearingBuilder prune();
    }

    public static class RequestClearingImpl
    extends CorrectableRequestMessage.CorrectableRequestMessageImpl
    implements RequestClearing {
        private final PortfolioReferenceModel portfolioReferenceModel;
        private final TradingEventsModel tradingEventsModel;
        private final DeClear deClear;
        private final EventValuationModel eventValuationModel;
        private final PartiesAndAccountsModel partiesAndAccountsModel;

        protected RequestClearingImpl(RequestClearingBuilder builder) {
            super(builder);
            this.portfolioReferenceModel = Optional.ofNullable(builder.getPortfolioReferenceModel()).map(f -> f.build()).orElse(null);
            this.tradingEventsModel = Optional.ofNullable(builder.getTradingEventsModel()).map(f -> f.build()).orElse(null);
            this.deClear = Optional.ofNullable(builder.getDeClear()).map(f -> f.build()).orElse(null);
            this.eventValuationModel = Optional.ofNullable(builder.getEventValuationModel()).map(f -> f.build()).orElse(null);
            this.partiesAndAccountsModel = Optional.ofNullable(builder.getPartiesAndAccountsModel()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="portfolioReferenceModel")
        @RuneAttribute(value="portfolioReferenceModel")
        public PortfolioReferenceModel getPortfolioReferenceModel() {
            return this.portfolioReferenceModel;
        }

        @Override
        @RosettaAttribute(value="tradingEventsModel")
        @RuneAttribute(value="tradingEventsModel")
        public TradingEventsModel getTradingEventsModel() {
            return this.tradingEventsModel;
        }

        @Override
        @RosettaAttribute(value="deClear")
        @RuneAttribute(value="deClear")
        public DeClear getDeClear() {
            return this.deClear;
        }

        @Override
        @RosettaAttribute(value="eventValuationModel")
        @RuneAttribute(value="eventValuationModel")
        public EventValuationModel getEventValuationModel() {
            return this.eventValuationModel;
        }

        @Override
        @RosettaAttribute(value="partiesAndAccountsModel", isRequired=true)
        @RuneAttribute(value="partiesAndAccountsModel", isRequired=true)
        public PartiesAndAccountsModel getPartiesAndAccountsModel() {
            return this.partiesAndAccountsModel;
        }

        @Override
        public RequestClearing build() {
            return this;
        }

        @Override
        public RequestClearingBuilder toBuilder() {
            RequestClearingBuilder builder = RequestClearing.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(RequestClearingBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getPortfolioReferenceModel()).ifPresent(builder::setPortfolioReferenceModel);
            Optional.ofNullable(this.getTradingEventsModel()).ifPresent(builder::setTradingEventsModel);
            Optional.ofNullable(this.getDeClear()).ifPresent(builder::setDeClear);
            Optional.ofNullable(this.getEventValuationModel()).ifPresent(builder::setEventValuationModel);
            Optional.ofNullable(this.getPartiesAndAccountsModel()).ifPresent(builder::setPartiesAndAccountsModel);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            RequestClearing _that = (RequestClearing)this.getType().cast(o);
            if (!Objects.equals(this.portfolioReferenceModel, _that.getPortfolioReferenceModel())) {
                return false;
            }
            if (!Objects.equals(this.tradingEventsModel, _that.getTradingEventsModel())) {
                return false;
            }
            if (!Objects.equals(this.deClear, _that.getDeClear())) {
                return false;
            }
            if (!Objects.equals(this.eventValuationModel, _that.getEventValuationModel())) {
                return false;
            }
            return Objects.equals(this.partiesAndAccountsModel, _that.getPartiesAndAccountsModel());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.portfolioReferenceModel != null ? this.portfolioReferenceModel.hashCode() : 0);
            _result = 31 * _result + (this.tradingEventsModel != null ? this.tradingEventsModel.hashCode() : 0);
            _result = 31 * _result + (this.deClear != null ? this.deClear.hashCode() : 0);
            _result = 31 * _result + (this.eventValuationModel != null ? this.eventValuationModel.hashCode() : 0);
            _result = 31 * _result + (this.partiesAndAccountsModel != null ? this.partiesAndAccountsModel.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "RequestClearing {portfolioReferenceModel=" + this.portfolioReferenceModel + ", tradingEventsModel=" + this.tradingEventsModel + ", deClear=" + this.deClear + ", eventValuationModel=" + this.eventValuationModel + ", partiesAndAccountsModel=" + this.partiesAndAccountsModel + '}' + " " + super.toString();
        }
    }
}

