/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.confirmation.processes;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.confirmation.processes.meta.RequestAllocationRetractedMeta;
import fpml.consolidated.doc.Allocations;
import fpml.consolidated.doc.TradeIdentifier;
import fpml.consolidated.doc.ValidationModel;
import fpml.consolidated.msg.CorrelationAndSequenceModel;
import fpml.consolidated.msg.NonCorrectableRequestMessage;
import fpml.consolidated.msg.RequestMessageHeader;
import fpml.consolidated.shared.OnBehalfOfModel;
import fpml.consolidated.shared.PartiesAndAccountsModel;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="RequestAllocationRetracted", builder=RequestAllocationRetractedBuilderImpl.class, version="1.1.0")
@RuneDataType(value="RequestAllocationRetracted", model="fpml", builder=RequestAllocationRetractedBuilderImpl.class, version="1.1.0")
public interface RequestAllocationRetracted
extends NonCorrectableRequestMessage {
    public static final RequestAllocationRetractedMeta metaData = new RequestAllocationRetractedMeta();

    public TradeIdentifier getBlockTradeIdentifier();

    public Allocations getAllocations();

    public PartiesAndAccountsModel getPartiesAndAccountsModel();

    @Override
    public RequestAllocationRetracted build();

    @Override
    public RequestAllocationRetractedBuilder toBuilder();

    public static RequestAllocationRetractedBuilder builder() {
        return new RequestAllocationRetractedBuilderImpl();
    }

    default public RosettaMetaData<? extends RequestAllocationRetracted> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends RequestAllocationRetracted> getType() {
        return RequestAllocationRetracted.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("fpmlVersion"), String.class, (Object)this.getFpmlVersion(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("expectedBuild"), Integer.class, (Object)this.getExpectedBuild(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("actualBuild"), Integer.class, (Object)this.getActualBuild(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("header"), processor, RequestMessageHeader.class, this.getHeader(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("validationModel"), processor, ValidationModel.class, this.getValidationModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("correlationAndSequenceModel"), processor, CorrelationAndSequenceModel.class, this.getCorrelationAndSequenceModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("onBehalfOfModel"), processor, OnBehalfOfModel.class, this.getOnBehalfOfModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("blockTradeIdentifier"), processor, TradeIdentifier.class, this.getBlockTradeIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("allocations"), processor, Allocations.class, this.getAllocations(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("partiesAndAccountsModel"), processor, PartiesAndAccountsModel.class, this.getPartiesAndAccountsModel(), new AttributeMeta[0]);
    }

    public static class RequestAllocationRetractedBuilderImpl
    extends NonCorrectableRequestMessage.NonCorrectableRequestMessageBuilderImpl
    implements RequestAllocationRetractedBuilder {
        protected TradeIdentifier.TradeIdentifierBuilder blockTradeIdentifier;
        protected Allocations.AllocationsBuilder allocations;
        protected PartiesAndAccountsModel.PartiesAndAccountsModelBuilder partiesAndAccountsModel;

        @Override
        @RosettaAttribute(value="blockTradeIdentifier")
        @RuneAttribute(value="blockTradeIdentifier")
        public TradeIdentifier.TradeIdentifierBuilder getBlockTradeIdentifier() {
            return this.blockTradeIdentifier;
        }

        @Override
        public TradeIdentifier.TradeIdentifierBuilder getOrCreateBlockTradeIdentifier() {
            TradeIdentifier.TradeIdentifierBuilder result = this.blockTradeIdentifier != null ? this.blockTradeIdentifier : (this.blockTradeIdentifier = TradeIdentifier.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="allocations")
        @RuneAttribute(value="allocations")
        public Allocations.AllocationsBuilder getAllocations() {
            return this.allocations;
        }

        @Override
        public Allocations.AllocationsBuilder getOrCreateAllocations() {
            Allocations.AllocationsBuilder result = this.allocations != null ? this.allocations : (this.allocations = Allocations.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="partiesAndAccountsModel")
        @RuneAttribute(value="partiesAndAccountsModel")
        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getPartiesAndAccountsModel() {
            return this.partiesAndAccountsModel;
        }

        @Override
        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getOrCreatePartiesAndAccountsModel() {
            PartiesAndAccountsModel.PartiesAndAccountsModelBuilder result = this.partiesAndAccountsModel != null ? this.partiesAndAccountsModel : (this.partiesAndAccountsModel = PartiesAndAccountsModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="fpmlVersion", isRequired=true)
        @RuneAttribute(value="fpmlVersion", isRequired=true)
        public RequestAllocationRetractedBuilder setFpmlVersion(String _fpmlVersion) {
            this.fpmlVersion = _fpmlVersion == null ? null : _fpmlVersion;
            return this;
        }

        @Override
        @RosettaAttribute(value="expectedBuild")
        @RuneAttribute(value="expectedBuild")
        public RequestAllocationRetractedBuilder setExpectedBuild(Integer _expectedBuild) {
            this.expectedBuild = _expectedBuild == null ? null : _expectedBuild;
            return this;
        }

        @Override
        @RosettaAttribute(value="actualBuild")
        @RuneAttribute(value="actualBuild")
        public RequestAllocationRetractedBuilder setActualBuild(Integer _actualBuild) {
            this.actualBuild = _actualBuild == null ? null : _actualBuild;
            return this;
        }

        @Override
        @RosettaAttribute(value="header")
        @RuneAttribute(value="header")
        public RequestAllocationRetractedBuilder setHeader(RequestMessageHeader _header) {
            this.header = _header == null ? null : _header.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="validationModel", isRequired=true)
        @RuneAttribute(value="validationModel", isRequired=true)
        public RequestAllocationRetractedBuilder setValidationModel(ValidationModel _validationModel) {
            this.validationModel = _validationModel == null ? null : _validationModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="correlationAndSequenceModel")
        @RuneAttribute(value="correlationAndSequenceModel")
        public RequestAllocationRetractedBuilder setCorrelationAndSequenceModel(CorrelationAndSequenceModel _correlationAndSequenceModel) {
            this.correlationAndSequenceModel = _correlationAndSequenceModel == null ? null : _correlationAndSequenceModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="onBehalfOfModel")
        @RuneAttribute(value="onBehalfOfModel")
        public RequestAllocationRetractedBuilder setOnBehalfOfModel(OnBehalfOfModel _onBehalfOfModel) {
            this.onBehalfOfModel = _onBehalfOfModel == null ? null : _onBehalfOfModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="blockTradeIdentifier")
        @RuneAttribute(value="blockTradeIdentifier")
        public RequestAllocationRetractedBuilder setBlockTradeIdentifier(TradeIdentifier _blockTradeIdentifier) {
            this.blockTradeIdentifier = _blockTradeIdentifier == null ? null : _blockTradeIdentifier.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="allocations")
        @RuneAttribute(value="allocations")
        public RequestAllocationRetractedBuilder setAllocations(Allocations _allocations) {
            this.allocations = _allocations == null ? null : _allocations.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="partiesAndAccountsModel")
        @RuneAttribute(value="partiesAndAccountsModel")
        public RequestAllocationRetractedBuilder setPartiesAndAccountsModel(PartiesAndAccountsModel _partiesAndAccountsModel) {
            this.partiesAndAccountsModel = _partiesAndAccountsModel == null ? null : _partiesAndAccountsModel.toBuilder();
            return this;
        }

        @Override
        public RequestAllocationRetracted build() {
            return new RequestAllocationRetractedImpl(this);
        }

        @Override
        public RequestAllocationRetractedBuilder toBuilder() {
            return this;
        }

        @Override
        public RequestAllocationRetractedBuilder prune() {
            super.prune();
            if (this.blockTradeIdentifier != null && !this.blockTradeIdentifier.prune().hasData()) {
                this.blockTradeIdentifier = null;
            }
            if (this.allocations != null && !this.allocations.prune().hasData()) {
                this.allocations = null;
            }
            if (this.partiesAndAccountsModel != null && !this.partiesAndAccountsModel.prune().hasData()) {
                this.partiesAndAccountsModel = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getBlockTradeIdentifier() != null && this.getBlockTradeIdentifier().hasData()) {
                return true;
            }
            if (this.getAllocations() != null && this.getAllocations().hasData()) {
                return true;
            }
            return this.getPartiesAndAccountsModel() != null && this.getPartiesAndAccountsModel().hasData();
        }

        @Override
        public RequestAllocationRetractedBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            RequestAllocationRetractedBuilder o = (RequestAllocationRetractedBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getBlockTradeIdentifier(), (RosettaModelObjectBuilder)o.getBlockTradeIdentifier(), this::setBlockTradeIdentifier);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAllocations(), (RosettaModelObjectBuilder)o.getAllocations(), this::setAllocations);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPartiesAndAccountsModel(), (RosettaModelObjectBuilder)o.getPartiesAndAccountsModel(), this::setPartiesAndAccountsModel);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            RequestAllocationRetracted _that = (RequestAllocationRetracted)this.getType().cast(o);
            if (!Objects.equals(this.blockTradeIdentifier, _that.getBlockTradeIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.allocations, _that.getAllocations())) {
                return false;
            }
            return Objects.equals(this.partiesAndAccountsModel, _that.getPartiesAndAccountsModel());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.blockTradeIdentifier != null ? this.blockTradeIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.allocations != null ? this.allocations.hashCode() : 0);
            _result = 31 * _result + (this.partiesAndAccountsModel != null ? this.partiesAndAccountsModel.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "RequestAllocationRetractedBuilder {blockTradeIdentifier=" + this.blockTradeIdentifier + ", allocations=" + this.allocations + ", partiesAndAccountsModel=" + this.partiesAndAccountsModel + '}' + " " + super.toString();
        }
    }

    public static interface RequestAllocationRetractedBuilder
    extends RequestAllocationRetracted,
    NonCorrectableRequestMessage.NonCorrectableRequestMessageBuilder {
        public TradeIdentifier.TradeIdentifierBuilder getOrCreateBlockTradeIdentifier();

        @Override
        public TradeIdentifier.TradeIdentifierBuilder getBlockTradeIdentifier();

        public Allocations.AllocationsBuilder getOrCreateAllocations();

        @Override
        public Allocations.AllocationsBuilder getAllocations();

        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getOrCreatePartiesAndAccountsModel();

        @Override
        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getPartiesAndAccountsModel();

        @Override
        public RequestAllocationRetractedBuilder setFpmlVersion(String var1);

        @Override
        public RequestAllocationRetractedBuilder setExpectedBuild(Integer var1);

        @Override
        public RequestAllocationRetractedBuilder setActualBuild(Integer var1);

        @Override
        public RequestAllocationRetractedBuilder setHeader(RequestMessageHeader var1);

        @Override
        public RequestAllocationRetractedBuilder setValidationModel(ValidationModel var1);

        @Override
        public RequestAllocationRetractedBuilder setCorrelationAndSequenceModel(CorrelationAndSequenceModel var1);

        @Override
        public RequestAllocationRetractedBuilder setOnBehalfOfModel(OnBehalfOfModel var1);

        public RequestAllocationRetractedBuilder setBlockTradeIdentifier(TradeIdentifier var1);

        public RequestAllocationRetractedBuilder setAllocations(Allocations var1);

        public RequestAllocationRetractedBuilder setPartiesAndAccountsModel(PartiesAndAccountsModel var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("fpmlVersion"), String.class, (Object)this.getFpmlVersion(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("expectedBuild"), Integer.class, (Object)this.getExpectedBuild(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("actualBuild"), Integer.class, (Object)this.getActualBuild(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("header"), processor, RequestMessageHeader.RequestMessageHeaderBuilder.class, (RosettaModelObjectBuilder)this.getHeader(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("validationModel"), processor, ValidationModel.ValidationModelBuilder.class, (RosettaModelObjectBuilder)this.getValidationModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("correlationAndSequenceModel"), processor, CorrelationAndSequenceModel.CorrelationAndSequenceModelBuilder.class, (RosettaModelObjectBuilder)this.getCorrelationAndSequenceModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("onBehalfOfModel"), processor, OnBehalfOfModel.OnBehalfOfModelBuilder.class, (RosettaModelObjectBuilder)this.getOnBehalfOfModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("blockTradeIdentifier"), processor, TradeIdentifier.TradeIdentifierBuilder.class, this.getBlockTradeIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("allocations"), processor, Allocations.AllocationsBuilder.class, this.getAllocations(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("partiesAndAccountsModel"), processor, PartiesAndAccountsModel.PartiesAndAccountsModelBuilder.class, this.getPartiesAndAccountsModel(), new AttributeMeta[0]);
        }

        @Override
        public RequestAllocationRetractedBuilder prune();
    }

    public static class RequestAllocationRetractedImpl
    extends NonCorrectableRequestMessage.NonCorrectableRequestMessageImpl
    implements RequestAllocationRetracted {
        private final TradeIdentifier blockTradeIdentifier;
        private final Allocations allocations;
        private final PartiesAndAccountsModel partiesAndAccountsModel;

        protected RequestAllocationRetractedImpl(RequestAllocationRetractedBuilder builder) {
            super(builder);
            this.blockTradeIdentifier = Optional.ofNullable(builder.getBlockTradeIdentifier()).map(f -> f.build()).orElse(null);
            this.allocations = Optional.ofNullable(builder.getAllocations()).map(f -> f.build()).orElse(null);
            this.partiesAndAccountsModel = Optional.ofNullable(builder.getPartiesAndAccountsModel()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="blockTradeIdentifier")
        @RuneAttribute(value="blockTradeIdentifier")
        public TradeIdentifier getBlockTradeIdentifier() {
            return this.blockTradeIdentifier;
        }

        @Override
        @RosettaAttribute(value="allocations")
        @RuneAttribute(value="allocations")
        public Allocations getAllocations() {
            return this.allocations;
        }

        @Override
        @RosettaAttribute(value="partiesAndAccountsModel")
        @RuneAttribute(value="partiesAndAccountsModel")
        public PartiesAndAccountsModel getPartiesAndAccountsModel() {
            return this.partiesAndAccountsModel;
        }

        @Override
        public RequestAllocationRetracted build() {
            return this;
        }

        @Override
        public RequestAllocationRetractedBuilder toBuilder() {
            RequestAllocationRetractedBuilder builder = RequestAllocationRetracted.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(RequestAllocationRetractedBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getBlockTradeIdentifier()).ifPresent(builder::setBlockTradeIdentifier);
            Optional.ofNullable(this.getAllocations()).ifPresent(builder::setAllocations);
            Optional.ofNullable(this.getPartiesAndAccountsModel()).ifPresent(builder::setPartiesAndAccountsModel);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            RequestAllocationRetracted _that = (RequestAllocationRetracted)this.getType().cast(o);
            if (!Objects.equals(this.blockTradeIdentifier, _that.getBlockTradeIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.allocations, _that.getAllocations())) {
                return false;
            }
            return Objects.equals(this.partiesAndAccountsModel, _that.getPartiesAndAccountsModel());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.blockTradeIdentifier != null ? this.blockTradeIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.allocations != null ? this.allocations.hashCode() : 0);
            _result = 31 * _result + (this.partiesAndAccountsModel != null ? this.partiesAndAccountsModel.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "RequestAllocationRetracted {blockTradeIdentifier=" + this.blockTradeIdentifier + ", allocations=" + this.allocations + ", partiesAndAccountsModel=" + this.partiesAndAccountsModel + '}' + " " + super.toString();
        }
    }
}

