/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.confirmation.processes;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.confirmation.processes.meta.RequestAllocationMeta;
import fpml.consolidated.doc.Allocations;
import fpml.consolidated.doc.TradeIdentifier;
import fpml.consolidated.doc.ValidationModel;
import fpml.consolidated.msg.CorrectableRequestMessage;
import fpml.consolidated.msg.CorrelationAndSequenceModel;
import fpml.consolidated.msg.RequestMessageHeader;
import fpml.consolidated.shared.OnBehalfOfModel;
import fpml.consolidated.shared.PartiesAndAccountsModel;
import fpml.consolidated.shared.RelatedParty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="RequestAllocation", builder=RequestAllocationBuilderImpl.class, version="1.1.0")
@RuneDataType(value="RequestAllocation", model="fpml", builder=RequestAllocationBuilderImpl.class, version="1.1.0")
public interface RequestAllocation
extends CorrectableRequestMessage {
    public static final RequestAllocationMeta metaData = new RequestAllocationMeta();

    public List<? extends RelatedParty> getRelatedParty();

    public TradeIdentifier getBlockTradeIdentifier();

    public Allocations getAllocations();

    public PartiesAndAccountsModel getPartiesAndAccountsModel();

    @Override
    public RequestAllocation build();

    @Override
    public RequestAllocationBuilder toBuilder();

    public static RequestAllocationBuilder builder() {
        return new RequestAllocationBuilderImpl();
    }

    default public RosettaMetaData<? extends RequestAllocation> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends RequestAllocation> getType() {
        return RequestAllocation.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("fpmlVersion"), String.class, (Object)this.getFpmlVersion(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("expectedBuild"), Integer.class, (Object)this.getExpectedBuild(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("actualBuild"), Integer.class, (Object)this.getActualBuild(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("header"), processor, RequestMessageHeader.class, this.getHeader(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("validationModel"), processor, ValidationModel.class, this.getValidationModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("isCorrection"), Boolean.class, (Object)this.getIsCorrection(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("correlationAndSequenceModel"), processor, CorrelationAndSequenceModel.class, this.getCorrelationAndSequenceModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("onBehalfOfModel"), processor, OnBehalfOfModel.class, this.getOnBehalfOfModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("relatedParty"), processor, RelatedParty.class, this.getRelatedParty(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("blockTradeIdentifier"), processor, TradeIdentifier.class, this.getBlockTradeIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("allocations"), processor, Allocations.class, this.getAllocations(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("partiesAndAccountsModel"), processor, PartiesAndAccountsModel.class, this.getPartiesAndAccountsModel(), new AttributeMeta[0]);
    }

    public static class RequestAllocationBuilderImpl
    extends CorrectableRequestMessage.CorrectableRequestMessageBuilderImpl
    implements RequestAllocationBuilder {
        protected List<RelatedParty.RelatedPartyBuilder> relatedParty = new ArrayList<RelatedParty.RelatedPartyBuilder>();
        protected TradeIdentifier.TradeIdentifierBuilder blockTradeIdentifier;
        protected Allocations.AllocationsBuilder allocations;
        protected PartiesAndAccountsModel.PartiesAndAccountsModelBuilder partiesAndAccountsModel;

        @Override
        @RosettaAttribute(value="relatedParty")
        @RuneAttribute(value="relatedParty")
        public List<? extends RelatedParty.RelatedPartyBuilder> getRelatedParty() {
            return this.relatedParty;
        }

        @Override
        public RelatedParty.RelatedPartyBuilder getOrCreateRelatedParty(int index) {
            if (this.relatedParty == null) {
                this.relatedParty = new ArrayList<RelatedParty.RelatedPartyBuilder>();
            }
            return (RelatedParty.RelatedPartyBuilder)this.getIndex(this.relatedParty, index, () -> {
                RelatedParty.RelatedPartyBuilder newRelatedParty = RelatedParty.builder();
                return newRelatedParty;
            });
        }

        @Override
        @RosettaAttribute(value="blockTradeIdentifier", isRequired=true)
        @RuneAttribute(value="blockTradeIdentifier", isRequired=true)
        public TradeIdentifier.TradeIdentifierBuilder getBlockTradeIdentifier() {
            return this.blockTradeIdentifier;
        }

        @Override
        public TradeIdentifier.TradeIdentifierBuilder getOrCreateBlockTradeIdentifier() {
            TradeIdentifier.TradeIdentifierBuilder result = this.blockTradeIdentifier != null ? this.blockTradeIdentifier : (this.blockTradeIdentifier = TradeIdentifier.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="allocations", isRequired=true)
        @RuneAttribute(value="allocations", isRequired=true)
        public Allocations.AllocationsBuilder getAllocations() {
            return this.allocations;
        }

        @Override
        public Allocations.AllocationsBuilder getOrCreateAllocations() {
            Allocations.AllocationsBuilder result = this.allocations != null ? this.allocations : (this.allocations = Allocations.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="partiesAndAccountsModel", isRequired=true)
        @RuneAttribute(value="partiesAndAccountsModel", isRequired=true)
        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getPartiesAndAccountsModel() {
            return this.partiesAndAccountsModel;
        }

        @Override
        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getOrCreatePartiesAndAccountsModel() {
            PartiesAndAccountsModel.PartiesAndAccountsModelBuilder result = this.partiesAndAccountsModel != null ? this.partiesAndAccountsModel : (this.partiesAndAccountsModel = PartiesAndAccountsModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="fpmlVersion", isRequired=true)
        @RuneAttribute(value="fpmlVersion", isRequired=true)
        public RequestAllocationBuilder setFpmlVersion(String _fpmlVersion) {
            this.fpmlVersion = _fpmlVersion == null ? null : _fpmlVersion;
            return this;
        }

        @Override
        @RosettaAttribute(value="expectedBuild")
        @RuneAttribute(value="expectedBuild")
        public RequestAllocationBuilder setExpectedBuild(Integer _expectedBuild) {
            this.expectedBuild = _expectedBuild == null ? null : _expectedBuild;
            return this;
        }

        @Override
        @RosettaAttribute(value="actualBuild")
        @RuneAttribute(value="actualBuild")
        public RequestAllocationBuilder setActualBuild(Integer _actualBuild) {
            this.actualBuild = _actualBuild == null ? null : _actualBuild;
            return this;
        }

        @Override
        @RosettaAttribute(value="header")
        @RuneAttribute(value="header")
        public RequestAllocationBuilder setHeader(RequestMessageHeader _header) {
            this.header = _header == null ? null : _header.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="validationModel", isRequired=true)
        @RuneAttribute(value="validationModel", isRequired=true)
        public RequestAllocationBuilder setValidationModel(ValidationModel _validationModel) {
            this.validationModel = _validationModel == null ? null : _validationModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="isCorrection")
        @RuneAttribute(value="isCorrection")
        public RequestAllocationBuilder setIsCorrection(Boolean _isCorrection) {
            this.isCorrection = _isCorrection == null ? null : _isCorrection;
            return this;
        }

        @Override
        @RosettaAttribute(value="correlationAndSequenceModel")
        @RuneAttribute(value="correlationAndSequenceModel")
        public RequestAllocationBuilder setCorrelationAndSequenceModel(CorrelationAndSequenceModel _correlationAndSequenceModel) {
            this.correlationAndSequenceModel = _correlationAndSequenceModel == null ? null : _correlationAndSequenceModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="onBehalfOfModel")
        @RuneAttribute(value="onBehalfOfModel")
        public RequestAllocationBuilder setOnBehalfOfModel(OnBehalfOfModel _onBehalfOfModel) {
            this.onBehalfOfModel = _onBehalfOfModel == null ? null : _onBehalfOfModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="relatedParty")
        @RuneAttribute(value="relatedParty")
        public RequestAllocationBuilder addRelatedParty(RelatedParty _relatedParty) {
            if (_relatedParty != null) {
                this.relatedParty.add(_relatedParty.toBuilder());
            }
            return this;
        }

        @Override
        public RequestAllocationBuilder addRelatedParty(RelatedParty _relatedParty, int idx) {
            this.getIndex(this.relatedParty, idx, () -> _relatedParty.toBuilder());
            return this;
        }

        @Override
        public RequestAllocationBuilder addRelatedParty(List<? extends RelatedParty> relatedPartys) {
            if (relatedPartys != null) {
                for (RelatedParty relatedParty : relatedPartys) {
                    this.relatedParty.add(relatedParty.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="relatedParty")
        public RequestAllocationBuilder setRelatedParty(List<? extends RelatedParty> relatedPartys) {
            this.relatedParty = relatedPartys == null ? new ArrayList<RelatedParty.RelatedPartyBuilder>() : (List)relatedPartys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="blockTradeIdentifier", isRequired=true)
        @RuneAttribute(value="blockTradeIdentifier", isRequired=true)
        public RequestAllocationBuilder setBlockTradeIdentifier(TradeIdentifier _blockTradeIdentifier) {
            this.blockTradeIdentifier = _blockTradeIdentifier == null ? null : _blockTradeIdentifier.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="allocations", isRequired=true)
        @RuneAttribute(value="allocations", isRequired=true)
        public RequestAllocationBuilder setAllocations(Allocations _allocations) {
            this.allocations = _allocations == null ? null : _allocations.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="partiesAndAccountsModel", isRequired=true)
        @RuneAttribute(value="partiesAndAccountsModel", isRequired=true)
        public RequestAllocationBuilder setPartiesAndAccountsModel(PartiesAndAccountsModel _partiesAndAccountsModel) {
            this.partiesAndAccountsModel = _partiesAndAccountsModel == null ? null : _partiesAndAccountsModel.toBuilder();
            return this;
        }

        @Override
        public RequestAllocation build() {
            return new RequestAllocationImpl(this);
        }

        @Override
        public RequestAllocationBuilder toBuilder() {
            return this;
        }

        @Override
        public RequestAllocationBuilder prune() {
            super.prune();
            this.relatedParty = this.relatedParty.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.blockTradeIdentifier != null && !this.blockTradeIdentifier.prune().hasData()) {
                this.blockTradeIdentifier = null;
            }
            if (this.allocations != null && !this.allocations.prune().hasData()) {
                this.allocations = null;
            }
            if (this.partiesAndAccountsModel != null && !this.partiesAndAccountsModel.prune().hasData()) {
                this.partiesAndAccountsModel = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getRelatedParty() != null && this.getRelatedParty().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getBlockTradeIdentifier() != null && this.getBlockTradeIdentifier().hasData()) {
                return true;
            }
            if (this.getAllocations() != null && this.getAllocations().hasData()) {
                return true;
            }
            return this.getPartiesAndAccountsModel() != null && this.getPartiesAndAccountsModel().hasData();
        }

        @Override
        public RequestAllocationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            RequestAllocationBuilder o = (RequestAllocationBuilder)other;
            merger.mergeRosetta(this.getRelatedParty(), o.getRelatedParty(), this::getOrCreateRelatedParty);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getBlockTradeIdentifier(), (RosettaModelObjectBuilder)o.getBlockTradeIdentifier(), this::setBlockTradeIdentifier);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAllocations(), (RosettaModelObjectBuilder)o.getAllocations(), this::setAllocations);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPartiesAndAccountsModel(), (RosettaModelObjectBuilder)o.getPartiesAndAccountsModel(), this::setPartiesAndAccountsModel);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            RequestAllocation _that = (RequestAllocation)this.getType().cast(o);
            if (!ListEquals.listEquals(this.relatedParty, _that.getRelatedParty())) {
                return false;
            }
            if (!Objects.equals(this.blockTradeIdentifier, _that.getBlockTradeIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.allocations, _that.getAllocations())) {
                return false;
            }
            return Objects.equals(this.partiesAndAccountsModel, _that.getPartiesAndAccountsModel());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.relatedParty != null ? this.relatedParty.hashCode() : 0);
            _result = 31 * _result + (this.blockTradeIdentifier != null ? this.blockTradeIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.allocations != null ? this.allocations.hashCode() : 0);
            _result = 31 * _result + (this.partiesAndAccountsModel != null ? this.partiesAndAccountsModel.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "RequestAllocationBuilder {relatedParty=" + this.relatedParty + ", blockTradeIdentifier=" + this.blockTradeIdentifier + ", allocations=" + this.allocations + ", partiesAndAccountsModel=" + this.partiesAndAccountsModel + '}' + " " + super.toString();
        }
    }

    public static interface RequestAllocationBuilder
    extends RequestAllocation,
    CorrectableRequestMessage.CorrectableRequestMessageBuilder {
        public RelatedParty.RelatedPartyBuilder getOrCreateRelatedParty(int var1);

        public List<? extends RelatedParty.RelatedPartyBuilder> getRelatedParty();

        public TradeIdentifier.TradeIdentifierBuilder getOrCreateBlockTradeIdentifier();

        @Override
        public TradeIdentifier.TradeIdentifierBuilder getBlockTradeIdentifier();

        public Allocations.AllocationsBuilder getOrCreateAllocations();

        @Override
        public Allocations.AllocationsBuilder getAllocations();

        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getOrCreatePartiesAndAccountsModel();

        @Override
        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getPartiesAndAccountsModel();

        @Override
        public RequestAllocationBuilder setFpmlVersion(String var1);

        @Override
        public RequestAllocationBuilder setExpectedBuild(Integer var1);

        @Override
        public RequestAllocationBuilder setActualBuild(Integer var1);

        @Override
        public RequestAllocationBuilder setHeader(RequestMessageHeader var1);

        @Override
        public RequestAllocationBuilder setValidationModel(ValidationModel var1);

        @Override
        public RequestAllocationBuilder setIsCorrection(Boolean var1);

        @Override
        public RequestAllocationBuilder setCorrelationAndSequenceModel(CorrelationAndSequenceModel var1);

        @Override
        public RequestAllocationBuilder setOnBehalfOfModel(OnBehalfOfModel var1);

        public RequestAllocationBuilder addRelatedParty(RelatedParty var1);

        public RequestAllocationBuilder addRelatedParty(RelatedParty var1, int var2);

        public RequestAllocationBuilder addRelatedParty(List<? extends RelatedParty> var1);

        public RequestAllocationBuilder setRelatedParty(List<? extends RelatedParty> var1);

        public RequestAllocationBuilder setBlockTradeIdentifier(TradeIdentifier var1);

        public RequestAllocationBuilder setAllocations(Allocations var1);

        public RequestAllocationBuilder setPartiesAndAccountsModel(PartiesAndAccountsModel var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("fpmlVersion"), String.class, (Object)this.getFpmlVersion(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("expectedBuild"), Integer.class, (Object)this.getExpectedBuild(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("actualBuild"), Integer.class, (Object)this.getActualBuild(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("header"), processor, RequestMessageHeader.RequestMessageHeaderBuilder.class, (RosettaModelObjectBuilder)this.getHeader(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("validationModel"), processor, ValidationModel.ValidationModelBuilder.class, (RosettaModelObjectBuilder)this.getValidationModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("isCorrection"), Boolean.class, (Object)this.getIsCorrection(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("correlationAndSequenceModel"), processor, CorrelationAndSequenceModel.CorrelationAndSequenceModelBuilder.class, (RosettaModelObjectBuilder)this.getCorrelationAndSequenceModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("onBehalfOfModel"), processor, OnBehalfOfModel.OnBehalfOfModelBuilder.class, (RosettaModelObjectBuilder)this.getOnBehalfOfModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("relatedParty"), processor, RelatedParty.RelatedPartyBuilder.class, this.getRelatedParty(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("blockTradeIdentifier"), processor, TradeIdentifier.TradeIdentifierBuilder.class, this.getBlockTradeIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("allocations"), processor, Allocations.AllocationsBuilder.class, this.getAllocations(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("partiesAndAccountsModel"), processor, PartiesAndAccountsModel.PartiesAndAccountsModelBuilder.class, this.getPartiesAndAccountsModel(), new AttributeMeta[0]);
        }

        @Override
        public RequestAllocationBuilder prune();
    }

    public static class RequestAllocationImpl
    extends CorrectableRequestMessage.CorrectableRequestMessageImpl
    implements RequestAllocation {
        private final List<? extends RelatedParty> relatedParty;
        private final TradeIdentifier blockTradeIdentifier;
        private final Allocations allocations;
        private final PartiesAndAccountsModel partiesAndAccountsModel;

        protected RequestAllocationImpl(RequestAllocationBuilder builder) {
            super(builder);
            this.relatedParty = Optional.ofNullable(builder.getRelatedParty()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.blockTradeIdentifier = Optional.ofNullable(builder.getBlockTradeIdentifier()).map(f -> f.build()).orElse(null);
            this.allocations = Optional.ofNullable(builder.getAllocations()).map(f -> f.build()).orElse(null);
            this.partiesAndAccountsModel = Optional.ofNullable(builder.getPartiesAndAccountsModel()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="relatedParty")
        @RuneAttribute(value="relatedParty")
        public List<? extends RelatedParty> getRelatedParty() {
            return this.relatedParty;
        }

        @Override
        @RosettaAttribute(value="blockTradeIdentifier", isRequired=true)
        @RuneAttribute(value="blockTradeIdentifier", isRequired=true)
        public TradeIdentifier getBlockTradeIdentifier() {
            return this.blockTradeIdentifier;
        }

        @Override
        @RosettaAttribute(value="allocations", isRequired=true)
        @RuneAttribute(value="allocations", isRequired=true)
        public Allocations getAllocations() {
            return this.allocations;
        }

        @Override
        @RosettaAttribute(value="partiesAndAccountsModel", isRequired=true)
        @RuneAttribute(value="partiesAndAccountsModel", isRequired=true)
        public PartiesAndAccountsModel getPartiesAndAccountsModel() {
            return this.partiesAndAccountsModel;
        }

        @Override
        public RequestAllocation build() {
            return this;
        }

        @Override
        public RequestAllocationBuilder toBuilder() {
            RequestAllocationBuilder builder = RequestAllocation.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(RequestAllocationBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getRelatedParty()).ifPresent(builder::setRelatedParty);
            Optional.ofNullable(this.getBlockTradeIdentifier()).ifPresent(builder::setBlockTradeIdentifier);
            Optional.ofNullable(this.getAllocations()).ifPresent(builder::setAllocations);
            Optional.ofNullable(this.getPartiesAndAccountsModel()).ifPresent(builder::setPartiesAndAccountsModel);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            RequestAllocation _that = (RequestAllocation)this.getType().cast(o);
            if (!ListEquals.listEquals(this.relatedParty, _that.getRelatedParty())) {
                return false;
            }
            if (!Objects.equals(this.blockTradeIdentifier, _that.getBlockTradeIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.allocations, _that.getAllocations())) {
                return false;
            }
            return Objects.equals(this.partiesAndAccountsModel, _that.getPartiesAndAccountsModel());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.relatedParty != null ? this.relatedParty.hashCode() : 0);
            _result = 31 * _result + (this.blockTradeIdentifier != null ? this.blockTradeIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.allocations != null ? this.allocations.hashCode() : 0);
            _result = 31 * _result + (this.partiesAndAccountsModel != null ? this.partiesAndAccountsModel.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "RequestAllocation {relatedParty=" + this.relatedParty + ", blockTradeIdentifier=" + this.blockTradeIdentifier + ", allocations=" + this.allocations + ", partiesAndAccountsModel=" + this.partiesAndAccountsModel + '}' + " " + super.toString();
        }
    }
}

