/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.confirmation.processes;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.business.events.AdditionalEvent;
import fpml.consolidated.business.events.ChangeEventsBaseModel;
import fpml.consolidated.business.events.OptionsEventsBaseModel;
import fpml.consolidated.business.events.PostTradeEventsBaseModel;
import fpml.consolidated.business.events.TradingEventsBaseModel;
import fpml.consolidated.confirmation.processes.meta.ConfirmationDisputedMeta;
import fpml.consolidated.doc.Reason;
import fpml.consolidated.doc.ValidationModel;
import fpml.consolidated.msg.CorrelationAndOptionalSequenceModel;
import fpml.consolidated.msg.ResponseMessage;
import fpml.consolidated.msg.ResponseMessageHeader;
import fpml.consolidated.shared.OnBehalfOfModel;
import fpml.consolidated.shared.PartiesAndAccountsModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="ConfirmationDisputed", builder=ConfirmationDisputedBuilderImpl.class, version="1.1.0")
@RuneDataType(value="ConfirmationDisputed", model="fpml", builder=ConfirmationDisputedBuilderImpl.class, version="1.1.0")
public interface ConfirmationDisputed
extends ResponseMessage {
    public static final ConfirmationDisputedMeta metaData = new ConfirmationDisputedMeta();

    public TradingEventsBaseModel getTradingEventsBaseModel();

    public PostTradeEventsBaseModel getPostTradeEventsBaseModel();

    public ChangeEventsBaseModel getChangeEventsBaseModel();

    public OptionsEventsBaseModel getOptionsEventsBaseModel();

    public AdditionalEvent getAdditionalEvent();

    public PartiesAndAccountsModel getPartiesAndAccountsModel();

    public List<? extends Reason> getReason();

    @Override
    public ConfirmationDisputed build();

    @Override
    public ConfirmationDisputedBuilder toBuilder();

    public static ConfirmationDisputedBuilder builder() {
        return new ConfirmationDisputedBuilderImpl();
    }

    default public RosettaMetaData<? extends ConfirmationDisputed> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends ConfirmationDisputed> getType() {
        return ConfirmationDisputed.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("fpmlVersion"), String.class, (Object)this.getFpmlVersion(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("expectedBuild"), Integer.class, (Object)this.getExpectedBuild(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("actualBuild"), Integer.class, (Object)this.getActualBuild(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("header"), processor, ResponseMessageHeader.class, this.getHeader(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("validationModel"), processor, ValidationModel.class, this.getValidationModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("correlationAndOptionalSequenceModel"), processor, CorrelationAndOptionalSequenceModel.class, this.getCorrelationAndOptionalSequenceModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("onBehalfOfModel"), processor, OnBehalfOfModel.class, this.getOnBehalfOfModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("tradingEventsBaseModel"), processor, TradingEventsBaseModel.class, this.getTradingEventsBaseModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("postTradeEventsBaseModel"), processor, PostTradeEventsBaseModel.class, this.getPostTradeEventsBaseModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("changeEventsBaseModel"), processor, ChangeEventsBaseModel.class, this.getChangeEventsBaseModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("optionsEventsBaseModel"), processor, OptionsEventsBaseModel.class, this.getOptionsEventsBaseModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("additionalEvent"), processor, AdditionalEvent.class, this.getAdditionalEvent(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("partiesAndAccountsModel"), processor, PartiesAndAccountsModel.class, this.getPartiesAndAccountsModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("reason"), processor, Reason.class, this.getReason(), new AttributeMeta[0]);
    }

    public static class ConfirmationDisputedBuilderImpl
    extends ResponseMessage.ResponseMessageBuilderImpl
    implements ConfirmationDisputedBuilder {
        protected TradingEventsBaseModel.TradingEventsBaseModelBuilder tradingEventsBaseModel;
        protected PostTradeEventsBaseModel.PostTradeEventsBaseModelBuilder postTradeEventsBaseModel;
        protected ChangeEventsBaseModel.ChangeEventsBaseModelBuilder changeEventsBaseModel;
        protected OptionsEventsBaseModel.OptionsEventsBaseModelBuilder optionsEventsBaseModel;
        protected AdditionalEvent.AdditionalEventBuilder additionalEvent;
        protected PartiesAndAccountsModel.PartiesAndAccountsModelBuilder partiesAndAccountsModel;
        protected List<Reason.ReasonBuilder> reason = new ArrayList<Reason.ReasonBuilder>();

        @Override
        @RosettaAttribute(value="tradingEventsBaseModel")
        @RuneAttribute(value="tradingEventsBaseModel")
        public TradingEventsBaseModel.TradingEventsBaseModelBuilder getTradingEventsBaseModel() {
            return this.tradingEventsBaseModel;
        }

        @Override
        public TradingEventsBaseModel.TradingEventsBaseModelBuilder getOrCreateTradingEventsBaseModel() {
            TradingEventsBaseModel.TradingEventsBaseModelBuilder result = this.tradingEventsBaseModel != null ? this.tradingEventsBaseModel : (this.tradingEventsBaseModel = TradingEventsBaseModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="postTradeEventsBaseModel")
        @RuneAttribute(value="postTradeEventsBaseModel")
        public PostTradeEventsBaseModel.PostTradeEventsBaseModelBuilder getPostTradeEventsBaseModel() {
            return this.postTradeEventsBaseModel;
        }

        @Override
        public PostTradeEventsBaseModel.PostTradeEventsBaseModelBuilder getOrCreatePostTradeEventsBaseModel() {
            PostTradeEventsBaseModel.PostTradeEventsBaseModelBuilder result = this.postTradeEventsBaseModel != null ? this.postTradeEventsBaseModel : (this.postTradeEventsBaseModel = PostTradeEventsBaseModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="changeEventsBaseModel")
        @RuneAttribute(value="changeEventsBaseModel")
        public ChangeEventsBaseModel.ChangeEventsBaseModelBuilder getChangeEventsBaseModel() {
            return this.changeEventsBaseModel;
        }

        @Override
        public ChangeEventsBaseModel.ChangeEventsBaseModelBuilder getOrCreateChangeEventsBaseModel() {
            ChangeEventsBaseModel.ChangeEventsBaseModelBuilder result = this.changeEventsBaseModel != null ? this.changeEventsBaseModel : (this.changeEventsBaseModel = ChangeEventsBaseModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="optionsEventsBaseModel")
        @RuneAttribute(value="optionsEventsBaseModel")
        public OptionsEventsBaseModel.OptionsEventsBaseModelBuilder getOptionsEventsBaseModel() {
            return this.optionsEventsBaseModel;
        }

        @Override
        public OptionsEventsBaseModel.OptionsEventsBaseModelBuilder getOrCreateOptionsEventsBaseModel() {
            OptionsEventsBaseModel.OptionsEventsBaseModelBuilder result = this.optionsEventsBaseModel != null ? this.optionsEventsBaseModel : (this.optionsEventsBaseModel = OptionsEventsBaseModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="additionalEvent")
        @RuneAttribute(value="additionalEvent")
        public AdditionalEvent.AdditionalEventBuilder getAdditionalEvent() {
            return this.additionalEvent;
        }

        @Override
        public AdditionalEvent.AdditionalEventBuilder getOrCreateAdditionalEvent() {
            AdditionalEvent.AdditionalEventBuilder result = this.additionalEvent != null ? this.additionalEvent : (this.additionalEvent = AdditionalEvent.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="partiesAndAccountsModel")
        @RuneAttribute(value="partiesAndAccountsModel")
        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getPartiesAndAccountsModel() {
            return this.partiesAndAccountsModel;
        }

        @Override
        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getOrCreatePartiesAndAccountsModel() {
            PartiesAndAccountsModel.PartiesAndAccountsModelBuilder result = this.partiesAndAccountsModel != null ? this.partiesAndAccountsModel : (this.partiesAndAccountsModel = PartiesAndAccountsModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="reason")
        @RuneAttribute(value="reason")
        public List<? extends Reason.ReasonBuilder> getReason() {
            return this.reason;
        }

        @Override
        public Reason.ReasonBuilder getOrCreateReason(int index) {
            if (this.reason == null) {
                this.reason = new ArrayList<Reason.ReasonBuilder>();
            }
            return (Reason.ReasonBuilder)this.getIndex(this.reason, index, () -> {
                Reason.ReasonBuilder newReason = Reason.builder();
                return newReason;
            });
        }

        @Override
        @RosettaAttribute(value="fpmlVersion", isRequired=true)
        @RuneAttribute(value="fpmlVersion", isRequired=true)
        public ConfirmationDisputedBuilder setFpmlVersion(String _fpmlVersion) {
            this.fpmlVersion = _fpmlVersion == null ? null : _fpmlVersion;
            return this;
        }

        @Override
        @RosettaAttribute(value="expectedBuild")
        @RuneAttribute(value="expectedBuild")
        public ConfirmationDisputedBuilder setExpectedBuild(Integer _expectedBuild) {
            this.expectedBuild = _expectedBuild == null ? null : _expectedBuild;
            return this;
        }

        @Override
        @RosettaAttribute(value="actualBuild")
        @RuneAttribute(value="actualBuild")
        public ConfirmationDisputedBuilder setActualBuild(Integer _actualBuild) {
            this.actualBuild = _actualBuild == null ? null : _actualBuild;
            return this;
        }

        @Override
        @RosettaAttribute(value="header")
        @RuneAttribute(value="header")
        public ConfirmationDisputedBuilder setHeader(ResponseMessageHeader _header) {
            this.header = _header == null ? null : _header.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="validationModel", isRequired=true)
        @RuneAttribute(value="validationModel", isRequired=true)
        public ConfirmationDisputedBuilder setValidationModel(ValidationModel _validationModel) {
            this.validationModel = _validationModel == null ? null : _validationModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="correlationAndOptionalSequenceModel", isRequired=true)
        @RuneAttribute(value="correlationAndOptionalSequenceModel", isRequired=true)
        public ConfirmationDisputedBuilder setCorrelationAndOptionalSequenceModel(CorrelationAndOptionalSequenceModel _correlationAndOptionalSequenceModel) {
            this.correlationAndOptionalSequenceModel = _correlationAndOptionalSequenceModel == null ? null : _correlationAndOptionalSequenceModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="onBehalfOfModel")
        @RuneAttribute(value="onBehalfOfModel")
        public ConfirmationDisputedBuilder setOnBehalfOfModel(OnBehalfOfModel _onBehalfOfModel) {
            this.onBehalfOfModel = _onBehalfOfModel == null ? null : _onBehalfOfModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="tradingEventsBaseModel")
        @RuneAttribute(value="tradingEventsBaseModel")
        public ConfirmationDisputedBuilder setTradingEventsBaseModel(TradingEventsBaseModel _tradingEventsBaseModel) {
            this.tradingEventsBaseModel = _tradingEventsBaseModel == null ? null : _tradingEventsBaseModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="postTradeEventsBaseModel")
        @RuneAttribute(value="postTradeEventsBaseModel")
        public ConfirmationDisputedBuilder setPostTradeEventsBaseModel(PostTradeEventsBaseModel _postTradeEventsBaseModel) {
            this.postTradeEventsBaseModel = _postTradeEventsBaseModel == null ? null : _postTradeEventsBaseModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="changeEventsBaseModel")
        @RuneAttribute(value="changeEventsBaseModel")
        public ConfirmationDisputedBuilder setChangeEventsBaseModel(ChangeEventsBaseModel _changeEventsBaseModel) {
            this.changeEventsBaseModel = _changeEventsBaseModel == null ? null : _changeEventsBaseModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="optionsEventsBaseModel")
        @RuneAttribute(value="optionsEventsBaseModel")
        public ConfirmationDisputedBuilder setOptionsEventsBaseModel(OptionsEventsBaseModel _optionsEventsBaseModel) {
            this.optionsEventsBaseModel = _optionsEventsBaseModel == null ? null : _optionsEventsBaseModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="additionalEvent")
        @RuneAttribute(value="additionalEvent")
        public ConfirmationDisputedBuilder setAdditionalEvent(AdditionalEvent _additionalEvent) {
            this.additionalEvent = _additionalEvent == null ? null : _additionalEvent.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="partiesAndAccountsModel")
        @RuneAttribute(value="partiesAndAccountsModel")
        public ConfirmationDisputedBuilder setPartiesAndAccountsModel(PartiesAndAccountsModel _partiesAndAccountsModel) {
            this.partiesAndAccountsModel = _partiesAndAccountsModel == null ? null : _partiesAndAccountsModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="reason")
        @RuneAttribute(value="reason")
        public ConfirmationDisputedBuilder addReason(Reason _reason) {
            if (_reason != null) {
                this.reason.add(_reason.toBuilder());
            }
            return this;
        }

        @Override
        public ConfirmationDisputedBuilder addReason(Reason _reason, int idx) {
            this.getIndex(this.reason, idx, () -> _reason.toBuilder());
            return this;
        }

        @Override
        public ConfirmationDisputedBuilder addReason(List<? extends Reason> reasons) {
            if (reasons != null) {
                for (Reason reason : reasons) {
                    this.reason.add(reason.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="reason")
        public ConfirmationDisputedBuilder setReason(List<? extends Reason> reasons) {
            this.reason = reasons == null ? new ArrayList<Reason.ReasonBuilder>() : (List)reasons.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public ConfirmationDisputed build() {
            return new ConfirmationDisputedImpl(this);
        }

        @Override
        public ConfirmationDisputedBuilder toBuilder() {
            return this;
        }

        @Override
        public ConfirmationDisputedBuilder prune() {
            super.prune();
            if (this.tradingEventsBaseModel != null && !this.tradingEventsBaseModel.prune().hasData()) {
                this.tradingEventsBaseModel = null;
            }
            if (this.postTradeEventsBaseModel != null && !this.postTradeEventsBaseModel.prune().hasData()) {
                this.postTradeEventsBaseModel = null;
            }
            if (this.changeEventsBaseModel != null && !this.changeEventsBaseModel.prune().hasData()) {
                this.changeEventsBaseModel = null;
            }
            if (this.optionsEventsBaseModel != null && !this.optionsEventsBaseModel.prune().hasData()) {
                this.optionsEventsBaseModel = null;
            }
            if (this.additionalEvent != null && !this.additionalEvent.prune().hasData()) {
                this.additionalEvent = null;
            }
            if (this.partiesAndAccountsModel != null && !this.partiesAndAccountsModel.prune().hasData()) {
                this.partiesAndAccountsModel = null;
            }
            this.reason = this.reason.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getTradingEventsBaseModel() != null && this.getTradingEventsBaseModel().hasData()) {
                return true;
            }
            if (this.getPostTradeEventsBaseModel() != null && this.getPostTradeEventsBaseModel().hasData()) {
                return true;
            }
            if (this.getChangeEventsBaseModel() != null && this.getChangeEventsBaseModel().hasData()) {
                return true;
            }
            if (this.getOptionsEventsBaseModel() != null && this.getOptionsEventsBaseModel().hasData()) {
                return true;
            }
            if (this.getAdditionalEvent() != null && this.getAdditionalEvent().hasData()) {
                return true;
            }
            if (this.getPartiesAndAccountsModel() != null && this.getPartiesAndAccountsModel().hasData()) {
                return true;
            }
            return this.getReason() != null && this.getReason().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        @Override
        public ConfirmationDisputedBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            ConfirmationDisputedBuilder o = (ConfirmationDisputedBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getTradingEventsBaseModel(), (RosettaModelObjectBuilder)o.getTradingEventsBaseModel(), this::setTradingEventsBaseModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPostTradeEventsBaseModel(), (RosettaModelObjectBuilder)o.getPostTradeEventsBaseModel(), this::setPostTradeEventsBaseModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getChangeEventsBaseModel(), (RosettaModelObjectBuilder)o.getChangeEventsBaseModel(), this::setChangeEventsBaseModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getOptionsEventsBaseModel(), (RosettaModelObjectBuilder)o.getOptionsEventsBaseModel(), this::setOptionsEventsBaseModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAdditionalEvent(), (RosettaModelObjectBuilder)o.getAdditionalEvent(), this::setAdditionalEvent);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPartiesAndAccountsModel(), (RosettaModelObjectBuilder)o.getPartiesAndAccountsModel(), this::setPartiesAndAccountsModel);
            merger.mergeRosetta(this.getReason(), o.getReason(), this::getOrCreateReason);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ConfirmationDisputed _that = (ConfirmationDisputed)this.getType().cast(o);
            if (!Objects.equals(this.tradingEventsBaseModel, _that.getTradingEventsBaseModel())) {
                return false;
            }
            if (!Objects.equals(this.postTradeEventsBaseModel, _that.getPostTradeEventsBaseModel())) {
                return false;
            }
            if (!Objects.equals(this.changeEventsBaseModel, _that.getChangeEventsBaseModel())) {
                return false;
            }
            if (!Objects.equals(this.optionsEventsBaseModel, _that.getOptionsEventsBaseModel())) {
                return false;
            }
            if (!Objects.equals(this.additionalEvent, _that.getAdditionalEvent())) {
                return false;
            }
            if (!Objects.equals(this.partiesAndAccountsModel, _that.getPartiesAndAccountsModel())) {
                return false;
            }
            return ListEquals.listEquals(this.reason, _that.getReason());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.tradingEventsBaseModel != null ? this.tradingEventsBaseModel.hashCode() : 0);
            _result = 31 * _result + (this.postTradeEventsBaseModel != null ? this.postTradeEventsBaseModel.hashCode() : 0);
            _result = 31 * _result + (this.changeEventsBaseModel != null ? this.changeEventsBaseModel.hashCode() : 0);
            _result = 31 * _result + (this.optionsEventsBaseModel != null ? this.optionsEventsBaseModel.hashCode() : 0);
            _result = 31 * _result + (this.additionalEvent != null ? this.additionalEvent.hashCode() : 0);
            _result = 31 * _result + (this.partiesAndAccountsModel != null ? this.partiesAndAccountsModel.hashCode() : 0);
            _result = 31 * _result + (this.reason != null ? this.reason.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "ConfirmationDisputedBuilder {tradingEventsBaseModel=" + this.tradingEventsBaseModel + ", postTradeEventsBaseModel=" + this.postTradeEventsBaseModel + ", changeEventsBaseModel=" + this.changeEventsBaseModel + ", optionsEventsBaseModel=" + this.optionsEventsBaseModel + ", additionalEvent=" + this.additionalEvent + ", partiesAndAccountsModel=" + this.partiesAndAccountsModel + ", reason=" + this.reason + '}' + " " + super.toString();
        }
    }

    public static interface ConfirmationDisputedBuilder
    extends ConfirmationDisputed,
    ResponseMessage.ResponseMessageBuilder {
        public TradingEventsBaseModel.TradingEventsBaseModelBuilder getOrCreateTradingEventsBaseModel();

        @Override
        public TradingEventsBaseModel.TradingEventsBaseModelBuilder getTradingEventsBaseModel();

        public PostTradeEventsBaseModel.PostTradeEventsBaseModelBuilder getOrCreatePostTradeEventsBaseModel();

        @Override
        public PostTradeEventsBaseModel.PostTradeEventsBaseModelBuilder getPostTradeEventsBaseModel();

        public ChangeEventsBaseModel.ChangeEventsBaseModelBuilder getOrCreateChangeEventsBaseModel();

        @Override
        public ChangeEventsBaseModel.ChangeEventsBaseModelBuilder getChangeEventsBaseModel();

        public OptionsEventsBaseModel.OptionsEventsBaseModelBuilder getOrCreateOptionsEventsBaseModel();

        @Override
        public OptionsEventsBaseModel.OptionsEventsBaseModelBuilder getOptionsEventsBaseModel();

        public AdditionalEvent.AdditionalEventBuilder getOrCreateAdditionalEvent();

        @Override
        public AdditionalEvent.AdditionalEventBuilder getAdditionalEvent();

        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getOrCreatePartiesAndAccountsModel();

        @Override
        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getPartiesAndAccountsModel();

        public Reason.ReasonBuilder getOrCreateReason(int var1);

        public List<? extends Reason.ReasonBuilder> getReason();

        @Override
        public ConfirmationDisputedBuilder setFpmlVersion(String var1);

        @Override
        public ConfirmationDisputedBuilder setExpectedBuild(Integer var1);

        @Override
        public ConfirmationDisputedBuilder setActualBuild(Integer var1);

        @Override
        public ConfirmationDisputedBuilder setHeader(ResponseMessageHeader var1);

        @Override
        public ConfirmationDisputedBuilder setValidationModel(ValidationModel var1);

        @Override
        public ConfirmationDisputedBuilder setCorrelationAndOptionalSequenceModel(CorrelationAndOptionalSequenceModel var1);

        @Override
        public ConfirmationDisputedBuilder setOnBehalfOfModel(OnBehalfOfModel var1);

        public ConfirmationDisputedBuilder setTradingEventsBaseModel(TradingEventsBaseModel var1);

        public ConfirmationDisputedBuilder setPostTradeEventsBaseModel(PostTradeEventsBaseModel var1);

        public ConfirmationDisputedBuilder setChangeEventsBaseModel(ChangeEventsBaseModel var1);

        public ConfirmationDisputedBuilder setOptionsEventsBaseModel(OptionsEventsBaseModel var1);

        public ConfirmationDisputedBuilder setAdditionalEvent(AdditionalEvent var1);

        public ConfirmationDisputedBuilder setPartiesAndAccountsModel(PartiesAndAccountsModel var1);

        public ConfirmationDisputedBuilder addReason(Reason var1);

        public ConfirmationDisputedBuilder addReason(Reason var1, int var2);

        public ConfirmationDisputedBuilder addReason(List<? extends Reason> var1);

        public ConfirmationDisputedBuilder setReason(List<? extends Reason> var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("fpmlVersion"), String.class, (Object)this.getFpmlVersion(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("expectedBuild"), Integer.class, (Object)this.getExpectedBuild(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("actualBuild"), Integer.class, (Object)this.getActualBuild(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("header"), processor, ResponseMessageHeader.ResponseMessageHeaderBuilder.class, (RosettaModelObjectBuilder)this.getHeader(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("validationModel"), processor, ValidationModel.ValidationModelBuilder.class, (RosettaModelObjectBuilder)this.getValidationModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("correlationAndOptionalSequenceModel"), processor, CorrelationAndOptionalSequenceModel.CorrelationAndOptionalSequenceModelBuilder.class, (RosettaModelObjectBuilder)this.getCorrelationAndOptionalSequenceModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("onBehalfOfModel"), processor, OnBehalfOfModel.OnBehalfOfModelBuilder.class, (RosettaModelObjectBuilder)this.getOnBehalfOfModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("tradingEventsBaseModel"), processor, TradingEventsBaseModel.TradingEventsBaseModelBuilder.class, this.getTradingEventsBaseModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("postTradeEventsBaseModel"), processor, PostTradeEventsBaseModel.PostTradeEventsBaseModelBuilder.class, this.getPostTradeEventsBaseModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("changeEventsBaseModel"), processor, ChangeEventsBaseModel.ChangeEventsBaseModelBuilder.class, this.getChangeEventsBaseModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("optionsEventsBaseModel"), processor, OptionsEventsBaseModel.OptionsEventsBaseModelBuilder.class, this.getOptionsEventsBaseModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("additionalEvent"), processor, AdditionalEvent.AdditionalEventBuilder.class, this.getAdditionalEvent(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("partiesAndAccountsModel"), processor, PartiesAndAccountsModel.PartiesAndAccountsModelBuilder.class, this.getPartiesAndAccountsModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("reason"), processor, Reason.ReasonBuilder.class, this.getReason(), new AttributeMeta[0]);
        }

        @Override
        public ConfirmationDisputedBuilder prune();
    }

    public static class ConfirmationDisputedImpl
    extends ResponseMessage.ResponseMessageImpl
    implements ConfirmationDisputed {
        private final TradingEventsBaseModel tradingEventsBaseModel;
        private final PostTradeEventsBaseModel postTradeEventsBaseModel;
        private final ChangeEventsBaseModel changeEventsBaseModel;
        private final OptionsEventsBaseModel optionsEventsBaseModel;
        private final AdditionalEvent additionalEvent;
        private final PartiesAndAccountsModel partiesAndAccountsModel;
        private final List<? extends Reason> reason;

        protected ConfirmationDisputedImpl(ConfirmationDisputedBuilder builder) {
            super(builder);
            this.tradingEventsBaseModel = Optional.ofNullable(builder.getTradingEventsBaseModel()).map(f -> f.build()).orElse(null);
            this.postTradeEventsBaseModel = Optional.ofNullable(builder.getPostTradeEventsBaseModel()).map(f -> f.build()).orElse(null);
            this.changeEventsBaseModel = Optional.ofNullable(builder.getChangeEventsBaseModel()).map(f -> f.build()).orElse(null);
            this.optionsEventsBaseModel = Optional.ofNullable(builder.getOptionsEventsBaseModel()).map(f -> f.build()).orElse(null);
            this.additionalEvent = Optional.ofNullable(builder.getAdditionalEvent()).map(f -> f.build()).orElse(null);
            this.partiesAndAccountsModel = Optional.ofNullable(builder.getPartiesAndAccountsModel()).map(f -> f.build()).orElse(null);
            this.reason = Optional.ofNullable(builder.getReason()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="tradingEventsBaseModel")
        @RuneAttribute(value="tradingEventsBaseModel")
        public TradingEventsBaseModel getTradingEventsBaseModel() {
            return this.tradingEventsBaseModel;
        }

        @Override
        @RosettaAttribute(value="postTradeEventsBaseModel")
        @RuneAttribute(value="postTradeEventsBaseModel")
        public PostTradeEventsBaseModel getPostTradeEventsBaseModel() {
            return this.postTradeEventsBaseModel;
        }

        @Override
        @RosettaAttribute(value="changeEventsBaseModel")
        @RuneAttribute(value="changeEventsBaseModel")
        public ChangeEventsBaseModel getChangeEventsBaseModel() {
            return this.changeEventsBaseModel;
        }

        @Override
        @RosettaAttribute(value="optionsEventsBaseModel")
        @RuneAttribute(value="optionsEventsBaseModel")
        public OptionsEventsBaseModel getOptionsEventsBaseModel() {
            return this.optionsEventsBaseModel;
        }

        @Override
        @RosettaAttribute(value="additionalEvent")
        @RuneAttribute(value="additionalEvent")
        public AdditionalEvent getAdditionalEvent() {
            return this.additionalEvent;
        }

        @Override
        @RosettaAttribute(value="partiesAndAccountsModel")
        @RuneAttribute(value="partiesAndAccountsModel")
        public PartiesAndAccountsModel getPartiesAndAccountsModel() {
            return this.partiesAndAccountsModel;
        }

        @Override
        @RosettaAttribute(value="reason")
        @RuneAttribute(value="reason")
        public List<? extends Reason> getReason() {
            return this.reason;
        }

        @Override
        public ConfirmationDisputed build() {
            return this;
        }

        @Override
        public ConfirmationDisputedBuilder toBuilder() {
            ConfirmationDisputedBuilder builder = ConfirmationDisputed.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ConfirmationDisputedBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getTradingEventsBaseModel()).ifPresent(builder::setTradingEventsBaseModel);
            Optional.ofNullable(this.getPostTradeEventsBaseModel()).ifPresent(builder::setPostTradeEventsBaseModel);
            Optional.ofNullable(this.getChangeEventsBaseModel()).ifPresent(builder::setChangeEventsBaseModel);
            Optional.ofNullable(this.getOptionsEventsBaseModel()).ifPresent(builder::setOptionsEventsBaseModel);
            Optional.ofNullable(this.getAdditionalEvent()).ifPresent(builder::setAdditionalEvent);
            Optional.ofNullable(this.getPartiesAndAccountsModel()).ifPresent(builder::setPartiesAndAccountsModel);
            Optional.ofNullable(this.getReason()).ifPresent(builder::setReason);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ConfirmationDisputed _that = (ConfirmationDisputed)this.getType().cast(o);
            if (!Objects.equals(this.tradingEventsBaseModel, _that.getTradingEventsBaseModel())) {
                return false;
            }
            if (!Objects.equals(this.postTradeEventsBaseModel, _that.getPostTradeEventsBaseModel())) {
                return false;
            }
            if (!Objects.equals(this.changeEventsBaseModel, _that.getChangeEventsBaseModel())) {
                return false;
            }
            if (!Objects.equals(this.optionsEventsBaseModel, _that.getOptionsEventsBaseModel())) {
                return false;
            }
            if (!Objects.equals(this.additionalEvent, _that.getAdditionalEvent())) {
                return false;
            }
            if (!Objects.equals(this.partiesAndAccountsModel, _that.getPartiesAndAccountsModel())) {
                return false;
            }
            return ListEquals.listEquals(this.reason, _that.getReason());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.tradingEventsBaseModel != null ? this.tradingEventsBaseModel.hashCode() : 0);
            _result = 31 * _result + (this.postTradeEventsBaseModel != null ? this.postTradeEventsBaseModel.hashCode() : 0);
            _result = 31 * _result + (this.changeEventsBaseModel != null ? this.changeEventsBaseModel.hashCode() : 0);
            _result = 31 * _result + (this.optionsEventsBaseModel != null ? this.optionsEventsBaseModel.hashCode() : 0);
            _result = 31 * _result + (this.additionalEvent != null ? this.additionalEvent.hashCode() : 0);
            _result = 31 * _result + (this.partiesAndAccountsModel != null ? this.partiesAndAccountsModel.hashCode() : 0);
            _result = 31 * _result + (this.reason != null ? this.reason.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "ConfirmationDisputed {tradingEventsBaseModel=" + this.tradingEventsBaseModel + ", postTradeEventsBaseModel=" + this.postTradeEventsBaseModel + ", changeEventsBaseModel=" + this.changeEventsBaseModel + ", optionsEventsBaseModel=" + this.optionsEventsBaseModel + ", additionalEvent=" + this.additionalEvent + ", partiesAndAccountsModel=" + this.partiesAndAccountsModel + ", reason=" + this.reason + '}' + " " + super.toString();
        }
    }
}

