/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.com.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import fpml.consolidated.com.ElectricityDelivery;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="ElectricityDeliveryChoice")
@ImplementedBy(value=Default.class)
public interface ElectricityDeliveryChoice
extends Validator<ElectricityDelivery> {
    public static final String NAME = "ElectricityDeliveryChoice";
    public static final String DEFINITION = "one-of";

    public static class NoOp
    implements ElectricityDeliveryChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ElectricityDelivery electricityDelivery) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements ElectricityDeliveryChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ElectricityDelivery electricityDelivery) {
            ComparisonResult result = this.executeDataRule(electricityDelivery);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)ElectricityDeliveryChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ElectricityDelivery", (RosettaPath)path, (String)ElectricityDeliveryChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)ElectricityDeliveryChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ElectricityDelivery", (RosettaPath)path, (String)ElectricityDeliveryChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(ElectricityDelivery electricityDelivery) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)electricityDelivery), Arrays.asList("electricityDeliverySequence0", "electricityDeliverySequence1"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.REQUIRED);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

