/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.com;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.asset.CommodityClassification;
import fpml.consolidated.com.PhysicalLegBase;
import fpml.consolidated.com.meta.PhysicalSwapLegMeta;
import fpml.consolidated.shared.PayerReceiverModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="PhysicalSwapLeg", builder=PhysicalSwapLegBuilderImpl.class, version="1.1.0")
@RuneDataType(value="PhysicalSwapLeg", model="fpml", builder=PhysicalSwapLegBuilderImpl.class, version="1.1.0")
public interface PhysicalSwapLeg
extends PhysicalLegBase {
    public static final PhysicalSwapLegMeta metaData = new PhysicalSwapLegMeta();

    public PayerReceiverModel getPayerReceiverModel();

    @Override
    public PhysicalSwapLeg build();

    @Override
    public PhysicalSwapLegBuilder toBuilder();

    public static PhysicalSwapLegBuilder builder() {
        return new PhysicalSwapLegBuilderImpl();
    }

    default public RosettaMetaData<? extends PhysicalSwapLeg> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends PhysicalSwapLeg> getType() {
        return PhysicalSwapLeg.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("commodityClassification"), processor, CommodityClassification.class, this.getCommodityClassification(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("payerReceiverModel"), processor, PayerReceiverModel.class, this.getPayerReceiverModel(), new AttributeMeta[0]);
    }

    public static class PhysicalSwapLegBuilderImpl
    extends PhysicalLegBase.PhysicalLegBaseBuilderImpl
    implements PhysicalSwapLegBuilder {
        protected PayerReceiverModel.PayerReceiverModelBuilder payerReceiverModel;

        @Override
        @RosettaAttribute(value="payerReceiverModel", isRequired=true)
        @RuneAttribute(value="payerReceiverModel", isRequired=true)
        public PayerReceiverModel.PayerReceiverModelBuilder getPayerReceiverModel() {
            return this.payerReceiverModel;
        }

        @Override
        public PayerReceiverModel.PayerReceiverModelBuilder getOrCreatePayerReceiverModel() {
            PayerReceiverModel.PayerReceiverModelBuilder result = this.payerReceiverModel != null ? this.payerReceiverModel : (this.payerReceiverModel = PayerReceiverModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public PhysicalSwapLegBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="commodityClassification")
        @RuneAttribute(value="commodityClassification")
        public PhysicalSwapLegBuilder addCommodityClassification(CommodityClassification _commodityClassification) {
            if (_commodityClassification != null) {
                this.commodityClassification.add(_commodityClassification.toBuilder());
            }
            return this;
        }

        @Override
        public PhysicalSwapLegBuilder addCommodityClassification(CommodityClassification _commodityClassification, int idx) {
            this.getIndex(this.commodityClassification, idx, () -> _commodityClassification.toBuilder());
            return this;
        }

        @Override
        public PhysicalSwapLegBuilder addCommodityClassification(List<? extends CommodityClassification> commodityClassifications) {
            if (commodityClassifications != null) {
                for (CommodityClassification commodityClassification : commodityClassifications) {
                    this.commodityClassification.add(commodityClassification.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="commodityClassification")
        public PhysicalSwapLegBuilder setCommodityClassification(List<? extends CommodityClassification> commodityClassifications) {
            this.commodityClassification = commodityClassifications == null ? new ArrayList() : (List)commodityClassifications.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="payerReceiverModel", isRequired=true)
        @RuneAttribute(value="payerReceiverModel", isRequired=true)
        public PhysicalSwapLegBuilder setPayerReceiverModel(PayerReceiverModel _payerReceiverModel) {
            this.payerReceiverModel = _payerReceiverModel == null ? null : _payerReceiverModel.toBuilder();
            return this;
        }

        @Override
        public PhysicalSwapLeg build() {
            return new PhysicalSwapLegImpl(this);
        }

        @Override
        public PhysicalSwapLegBuilder toBuilder() {
            return this;
        }

        @Override
        public PhysicalSwapLegBuilder prune() {
            super.prune();
            if (this.payerReceiverModel != null && !this.payerReceiverModel.prune().hasData()) {
                this.payerReceiverModel = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            return this.getPayerReceiverModel() != null && this.getPayerReceiverModel().hasData();
        }

        @Override
        public PhysicalSwapLegBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            PhysicalSwapLegBuilder o = (PhysicalSwapLegBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPayerReceiverModel(), (RosettaModelObjectBuilder)o.getPayerReceiverModel(), this::setPayerReceiverModel);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            PhysicalSwapLeg _that = (PhysicalSwapLeg)this.getType().cast(o);
            return Objects.equals(this.payerReceiverModel, _that.getPayerReceiverModel());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.payerReceiverModel != null ? this.payerReceiverModel.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "PhysicalSwapLegBuilder {payerReceiverModel=" + this.payerReceiverModel + '}' + " " + super.toString();
        }
    }

    public static interface PhysicalSwapLegBuilder
    extends PhysicalSwapLeg,
    PhysicalLegBase.PhysicalLegBaseBuilder {
        public PayerReceiverModel.PayerReceiverModelBuilder getOrCreatePayerReceiverModel();

        @Override
        public PayerReceiverModel.PayerReceiverModelBuilder getPayerReceiverModel();

        @Override
        public PhysicalSwapLegBuilder setId(String var1);

        @Override
        public PhysicalSwapLegBuilder addCommodityClassification(CommodityClassification var1);

        @Override
        public PhysicalSwapLegBuilder addCommodityClassification(CommodityClassification var1, int var2);

        @Override
        public PhysicalSwapLegBuilder addCommodityClassification(List<? extends CommodityClassification> var1);

        @Override
        public PhysicalSwapLegBuilder setCommodityClassification(List<? extends CommodityClassification> var1);

        public PhysicalSwapLegBuilder setPayerReceiverModel(PayerReceiverModel var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("commodityClassification"), processor, CommodityClassification.CommodityClassificationBuilder.class, this.getCommodityClassification(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("payerReceiverModel"), processor, PayerReceiverModel.PayerReceiverModelBuilder.class, this.getPayerReceiverModel(), new AttributeMeta[0]);
        }

        @Override
        public PhysicalSwapLegBuilder prune();
    }

    public static class PhysicalSwapLegImpl
    extends PhysicalLegBase.PhysicalLegBaseImpl
    implements PhysicalSwapLeg {
        private final PayerReceiverModel payerReceiverModel;

        protected PhysicalSwapLegImpl(PhysicalSwapLegBuilder builder) {
            super(builder);
            this.payerReceiverModel = Optional.ofNullable(builder.getPayerReceiverModel()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="payerReceiverModel", isRequired=true)
        @RuneAttribute(value="payerReceiverModel", isRequired=true)
        public PayerReceiverModel getPayerReceiverModel() {
            return this.payerReceiverModel;
        }

        @Override
        public PhysicalSwapLeg build() {
            return this;
        }

        @Override
        public PhysicalSwapLegBuilder toBuilder() {
            PhysicalSwapLegBuilder builder = PhysicalSwapLeg.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(PhysicalSwapLegBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getPayerReceiverModel()).ifPresent(builder::setPayerReceiverModel);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            PhysicalSwapLeg _that = (PhysicalSwapLeg)this.getType().cast(o);
            return Objects.equals(this.payerReceiverModel, _that.getPayerReceiverModel());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.payerReceiverModel != null ? this.payerReceiverModel.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "PhysicalSwapLeg {payerReceiverModel=" + this.payerReceiverModel + '}' + " " + super.toString();
        }
    }
}

