/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.com;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.com.CommodityDeliveryPoint;
import fpml.consolidated.com.meta.OilTransferDeliveryMeta;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="OilTransferDelivery", builder=OilTransferDeliveryBuilderImpl.class, version="1.1.0")
@RuneDataType(value="OilTransferDelivery", model="fpml", builder=OilTransferDeliveryBuilderImpl.class, version="1.1.0")
public interface OilTransferDelivery
extends RosettaModelObject {
    public static final OilTransferDeliveryMeta metaData = new OilTransferDeliveryMeta();

    public Boolean getApplicable();

    public CommodityDeliveryPoint getDeliveryLocation();

    public OilTransferDelivery build();

    public OilTransferDeliveryBuilder toBuilder();

    public static OilTransferDeliveryBuilder builder() {
        return new OilTransferDeliveryBuilderImpl();
    }

    default public RosettaMetaData<? extends OilTransferDelivery> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends OilTransferDelivery> getType() {
        return OilTransferDelivery.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("applicable"), Boolean.class, (Object)this.getApplicable(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("deliveryLocation"), processor, CommodityDeliveryPoint.class, this.getDeliveryLocation(), new AttributeMeta[0]);
    }

    public static class OilTransferDeliveryBuilderImpl
    implements OilTransferDeliveryBuilder {
        protected Boolean applicable;
        protected CommodityDeliveryPoint.CommodityDeliveryPointBuilder deliveryLocation;

        @Override
        @RosettaAttribute(value="applicable")
        @RuneAttribute(value="applicable")
        public Boolean getApplicable() {
            return this.applicable;
        }

        @Override
        @RosettaAttribute(value="deliveryLocation")
        @RuneAttribute(value="deliveryLocation")
        public CommodityDeliveryPoint.CommodityDeliveryPointBuilder getDeliveryLocation() {
            return this.deliveryLocation;
        }

        @Override
        public CommodityDeliveryPoint.CommodityDeliveryPointBuilder getOrCreateDeliveryLocation() {
            CommodityDeliveryPoint.CommodityDeliveryPointBuilder result = this.deliveryLocation != null ? this.deliveryLocation : (this.deliveryLocation = CommodityDeliveryPoint.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="applicable")
        @RuneAttribute(value="applicable")
        public OilTransferDeliveryBuilder setApplicable(Boolean _applicable) {
            this.applicable = _applicable == null ? null : _applicable;
            return this;
        }

        @Override
        @RosettaAttribute(value="deliveryLocation")
        @RuneAttribute(value="deliveryLocation")
        public OilTransferDeliveryBuilder setDeliveryLocation(CommodityDeliveryPoint _deliveryLocation) {
            this.deliveryLocation = _deliveryLocation == null ? null : _deliveryLocation.toBuilder();
            return this;
        }

        @Override
        public OilTransferDelivery build() {
            return new OilTransferDeliveryImpl(this);
        }

        @Override
        public OilTransferDeliveryBuilder toBuilder() {
            return this;
        }

        @Override
        public OilTransferDeliveryBuilder prune() {
            if (this.deliveryLocation != null && !this.deliveryLocation.prune().hasData()) {
                this.deliveryLocation = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getApplicable() != null) {
                return true;
            }
            return this.getDeliveryLocation() != null && this.getDeliveryLocation().hasData();
        }

        public OilTransferDeliveryBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            OilTransferDeliveryBuilder o = (OilTransferDeliveryBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDeliveryLocation(), (RosettaModelObjectBuilder)o.getDeliveryLocation(), this::setDeliveryLocation);
            merger.mergeBasic((Object)this.getApplicable(), (Object)o.getApplicable(), this::setApplicable, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            OilTransferDelivery _that = this.getType().cast(o);
            if (!Objects.equals(this.applicable, _that.getApplicable())) {
                return false;
            }
            return Objects.equals(this.deliveryLocation, _that.getDeliveryLocation());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.applicable != null ? this.applicable.hashCode() : 0);
            _result = 31 * _result + (this.deliveryLocation != null ? this.deliveryLocation.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "OilTransferDeliveryBuilder {applicable=" + this.applicable + ", deliveryLocation=" + this.deliveryLocation + '}';
        }
    }

    public static interface OilTransferDeliveryBuilder
    extends OilTransferDelivery,
    RosettaModelObjectBuilder {
        public CommodityDeliveryPoint.CommodityDeliveryPointBuilder getOrCreateDeliveryLocation();

        @Override
        public CommodityDeliveryPoint.CommodityDeliveryPointBuilder getDeliveryLocation();

        public OilTransferDeliveryBuilder setApplicable(Boolean var1);

        public OilTransferDeliveryBuilder setDeliveryLocation(CommodityDeliveryPoint var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("applicable"), Boolean.class, (Object)this.getApplicable(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("deliveryLocation"), processor, CommodityDeliveryPoint.CommodityDeliveryPointBuilder.class, this.getDeliveryLocation(), new AttributeMeta[0]);
        }

        public OilTransferDeliveryBuilder prune();
    }

    public static class OilTransferDeliveryImpl
    implements OilTransferDelivery {
        private final Boolean applicable;
        private final CommodityDeliveryPoint deliveryLocation;

        protected OilTransferDeliveryImpl(OilTransferDeliveryBuilder builder) {
            this.applicable = builder.getApplicable();
            this.deliveryLocation = Optional.ofNullable(builder.getDeliveryLocation()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="applicable")
        @RuneAttribute(value="applicable")
        public Boolean getApplicable() {
            return this.applicable;
        }

        @Override
        @RosettaAttribute(value="deliveryLocation")
        @RuneAttribute(value="deliveryLocation")
        public CommodityDeliveryPoint getDeliveryLocation() {
            return this.deliveryLocation;
        }

        @Override
        public OilTransferDelivery build() {
            return this;
        }

        @Override
        public OilTransferDeliveryBuilder toBuilder() {
            OilTransferDeliveryBuilder builder = OilTransferDelivery.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(OilTransferDeliveryBuilder builder) {
            Optional.ofNullable(this.getApplicable()).ifPresent(builder::setApplicable);
            Optional.ofNullable(this.getDeliveryLocation()).ifPresent(builder::setDeliveryLocation);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            OilTransferDelivery _that = this.getType().cast(o);
            if (!Objects.equals(this.applicable, _that.getApplicable())) {
                return false;
            }
            return Objects.equals(this.deliveryLocation, _that.getDeliveryLocation());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.applicable != null ? this.applicable.hashCode() : 0);
            _result = 31 * _result + (this.deliveryLocation != null ? this.deliveryLocation.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "OilTransferDelivery {applicable=" + this.applicable + ", deliveryLocation=" + this.deliveryLocation + '}';
        }
    }
}

