/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.com;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.com.CommodityDeliveryPoint;
import fpml.consolidated.com.CommodityDeliveryRisk;
import fpml.consolidated.com.meta.MetalDeliveryMeta;
import fpml.consolidated.fpmlenum.MetalTitleEnum;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="MetalDelivery", builder=MetalDeliveryBuilderImpl.class, version="1.1.0")
@RuneDataType(value="MetalDelivery", model="fpml", builder=MetalDeliveryBuilderImpl.class, version="1.1.0")
public interface MetalDelivery
extends RosettaModelObject {
    public static final MetalDeliveryMeta metaData = new MetalDeliveryMeta();

    public CommodityDeliveryPoint getDeliveryLocation();

    public CommodityDeliveryRisk getRisk();

    public BigDecimal getTotalQuantityTolerance();

    public BigDecimal getPeriodQuantityTolerance();

    public MetalTitleEnum getTitle();

    public MetalDelivery build();

    public MetalDeliveryBuilder toBuilder();

    public static MetalDeliveryBuilder builder() {
        return new MetalDeliveryBuilderImpl();
    }

    default public RosettaMetaData<? extends MetalDelivery> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends MetalDelivery> getType() {
        return MetalDelivery.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("deliveryLocation"), processor, CommodityDeliveryPoint.class, this.getDeliveryLocation(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("risk"), processor, CommodityDeliveryRisk.class, this.getRisk(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("totalQuantityTolerance"), BigDecimal.class, (Object)this.getTotalQuantityTolerance(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("periodQuantityTolerance"), BigDecimal.class, (Object)this.getPeriodQuantityTolerance(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("title"), MetalTitleEnum.class, (Object)this.getTitle(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class MetalDeliveryBuilderImpl
    implements MetalDeliveryBuilder {
        protected CommodityDeliveryPoint.CommodityDeliveryPointBuilder deliveryLocation;
        protected CommodityDeliveryRisk.CommodityDeliveryRiskBuilder risk;
        protected BigDecimal totalQuantityTolerance;
        protected BigDecimal periodQuantityTolerance;
        protected MetalTitleEnum title;

        @Override
        @RosettaAttribute(value="deliveryLocation")
        @RuneAttribute(value="deliveryLocation")
        public CommodityDeliveryPoint.CommodityDeliveryPointBuilder getDeliveryLocation() {
            return this.deliveryLocation;
        }

        @Override
        public CommodityDeliveryPoint.CommodityDeliveryPointBuilder getOrCreateDeliveryLocation() {
            CommodityDeliveryPoint.CommodityDeliveryPointBuilder result = this.deliveryLocation != null ? this.deliveryLocation : (this.deliveryLocation = CommodityDeliveryPoint.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="risk")
        @RuneAttribute(value="risk")
        public CommodityDeliveryRisk.CommodityDeliveryRiskBuilder getRisk() {
            return this.risk;
        }

        @Override
        public CommodityDeliveryRisk.CommodityDeliveryRiskBuilder getOrCreateRisk() {
            CommodityDeliveryRisk.CommodityDeliveryRiskBuilder result = this.risk != null ? this.risk : (this.risk = CommodityDeliveryRisk.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="totalQuantityTolerance")
        @RuneAttribute(value="totalQuantityTolerance")
        public BigDecimal getTotalQuantityTolerance() {
            return this.totalQuantityTolerance;
        }

        @Override
        @RosettaAttribute(value="periodQuantityTolerance")
        @RuneAttribute(value="periodQuantityTolerance")
        public BigDecimal getPeriodQuantityTolerance() {
            return this.periodQuantityTolerance;
        }

        @Override
        @RosettaAttribute(value="title")
        @RuneAttribute(value="title")
        public MetalTitleEnum getTitle() {
            return this.title;
        }

        @Override
        @RosettaAttribute(value="deliveryLocation")
        @RuneAttribute(value="deliveryLocation")
        public MetalDeliveryBuilder setDeliveryLocation(CommodityDeliveryPoint _deliveryLocation) {
            this.deliveryLocation = _deliveryLocation == null ? null : _deliveryLocation.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="risk")
        @RuneAttribute(value="risk")
        public MetalDeliveryBuilder setRisk(CommodityDeliveryRisk _risk) {
            this.risk = _risk == null ? null : _risk.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="totalQuantityTolerance")
        @RuneAttribute(value="totalQuantityTolerance")
        public MetalDeliveryBuilder setTotalQuantityTolerance(BigDecimal _totalQuantityTolerance) {
            this.totalQuantityTolerance = _totalQuantityTolerance == null ? null : _totalQuantityTolerance;
            return this;
        }

        @Override
        @RosettaAttribute(value="periodQuantityTolerance")
        @RuneAttribute(value="periodQuantityTolerance")
        public MetalDeliveryBuilder setPeriodQuantityTolerance(BigDecimal _periodQuantityTolerance) {
            this.periodQuantityTolerance = _periodQuantityTolerance == null ? null : _periodQuantityTolerance;
            return this;
        }

        @Override
        @RosettaAttribute(value="title")
        @RuneAttribute(value="title")
        public MetalDeliveryBuilder setTitle(MetalTitleEnum _title) {
            this.title = _title == null ? null : _title;
            return this;
        }

        @Override
        public MetalDelivery build() {
            return new MetalDeliveryImpl(this);
        }

        @Override
        public MetalDeliveryBuilder toBuilder() {
            return this;
        }

        @Override
        public MetalDeliveryBuilder prune() {
            if (this.deliveryLocation != null && !this.deliveryLocation.prune().hasData()) {
                this.deliveryLocation = null;
            }
            if (this.risk != null && !this.risk.prune().hasData()) {
                this.risk = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getDeliveryLocation() != null && this.getDeliveryLocation().hasData()) {
                return true;
            }
            if (this.getRisk() != null && this.getRisk().hasData()) {
                return true;
            }
            if (this.getTotalQuantityTolerance() != null) {
                return true;
            }
            if (this.getPeriodQuantityTolerance() != null) {
                return true;
            }
            return this.getTitle() != null;
        }

        public MetalDeliveryBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            MetalDeliveryBuilder o = (MetalDeliveryBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDeliveryLocation(), (RosettaModelObjectBuilder)o.getDeliveryLocation(), this::setDeliveryLocation);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getRisk(), (RosettaModelObjectBuilder)o.getRisk(), this::setRisk);
            merger.mergeBasic((Object)this.getTotalQuantityTolerance(), (Object)o.getTotalQuantityTolerance(), this::setTotalQuantityTolerance, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPeriodQuantityTolerance(), (Object)o.getPeriodQuantityTolerance(), this::setPeriodQuantityTolerance, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getTitle(), (Object)o.getTitle(), this::setTitle, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            MetalDelivery _that = this.getType().cast(o);
            if (!Objects.equals(this.deliveryLocation, _that.getDeliveryLocation())) {
                return false;
            }
            if (!Objects.equals(this.risk, _that.getRisk())) {
                return false;
            }
            if (!Objects.equals(this.totalQuantityTolerance, _that.getTotalQuantityTolerance())) {
                return false;
            }
            if (!Objects.equals(this.periodQuantityTolerance, _that.getPeriodQuantityTolerance())) {
                return false;
            }
            return Objects.equals((Object)this.title, (Object)_that.getTitle());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.deliveryLocation != null ? this.deliveryLocation.hashCode() : 0);
            _result = 31 * _result + (this.risk != null ? this.risk.hashCode() : 0);
            _result = 31 * _result + (this.totalQuantityTolerance != null ? this.totalQuantityTolerance.hashCode() : 0);
            _result = 31 * _result + (this.periodQuantityTolerance != null ? this.periodQuantityTolerance.hashCode() : 0);
            _result = 31 * _result + (this.title != null ? ((Object)((Object)this.title)).getClass().getName().hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "MetalDeliveryBuilder {deliveryLocation=" + this.deliveryLocation + ", risk=" + this.risk + ", totalQuantityTolerance=" + this.totalQuantityTolerance + ", periodQuantityTolerance=" + this.periodQuantityTolerance + ", title=" + (Object)((Object)this.title) + '}';
        }
    }

    public static interface MetalDeliveryBuilder
    extends MetalDelivery,
    RosettaModelObjectBuilder {
        public CommodityDeliveryPoint.CommodityDeliveryPointBuilder getOrCreateDeliveryLocation();

        @Override
        public CommodityDeliveryPoint.CommodityDeliveryPointBuilder getDeliveryLocation();

        public CommodityDeliveryRisk.CommodityDeliveryRiskBuilder getOrCreateRisk();

        @Override
        public CommodityDeliveryRisk.CommodityDeliveryRiskBuilder getRisk();

        public MetalDeliveryBuilder setDeliveryLocation(CommodityDeliveryPoint var1);

        public MetalDeliveryBuilder setRisk(CommodityDeliveryRisk var1);

        public MetalDeliveryBuilder setTotalQuantityTolerance(BigDecimal var1);

        public MetalDeliveryBuilder setPeriodQuantityTolerance(BigDecimal var1);

        public MetalDeliveryBuilder setTitle(MetalTitleEnum var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("deliveryLocation"), processor, CommodityDeliveryPoint.CommodityDeliveryPointBuilder.class, this.getDeliveryLocation(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("risk"), processor, CommodityDeliveryRisk.CommodityDeliveryRiskBuilder.class, this.getRisk(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("totalQuantityTolerance"), BigDecimal.class, (Object)this.getTotalQuantityTolerance(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("periodQuantityTolerance"), BigDecimal.class, (Object)this.getPeriodQuantityTolerance(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("title"), MetalTitleEnum.class, (Object)this.getTitle(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public MetalDeliveryBuilder prune();
    }

    public static class MetalDeliveryImpl
    implements MetalDelivery {
        private final CommodityDeliveryPoint deliveryLocation;
        private final CommodityDeliveryRisk risk;
        private final BigDecimal totalQuantityTolerance;
        private final BigDecimal periodQuantityTolerance;
        private final MetalTitleEnum title;

        protected MetalDeliveryImpl(MetalDeliveryBuilder builder) {
            this.deliveryLocation = Optional.ofNullable(builder.getDeliveryLocation()).map(f -> f.build()).orElse(null);
            this.risk = Optional.ofNullable(builder.getRisk()).map(f -> f.build()).orElse(null);
            this.totalQuantityTolerance = builder.getTotalQuantityTolerance();
            this.periodQuantityTolerance = builder.getPeriodQuantityTolerance();
            this.title = builder.getTitle();
        }

        @Override
        @RosettaAttribute(value="deliveryLocation")
        @RuneAttribute(value="deliveryLocation")
        public CommodityDeliveryPoint getDeliveryLocation() {
            return this.deliveryLocation;
        }

        @Override
        @RosettaAttribute(value="risk")
        @RuneAttribute(value="risk")
        public CommodityDeliveryRisk getRisk() {
            return this.risk;
        }

        @Override
        @RosettaAttribute(value="totalQuantityTolerance")
        @RuneAttribute(value="totalQuantityTolerance")
        public BigDecimal getTotalQuantityTolerance() {
            return this.totalQuantityTolerance;
        }

        @Override
        @RosettaAttribute(value="periodQuantityTolerance")
        @RuneAttribute(value="periodQuantityTolerance")
        public BigDecimal getPeriodQuantityTolerance() {
            return this.periodQuantityTolerance;
        }

        @Override
        @RosettaAttribute(value="title")
        @RuneAttribute(value="title")
        public MetalTitleEnum getTitle() {
            return this.title;
        }

        @Override
        public MetalDelivery build() {
            return this;
        }

        @Override
        public MetalDeliveryBuilder toBuilder() {
            MetalDeliveryBuilder builder = MetalDelivery.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(MetalDeliveryBuilder builder) {
            Optional.ofNullable(this.getDeliveryLocation()).ifPresent(builder::setDeliveryLocation);
            Optional.ofNullable(this.getRisk()).ifPresent(builder::setRisk);
            Optional.ofNullable(this.getTotalQuantityTolerance()).ifPresent(builder::setTotalQuantityTolerance);
            Optional.ofNullable(this.getPeriodQuantityTolerance()).ifPresent(builder::setPeriodQuantityTolerance);
            Optional.ofNullable(this.getTitle()).ifPresent(builder::setTitle);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            MetalDelivery _that = this.getType().cast(o);
            if (!Objects.equals(this.deliveryLocation, _that.getDeliveryLocation())) {
                return false;
            }
            if (!Objects.equals(this.risk, _that.getRisk())) {
                return false;
            }
            if (!Objects.equals(this.totalQuantityTolerance, _that.getTotalQuantityTolerance())) {
                return false;
            }
            if (!Objects.equals(this.periodQuantityTolerance, _that.getPeriodQuantityTolerance())) {
                return false;
            }
            return Objects.equals((Object)this.title, (Object)_that.getTitle());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.deliveryLocation != null ? this.deliveryLocation.hashCode() : 0);
            _result = 31 * _result + (this.risk != null ? this.risk.hashCode() : 0);
            _result = 31 * _result + (this.totalQuantityTolerance != null ? this.totalQuantityTolerance.hashCode() : 0);
            _result = 31 * _result + (this.periodQuantityTolerance != null ? this.periodQuantityTolerance.hashCode() : 0);
            _result = 31 * _result + (this.title != null ? ((Object)((Object)this.title)).getClass().getName().hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "MetalDelivery {deliveryLocation=" + this.deliveryLocation + ", risk=" + this.risk + ", totalQuantityTolerance=" + this.totalQuantityTolerance + ", periodQuantityTolerance=" + this.periodQuantityTolerance + ", title=" + (Object)((Object)this.title) + '}';
        }
    }
}

