/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.com;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.com.CommodityNotionalQuantity;
import fpml.consolidated.com.meta.GasPhysicalQuantitySequenceMeta;
import fpml.consolidated.shared.PartyReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="GasPhysicalQuantitySequence", builder=GasPhysicalQuantitySequenceBuilderImpl.class, version="1.1.0")
@RuneDataType(value="GasPhysicalQuantitySequence", model="fpml", builder=GasPhysicalQuantitySequenceBuilderImpl.class, version="1.1.0")
public interface GasPhysicalQuantitySequence
extends RosettaModelObject {
    public static final GasPhysicalQuantitySequenceMeta metaData = new GasPhysicalQuantitySequenceMeta();

    public List<? extends CommodityNotionalQuantity> getMinPhysicalQuantity();

    public List<? extends CommodityNotionalQuantity> getMaxPhysicalQuantity();

    public PartyReference getElectingParty();

    public GasPhysicalQuantitySequence build();

    public GasPhysicalQuantitySequenceBuilder toBuilder();

    public static GasPhysicalQuantitySequenceBuilder builder() {
        return new GasPhysicalQuantitySequenceBuilderImpl();
    }

    default public RosettaMetaData<? extends GasPhysicalQuantitySequence> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends GasPhysicalQuantitySequence> getType() {
        return GasPhysicalQuantitySequence.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("minPhysicalQuantity"), processor, CommodityNotionalQuantity.class, this.getMinPhysicalQuantity(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("maxPhysicalQuantity"), processor, CommodityNotionalQuantity.class, this.getMaxPhysicalQuantity(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("electingParty"), processor, PartyReference.class, this.getElectingParty(), new AttributeMeta[0]);
    }

    public static class GasPhysicalQuantitySequenceBuilderImpl
    implements GasPhysicalQuantitySequenceBuilder {
        protected List<CommodityNotionalQuantity.CommodityNotionalQuantityBuilder> minPhysicalQuantity = new ArrayList<CommodityNotionalQuantity.CommodityNotionalQuantityBuilder>();
        protected List<CommodityNotionalQuantity.CommodityNotionalQuantityBuilder> maxPhysicalQuantity = new ArrayList<CommodityNotionalQuantity.CommodityNotionalQuantityBuilder>();
        protected PartyReference.PartyReferenceBuilder electingParty;

        @Override
        @RosettaAttribute(value="minPhysicalQuantity")
        @RuneAttribute(value="minPhysicalQuantity")
        public List<? extends CommodityNotionalQuantity.CommodityNotionalQuantityBuilder> getMinPhysicalQuantity() {
            return this.minPhysicalQuantity;
        }

        @Override
        public CommodityNotionalQuantity.CommodityNotionalQuantityBuilder getOrCreateMinPhysicalQuantity(int index) {
            if (this.minPhysicalQuantity == null) {
                this.minPhysicalQuantity = new ArrayList<CommodityNotionalQuantity.CommodityNotionalQuantityBuilder>();
            }
            return (CommodityNotionalQuantity.CommodityNotionalQuantityBuilder)this.getIndex(this.minPhysicalQuantity, index, () -> {
                CommodityNotionalQuantity.CommodityNotionalQuantityBuilder newMinPhysicalQuantity = CommodityNotionalQuantity.builder();
                return newMinPhysicalQuantity;
            });
        }

        @Override
        @RosettaAttribute(value="maxPhysicalQuantity")
        @RuneAttribute(value="maxPhysicalQuantity")
        public List<? extends CommodityNotionalQuantity.CommodityNotionalQuantityBuilder> getMaxPhysicalQuantity() {
            return this.maxPhysicalQuantity;
        }

        @Override
        public CommodityNotionalQuantity.CommodityNotionalQuantityBuilder getOrCreateMaxPhysicalQuantity(int index) {
            if (this.maxPhysicalQuantity == null) {
                this.maxPhysicalQuantity = new ArrayList<CommodityNotionalQuantity.CommodityNotionalQuantityBuilder>();
            }
            return (CommodityNotionalQuantity.CommodityNotionalQuantityBuilder)this.getIndex(this.maxPhysicalQuantity, index, () -> {
                CommodityNotionalQuantity.CommodityNotionalQuantityBuilder newMaxPhysicalQuantity = CommodityNotionalQuantity.builder();
                return newMaxPhysicalQuantity;
            });
        }

        @Override
        @RosettaAttribute(value="electingParty")
        @RuneAttribute(value="electingParty")
        public PartyReference.PartyReferenceBuilder getElectingParty() {
            return this.electingParty;
        }

        @Override
        public PartyReference.PartyReferenceBuilder getOrCreateElectingParty() {
            PartyReference.PartyReferenceBuilder result = this.electingParty != null ? this.electingParty : (this.electingParty = PartyReference.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="minPhysicalQuantity")
        @RuneAttribute(value="minPhysicalQuantity")
        public GasPhysicalQuantitySequenceBuilder addMinPhysicalQuantity(CommodityNotionalQuantity _minPhysicalQuantity) {
            if (_minPhysicalQuantity != null) {
                this.minPhysicalQuantity.add(_minPhysicalQuantity.toBuilder());
            }
            return this;
        }

        @Override
        public GasPhysicalQuantitySequenceBuilder addMinPhysicalQuantity(CommodityNotionalQuantity _minPhysicalQuantity, int idx) {
            this.getIndex(this.minPhysicalQuantity, idx, () -> _minPhysicalQuantity.toBuilder());
            return this;
        }

        @Override
        public GasPhysicalQuantitySequenceBuilder addMinPhysicalQuantity(List<? extends CommodityNotionalQuantity> minPhysicalQuantitys) {
            if (minPhysicalQuantitys != null) {
                for (CommodityNotionalQuantity commodityNotionalQuantity : minPhysicalQuantitys) {
                    this.minPhysicalQuantity.add(commodityNotionalQuantity.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="minPhysicalQuantity")
        public GasPhysicalQuantitySequenceBuilder setMinPhysicalQuantity(List<? extends CommodityNotionalQuantity> minPhysicalQuantitys) {
            this.minPhysicalQuantity = minPhysicalQuantitys == null ? new ArrayList<CommodityNotionalQuantity.CommodityNotionalQuantityBuilder>() : (List)minPhysicalQuantitys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="maxPhysicalQuantity")
        @RuneAttribute(value="maxPhysicalQuantity")
        public GasPhysicalQuantitySequenceBuilder addMaxPhysicalQuantity(CommodityNotionalQuantity _maxPhysicalQuantity) {
            if (_maxPhysicalQuantity != null) {
                this.maxPhysicalQuantity.add(_maxPhysicalQuantity.toBuilder());
            }
            return this;
        }

        @Override
        public GasPhysicalQuantitySequenceBuilder addMaxPhysicalQuantity(CommodityNotionalQuantity _maxPhysicalQuantity, int idx) {
            this.getIndex(this.maxPhysicalQuantity, idx, () -> _maxPhysicalQuantity.toBuilder());
            return this;
        }

        @Override
        public GasPhysicalQuantitySequenceBuilder addMaxPhysicalQuantity(List<? extends CommodityNotionalQuantity> maxPhysicalQuantitys) {
            if (maxPhysicalQuantitys != null) {
                for (CommodityNotionalQuantity commodityNotionalQuantity : maxPhysicalQuantitys) {
                    this.maxPhysicalQuantity.add(commodityNotionalQuantity.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="maxPhysicalQuantity")
        public GasPhysicalQuantitySequenceBuilder setMaxPhysicalQuantity(List<? extends CommodityNotionalQuantity> maxPhysicalQuantitys) {
            this.maxPhysicalQuantity = maxPhysicalQuantitys == null ? new ArrayList<CommodityNotionalQuantity.CommodityNotionalQuantityBuilder>() : (List)maxPhysicalQuantitys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="electingParty")
        @RuneAttribute(value="electingParty")
        public GasPhysicalQuantitySequenceBuilder setElectingParty(PartyReference _electingParty) {
            this.electingParty = _electingParty == null ? null : _electingParty.toBuilder();
            return this;
        }

        @Override
        public GasPhysicalQuantitySequence build() {
            return new GasPhysicalQuantitySequenceImpl(this);
        }

        @Override
        public GasPhysicalQuantitySequenceBuilder toBuilder() {
            return this;
        }

        @Override
        public GasPhysicalQuantitySequenceBuilder prune() {
            this.minPhysicalQuantity = this.minPhysicalQuantity.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.maxPhysicalQuantity = this.maxPhysicalQuantity.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.electingParty != null && !this.electingParty.prune().hasData()) {
                this.electingParty = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getMinPhysicalQuantity() != null && this.getMinPhysicalQuantity().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getMaxPhysicalQuantity() != null && this.getMaxPhysicalQuantity().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getElectingParty() != null && this.getElectingParty().hasData();
        }

        public GasPhysicalQuantitySequenceBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            GasPhysicalQuantitySequenceBuilder o = (GasPhysicalQuantitySequenceBuilder)other;
            merger.mergeRosetta(this.getMinPhysicalQuantity(), o.getMinPhysicalQuantity(), this::getOrCreateMinPhysicalQuantity);
            merger.mergeRosetta(this.getMaxPhysicalQuantity(), o.getMaxPhysicalQuantity(), this::getOrCreateMaxPhysicalQuantity);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getElectingParty(), (RosettaModelObjectBuilder)o.getElectingParty(), this::setElectingParty);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            GasPhysicalQuantitySequence _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.minPhysicalQuantity, _that.getMinPhysicalQuantity())) {
                return false;
            }
            if (!ListEquals.listEquals(this.maxPhysicalQuantity, _that.getMaxPhysicalQuantity())) {
                return false;
            }
            return Objects.equals(this.electingParty, _that.getElectingParty());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.minPhysicalQuantity != null ? this.minPhysicalQuantity.hashCode() : 0);
            _result = 31 * _result + (this.maxPhysicalQuantity != null ? this.maxPhysicalQuantity.hashCode() : 0);
            _result = 31 * _result + (this.electingParty != null ? this.electingParty.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "GasPhysicalQuantitySequenceBuilder {minPhysicalQuantity=" + this.minPhysicalQuantity + ", maxPhysicalQuantity=" + this.maxPhysicalQuantity + ", electingParty=" + this.electingParty + '}';
        }
    }

    public static interface GasPhysicalQuantitySequenceBuilder
    extends GasPhysicalQuantitySequence,
    RosettaModelObjectBuilder {
        public CommodityNotionalQuantity.CommodityNotionalQuantityBuilder getOrCreateMinPhysicalQuantity(int var1);

        public List<? extends CommodityNotionalQuantity.CommodityNotionalQuantityBuilder> getMinPhysicalQuantity();

        public CommodityNotionalQuantity.CommodityNotionalQuantityBuilder getOrCreateMaxPhysicalQuantity(int var1);

        public List<? extends CommodityNotionalQuantity.CommodityNotionalQuantityBuilder> getMaxPhysicalQuantity();

        public PartyReference.PartyReferenceBuilder getOrCreateElectingParty();

        @Override
        public PartyReference.PartyReferenceBuilder getElectingParty();

        public GasPhysicalQuantitySequenceBuilder addMinPhysicalQuantity(CommodityNotionalQuantity var1);

        public GasPhysicalQuantitySequenceBuilder addMinPhysicalQuantity(CommodityNotionalQuantity var1, int var2);

        public GasPhysicalQuantitySequenceBuilder addMinPhysicalQuantity(List<? extends CommodityNotionalQuantity> var1);

        public GasPhysicalQuantitySequenceBuilder setMinPhysicalQuantity(List<? extends CommodityNotionalQuantity> var1);

        public GasPhysicalQuantitySequenceBuilder addMaxPhysicalQuantity(CommodityNotionalQuantity var1);

        public GasPhysicalQuantitySequenceBuilder addMaxPhysicalQuantity(CommodityNotionalQuantity var1, int var2);

        public GasPhysicalQuantitySequenceBuilder addMaxPhysicalQuantity(List<? extends CommodityNotionalQuantity> var1);

        public GasPhysicalQuantitySequenceBuilder setMaxPhysicalQuantity(List<? extends CommodityNotionalQuantity> var1);

        public GasPhysicalQuantitySequenceBuilder setElectingParty(PartyReference var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("minPhysicalQuantity"), processor, CommodityNotionalQuantity.CommodityNotionalQuantityBuilder.class, this.getMinPhysicalQuantity(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("maxPhysicalQuantity"), processor, CommodityNotionalQuantity.CommodityNotionalQuantityBuilder.class, this.getMaxPhysicalQuantity(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("electingParty"), processor, PartyReference.PartyReferenceBuilder.class, this.getElectingParty(), new AttributeMeta[0]);
        }

        public GasPhysicalQuantitySequenceBuilder prune();
    }

    public static class GasPhysicalQuantitySequenceImpl
    implements GasPhysicalQuantitySequence {
        private final List<? extends CommodityNotionalQuantity> minPhysicalQuantity;
        private final List<? extends CommodityNotionalQuantity> maxPhysicalQuantity;
        private final PartyReference electingParty;

        protected GasPhysicalQuantitySequenceImpl(GasPhysicalQuantitySequenceBuilder builder) {
            this.minPhysicalQuantity = Optional.ofNullable(builder.getMinPhysicalQuantity()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.maxPhysicalQuantity = Optional.ofNullable(builder.getMaxPhysicalQuantity()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.electingParty = Optional.ofNullable(builder.getElectingParty()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="minPhysicalQuantity")
        @RuneAttribute(value="minPhysicalQuantity")
        public List<? extends CommodityNotionalQuantity> getMinPhysicalQuantity() {
            return this.minPhysicalQuantity;
        }

        @Override
        @RosettaAttribute(value="maxPhysicalQuantity")
        @RuneAttribute(value="maxPhysicalQuantity")
        public List<? extends CommodityNotionalQuantity> getMaxPhysicalQuantity() {
            return this.maxPhysicalQuantity;
        }

        @Override
        @RosettaAttribute(value="electingParty")
        @RuneAttribute(value="electingParty")
        public PartyReference getElectingParty() {
            return this.electingParty;
        }

        @Override
        public GasPhysicalQuantitySequence build() {
            return this;
        }

        @Override
        public GasPhysicalQuantitySequenceBuilder toBuilder() {
            GasPhysicalQuantitySequenceBuilder builder = GasPhysicalQuantitySequence.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(GasPhysicalQuantitySequenceBuilder builder) {
            Optional.ofNullable(this.getMinPhysicalQuantity()).ifPresent(builder::setMinPhysicalQuantity);
            Optional.ofNullable(this.getMaxPhysicalQuantity()).ifPresent(builder::setMaxPhysicalQuantity);
            Optional.ofNullable(this.getElectingParty()).ifPresent(builder::setElectingParty);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            GasPhysicalQuantitySequence _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.minPhysicalQuantity, _that.getMinPhysicalQuantity())) {
                return false;
            }
            if (!ListEquals.listEquals(this.maxPhysicalQuantity, _that.getMaxPhysicalQuantity())) {
                return false;
            }
            return Objects.equals(this.electingParty, _that.getElectingParty());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.minPhysicalQuantity != null ? this.minPhysicalQuantity.hashCode() : 0);
            _result = 31 * _result + (this.maxPhysicalQuantity != null ? this.maxPhysicalQuantity.hashCode() : 0);
            _result = 31 * _result + (this.electingParty != null ? this.electingParty.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "GasPhysicalQuantitySequence {minPhysicalQuantity=" + this.minPhysicalQuantity + ", maxPhysicalQuantity=" + this.maxPhysicalQuantity + ", electingParty=" + this.electingParty + '}';
        }
    }
}

