/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.com;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.asset.CommodityClassification;
import fpml.consolidated.com.GasDelivery;
import fpml.consolidated.com.GasDeliveryPeriods;
import fpml.consolidated.com.GasPhysicalQuantity;
import fpml.consolidated.com.GasProduct;
import fpml.consolidated.com.PhysicalSwapLeg;
import fpml.consolidated.com.meta.GasPhysicalLegMeta;
import fpml.consolidated.shared.PayerReceiverModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="GasPhysicalLeg", builder=GasPhysicalLegBuilderImpl.class, version="1.1.0")
@RuneDataType(value="GasPhysicalLeg", model="fpml", builder=GasPhysicalLegBuilderImpl.class, version="1.1.0")
public interface GasPhysicalLeg
extends PhysicalSwapLeg {
    public static final GasPhysicalLegMeta metaData = new GasPhysicalLegMeta();

    public GasDeliveryPeriods getDeliveryPeriods();

    public GasProduct getGas();

    public GasDelivery getDeliveryConditions();

    public GasPhysicalQuantity getDeliveryQuantity();

    @Override
    public GasPhysicalLeg build();

    @Override
    public GasPhysicalLegBuilder toBuilder();

    public static GasPhysicalLegBuilder builder() {
        return new GasPhysicalLegBuilderImpl();
    }

    default public RosettaMetaData<? extends GasPhysicalLeg> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends GasPhysicalLeg> getType() {
        return GasPhysicalLeg.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("commodityClassification"), processor, CommodityClassification.class, this.getCommodityClassification(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("payerReceiverModel"), processor, PayerReceiverModel.class, this.getPayerReceiverModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("deliveryPeriods"), processor, GasDeliveryPeriods.class, this.getDeliveryPeriods(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("gas"), processor, GasProduct.class, this.getGas(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("deliveryConditions"), processor, GasDelivery.class, this.getDeliveryConditions(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("deliveryQuantity"), processor, GasPhysicalQuantity.class, this.getDeliveryQuantity(), new AttributeMeta[0]);
    }

    public static class GasPhysicalLegBuilderImpl
    extends PhysicalSwapLeg.PhysicalSwapLegBuilderImpl
    implements GasPhysicalLegBuilder {
        protected GasDeliveryPeriods.GasDeliveryPeriodsBuilder deliveryPeriods;
        protected GasProduct.GasProductBuilder gas;
        protected GasDelivery.GasDeliveryBuilder deliveryConditions;
        protected GasPhysicalQuantity.GasPhysicalQuantityBuilder deliveryQuantity;

        @Override
        @RosettaAttribute(value="deliveryPeriods", isRequired=true)
        @RuneAttribute(value="deliveryPeriods", isRequired=true)
        public GasDeliveryPeriods.GasDeliveryPeriodsBuilder getDeliveryPeriods() {
            return this.deliveryPeriods;
        }

        @Override
        public GasDeliveryPeriods.GasDeliveryPeriodsBuilder getOrCreateDeliveryPeriods() {
            GasDeliveryPeriods.GasDeliveryPeriodsBuilder result = this.deliveryPeriods != null ? this.deliveryPeriods : (this.deliveryPeriods = GasDeliveryPeriods.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="gas", isRequired=true)
        @RuneAttribute(value="gas", isRequired=true)
        public GasProduct.GasProductBuilder getGas() {
            return this.gas;
        }

        @Override
        public GasProduct.GasProductBuilder getOrCreateGas() {
            GasProduct.GasProductBuilder result = this.gas != null ? this.gas : (this.gas = GasProduct.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="deliveryConditions")
        @RuneAttribute(value="deliveryConditions")
        public GasDelivery.GasDeliveryBuilder getDeliveryConditions() {
            return this.deliveryConditions;
        }

        @Override
        public GasDelivery.GasDeliveryBuilder getOrCreateDeliveryConditions() {
            GasDelivery.GasDeliveryBuilder result = this.deliveryConditions != null ? this.deliveryConditions : (this.deliveryConditions = GasDelivery.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="deliveryQuantity", isRequired=true)
        @RuneAttribute(value="deliveryQuantity", isRequired=true)
        public GasPhysicalQuantity.GasPhysicalQuantityBuilder getDeliveryQuantity() {
            return this.deliveryQuantity;
        }

        @Override
        public GasPhysicalQuantity.GasPhysicalQuantityBuilder getOrCreateDeliveryQuantity() {
            GasPhysicalQuantity.GasPhysicalQuantityBuilder result = this.deliveryQuantity != null ? this.deliveryQuantity : (this.deliveryQuantity = GasPhysicalQuantity.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public GasPhysicalLegBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="commodityClassification")
        @RuneAttribute(value="commodityClassification")
        public GasPhysicalLegBuilder addCommodityClassification(CommodityClassification _commodityClassification) {
            if (_commodityClassification != null) {
                this.commodityClassification.add(_commodityClassification.toBuilder());
            }
            return this;
        }

        @Override
        public GasPhysicalLegBuilder addCommodityClassification(CommodityClassification _commodityClassification, int idx) {
            this.getIndex(this.commodityClassification, idx, () -> _commodityClassification.toBuilder());
            return this;
        }

        @Override
        public GasPhysicalLegBuilder addCommodityClassification(List<? extends CommodityClassification> commodityClassifications) {
            if (commodityClassifications != null) {
                for (CommodityClassification commodityClassification : commodityClassifications) {
                    this.commodityClassification.add(commodityClassification.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="commodityClassification")
        public GasPhysicalLegBuilder setCommodityClassification(List<? extends CommodityClassification> commodityClassifications) {
            this.commodityClassification = commodityClassifications == null ? new ArrayList() : (List)commodityClassifications.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="payerReceiverModel", isRequired=true)
        @RuneAttribute(value="payerReceiverModel", isRequired=true)
        public GasPhysicalLegBuilder setPayerReceiverModel(PayerReceiverModel _payerReceiverModel) {
            this.payerReceiverModel = _payerReceiverModel == null ? null : _payerReceiverModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="deliveryPeriods", isRequired=true)
        @RuneAttribute(value="deliveryPeriods", isRequired=true)
        public GasPhysicalLegBuilder setDeliveryPeriods(GasDeliveryPeriods _deliveryPeriods) {
            this.deliveryPeriods = _deliveryPeriods == null ? null : _deliveryPeriods.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="gas", isRequired=true)
        @RuneAttribute(value="gas", isRequired=true)
        public GasPhysicalLegBuilder setGas(GasProduct _gas) {
            this.gas = _gas == null ? null : _gas.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="deliveryConditions")
        @RuneAttribute(value="deliveryConditions")
        public GasPhysicalLegBuilder setDeliveryConditions(GasDelivery _deliveryConditions) {
            this.deliveryConditions = _deliveryConditions == null ? null : _deliveryConditions.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="deliveryQuantity", isRequired=true)
        @RuneAttribute(value="deliveryQuantity", isRequired=true)
        public GasPhysicalLegBuilder setDeliveryQuantity(GasPhysicalQuantity _deliveryQuantity) {
            this.deliveryQuantity = _deliveryQuantity == null ? null : _deliveryQuantity.toBuilder();
            return this;
        }

        @Override
        public GasPhysicalLeg build() {
            return new GasPhysicalLegImpl(this);
        }

        @Override
        public GasPhysicalLegBuilder toBuilder() {
            return this;
        }

        @Override
        public GasPhysicalLegBuilder prune() {
            super.prune();
            if (this.deliveryPeriods != null && !this.deliveryPeriods.prune().hasData()) {
                this.deliveryPeriods = null;
            }
            if (this.gas != null && !this.gas.prune().hasData()) {
                this.gas = null;
            }
            if (this.deliveryConditions != null && !this.deliveryConditions.prune().hasData()) {
                this.deliveryConditions = null;
            }
            if (this.deliveryQuantity != null && !this.deliveryQuantity.prune().hasData()) {
                this.deliveryQuantity = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getDeliveryPeriods() != null && this.getDeliveryPeriods().hasData()) {
                return true;
            }
            if (this.getGas() != null && this.getGas().hasData()) {
                return true;
            }
            if (this.getDeliveryConditions() != null && this.getDeliveryConditions().hasData()) {
                return true;
            }
            return this.getDeliveryQuantity() != null && this.getDeliveryQuantity().hasData();
        }

        @Override
        public GasPhysicalLegBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            GasPhysicalLegBuilder o = (GasPhysicalLegBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDeliveryPeriods(), (RosettaModelObjectBuilder)o.getDeliveryPeriods(), this::setDeliveryPeriods);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getGas(), (RosettaModelObjectBuilder)o.getGas(), this::setGas);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDeliveryConditions(), (RosettaModelObjectBuilder)o.getDeliveryConditions(), this::setDeliveryConditions);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDeliveryQuantity(), (RosettaModelObjectBuilder)o.getDeliveryQuantity(), this::setDeliveryQuantity);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            GasPhysicalLeg _that = (GasPhysicalLeg)this.getType().cast(o);
            if (!Objects.equals(this.deliveryPeriods, _that.getDeliveryPeriods())) {
                return false;
            }
            if (!Objects.equals(this.gas, _that.getGas())) {
                return false;
            }
            if (!Objects.equals(this.deliveryConditions, _that.getDeliveryConditions())) {
                return false;
            }
            return Objects.equals(this.deliveryQuantity, _that.getDeliveryQuantity());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.deliveryPeriods != null ? this.deliveryPeriods.hashCode() : 0);
            _result = 31 * _result + (this.gas != null ? this.gas.hashCode() : 0);
            _result = 31 * _result + (this.deliveryConditions != null ? this.deliveryConditions.hashCode() : 0);
            _result = 31 * _result + (this.deliveryQuantity != null ? this.deliveryQuantity.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "GasPhysicalLegBuilder {deliveryPeriods=" + this.deliveryPeriods + ", gas=" + this.gas + ", deliveryConditions=" + this.deliveryConditions + ", deliveryQuantity=" + this.deliveryQuantity + '}' + " " + super.toString();
        }
    }

    public static interface GasPhysicalLegBuilder
    extends GasPhysicalLeg,
    PhysicalSwapLeg.PhysicalSwapLegBuilder {
        public GasDeliveryPeriods.GasDeliveryPeriodsBuilder getOrCreateDeliveryPeriods();

        @Override
        public GasDeliveryPeriods.GasDeliveryPeriodsBuilder getDeliveryPeriods();

        public GasProduct.GasProductBuilder getOrCreateGas();

        @Override
        public GasProduct.GasProductBuilder getGas();

        public GasDelivery.GasDeliveryBuilder getOrCreateDeliveryConditions();

        @Override
        public GasDelivery.GasDeliveryBuilder getDeliveryConditions();

        public GasPhysicalQuantity.GasPhysicalQuantityBuilder getOrCreateDeliveryQuantity();

        @Override
        public GasPhysicalQuantity.GasPhysicalQuantityBuilder getDeliveryQuantity();

        @Override
        public GasPhysicalLegBuilder setId(String var1);

        @Override
        public GasPhysicalLegBuilder addCommodityClassification(CommodityClassification var1);

        @Override
        public GasPhysicalLegBuilder addCommodityClassification(CommodityClassification var1, int var2);

        @Override
        public GasPhysicalLegBuilder addCommodityClassification(List<? extends CommodityClassification> var1);

        @Override
        public GasPhysicalLegBuilder setCommodityClassification(List<? extends CommodityClassification> var1);

        @Override
        public GasPhysicalLegBuilder setPayerReceiverModel(PayerReceiverModel var1);

        public GasPhysicalLegBuilder setDeliveryPeriods(GasDeliveryPeriods var1);

        public GasPhysicalLegBuilder setGas(GasProduct var1);

        public GasPhysicalLegBuilder setDeliveryConditions(GasDelivery var1);

        public GasPhysicalLegBuilder setDeliveryQuantity(GasPhysicalQuantity var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("commodityClassification"), processor, CommodityClassification.CommodityClassificationBuilder.class, this.getCommodityClassification(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("payerReceiverModel"), processor, PayerReceiverModel.PayerReceiverModelBuilder.class, (RosettaModelObjectBuilder)this.getPayerReceiverModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("deliveryPeriods"), processor, GasDeliveryPeriods.GasDeliveryPeriodsBuilder.class, this.getDeliveryPeriods(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("gas"), processor, GasProduct.GasProductBuilder.class, this.getGas(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("deliveryConditions"), processor, GasDelivery.GasDeliveryBuilder.class, this.getDeliveryConditions(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("deliveryQuantity"), processor, GasPhysicalQuantity.GasPhysicalQuantityBuilder.class, this.getDeliveryQuantity(), new AttributeMeta[0]);
        }

        @Override
        public GasPhysicalLegBuilder prune();
    }

    public static class GasPhysicalLegImpl
    extends PhysicalSwapLeg.PhysicalSwapLegImpl
    implements GasPhysicalLeg {
        private final GasDeliveryPeriods deliveryPeriods;
        private final GasProduct gas;
        private final GasDelivery deliveryConditions;
        private final GasPhysicalQuantity deliveryQuantity;

        protected GasPhysicalLegImpl(GasPhysicalLegBuilder builder) {
            super(builder);
            this.deliveryPeriods = Optional.ofNullable(builder.getDeliveryPeriods()).map(f -> f.build()).orElse(null);
            this.gas = Optional.ofNullable(builder.getGas()).map(f -> f.build()).orElse(null);
            this.deliveryConditions = Optional.ofNullable(builder.getDeliveryConditions()).map(f -> f.build()).orElse(null);
            this.deliveryQuantity = Optional.ofNullable(builder.getDeliveryQuantity()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="deliveryPeriods", isRequired=true)
        @RuneAttribute(value="deliveryPeriods", isRequired=true)
        public GasDeliveryPeriods getDeliveryPeriods() {
            return this.deliveryPeriods;
        }

        @Override
        @RosettaAttribute(value="gas", isRequired=true)
        @RuneAttribute(value="gas", isRequired=true)
        public GasProduct getGas() {
            return this.gas;
        }

        @Override
        @RosettaAttribute(value="deliveryConditions")
        @RuneAttribute(value="deliveryConditions")
        public GasDelivery getDeliveryConditions() {
            return this.deliveryConditions;
        }

        @Override
        @RosettaAttribute(value="deliveryQuantity", isRequired=true)
        @RuneAttribute(value="deliveryQuantity", isRequired=true)
        public GasPhysicalQuantity getDeliveryQuantity() {
            return this.deliveryQuantity;
        }

        @Override
        public GasPhysicalLeg build() {
            return this;
        }

        @Override
        public GasPhysicalLegBuilder toBuilder() {
            GasPhysicalLegBuilder builder = GasPhysicalLeg.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(GasPhysicalLegBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getDeliveryPeriods()).ifPresent(builder::setDeliveryPeriods);
            Optional.ofNullable(this.getGas()).ifPresent(builder::setGas);
            Optional.ofNullable(this.getDeliveryConditions()).ifPresent(builder::setDeliveryConditions);
            Optional.ofNullable(this.getDeliveryQuantity()).ifPresent(builder::setDeliveryQuantity);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            GasPhysicalLeg _that = (GasPhysicalLeg)this.getType().cast(o);
            if (!Objects.equals(this.deliveryPeriods, _that.getDeliveryPeriods())) {
                return false;
            }
            if (!Objects.equals(this.gas, _that.getGas())) {
                return false;
            }
            if (!Objects.equals(this.deliveryConditions, _that.getDeliveryConditions())) {
                return false;
            }
            return Objects.equals(this.deliveryQuantity, _that.getDeliveryQuantity());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.deliveryPeriods != null ? this.deliveryPeriods.hashCode() : 0);
            _result = 31 * _result + (this.gas != null ? this.gas.hashCode() : 0);
            _result = 31 * _result + (this.deliveryConditions != null ? this.deliveryConditions.hashCode() : 0);
            _result = 31 * _result + (this.deliveryQuantity != null ? this.deliveryQuantity.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "GasPhysicalLeg {deliveryPeriods=" + this.deliveryPeriods + ", gas=" + this.gas + ", deliveryConditions=" + this.deliveryConditions + ", deliveryQuantity=" + this.deliveryQuantity + '}' + " " + super.toString();
        }
    }
}

