/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.com;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.com.meta.CommodityPremiumMeta;
import fpml.consolidated.shared.AdjustableOrRelativeDate;
import fpml.consolidated.shared.NonNegativeMoney;
import fpml.consolidated.shared.NonNegativePayment;
import fpml.consolidated.shared.PayerReceiverModel;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="CommodityPremium", builder=CommodityPremiumBuilderImpl.class, version="1.1.0")
@RuneDataType(value="CommodityPremium", model="fpml", builder=CommodityPremiumBuilderImpl.class, version="1.1.0")
public interface CommodityPremium
extends NonNegativePayment {
    public static final CommodityPremiumMeta metaData = new CommodityPremiumMeta();

    public NonNegativeMoney getPremiumPerUnit();

    @Override
    public CommodityPremium build();

    @Override
    public CommodityPremiumBuilder toBuilder();

    public static CommodityPremiumBuilder builder() {
        return new CommodityPremiumBuilderImpl();
    }

    default public RosettaMetaData<? extends CommodityPremium> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CommodityPremium> getType() {
        return CommodityPremium.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("payerReceiverModel"), processor, PayerReceiverModel.class, this.getPayerReceiverModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("paymentDate"), processor, AdjustableOrRelativeDate.class, this.getPaymentDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("paymentAmount"), processor, NonNegativeMoney.class, this.getPaymentAmount(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("premiumPerUnit"), processor, NonNegativeMoney.class, this.getPremiumPerUnit(), new AttributeMeta[0]);
    }

    public static class CommodityPremiumBuilderImpl
    extends NonNegativePayment.NonNegativePaymentBuilderImpl
    implements CommodityPremiumBuilder {
        protected NonNegativeMoney.NonNegativeMoneyBuilder premiumPerUnit;

        @Override
        @RosettaAttribute(value="premiumPerUnit")
        @RuneAttribute(value="premiumPerUnit")
        public NonNegativeMoney.NonNegativeMoneyBuilder getPremiumPerUnit() {
            return this.premiumPerUnit;
        }

        @Override
        public NonNegativeMoney.NonNegativeMoneyBuilder getOrCreatePremiumPerUnit() {
            NonNegativeMoney.NonNegativeMoneyBuilder result = this.premiumPerUnit != null ? this.premiumPerUnit : (this.premiumPerUnit = NonNegativeMoney.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public CommodityPremiumBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="payerReceiverModel", isRequired=true)
        @RuneAttribute(value="payerReceiverModel", isRequired=true)
        public CommodityPremiumBuilder setPayerReceiverModel(PayerReceiverModel _payerReceiverModel) {
            this.payerReceiverModel = _payerReceiverModel == null ? null : _payerReceiverModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="paymentDate")
        @RuneAttribute(value="paymentDate")
        public CommodityPremiumBuilder setPaymentDate(AdjustableOrRelativeDate _paymentDate) {
            this.paymentDate = _paymentDate == null ? null : _paymentDate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="paymentAmount", isRequired=true)
        @RuneAttribute(value="paymentAmount", isRequired=true)
        public CommodityPremiumBuilder setPaymentAmount(NonNegativeMoney _paymentAmount) {
            this.paymentAmount = _paymentAmount == null ? null : _paymentAmount.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="premiumPerUnit")
        @RuneAttribute(value="premiumPerUnit")
        public CommodityPremiumBuilder setPremiumPerUnit(NonNegativeMoney _premiumPerUnit) {
            this.premiumPerUnit = _premiumPerUnit == null ? null : _premiumPerUnit.toBuilder();
            return this;
        }

        @Override
        public CommodityPremium build() {
            return new CommodityPremiumImpl(this);
        }

        @Override
        public CommodityPremiumBuilder toBuilder() {
            return this;
        }

        @Override
        public CommodityPremiumBuilder prune() {
            super.prune();
            if (this.premiumPerUnit != null && !this.premiumPerUnit.prune().hasData()) {
                this.premiumPerUnit = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            return this.getPremiumPerUnit() != null && this.getPremiumPerUnit().hasData();
        }

        @Override
        public CommodityPremiumBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            CommodityPremiumBuilder o = (CommodityPremiumBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPremiumPerUnit(), (RosettaModelObjectBuilder)o.getPremiumPerUnit(), this::setPremiumPerUnit);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CommodityPremium _that = (CommodityPremium)this.getType().cast(o);
            return Objects.equals(this.premiumPerUnit, _that.getPremiumPerUnit());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.premiumPerUnit != null ? this.premiumPerUnit.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "CommodityPremiumBuilder {premiumPerUnit=" + this.premiumPerUnit + '}' + " " + super.toString();
        }
    }

    public static interface CommodityPremiumBuilder
    extends CommodityPremium,
    NonNegativePayment.NonNegativePaymentBuilder {
        public NonNegativeMoney.NonNegativeMoneyBuilder getOrCreatePremiumPerUnit();

        @Override
        public NonNegativeMoney.NonNegativeMoneyBuilder getPremiumPerUnit();

        @Override
        public CommodityPremiumBuilder setId(String var1);

        @Override
        public CommodityPremiumBuilder setPayerReceiverModel(PayerReceiverModel var1);

        @Override
        public CommodityPremiumBuilder setPaymentDate(AdjustableOrRelativeDate var1);

        @Override
        public CommodityPremiumBuilder setPaymentAmount(NonNegativeMoney var1);

        public CommodityPremiumBuilder setPremiumPerUnit(NonNegativeMoney var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("payerReceiverModel"), processor, PayerReceiverModel.PayerReceiverModelBuilder.class, (RosettaModelObjectBuilder)this.getPayerReceiverModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("paymentDate"), processor, AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder.class, (RosettaModelObjectBuilder)this.getPaymentDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("paymentAmount"), processor, NonNegativeMoney.NonNegativeMoneyBuilder.class, (RosettaModelObjectBuilder)this.getPaymentAmount(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("premiumPerUnit"), processor, NonNegativeMoney.NonNegativeMoneyBuilder.class, this.getPremiumPerUnit(), new AttributeMeta[0]);
        }

        @Override
        public CommodityPremiumBuilder prune();
    }

    public static class CommodityPremiumImpl
    extends NonNegativePayment.NonNegativePaymentImpl
    implements CommodityPremium {
        private final NonNegativeMoney premiumPerUnit;

        protected CommodityPremiumImpl(CommodityPremiumBuilder builder) {
            super(builder);
            this.premiumPerUnit = Optional.ofNullable(builder.getPremiumPerUnit()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="premiumPerUnit")
        @RuneAttribute(value="premiumPerUnit")
        public NonNegativeMoney getPremiumPerUnit() {
            return this.premiumPerUnit;
        }

        @Override
        public CommodityPremium build() {
            return this;
        }

        @Override
        public CommodityPremiumBuilder toBuilder() {
            CommodityPremiumBuilder builder = CommodityPremium.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CommodityPremiumBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getPremiumPerUnit()).ifPresent(builder::setPremiumPerUnit);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CommodityPremium _that = (CommodityPremium)this.getType().cast(o);
            return Objects.equals(this.premiumPerUnit, _that.getPremiumPerUnit());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.premiumPerUnit != null ? this.premiumPerUnit.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "CommodityPremium {premiumPerUnit=" + this.premiumPerUnit + '}' + " " + super.toString();
        }
    }
}

