/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.com;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.com.CoalProductSource;
import fpml.consolidated.com.CoalProductSpecifications;
import fpml.consolidated.com.CoalProductType;
import fpml.consolidated.com.CommodityUSCoalProductModel;
import fpml.consolidated.com.meta.CoalProductMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="CoalProduct", builder=CoalProductBuilderImpl.class, version="1.1.0")
@RuneDataType(value="CoalProduct", model="fpml", builder=CoalProductBuilderImpl.class, version="1.1.0")
public interface CoalProduct
extends RosettaModelObject {
    public static final CoalProductMeta metaData = new CoalProductMeta();

    public CoalProductType _getType();

    public CoalProductSpecifications getCoalProductSpecifications();

    public List<? extends CoalProductSource> getSource();

    public Boolean getSCoTASpecifications();

    public CommodityUSCoalProductModel getCommodityUSCoalProductModel();

    public CoalProduct build();

    public CoalProductBuilder toBuilder();

    public static CoalProductBuilder builder() {
        return new CoalProductBuilderImpl();
    }

    default public RosettaMetaData<? extends CoalProduct> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CoalProduct> getType() {
        return CoalProduct.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("type"), processor, CoalProductType.class, this._getType(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("coalProductSpecifications"), processor, CoalProductSpecifications.class, this.getCoalProductSpecifications(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("source"), processor, CoalProductSource.class, this.getSource(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("sCoTASpecifications"), Boolean.class, (Object)this.getSCoTASpecifications(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("commodityUSCoalProductModel"), processor, CommodityUSCoalProductModel.class, this.getCommodityUSCoalProductModel(), new AttributeMeta[0]);
    }

    public static class CoalProductBuilderImpl
    implements CoalProductBuilder {
        protected CoalProductType.CoalProductTypeBuilder type;
        protected CoalProductSpecifications.CoalProductSpecificationsBuilder coalProductSpecifications;
        protected List<CoalProductSource.CoalProductSourceBuilder> source = new ArrayList<CoalProductSource.CoalProductSourceBuilder>();
        protected Boolean sCoTASpecifications;
        protected CommodityUSCoalProductModel.CommodityUSCoalProductModelBuilder commodityUSCoalProductModel;

        @Override
        @RosettaAttribute(value="type")
        @RuneAttribute(value="type")
        public CoalProductType.CoalProductTypeBuilder _getType() {
            return this.type;
        }

        @Override
        public CoalProductType.CoalProductTypeBuilder getOrCreateType() {
            CoalProductType.CoalProductTypeBuilder result = this.type != null ? this.type : (this.type = CoalProductType.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="coalProductSpecifications")
        @RuneAttribute(value="coalProductSpecifications")
        public CoalProductSpecifications.CoalProductSpecificationsBuilder getCoalProductSpecifications() {
            return this.coalProductSpecifications;
        }

        @Override
        public CoalProductSpecifications.CoalProductSpecificationsBuilder getOrCreateCoalProductSpecifications() {
            CoalProductSpecifications.CoalProductSpecificationsBuilder result = this.coalProductSpecifications != null ? this.coalProductSpecifications : (this.coalProductSpecifications = CoalProductSpecifications.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="source")
        @RuneAttribute(value="source")
        public List<? extends CoalProductSource.CoalProductSourceBuilder> getSource() {
            return this.source;
        }

        @Override
        public CoalProductSource.CoalProductSourceBuilder getOrCreateSource(int index) {
            if (this.source == null) {
                this.source = new ArrayList<CoalProductSource.CoalProductSourceBuilder>();
            }
            return (CoalProductSource.CoalProductSourceBuilder)this.getIndex(this.source, index, () -> {
                CoalProductSource.CoalProductSourceBuilder newSource = CoalProductSource.builder();
                return newSource;
            });
        }

        @Override
        @RosettaAttribute(value="sCoTASpecifications")
        @RuneAttribute(value="sCoTASpecifications")
        public Boolean getSCoTASpecifications() {
            return this.sCoTASpecifications;
        }

        @Override
        @RosettaAttribute(value="commodityUSCoalProductModel")
        @RuneAttribute(value="commodityUSCoalProductModel")
        public CommodityUSCoalProductModel.CommodityUSCoalProductModelBuilder getCommodityUSCoalProductModel() {
            return this.commodityUSCoalProductModel;
        }

        @Override
        public CommodityUSCoalProductModel.CommodityUSCoalProductModelBuilder getOrCreateCommodityUSCoalProductModel() {
            CommodityUSCoalProductModel.CommodityUSCoalProductModelBuilder result = this.commodityUSCoalProductModel != null ? this.commodityUSCoalProductModel : (this.commodityUSCoalProductModel = CommodityUSCoalProductModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="type")
        @RuneAttribute(value="type")
        public CoalProductBuilder setType(CoalProductType _type) {
            this.type = _type == null ? null : _type.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="coalProductSpecifications")
        @RuneAttribute(value="coalProductSpecifications")
        public CoalProductBuilder setCoalProductSpecifications(CoalProductSpecifications _coalProductSpecifications) {
            this.coalProductSpecifications = _coalProductSpecifications == null ? null : _coalProductSpecifications.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="source")
        @RuneAttribute(value="source")
        public CoalProductBuilder addSource(CoalProductSource _source) {
            if (_source != null) {
                this.source.add(_source.toBuilder());
            }
            return this;
        }

        @Override
        public CoalProductBuilder addSource(CoalProductSource _source, int idx) {
            this.getIndex(this.source, idx, () -> _source.toBuilder());
            return this;
        }

        @Override
        public CoalProductBuilder addSource(List<? extends CoalProductSource> sources) {
            if (sources != null) {
                for (CoalProductSource coalProductSource : sources) {
                    this.source.add(coalProductSource.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="source")
        public CoalProductBuilder setSource(List<? extends CoalProductSource> sources) {
            this.source = sources == null ? new ArrayList<CoalProductSource.CoalProductSourceBuilder>() : (List)sources.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="sCoTASpecifications")
        @RuneAttribute(value="sCoTASpecifications")
        public CoalProductBuilder setSCoTASpecifications(Boolean _sCoTASpecifications) {
            this.sCoTASpecifications = _sCoTASpecifications == null ? null : _sCoTASpecifications;
            return this;
        }

        @Override
        @RosettaAttribute(value="commodityUSCoalProductModel")
        @RuneAttribute(value="commodityUSCoalProductModel")
        public CoalProductBuilder setCommodityUSCoalProductModel(CommodityUSCoalProductModel _commodityUSCoalProductModel) {
            this.commodityUSCoalProductModel = _commodityUSCoalProductModel == null ? null : _commodityUSCoalProductModel.toBuilder();
            return this;
        }

        @Override
        public CoalProduct build() {
            return new CoalProductImpl(this);
        }

        @Override
        public CoalProductBuilder toBuilder() {
            return this;
        }

        @Override
        public CoalProductBuilder prune() {
            if (this.type != null && !this.type.prune().hasData()) {
                this.type = null;
            }
            if (this.coalProductSpecifications != null && !this.coalProductSpecifications.prune().hasData()) {
                this.coalProductSpecifications = null;
            }
            this.source = this.source.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.commodityUSCoalProductModel != null && !this.commodityUSCoalProductModel.prune().hasData()) {
                this.commodityUSCoalProductModel = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this._getType() != null && this._getType().hasData()) {
                return true;
            }
            if (this.getCoalProductSpecifications() != null && this.getCoalProductSpecifications().hasData()) {
                return true;
            }
            if (this.getSource() != null && this.getSource().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getSCoTASpecifications() != null) {
                return true;
            }
            return this.getCommodityUSCoalProductModel() != null && this.getCommodityUSCoalProductModel().hasData();
        }

        public CoalProductBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            CoalProductBuilder o = (CoalProductBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this._getType(), (RosettaModelObjectBuilder)o._getType(), this::setType);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCoalProductSpecifications(), (RosettaModelObjectBuilder)o.getCoalProductSpecifications(), this::setCoalProductSpecifications);
            merger.mergeRosetta(this.getSource(), o.getSource(), this::getOrCreateSource);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCommodityUSCoalProductModel(), (RosettaModelObjectBuilder)o.getCommodityUSCoalProductModel(), this::setCommodityUSCoalProductModel);
            merger.mergeBasic((Object)this.getSCoTASpecifications(), (Object)o.getSCoTASpecifications(), this::setSCoTASpecifications, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CoalProduct _that = this.getType().cast(o);
            if (!Objects.equals(this.type, _that._getType())) {
                return false;
            }
            if (!Objects.equals(this.coalProductSpecifications, _that.getCoalProductSpecifications())) {
                return false;
            }
            if (!ListEquals.listEquals(this.source, _that.getSource())) {
                return false;
            }
            if (!Objects.equals(this.sCoTASpecifications, _that.getSCoTASpecifications())) {
                return false;
            }
            return Objects.equals(this.commodityUSCoalProductModel, _that.getCommodityUSCoalProductModel());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.type != null ? this.type.hashCode() : 0);
            _result = 31 * _result + (this.coalProductSpecifications != null ? this.coalProductSpecifications.hashCode() : 0);
            _result = 31 * _result + (this.source != null ? this.source.hashCode() : 0);
            _result = 31 * _result + (this.sCoTASpecifications != null ? this.sCoTASpecifications.hashCode() : 0);
            _result = 31 * _result + (this.commodityUSCoalProductModel != null ? this.commodityUSCoalProductModel.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CoalProductBuilder {type=" + this.type + ", coalProductSpecifications=" + this.coalProductSpecifications + ", source=" + this.source + ", sCoTASpecifications=" + this.sCoTASpecifications + ", commodityUSCoalProductModel=" + this.commodityUSCoalProductModel + '}';
        }
    }

    public static interface CoalProductBuilder
    extends CoalProduct,
    RosettaModelObjectBuilder {
        public CoalProductType.CoalProductTypeBuilder getOrCreateType();

        @Override
        public CoalProductType.CoalProductTypeBuilder _getType();

        public CoalProductSpecifications.CoalProductSpecificationsBuilder getOrCreateCoalProductSpecifications();

        @Override
        public CoalProductSpecifications.CoalProductSpecificationsBuilder getCoalProductSpecifications();

        public CoalProductSource.CoalProductSourceBuilder getOrCreateSource(int var1);

        public List<? extends CoalProductSource.CoalProductSourceBuilder> getSource();

        public CommodityUSCoalProductModel.CommodityUSCoalProductModelBuilder getOrCreateCommodityUSCoalProductModel();

        @Override
        public CommodityUSCoalProductModel.CommodityUSCoalProductModelBuilder getCommodityUSCoalProductModel();

        public CoalProductBuilder setType(CoalProductType var1);

        public CoalProductBuilder setCoalProductSpecifications(CoalProductSpecifications var1);

        public CoalProductBuilder addSource(CoalProductSource var1);

        public CoalProductBuilder addSource(CoalProductSource var1, int var2);

        public CoalProductBuilder addSource(List<? extends CoalProductSource> var1);

        public CoalProductBuilder setSource(List<? extends CoalProductSource> var1);

        public CoalProductBuilder setSCoTASpecifications(Boolean var1);

        public CoalProductBuilder setCommodityUSCoalProductModel(CommodityUSCoalProductModel var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("type"), processor, CoalProductType.CoalProductTypeBuilder.class, this._getType(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("coalProductSpecifications"), processor, CoalProductSpecifications.CoalProductSpecificationsBuilder.class, this.getCoalProductSpecifications(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("source"), processor, CoalProductSource.CoalProductSourceBuilder.class, this.getSource(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("sCoTASpecifications"), Boolean.class, (Object)this.getSCoTASpecifications(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("commodityUSCoalProductModel"), processor, CommodityUSCoalProductModel.CommodityUSCoalProductModelBuilder.class, this.getCommodityUSCoalProductModel(), new AttributeMeta[0]);
        }

        public CoalProductBuilder prune();
    }

    public static class CoalProductImpl
    implements CoalProduct {
        private final CoalProductType type;
        private final CoalProductSpecifications coalProductSpecifications;
        private final List<? extends CoalProductSource> source;
        private final Boolean sCoTASpecifications;
        private final CommodityUSCoalProductModel commodityUSCoalProductModel;

        protected CoalProductImpl(CoalProductBuilder builder) {
            this.type = Optional.ofNullable(builder._getType()).map(f -> f.build()).orElse(null);
            this.coalProductSpecifications = Optional.ofNullable(builder.getCoalProductSpecifications()).map(f -> f.build()).orElse(null);
            this.source = Optional.ofNullable(builder.getSource()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.sCoTASpecifications = builder.getSCoTASpecifications();
            this.commodityUSCoalProductModel = Optional.ofNullable(builder.getCommodityUSCoalProductModel()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="type")
        @RuneAttribute(value="type")
        public CoalProductType _getType() {
            return this.type;
        }

        @Override
        @RosettaAttribute(value="coalProductSpecifications")
        @RuneAttribute(value="coalProductSpecifications")
        public CoalProductSpecifications getCoalProductSpecifications() {
            return this.coalProductSpecifications;
        }

        @Override
        @RosettaAttribute(value="source")
        @RuneAttribute(value="source")
        public List<? extends CoalProductSource> getSource() {
            return this.source;
        }

        @Override
        @RosettaAttribute(value="sCoTASpecifications")
        @RuneAttribute(value="sCoTASpecifications")
        public Boolean getSCoTASpecifications() {
            return this.sCoTASpecifications;
        }

        @Override
        @RosettaAttribute(value="commodityUSCoalProductModel")
        @RuneAttribute(value="commodityUSCoalProductModel")
        public CommodityUSCoalProductModel getCommodityUSCoalProductModel() {
            return this.commodityUSCoalProductModel;
        }

        @Override
        public CoalProduct build() {
            return this;
        }

        @Override
        public CoalProductBuilder toBuilder() {
            CoalProductBuilder builder = CoalProduct.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CoalProductBuilder builder) {
            Optional.ofNullable(this._getType()).ifPresent(builder::setType);
            Optional.ofNullable(this.getCoalProductSpecifications()).ifPresent(builder::setCoalProductSpecifications);
            Optional.ofNullable(this.getSource()).ifPresent(builder::setSource);
            Optional.ofNullable(this.getSCoTASpecifications()).ifPresent(builder::setSCoTASpecifications);
            Optional.ofNullable(this.getCommodityUSCoalProductModel()).ifPresent(builder::setCommodityUSCoalProductModel);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CoalProduct _that = this.getType().cast(o);
            if (!Objects.equals(this.type, _that._getType())) {
                return false;
            }
            if (!Objects.equals(this.coalProductSpecifications, _that.getCoalProductSpecifications())) {
                return false;
            }
            if (!ListEquals.listEquals(this.source, _that.getSource())) {
                return false;
            }
            if (!Objects.equals(this.sCoTASpecifications, _that.getSCoTASpecifications())) {
                return false;
            }
            return Objects.equals(this.commodityUSCoalProductModel, _that.getCommodityUSCoalProductModel());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.type != null ? this.type.hashCode() : 0);
            _result = 31 * _result + (this.coalProductSpecifications != null ? this.coalProductSpecifications.hashCode() : 0);
            _result = 31 * _result + (this.source != null ? this.source.hashCode() : 0);
            _result = 31 * _result + (this.sCoTASpecifications != null ? this.sCoTASpecifications.hashCode() : 0);
            _result = 31 * _result + (this.commodityUSCoalProductModel != null ? this.commodityUSCoalProductModel.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CoalProduct {type=" + this.type + ", coalProductSpecifications=" + this.coalProductSpecifications + ", source=" + this.source + ", sCoTASpecifications=" + this.sCoTASpecifications + ", commodityUSCoalProductModel=" + this.commodityUSCoalProductModel + '}';
        }
    }
}

