/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.business.events;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.business.events.CashflowObservationReference;
import fpml.consolidated.business.events.meta.CashflowFixingMeta;
import fpml.consolidated.shared.Rounding;
import fpml.consolidated.shared.Strike;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="CashflowFixing", builder=CashflowFixingBuilderImpl.class, version="1.1.0")
@RuneDataType(value="CashflowFixing", model="fpml", builder=CashflowFixingBuilderImpl.class, version="1.1.0")
public interface CashflowFixing
extends RosettaModelObject {
    public static final CashflowFixingMeta metaData = new CashflowFixingMeta();

    public List<? extends CashflowObservationReference> getObservationReference();

    public BigDecimal getCalculatedValue();

    public BigDecimal getMultiplier();

    public BigDecimal getSpread();

    public List<? extends Strike> getCapValue();

    public List<? extends Strike> getFloorValue();

    public Boolean getNegativeInterestRate();

    public Rounding getRounding();

    public String getId();

    public CashflowFixing build();

    public CashflowFixingBuilder toBuilder();

    public static CashflowFixingBuilder builder() {
        return new CashflowFixingBuilderImpl();
    }

    default public RosettaMetaData<? extends CashflowFixing> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CashflowFixing> getType() {
        return CashflowFixing.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("observationReference"), processor, CashflowObservationReference.class, this.getObservationReference(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("calculatedValue"), BigDecimal.class, (Object)this.getCalculatedValue(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("multiplier"), BigDecimal.class, (Object)this.getMultiplier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("spread"), BigDecimal.class, (Object)this.getSpread(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("capValue"), processor, Strike.class, this.getCapValue(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("floorValue"), processor, Strike.class, this.getFloorValue(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("negativeInterestRate"), Boolean.class, (Object)this.getNegativeInterestRate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("rounding"), processor, Rounding.class, this.getRounding(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class CashflowFixingBuilderImpl
    implements CashflowFixingBuilder {
        protected List<CashflowObservationReference.CashflowObservationReferenceBuilder> observationReference = new ArrayList<CashflowObservationReference.CashflowObservationReferenceBuilder>();
        protected BigDecimal calculatedValue;
        protected BigDecimal multiplier;
        protected BigDecimal spread;
        protected List<Strike.StrikeBuilder> capValue = new ArrayList<Strike.StrikeBuilder>();
        protected List<Strike.StrikeBuilder> floorValue = new ArrayList<Strike.StrikeBuilder>();
        protected Boolean negativeInterestRate;
        protected Rounding.RoundingBuilder rounding;
        protected String id;

        @Override
        @RosettaAttribute(value="observationReference")
        @RuneAttribute(value="observationReference")
        public List<? extends CashflowObservationReference.CashflowObservationReferenceBuilder> getObservationReference() {
            return this.observationReference;
        }

        @Override
        public CashflowObservationReference.CashflowObservationReferenceBuilder getOrCreateObservationReference(int index) {
            if (this.observationReference == null) {
                this.observationReference = new ArrayList<CashflowObservationReference.CashflowObservationReferenceBuilder>();
            }
            return (CashflowObservationReference.CashflowObservationReferenceBuilder)this.getIndex(this.observationReference, index, () -> {
                CashflowObservationReference.CashflowObservationReferenceBuilder newObservationReference = CashflowObservationReference.builder();
                return newObservationReference;
            });
        }

        @Override
        @RosettaAttribute(value="calculatedValue")
        @RuneAttribute(value="calculatedValue")
        public BigDecimal getCalculatedValue() {
            return this.calculatedValue;
        }

        @Override
        @RosettaAttribute(value="multiplier")
        @RuneAttribute(value="multiplier")
        public BigDecimal getMultiplier() {
            return this.multiplier;
        }

        @Override
        @RosettaAttribute(value="spread")
        @RuneAttribute(value="spread")
        public BigDecimal getSpread() {
            return this.spread;
        }

        @Override
        @RosettaAttribute(value="capValue")
        @RuneAttribute(value="capValue")
        public List<? extends Strike.StrikeBuilder> getCapValue() {
            return this.capValue;
        }

        @Override
        public Strike.StrikeBuilder getOrCreateCapValue(int index) {
            if (this.capValue == null) {
                this.capValue = new ArrayList<Strike.StrikeBuilder>();
            }
            return (Strike.StrikeBuilder)this.getIndex(this.capValue, index, () -> {
                Strike.StrikeBuilder newCapValue = Strike.builder();
                return newCapValue;
            });
        }

        @Override
        @RosettaAttribute(value="floorValue")
        @RuneAttribute(value="floorValue")
        public List<? extends Strike.StrikeBuilder> getFloorValue() {
            return this.floorValue;
        }

        @Override
        public Strike.StrikeBuilder getOrCreateFloorValue(int index) {
            if (this.floorValue == null) {
                this.floorValue = new ArrayList<Strike.StrikeBuilder>();
            }
            return (Strike.StrikeBuilder)this.getIndex(this.floorValue, index, () -> {
                Strike.StrikeBuilder newFloorValue = Strike.builder();
                return newFloorValue;
            });
        }

        @Override
        @RosettaAttribute(value="negativeInterestRate")
        @RuneAttribute(value="negativeInterestRate")
        public Boolean getNegativeInterestRate() {
            return this.negativeInterestRate;
        }

        @Override
        @RosettaAttribute(value="rounding")
        @RuneAttribute(value="rounding")
        public Rounding.RoundingBuilder getRounding() {
            return this.rounding;
        }

        @Override
        public Rounding.RoundingBuilder getOrCreateRounding() {
            Rounding.RoundingBuilder result = this.rounding != null ? this.rounding : (this.rounding = Rounding.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public String getId() {
            return this.id;
        }

        @Override
        @RosettaAttribute(value="observationReference")
        @RuneAttribute(value="observationReference")
        public CashflowFixingBuilder addObservationReference(CashflowObservationReference _observationReference) {
            if (_observationReference != null) {
                this.observationReference.add(_observationReference.toBuilder());
            }
            return this;
        }

        @Override
        public CashflowFixingBuilder addObservationReference(CashflowObservationReference _observationReference, int idx) {
            this.getIndex(this.observationReference, idx, () -> _observationReference.toBuilder());
            return this;
        }

        @Override
        public CashflowFixingBuilder addObservationReference(List<? extends CashflowObservationReference> observationReferences) {
            if (observationReferences != null) {
                for (CashflowObservationReference cashflowObservationReference : observationReferences) {
                    this.observationReference.add(cashflowObservationReference.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="observationReference")
        public CashflowFixingBuilder setObservationReference(List<? extends CashflowObservationReference> observationReferences) {
            this.observationReference = observationReferences == null ? new ArrayList<CashflowObservationReference.CashflowObservationReferenceBuilder>() : (List)observationReferences.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="calculatedValue")
        @RuneAttribute(value="calculatedValue")
        public CashflowFixingBuilder setCalculatedValue(BigDecimal _calculatedValue) {
            this.calculatedValue = _calculatedValue == null ? null : _calculatedValue;
            return this;
        }

        @Override
        @RosettaAttribute(value="multiplier")
        @RuneAttribute(value="multiplier")
        public CashflowFixingBuilder setMultiplier(BigDecimal _multiplier) {
            this.multiplier = _multiplier == null ? null : _multiplier;
            return this;
        }

        @Override
        @RosettaAttribute(value="spread")
        @RuneAttribute(value="spread")
        public CashflowFixingBuilder setSpread(BigDecimal _spread) {
            this.spread = _spread == null ? null : _spread;
            return this;
        }

        @Override
        @RosettaAttribute(value="capValue")
        @RuneAttribute(value="capValue")
        public CashflowFixingBuilder addCapValue(Strike _capValue) {
            if (_capValue != null) {
                this.capValue.add(_capValue.toBuilder());
            }
            return this;
        }

        @Override
        public CashflowFixingBuilder addCapValue(Strike _capValue, int idx) {
            this.getIndex(this.capValue, idx, () -> _capValue.toBuilder());
            return this;
        }

        @Override
        public CashflowFixingBuilder addCapValue(List<? extends Strike> capValues) {
            if (capValues != null) {
                for (Strike strike : capValues) {
                    this.capValue.add(strike.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="capValue")
        public CashflowFixingBuilder setCapValue(List<? extends Strike> capValues) {
            this.capValue = capValues == null ? new ArrayList<Strike.StrikeBuilder>() : (List)capValues.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="floorValue")
        @RuneAttribute(value="floorValue")
        public CashflowFixingBuilder addFloorValue(Strike _floorValue) {
            if (_floorValue != null) {
                this.floorValue.add(_floorValue.toBuilder());
            }
            return this;
        }

        @Override
        public CashflowFixingBuilder addFloorValue(Strike _floorValue, int idx) {
            this.getIndex(this.floorValue, idx, () -> _floorValue.toBuilder());
            return this;
        }

        @Override
        public CashflowFixingBuilder addFloorValue(List<? extends Strike> floorValues) {
            if (floorValues != null) {
                for (Strike strike : floorValues) {
                    this.floorValue.add(strike.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="floorValue")
        public CashflowFixingBuilder setFloorValue(List<? extends Strike> floorValues) {
            this.floorValue = floorValues == null ? new ArrayList<Strike.StrikeBuilder>() : (List)floorValues.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="negativeInterestRate")
        @RuneAttribute(value="negativeInterestRate")
        public CashflowFixingBuilder setNegativeInterestRate(Boolean _negativeInterestRate) {
            this.negativeInterestRate = _negativeInterestRate == null ? null : _negativeInterestRate;
            return this;
        }

        @Override
        @RosettaAttribute(value="rounding")
        @RuneAttribute(value="rounding")
        public CashflowFixingBuilder setRounding(Rounding _rounding) {
            this.rounding = _rounding == null ? null : _rounding.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public CashflowFixingBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        public CashflowFixing build() {
            return new CashflowFixingImpl(this);
        }

        @Override
        public CashflowFixingBuilder toBuilder() {
            return this;
        }

        @Override
        public CashflowFixingBuilder prune() {
            this.observationReference = this.observationReference.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.capValue = this.capValue.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.floorValue = this.floorValue.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.rounding != null && !this.rounding.prune().hasData()) {
                this.rounding = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getObservationReference() != null && this.getObservationReference().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getCalculatedValue() != null) {
                return true;
            }
            if (this.getMultiplier() != null) {
                return true;
            }
            if (this.getSpread() != null) {
                return true;
            }
            if (this.getCapValue() != null && this.getCapValue().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getFloorValue() != null && this.getFloorValue().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getNegativeInterestRate() != null) {
                return true;
            }
            if (this.getRounding() != null && this.getRounding().hasData()) {
                return true;
            }
            return this.getId() != null;
        }

        public CashflowFixingBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            CashflowFixingBuilder o = (CashflowFixingBuilder)other;
            merger.mergeRosetta(this.getObservationReference(), o.getObservationReference(), this::getOrCreateObservationReference);
            merger.mergeRosetta(this.getCapValue(), o.getCapValue(), this::getOrCreateCapValue);
            merger.mergeRosetta(this.getFloorValue(), o.getFloorValue(), this::getOrCreateFloorValue);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getRounding(), (RosettaModelObjectBuilder)o.getRounding(), this::setRounding);
            merger.mergeBasic((Object)this.getCalculatedValue(), (Object)o.getCalculatedValue(), this::setCalculatedValue, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getMultiplier(), (Object)o.getMultiplier(), this::setMultiplier, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSpread(), (Object)o.getSpread(), this::setSpread, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getNegativeInterestRate(), (Object)o.getNegativeInterestRate(), this::setNegativeInterestRate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getId(), (Object)o.getId(), this::setId, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CashflowFixing _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.observationReference, _that.getObservationReference())) {
                return false;
            }
            if (!Objects.equals(this.calculatedValue, _that.getCalculatedValue())) {
                return false;
            }
            if (!Objects.equals(this.multiplier, _that.getMultiplier())) {
                return false;
            }
            if (!Objects.equals(this.spread, _that.getSpread())) {
                return false;
            }
            if (!ListEquals.listEquals(this.capValue, _that.getCapValue())) {
                return false;
            }
            if (!ListEquals.listEquals(this.floorValue, _that.getFloorValue())) {
                return false;
            }
            if (!Objects.equals(this.negativeInterestRate, _that.getNegativeInterestRate())) {
                return false;
            }
            if (!Objects.equals(this.rounding, _that.getRounding())) {
                return false;
            }
            return Objects.equals(this.id, _that.getId());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.observationReference != null ? this.observationReference.hashCode() : 0);
            _result = 31 * _result + (this.calculatedValue != null ? this.calculatedValue.hashCode() : 0);
            _result = 31 * _result + (this.multiplier != null ? this.multiplier.hashCode() : 0);
            _result = 31 * _result + (this.spread != null ? this.spread.hashCode() : 0);
            _result = 31 * _result + (this.capValue != null ? this.capValue.hashCode() : 0);
            _result = 31 * _result + (this.floorValue != null ? this.floorValue.hashCode() : 0);
            _result = 31 * _result + (this.negativeInterestRate != null ? this.negativeInterestRate.hashCode() : 0);
            _result = 31 * _result + (this.rounding != null ? this.rounding.hashCode() : 0);
            _result = 31 * _result + (this.id != null ? this.id.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CashflowFixingBuilder {observationReference=" + this.observationReference + ", calculatedValue=" + this.calculatedValue + ", multiplier=" + this.multiplier + ", spread=" + this.spread + ", capValue=" + this.capValue + ", floorValue=" + this.floorValue + ", negativeInterestRate=" + this.negativeInterestRate + ", rounding=" + this.rounding + ", id=" + this.id + '}';
        }
    }

    public static interface CashflowFixingBuilder
    extends CashflowFixing,
    RosettaModelObjectBuilder {
        public CashflowObservationReference.CashflowObservationReferenceBuilder getOrCreateObservationReference(int var1);

        public List<? extends CashflowObservationReference.CashflowObservationReferenceBuilder> getObservationReference();

        public Strike.StrikeBuilder getOrCreateCapValue(int var1);

        public List<? extends Strike.StrikeBuilder> getCapValue();

        public Strike.StrikeBuilder getOrCreateFloorValue(int var1);

        public List<? extends Strike.StrikeBuilder> getFloorValue();

        public Rounding.RoundingBuilder getOrCreateRounding();

        @Override
        public Rounding.RoundingBuilder getRounding();

        public CashflowFixingBuilder addObservationReference(CashflowObservationReference var1);

        public CashflowFixingBuilder addObservationReference(CashflowObservationReference var1, int var2);

        public CashflowFixingBuilder addObservationReference(List<? extends CashflowObservationReference> var1);

        public CashflowFixingBuilder setObservationReference(List<? extends CashflowObservationReference> var1);

        public CashflowFixingBuilder setCalculatedValue(BigDecimal var1);

        public CashflowFixingBuilder setMultiplier(BigDecimal var1);

        public CashflowFixingBuilder setSpread(BigDecimal var1);

        public CashflowFixingBuilder addCapValue(Strike var1);

        public CashflowFixingBuilder addCapValue(Strike var1, int var2);

        public CashflowFixingBuilder addCapValue(List<? extends Strike> var1);

        public CashflowFixingBuilder setCapValue(List<? extends Strike> var1);

        public CashflowFixingBuilder addFloorValue(Strike var1);

        public CashflowFixingBuilder addFloorValue(Strike var1, int var2);

        public CashflowFixingBuilder addFloorValue(List<? extends Strike> var1);

        public CashflowFixingBuilder setFloorValue(List<? extends Strike> var1);

        public CashflowFixingBuilder setNegativeInterestRate(Boolean var1);

        public CashflowFixingBuilder setRounding(Rounding var1);

        public CashflowFixingBuilder setId(String var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("observationReference"), processor, CashflowObservationReference.CashflowObservationReferenceBuilder.class, this.getObservationReference(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("calculatedValue"), BigDecimal.class, (Object)this.getCalculatedValue(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("multiplier"), BigDecimal.class, (Object)this.getMultiplier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("spread"), BigDecimal.class, (Object)this.getSpread(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("capValue"), processor, Strike.StrikeBuilder.class, this.getCapValue(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("floorValue"), processor, Strike.StrikeBuilder.class, this.getFloorValue(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("negativeInterestRate"), Boolean.class, (Object)this.getNegativeInterestRate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("rounding"), processor, Rounding.RoundingBuilder.class, this.getRounding(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public CashflowFixingBuilder prune();
    }

    public static class CashflowFixingImpl
    implements CashflowFixing {
        private final List<? extends CashflowObservationReference> observationReference;
        private final BigDecimal calculatedValue;
        private final BigDecimal multiplier;
        private final BigDecimal spread;
        private final List<? extends Strike> capValue;
        private final List<? extends Strike> floorValue;
        private final Boolean negativeInterestRate;
        private final Rounding rounding;
        private final String id;

        protected CashflowFixingImpl(CashflowFixingBuilder builder) {
            this.observationReference = Optional.ofNullable(builder.getObservationReference()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.calculatedValue = builder.getCalculatedValue();
            this.multiplier = builder.getMultiplier();
            this.spread = builder.getSpread();
            this.capValue = Optional.ofNullable(builder.getCapValue()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.floorValue = Optional.ofNullable(builder.getFloorValue()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.negativeInterestRate = builder.getNegativeInterestRate();
            this.rounding = Optional.ofNullable(builder.getRounding()).map(f -> f.build()).orElse(null);
            this.id = builder.getId();
        }

        @Override
        @RosettaAttribute(value="observationReference")
        @RuneAttribute(value="observationReference")
        public List<? extends CashflowObservationReference> getObservationReference() {
            return this.observationReference;
        }

        @Override
        @RosettaAttribute(value="calculatedValue")
        @RuneAttribute(value="calculatedValue")
        public BigDecimal getCalculatedValue() {
            return this.calculatedValue;
        }

        @Override
        @RosettaAttribute(value="multiplier")
        @RuneAttribute(value="multiplier")
        public BigDecimal getMultiplier() {
            return this.multiplier;
        }

        @Override
        @RosettaAttribute(value="spread")
        @RuneAttribute(value="spread")
        public BigDecimal getSpread() {
            return this.spread;
        }

        @Override
        @RosettaAttribute(value="capValue")
        @RuneAttribute(value="capValue")
        public List<? extends Strike> getCapValue() {
            return this.capValue;
        }

        @Override
        @RosettaAttribute(value="floorValue")
        @RuneAttribute(value="floorValue")
        public List<? extends Strike> getFloorValue() {
            return this.floorValue;
        }

        @Override
        @RosettaAttribute(value="negativeInterestRate")
        @RuneAttribute(value="negativeInterestRate")
        public Boolean getNegativeInterestRate() {
            return this.negativeInterestRate;
        }

        @Override
        @RosettaAttribute(value="rounding")
        @RuneAttribute(value="rounding")
        public Rounding getRounding() {
            return this.rounding;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public String getId() {
            return this.id;
        }

        @Override
        public CashflowFixing build() {
            return this;
        }

        @Override
        public CashflowFixingBuilder toBuilder() {
            CashflowFixingBuilder builder = CashflowFixing.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CashflowFixingBuilder builder) {
            Optional.ofNullable(this.getObservationReference()).ifPresent(builder::setObservationReference);
            Optional.ofNullable(this.getCalculatedValue()).ifPresent(builder::setCalculatedValue);
            Optional.ofNullable(this.getMultiplier()).ifPresent(builder::setMultiplier);
            Optional.ofNullable(this.getSpread()).ifPresent(builder::setSpread);
            Optional.ofNullable(this.getCapValue()).ifPresent(builder::setCapValue);
            Optional.ofNullable(this.getFloorValue()).ifPresent(builder::setFloorValue);
            Optional.ofNullable(this.getNegativeInterestRate()).ifPresent(builder::setNegativeInterestRate);
            Optional.ofNullable(this.getRounding()).ifPresent(builder::setRounding);
            Optional.ofNullable(this.getId()).ifPresent(builder::setId);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CashflowFixing _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.observationReference, _that.getObservationReference())) {
                return false;
            }
            if (!Objects.equals(this.calculatedValue, _that.getCalculatedValue())) {
                return false;
            }
            if (!Objects.equals(this.multiplier, _that.getMultiplier())) {
                return false;
            }
            if (!Objects.equals(this.spread, _that.getSpread())) {
                return false;
            }
            if (!ListEquals.listEquals(this.capValue, _that.getCapValue())) {
                return false;
            }
            if (!ListEquals.listEquals(this.floorValue, _that.getFloorValue())) {
                return false;
            }
            if (!Objects.equals(this.negativeInterestRate, _that.getNegativeInterestRate())) {
                return false;
            }
            if (!Objects.equals(this.rounding, _that.getRounding())) {
                return false;
            }
            return Objects.equals(this.id, _that.getId());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.observationReference != null ? this.observationReference.hashCode() : 0);
            _result = 31 * _result + (this.calculatedValue != null ? this.calculatedValue.hashCode() : 0);
            _result = 31 * _result + (this.multiplier != null ? this.multiplier.hashCode() : 0);
            _result = 31 * _result + (this.spread != null ? this.spread.hashCode() : 0);
            _result = 31 * _result + (this.capValue != null ? this.capValue.hashCode() : 0);
            _result = 31 * _result + (this.floorValue != null ? this.floorValue.hashCode() : 0);
            _result = 31 * _result + (this.negativeInterestRate != null ? this.negativeInterestRate.hashCode() : 0);
            _result = 31 * _result + (this.rounding != null ? this.rounding.hashCode() : 0);
            _result = 31 * _result + (this.id != null ? this.id.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CashflowFixing {observationReference=" + this.observationReference + ", calculatedValue=" + this.calculatedValue + ", multiplier=" + this.multiplier + ", spread=" + this.spread + ", capValue=" + this.capValue + ", floorValue=" + this.floorValue + ", negativeInterestRate=" + this.negativeInterestRate + ", rounding=" + this.rounding + ", id=" + this.id + '}';
        }
    }
}

