/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.business.events;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.business.events.BusinessEventIdentifier;
import fpml.consolidated.business.events.meta.AbstractEventMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="AbstractEvent", builder=AbstractEventBuilderImpl.class, version="1.1.0")
@RuneDataType(value="AbstractEvent", model="fpml", builder=AbstractEventBuilderImpl.class, version="1.1.0")
public interface AbstractEvent
extends RosettaModelObject {
    public static final AbstractEventMeta metaData = new AbstractEventMeta();

    public List<? extends BusinessEventIdentifier> getEventIdentifier();

    public AbstractEvent build();

    public AbstractEventBuilder toBuilder();

    public static AbstractEventBuilder builder() {
        return new AbstractEventBuilderImpl();
    }

    default public RosettaMetaData<? extends AbstractEvent> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends AbstractEvent> getType() {
        return AbstractEvent.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("eventIdentifier"), processor, BusinessEventIdentifier.class, this.getEventIdentifier(), new AttributeMeta[0]);
    }

    public static class AbstractEventBuilderImpl
    implements AbstractEventBuilder {
        protected List<BusinessEventIdentifier.BusinessEventIdentifierBuilder> eventIdentifier = new ArrayList<BusinessEventIdentifier.BusinessEventIdentifierBuilder>();

        @Override
        @RosettaAttribute(value="eventIdentifier")
        @RuneAttribute(value="eventIdentifier")
        public List<? extends BusinessEventIdentifier.BusinessEventIdentifierBuilder> getEventIdentifier() {
            return this.eventIdentifier;
        }

        @Override
        public BusinessEventIdentifier.BusinessEventIdentifierBuilder getOrCreateEventIdentifier(int index) {
            if (this.eventIdentifier == null) {
                this.eventIdentifier = new ArrayList<BusinessEventIdentifier.BusinessEventIdentifierBuilder>();
            }
            return (BusinessEventIdentifier.BusinessEventIdentifierBuilder)this.getIndex(this.eventIdentifier, index, () -> {
                BusinessEventIdentifier.BusinessEventIdentifierBuilder newEventIdentifier = BusinessEventIdentifier.builder();
                return newEventIdentifier;
            });
        }

        @Override
        @RosettaAttribute(value="eventIdentifier")
        @RuneAttribute(value="eventIdentifier")
        public AbstractEventBuilder addEventIdentifier(BusinessEventIdentifier _eventIdentifier) {
            if (_eventIdentifier != null) {
                this.eventIdentifier.add(_eventIdentifier.toBuilder());
            }
            return this;
        }

        @Override
        public AbstractEventBuilder addEventIdentifier(BusinessEventIdentifier _eventIdentifier, int idx) {
            this.getIndex(this.eventIdentifier, idx, () -> _eventIdentifier.toBuilder());
            return this;
        }

        @Override
        public AbstractEventBuilder addEventIdentifier(List<? extends BusinessEventIdentifier> eventIdentifiers) {
            if (eventIdentifiers != null) {
                for (BusinessEventIdentifier businessEventIdentifier : eventIdentifiers) {
                    this.eventIdentifier.add(businessEventIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="eventIdentifier")
        public AbstractEventBuilder setEventIdentifier(List<? extends BusinessEventIdentifier> eventIdentifiers) {
            this.eventIdentifier = eventIdentifiers == null ? new ArrayList<BusinessEventIdentifier.BusinessEventIdentifierBuilder>() : (List)eventIdentifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public AbstractEvent build() {
            return new AbstractEventImpl(this);
        }

        @Override
        public AbstractEventBuilder toBuilder() {
            return this;
        }

        @Override
        public AbstractEventBuilder prune() {
            this.eventIdentifier = this.eventIdentifier.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            return this.getEventIdentifier() != null && this.getEventIdentifier().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public AbstractEventBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            AbstractEventBuilder o = (AbstractEventBuilder)other;
            merger.mergeRosetta(this.getEventIdentifier(), o.getEventIdentifier(), this::getOrCreateEventIdentifier);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            AbstractEvent _that = this.getType().cast(o);
            return ListEquals.listEquals(this.eventIdentifier, _that.getEventIdentifier());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.eventIdentifier != null ? this.eventIdentifier.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "AbstractEventBuilder {eventIdentifier=" + this.eventIdentifier + '}';
        }
    }

    public static interface AbstractEventBuilder
    extends AbstractEvent,
    RosettaModelObjectBuilder {
        public BusinessEventIdentifier.BusinessEventIdentifierBuilder getOrCreateEventIdentifier(int var1);

        public List<? extends BusinessEventIdentifier.BusinessEventIdentifierBuilder> getEventIdentifier();

        public AbstractEventBuilder addEventIdentifier(BusinessEventIdentifier var1);

        public AbstractEventBuilder addEventIdentifier(BusinessEventIdentifier var1, int var2);

        public AbstractEventBuilder addEventIdentifier(List<? extends BusinessEventIdentifier> var1);

        public AbstractEventBuilder setEventIdentifier(List<? extends BusinessEventIdentifier> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("eventIdentifier"), processor, BusinessEventIdentifier.BusinessEventIdentifierBuilder.class, this.getEventIdentifier(), new AttributeMeta[0]);
        }

        public AbstractEventBuilder prune();
    }

    public static class AbstractEventImpl
    implements AbstractEvent {
        private final List<? extends BusinessEventIdentifier> eventIdentifier;

        protected AbstractEventImpl(AbstractEventBuilder builder) {
            this.eventIdentifier = Optional.ofNullable(builder.getEventIdentifier()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="eventIdentifier")
        @RuneAttribute(value="eventIdentifier")
        public List<? extends BusinessEventIdentifier> getEventIdentifier() {
            return this.eventIdentifier;
        }

        @Override
        public AbstractEvent build() {
            return this;
        }

        @Override
        public AbstractEventBuilder toBuilder() {
            AbstractEventBuilder builder = AbstractEvent.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(AbstractEventBuilder builder) {
            Optional.ofNullable(this.getEventIdentifier()).ifPresent(builder::setEventIdentifier);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            AbstractEvent _that = this.getType().cast(o);
            return ListEquals.listEquals(this.eventIdentifier, _that.getEventIdentifier());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.eventIdentifier != null ? this.eventIdentifier.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "AbstractEvent {eventIdentifier=" + this.eventIdentifier + '}';
        }
    }
}

