/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.asset;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.asset.FacilityType;
import fpml.consolidated.asset.InstrumentType;
import fpml.consolidated.asset.Lien;
import fpml.consolidated.asset.LoanChoice;
import fpml.consolidated.asset.UnderlyingAsset;
import fpml.consolidated.asset.UnderlyingAssetTranche;
import fpml.consolidated.asset.meta.LoanMeta;
import fpml.consolidated.shared.ClearanceSystem;
import fpml.consolidated.shared.CreditSeniority;
import fpml.consolidated.shared.ExchangeId;
import fpml.consolidated.shared.IdentifiedCurrency;
import fpml.consolidated.shared.InstrumentId;
import fpml.consolidated.shared.ProductReference;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="Loan", builder=LoanBuilderImpl.class, version="1.1.0")
@RuneDataType(value="Loan", model="fpml", builder=LoanBuilderImpl.class, version="1.1.0")
public interface Loan
extends UnderlyingAsset {
    public static final LoanMeta metaData = new LoanMeta();

    public List<? extends LoanChoice> getLoanChoice();

    public Lien getLien();

    public FacilityType getFacilityType();

    public ZonedDateTime getMaturity();

    public ZonedDateTime getCreditAgreementDate();

    public UnderlyingAssetTranche getTranche();

    public CreditSeniority getSeniority();

    @Override
    public Loan build();

    @Override
    public LoanBuilder toBuilder();

    public static LoanBuilder builder() {
        return new LoanBuilderImpl();
    }

    default public RosettaMetaData<? extends Loan> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends Loan> getType() {
        return Loan.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("instrumentId"), processor, InstrumentId.class, this.getInstrumentId(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("instrumentType"), processor, InstrumentType.class, this.getInstrumentType(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("description"), String.class, (Object)this.getDescription(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("currency"), processor, IdentifiedCurrency.class, this.getCurrency(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("exchangeId"), processor, ExchangeId.class, this.getExchangeId(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("clearanceSystem"), processor, ClearanceSystem.class, this.getClearanceSystem(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("definition"), processor, ProductReference.class, this.getDefinition(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("loanChoice"), processor, LoanChoice.class, this.getLoanChoice(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("lien"), processor, Lien.class, this.getLien(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("facilityType"), processor, FacilityType.class, this.getFacilityType(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("maturity"), ZonedDateTime.class, (Object)this.getMaturity(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("creditAgreementDate"), ZonedDateTime.class, (Object)this.getCreditAgreementDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("tranche"), processor, UnderlyingAssetTranche.class, this.getTranche(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("seniority"), processor, CreditSeniority.class, this.getSeniority(), new AttributeMeta[0]);
    }

    public static class LoanBuilderImpl
    extends UnderlyingAsset.UnderlyingAssetBuilderImpl
    implements LoanBuilder {
        protected List<LoanChoice.LoanChoiceBuilder> loanChoice = new ArrayList<LoanChoice.LoanChoiceBuilder>();
        protected Lien.LienBuilder lien;
        protected FacilityType.FacilityTypeBuilder facilityType;
        protected ZonedDateTime maturity;
        protected ZonedDateTime creditAgreementDate;
        protected UnderlyingAssetTranche.UnderlyingAssetTrancheBuilder tranche;
        protected CreditSeniority.CreditSeniorityBuilder seniority;

        @Override
        @RosettaAttribute(value="loanChoice")
        @RuneAttribute(value="loanChoice")
        public List<? extends LoanChoice.LoanChoiceBuilder> getLoanChoice() {
            return this.loanChoice;
        }

        @Override
        public LoanChoice.LoanChoiceBuilder getOrCreateLoanChoice(int index) {
            if (this.loanChoice == null) {
                this.loanChoice = new ArrayList<LoanChoice.LoanChoiceBuilder>();
            }
            return (LoanChoice.LoanChoiceBuilder)this.getIndex(this.loanChoice, index, () -> {
                LoanChoice.LoanChoiceBuilder newLoanChoice = LoanChoice.builder();
                return newLoanChoice;
            });
        }

        @Override
        @RosettaAttribute(value="lien")
        @RuneAttribute(value="lien")
        public Lien.LienBuilder getLien() {
            return this.lien;
        }

        @Override
        public Lien.LienBuilder getOrCreateLien() {
            Lien.LienBuilder result = this.lien != null ? this.lien : (this.lien = Lien.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="facilityType")
        @RuneAttribute(value="facilityType")
        public FacilityType.FacilityTypeBuilder getFacilityType() {
            return this.facilityType;
        }

        @Override
        public FacilityType.FacilityTypeBuilder getOrCreateFacilityType() {
            FacilityType.FacilityTypeBuilder result = this.facilityType != null ? this.facilityType : (this.facilityType = FacilityType.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="maturity")
        @RuneAttribute(value="maturity")
        public ZonedDateTime getMaturity() {
            return this.maturity;
        }

        @Override
        @RosettaAttribute(value="creditAgreementDate")
        @RuneAttribute(value="creditAgreementDate")
        public ZonedDateTime getCreditAgreementDate() {
            return this.creditAgreementDate;
        }

        @Override
        @RosettaAttribute(value="tranche")
        @RuneAttribute(value="tranche")
        public UnderlyingAssetTranche.UnderlyingAssetTrancheBuilder getTranche() {
            return this.tranche;
        }

        @Override
        public UnderlyingAssetTranche.UnderlyingAssetTrancheBuilder getOrCreateTranche() {
            UnderlyingAssetTranche.UnderlyingAssetTrancheBuilder result = this.tranche != null ? this.tranche : (this.tranche = UnderlyingAssetTranche.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="seniority")
        @RuneAttribute(value="seniority")
        public CreditSeniority.CreditSeniorityBuilder getSeniority() {
            return this.seniority;
        }

        @Override
        public CreditSeniority.CreditSeniorityBuilder getOrCreateSeniority() {
            CreditSeniority.CreditSeniorityBuilder result = this.seniority != null ? this.seniority : (this.seniority = CreditSeniority.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public LoanBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="instrumentId", isRequired=true)
        @RuneAttribute(value="instrumentId", isRequired=true)
        public LoanBuilder addInstrumentId(InstrumentId _instrumentId) {
            if (_instrumentId != null) {
                this.instrumentId.add(_instrumentId.toBuilder());
            }
            return this;
        }

        @Override
        public LoanBuilder addInstrumentId(InstrumentId _instrumentId, int idx) {
            this.getIndex(this.instrumentId, idx, () -> _instrumentId.toBuilder());
            return this;
        }

        @Override
        public LoanBuilder addInstrumentId(List<? extends InstrumentId> instrumentIds) {
            if (instrumentIds != null) {
                for (InstrumentId instrumentId : instrumentIds) {
                    this.instrumentId.add(instrumentId.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="instrumentId")
        public LoanBuilder setInstrumentId(List<? extends InstrumentId> instrumentIds) {
            this.instrumentId = instrumentIds == null ? new ArrayList() : (List)instrumentIds.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="instrumentType")
        @RuneAttribute(value="instrumentType")
        public LoanBuilder addInstrumentType(InstrumentType _instrumentType) {
            if (_instrumentType != null) {
                this.instrumentType.add(_instrumentType.toBuilder());
            }
            return this;
        }

        @Override
        public LoanBuilder addInstrumentType(InstrumentType _instrumentType, int idx) {
            this.getIndex(this.instrumentType, idx, () -> _instrumentType.toBuilder());
            return this;
        }

        @Override
        public LoanBuilder addInstrumentType(List<? extends InstrumentType> instrumentTypes) {
            if (instrumentTypes != null) {
                for (InstrumentType instrumentType : instrumentTypes) {
                    this.instrumentType.add(instrumentType.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="instrumentType")
        public LoanBuilder setInstrumentType(List<? extends InstrumentType> instrumentTypes) {
            this.instrumentType = instrumentTypes == null ? new ArrayList() : (List)instrumentTypes.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="description")
        @RuneAttribute(value="description")
        public LoanBuilder setDescription(String _description) {
            this.description = _description == null ? null : _description;
            return this;
        }

        @Override
        @RosettaAttribute(value="currency")
        @RuneAttribute(value="currency")
        public LoanBuilder setCurrency(IdentifiedCurrency _currency) {
            this.currency = _currency == null ? null : _currency.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="exchangeId")
        @RuneAttribute(value="exchangeId")
        public LoanBuilder setExchangeId(ExchangeId _exchangeId) {
            this.exchangeId = _exchangeId == null ? null : _exchangeId.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="clearanceSystem")
        @RuneAttribute(value="clearanceSystem")
        public LoanBuilder setClearanceSystem(ClearanceSystem _clearanceSystem) {
            this.clearanceSystem = _clearanceSystem == null ? null : _clearanceSystem.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="definition")
        @RuneAttribute(value="definition")
        public LoanBuilder setDefinition(ProductReference _definition) {
            this.definition = _definition == null ? null : _definition.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="loanChoice")
        @RuneAttribute(value="loanChoice")
        public LoanBuilder addLoanChoice(LoanChoice _loanChoice) {
            if (_loanChoice != null) {
                this.loanChoice.add(_loanChoice.toBuilder());
            }
            return this;
        }

        @Override
        public LoanBuilder addLoanChoice(LoanChoice _loanChoice, int idx) {
            this.getIndex(this.loanChoice, idx, () -> _loanChoice.toBuilder());
            return this;
        }

        @Override
        public LoanBuilder addLoanChoice(List<? extends LoanChoice> loanChoices) {
            if (loanChoices != null) {
                for (LoanChoice loanChoice : loanChoices) {
                    this.loanChoice.add(loanChoice.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="loanChoice")
        public LoanBuilder setLoanChoice(List<? extends LoanChoice> loanChoices) {
            this.loanChoice = loanChoices == null ? new ArrayList<LoanChoice.LoanChoiceBuilder>() : (List)loanChoices.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="lien")
        @RuneAttribute(value="lien")
        public LoanBuilder setLien(Lien _lien) {
            this.lien = _lien == null ? null : _lien.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="facilityType")
        @RuneAttribute(value="facilityType")
        public LoanBuilder setFacilityType(FacilityType _facilityType) {
            this.facilityType = _facilityType == null ? null : _facilityType.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="maturity")
        @RuneAttribute(value="maturity")
        public LoanBuilder setMaturity(ZonedDateTime _maturity) {
            this.maturity = _maturity == null ? null : _maturity;
            return this;
        }

        @Override
        @RosettaAttribute(value="creditAgreementDate")
        @RuneAttribute(value="creditAgreementDate")
        public LoanBuilder setCreditAgreementDate(ZonedDateTime _creditAgreementDate) {
            this.creditAgreementDate = _creditAgreementDate == null ? null : _creditAgreementDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="tranche")
        @RuneAttribute(value="tranche")
        public LoanBuilder setTranche(UnderlyingAssetTranche _tranche) {
            this.tranche = _tranche == null ? null : _tranche.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="seniority")
        @RuneAttribute(value="seniority")
        public LoanBuilder setSeniority(CreditSeniority _seniority) {
            this.seniority = _seniority == null ? null : _seniority.toBuilder();
            return this;
        }

        @Override
        public Loan build() {
            return new LoanImpl(this);
        }

        @Override
        public LoanBuilder toBuilder() {
            return this;
        }

        @Override
        public LoanBuilder prune() {
            super.prune();
            this.loanChoice = this.loanChoice.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.lien != null && !this.lien.prune().hasData()) {
                this.lien = null;
            }
            if (this.facilityType != null && !this.facilityType.prune().hasData()) {
                this.facilityType = null;
            }
            if (this.tranche != null && !this.tranche.prune().hasData()) {
                this.tranche = null;
            }
            if (this.seniority != null && !this.seniority.prune().hasData()) {
                this.seniority = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getLoanChoice() != null && this.getLoanChoice().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getLien() != null && this.getLien().hasData()) {
                return true;
            }
            if (this.getFacilityType() != null && this.getFacilityType().hasData()) {
                return true;
            }
            if (this.getMaturity() != null) {
                return true;
            }
            if (this.getCreditAgreementDate() != null) {
                return true;
            }
            if (this.getTranche() != null && this.getTranche().hasData()) {
                return true;
            }
            return this.getSeniority() != null && this.getSeniority().hasData();
        }

        @Override
        public LoanBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            LoanBuilder o = (LoanBuilder)other;
            merger.mergeRosetta(this.getLoanChoice(), o.getLoanChoice(), this::getOrCreateLoanChoice);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getLien(), (RosettaModelObjectBuilder)o.getLien(), this::setLien);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFacilityType(), (RosettaModelObjectBuilder)o.getFacilityType(), this::setFacilityType);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getTranche(), (RosettaModelObjectBuilder)o.getTranche(), this::setTranche);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSeniority(), (RosettaModelObjectBuilder)o.getSeniority(), this::setSeniority);
            merger.mergeBasic((Object)this.getMaturity(), (Object)o.getMaturity(), this::setMaturity, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCreditAgreementDate(), (Object)o.getCreditAgreementDate(), this::setCreditAgreementDate, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Loan _that = (Loan)this.getType().cast(o);
            if (!ListEquals.listEquals(this.loanChoice, _that.getLoanChoice())) {
                return false;
            }
            if (!Objects.equals(this.lien, _that.getLien())) {
                return false;
            }
            if (!Objects.equals(this.facilityType, _that.getFacilityType())) {
                return false;
            }
            if (!Objects.equals(this.maturity, _that.getMaturity())) {
                return false;
            }
            if (!Objects.equals(this.creditAgreementDate, _that.getCreditAgreementDate())) {
                return false;
            }
            if (!Objects.equals(this.tranche, _that.getTranche())) {
                return false;
            }
            return Objects.equals(this.seniority, _that.getSeniority());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.loanChoice != null ? this.loanChoice.hashCode() : 0);
            _result = 31 * _result + (this.lien != null ? this.lien.hashCode() : 0);
            _result = 31 * _result + (this.facilityType != null ? this.facilityType.hashCode() : 0);
            _result = 31 * _result + (this.maturity != null ? this.maturity.hashCode() : 0);
            _result = 31 * _result + (this.creditAgreementDate != null ? this.creditAgreementDate.hashCode() : 0);
            _result = 31 * _result + (this.tranche != null ? this.tranche.hashCode() : 0);
            _result = 31 * _result + (this.seniority != null ? this.seniority.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "LoanBuilder {loanChoice=" + this.loanChoice + ", lien=" + this.lien + ", facilityType=" + this.facilityType + ", maturity=" + this.maturity + ", creditAgreementDate=" + this.creditAgreementDate + ", tranche=" + this.tranche + ", seniority=" + this.seniority + '}' + " " + super.toString();
        }
    }

    public static interface LoanBuilder
    extends Loan,
    UnderlyingAsset.UnderlyingAssetBuilder {
        public LoanChoice.LoanChoiceBuilder getOrCreateLoanChoice(int var1);

        public List<? extends LoanChoice.LoanChoiceBuilder> getLoanChoice();

        public Lien.LienBuilder getOrCreateLien();

        @Override
        public Lien.LienBuilder getLien();

        public FacilityType.FacilityTypeBuilder getOrCreateFacilityType();

        @Override
        public FacilityType.FacilityTypeBuilder getFacilityType();

        public UnderlyingAssetTranche.UnderlyingAssetTrancheBuilder getOrCreateTranche();

        @Override
        public UnderlyingAssetTranche.UnderlyingAssetTrancheBuilder getTranche();

        public CreditSeniority.CreditSeniorityBuilder getOrCreateSeniority();

        @Override
        public CreditSeniority.CreditSeniorityBuilder getSeniority();

        @Override
        public LoanBuilder setId(String var1);

        @Override
        public LoanBuilder addInstrumentId(InstrumentId var1);

        @Override
        public LoanBuilder addInstrumentId(InstrumentId var1, int var2);

        @Override
        public LoanBuilder addInstrumentId(List<? extends InstrumentId> var1);

        @Override
        public LoanBuilder setInstrumentId(List<? extends InstrumentId> var1);

        @Override
        public LoanBuilder addInstrumentType(InstrumentType var1);

        @Override
        public LoanBuilder addInstrumentType(InstrumentType var1, int var2);

        @Override
        public LoanBuilder addInstrumentType(List<? extends InstrumentType> var1);

        @Override
        public LoanBuilder setInstrumentType(List<? extends InstrumentType> var1);

        @Override
        public LoanBuilder setDescription(String var1);

        @Override
        public LoanBuilder setCurrency(IdentifiedCurrency var1);

        @Override
        public LoanBuilder setExchangeId(ExchangeId var1);

        @Override
        public LoanBuilder setClearanceSystem(ClearanceSystem var1);

        @Override
        public LoanBuilder setDefinition(ProductReference var1);

        public LoanBuilder addLoanChoice(LoanChoice var1);

        public LoanBuilder addLoanChoice(LoanChoice var1, int var2);

        public LoanBuilder addLoanChoice(List<? extends LoanChoice> var1);

        public LoanBuilder setLoanChoice(List<? extends LoanChoice> var1);

        public LoanBuilder setLien(Lien var1);

        public LoanBuilder setFacilityType(FacilityType var1);

        public LoanBuilder setMaturity(ZonedDateTime var1);

        public LoanBuilder setCreditAgreementDate(ZonedDateTime var1);

        public LoanBuilder setTranche(UnderlyingAssetTranche var1);

        public LoanBuilder setSeniority(CreditSeniority var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("instrumentId"), processor, InstrumentId.InstrumentIdBuilder.class, this.getInstrumentId(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("instrumentType"), processor, InstrumentType.InstrumentTypeBuilder.class, this.getInstrumentType(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("description"), String.class, (Object)this.getDescription(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("currency"), processor, IdentifiedCurrency.IdentifiedCurrencyBuilder.class, (RosettaModelObjectBuilder)this.getCurrency(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("exchangeId"), processor, ExchangeId.ExchangeIdBuilder.class, (RosettaModelObjectBuilder)this.getExchangeId(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("clearanceSystem"), processor, ClearanceSystem.ClearanceSystemBuilder.class, (RosettaModelObjectBuilder)this.getClearanceSystem(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("definition"), processor, ProductReference.ProductReferenceBuilder.class, (RosettaModelObjectBuilder)this.getDefinition(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("loanChoice"), processor, LoanChoice.LoanChoiceBuilder.class, this.getLoanChoice(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("lien"), processor, Lien.LienBuilder.class, this.getLien(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("facilityType"), processor, FacilityType.FacilityTypeBuilder.class, this.getFacilityType(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("maturity"), ZonedDateTime.class, (Object)this.getMaturity(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("creditAgreementDate"), ZonedDateTime.class, (Object)this.getCreditAgreementDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("tranche"), processor, UnderlyingAssetTranche.UnderlyingAssetTrancheBuilder.class, this.getTranche(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("seniority"), processor, CreditSeniority.CreditSeniorityBuilder.class, this.getSeniority(), new AttributeMeta[0]);
        }

        @Override
        public LoanBuilder prune();
    }

    public static class LoanImpl
    extends UnderlyingAsset.UnderlyingAssetImpl
    implements Loan {
        private final List<? extends LoanChoice> loanChoice;
        private final Lien lien;
        private final FacilityType facilityType;
        private final ZonedDateTime maturity;
        private final ZonedDateTime creditAgreementDate;
        private final UnderlyingAssetTranche tranche;
        private final CreditSeniority seniority;

        protected LoanImpl(LoanBuilder builder) {
            super(builder);
            this.loanChoice = Optional.ofNullable(builder.getLoanChoice()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.lien = Optional.ofNullable(builder.getLien()).map(f -> f.build()).orElse(null);
            this.facilityType = Optional.ofNullable(builder.getFacilityType()).map(f -> f.build()).orElse(null);
            this.maturity = builder.getMaturity();
            this.creditAgreementDate = builder.getCreditAgreementDate();
            this.tranche = Optional.ofNullable(builder.getTranche()).map(f -> f.build()).orElse(null);
            this.seniority = Optional.ofNullable(builder.getSeniority()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="loanChoice")
        @RuneAttribute(value="loanChoice")
        public List<? extends LoanChoice> getLoanChoice() {
            return this.loanChoice;
        }

        @Override
        @RosettaAttribute(value="lien")
        @RuneAttribute(value="lien")
        public Lien getLien() {
            return this.lien;
        }

        @Override
        @RosettaAttribute(value="facilityType")
        @RuneAttribute(value="facilityType")
        public FacilityType getFacilityType() {
            return this.facilityType;
        }

        @Override
        @RosettaAttribute(value="maturity")
        @RuneAttribute(value="maturity")
        public ZonedDateTime getMaturity() {
            return this.maturity;
        }

        @Override
        @RosettaAttribute(value="creditAgreementDate")
        @RuneAttribute(value="creditAgreementDate")
        public ZonedDateTime getCreditAgreementDate() {
            return this.creditAgreementDate;
        }

        @Override
        @RosettaAttribute(value="tranche")
        @RuneAttribute(value="tranche")
        public UnderlyingAssetTranche getTranche() {
            return this.tranche;
        }

        @Override
        @RosettaAttribute(value="seniority")
        @RuneAttribute(value="seniority")
        public CreditSeniority getSeniority() {
            return this.seniority;
        }

        @Override
        public Loan build() {
            return this;
        }

        @Override
        public LoanBuilder toBuilder() {
            LoanBuilder builder = Loan.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(LoanBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getLoanChoice()).ifPresent(builder::setLoanChoice);
            Optional.ofNullable(this.getLien()).ifPresent(builder::setLien);
            Optional.ofNullable(this.getFacilityType()).ifPresent(builder::setFacilityType);
            Optional.ofNullable(this.getMaturity()).ifPresent(builder::setMaturity);
            Optional.ofNullable(this.getCreditAgreementDate()).ifPresent(builder::setCreditAgreementDate);
            Optional.ofNullable(this.getTranche()).ifPresent(builder::setTranche);
            Optional.ofNullable(this.getSeniority()).ifPresent(builder::setSeniority);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Loan _that = (Loan)this.getType().cast(o);
            if (!ListEquals.listEquals(this.loanChoice, _that.getLoanChoice())) {
                return false;
            }
            if (!Objects.equals(this.lien, _that.getLien())) {
                return false;
            }
            if (!Objects.equals(this.facilityType, _that.getFacilityType())) {
                return false;
            }
            if (!Objects.equals(this.maturity, _that.getMaturity())) {
                return false;
            }
            if (!Objects.equals(this.creditAgreementDate, _that.getCreditAgreementDate())) {
                return false;
            }
            if (!Objects.equals(this.tranche, _that.getTranche())) {
                return false;
            }
            return Objects.equals(this.seniority, _that.getSeniority());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.loanChoice != null ? this.loanChoice.hashCode() : 0);
            _result = 31 * _result + (this.lien != null ? this.lien.hashCode() : 0);
            _result = 31 * _result + (this.facilityType != null ? this.facilityType.hashCode() : 0);
            _result = 31 * _result + (this.maturity != null ? this.maturity.hashCode() : 0);
            _result = 31 * _result + (this.creditAgreementDate != null ? this.creditAgreementDate.hashCode() : 0);
            _result = 31 * _result + (this.tranche != null ? this.tranche.hashCode() : 0);
            _result = 31 * _result + (this.seniority != null ? this.seniority.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "Loan {loanChoice=" + this.loanChoice + ", lien=" + this.lien + ", facilityType=" + this.facilityType + ", maturity=" + this.maturity + ", creditAgreementDate=" + this.creditAgreementDate + ", tranche=" + this.tranche + ", seniority=" + this.seniority + '}' + " " + super.toString();
        }
    }
}

