/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.asset;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.asset.CouponType;
import fpml.consolidated.asset.CreditQuality;
import fpml.consolidated.asset.meta.FixedIncomeSecurityContentModelMeta;
import fpml.consolidated.shared.CreditRating;
import fpml.consolidated.shared.CreditSeniority;
import fpml.consolidated.shared.PartyReference;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="FixedIncomeSecurityContentModel", builder=FixedIncomeSecurityContentModelBuilderImpl.class, version="1.1.0")
@RuneDataType(value="FixedIncomeSecurityContentModel", model="fpml", builder=FixedIncomeSecurityContentModelBuilderImpl.class, version="1.1.0")
public interface FixedIncomeSecurityContentModel
extends RosettaModelObject {
    public static final FixedIncomeSecurityContentModelMeta metaData = new FixedIncomeSecurityContentModelMeta();

    public String getIssuerName();

    public PartyReference getIssuerPartyReference();

    public CreditSeniority getSeniority();

    public List<? extends CreditQuality> getCreditQuality();

    public List<? extends CreditRating> getCreditRating();

    public CouponType getCouponType();

    public BigDecimal getCouponRate();

    public ZonedDateTime getMaturity();

    public FixedIncomeSecurityContentModel build();

    public FixedIncomeSecurityContentModelBuilder toBuilder();

    public static FixedIncomeSecurityContentModelBuilder builder() {
        return new FixedIncomeSecurityContentModelBuilderImpl();
    }

    default public RosettaMetaData<? extends FixedIncomeSecurityContentModel> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends FixedIncomeSecurityContentModel> getType() {
        return FixedIncomeSecurityContentModel.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("issuerName"), String.class, (Object)this.getIssuerName(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("issuerPartyReference"), processor, PartyReference.class, this.getIssuerPartyReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("seniority"), processor, CreditSeniority.class, this.getSeniority(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("creditQuality"), processor, CreditQuality.class, this.getCreditQuality(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("creditRating"), processor, CreditRating.class, this.getCreditRating(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("couponType"), processor, CouponType.class, this.getCouponType(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("couponRate"), BigDecimal.class, (Object)this.getCouponRate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("maturity"), ZonedDateTime.class, (Object)this.getMaturity(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class FixedIncomeSecurityContentModelBuilderImpl
    implements FixedIncomeSecurityContentModelBuilder {
        protected String issuerName;
        protected PartyReference.PartyReferenceBuilder issuerPartyReference;
        protected CreditSeniority.CreditSeniorityBuilder seniority;
        protected List<CreditQuality.CreditQualityBuilder> creditQuality = new ArrayList<CreditQuality.CreditQualityBuilder>();
        protected List<CreditRating.CreditRatingBuilder> creditRating = new ArrayList<CreditRating.CreditRatingBuilder>();
        protected CouponType.CouponTypeBuilder couponType;
        protected BigDecimal couponRate;
        protected ZonedDateTime maturity;

        @Override
        @RosettaAttribute(value="issuerName")
        @RuneAttribute(value="issuerName")
        public String getIssuerName() {
            return this.issuerName;
        }

        @Override
        @RosettaAttribute(value="issuerPartyReference")
        @RuneAttribute(value="issuerPartyReference")
        public PartyReference.PartyReferenceBuilder getIssuerPartyReference() {
            return this.issuerPartyReference;
        }

        @Override
        public PartyReference.PartyReferenceBuilder getOrCreateIssuerPartyReference() {
            PartyReference.PartyReferenceBuilder result = this.issuerPartyReference != null ? this.issuerPartyReference : (this.issuerPartyReference = PartyReference.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="seniority")
        @RuneAttribute(value="seniority")
        public CreditSeniority.CreditSeniorityBuilder getSeniority() {
            return this.seniority;
        }

        @Override
        public CreditSeniority.CreditSeniorityBuilder getOrCreateSeniority() {
            CreditSeniority.CreditSeniorityBuilder result = this.seniority != null ? this.seniority : (this.seniority = CreditSeniority.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="creditQuality")
        @RuneAttribute(value="creditQuality")
        public List<? extends CreditQuality.CreditQualityBuilder> getCreditQuality() {
            return this.creditQuality;
        }

        @Override
        public CreditQuality.CreditQualityBuilder getOrCreateCreditQuality(int index) {
            if (this.creditQuality == null) {
                this.creditQuality = new ArrayList<CreditQuality.CreditQualityBuilder>();
            }
            return (CreditQuality.CreditQualityBuilder)this.getIndex(this.creditQuality, index, () -> {
                CreditQuality.CreditQualityBuilder newCreditQuality = CreditQuality.builder();
                return newCreditQuality;
            });
        }

        @Override
        @RosettaAttribute(value="creditRating")
        @RuneAttribute(value="creditRating")
        public List<? extends CreditRating.CreditRatingBuilder> getCreditRating() {
            return this.creditRating;
        }

        @Override
        public CreditRating.CreditRatingBuilder getOrCreateCreditRating(int index) {
            if (this.creditRating == null) {
                this.creditRating = new ArrayList<CreditRating.CreditRatingBuilder>();
            }
            return (CreditRating.CreditRatingBuilder)this.getIndex(this.creditRating, index, () -> {
                CreditRating.CreditRatingBuilder newCreditRating = CreditRating.builder();
                return newCreditRating;
            });
        }

        @Override
        @RosettaAttribute(value="couponType")
        @RuneAttribute(value="couponType")
        public CouponType.CouponTypeBuilder getCouponType() {
            return this.couponType;
        }

        @Override
        public CouponType.CouponTypeBuilder getOrCreateCouponType() {
            CouponType.CouponTypeBuilder result = this.couponType != null ? this.couponType : (this.couponType = CouponType.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="couponRate")
        @RuneAttribute(value="couponRate")
        public BigDecimal getCouponRate() {
            return this.couponRate;
        }

        @Override
        @RosettaAttribute(value="maturity")
        @RuneAttribute(value="maturity")
        public ZonedDateTime getMaturity() {
            return this.maturity;
        }

        @Override
        @RosettaAttribute(value="issuerName")
        @RuneAttribute(value="issuerName")
        public FixedIncomeSecurityContentModelBuilder setIssuerName(String _issuerName) {
            this.issuerName = _issuerName == null ? null : _issuerName;
            return this;
        }

        @Override
        @RosettaAttribute(value="issuerPartyReference")
        @RuneAttribute(value="issuerPartyReference")
        public FixedIncomeSecurityContentModelBuilder setIssuerPartyReference(PartyReference _issuerPartyReference) {
            this.issuerPartyReference = _issuerPartyReference == null ? null : _issuerPartyReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="seniority")
        @RuneAttribute(value="seniority")
        public FixedIncomeSecurityContentModelBuilder setSeniority(CreditSeniority _seniority) {
            this.seniority = _seniority == null ? null : _seniority.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="creditQuality")
        @RuneAttribute(value="creditQuality")
        public FixedIncomeSecurityContentModelBuilder addCreditQuality(CreditQuality _creditQuality) {
            if (_creditQuality != null) {
                this.creditQuality.add(_creditQuality.toBuilder());
            }
            return this;
        }

        @Override
        public FixedIncomeSecurityContentModelBuilder addCreditQuality(CreditQuality _creditQuality, int idx) {
            this.getIndex(this.creditQuality, idx, () -> _creditQuality.toBuilder());
            return this;
        }

        @Override
        public FixedIncomeSecurityContentModelBuilder addCreditQuality(List<? extends CreditQuality> creditQualitys) {
            if (creditQualitys != null) {
                for (CreditQuality creditQuality : creditQualitys) {
                    this.creditQuality.add(creditQuality.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="creditQuality")
        public FixedIncomeSecurityContentModelBuilder setCreditQuality(List<? extends CreditQuality> creditQualitys) {
            this.creditQuality = creditQualitys == null ? new ArrayList<CreditQuality.CreditQualityBuilder>() : (List)creditQualitys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="creditRating")
        @RuneAttribute(value="creditRating")
        public FixedIncomeSecurityContentModelBuilder addCreditRating(CreditRating _creditRating) {
            if (_creditRating != null) {
                this.creditRating.add(_creditRating.toBuilder());
            }
            return this;
        }

        @Override
        public FixedIncomeSecurityContentModelBuilder addCreditRating(CreditRating _creditRating, int idx) {
            this.getIndex(this.creditRating, idx, () -> _creditRating.toBuilder());
            return this;
        }

        @Override
        public FixedIncomeSecurityContentModelBuilder addCreditRating(List<? extends CreditRating> creditRatings) {
            if (creditRatings != null) {
                for (CreditRating creditRating : creditRatings) {
                    this.creditRating.add(creditRating.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="creditRating")
        public FixedIncomeSecurityContentModelBuilder setCreditRating(List<? extends CreditRating> creditRatings) {
            this.creditRating = creditRatings == null ? new ArrayList<CreditRating.CreditRatingBuilder>() : (List)creditRatings.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="couponType")
        @RuneAttribute(value="couponType")
        public FixedIncomeSecurityContentModelBuilder setCouponType(CouponType _couponType) {
            this.couponType = _couponType == null ? null : _couponType.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="couponRate")
        @RuneAttribute(value="couponRate")
        public FixedIncomeSecurityContentModelBuilder setCouponRate(BigDecimal _couponRate) {
            this.couponRate = _couponRate == null ? null : _couponRate;
            return this;
        }

        @Override
        @RosettaAttribute(value="maturity")
        @RuneAttribute(value="maturity")
        public FixedIncomeSecurityContentModelBuilder setMaturity(ZonedDateTime _maturity) {
            this.maturity = _maturity == null ? null : _maturity;
            return this;
        }

        @Override
        public FixedIncomeSecurityContentModel build() {
            return new FixedIncomeSecurityContentModelImpl(this);
        }

        @Override
        public FixedIncomeSecurityContentModelBuilder toBuilder() {
            return this;
        }

        @Override
        public FixedIncomeSecurityContentModelBuilder prune() {
            if (this.issuerPartyReference != null && !this.issuerPartyReference.prune().hasData()) {
                this.issuerPartyReference = null;
            }
            if (this.seniority != null && !this.seniority.prune().hasData()) {
                this.seniority = null;
            }
            this.creditQuality = this.creditQuality.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.creditRating = this.creditRating.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.couponType != null && !this.couponType.prune().hasData()) {
                this.couponType = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getIssuerName() != null) {
                return true;
            }
            if (this.getIssuerPartyReference() != null && this.getIssuerPartyReference().hasData()) {
                return true;
            }
            if (this.getSeniority() != null && this.getSeniority().hasData()) {
                return true;
            }
            if (this.getCreditQuality() != null && this.getCreditQuality().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getCreditRating() != null && this.getCreditRating().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getCouponType() != null && this.getCouponType().hasData()) {
                return true;
            }
            if (this.getCouponRate() != null) {
                return true;
            }
            return this.getMaturity() != null;
        }

        public FixedIncomeSecurityContentModelBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            FixedIncomeSecurityContentModelBuilder o = (FixedIncomeSecurityContentModelBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getIssuerPartyReference(), (RosettaModelObjectBuilder)o.getIssuerPartyReference(), this::setIssuerPartyReference);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSeniority(), (RosettaModelObjectBuilder)o.getSeniority(), this::setSeniority);
            merger.mergeRosetta(this.getCreditQuality(), o.getCreditQuality(), this::getOrCreateCreditQuality);
            merger.mergeRosetta(this.getCreditRating(), o.getCreditRating(), this::getOrCreateCreditRating);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCouponType(), (RosettaModelObjectBuilder)o.getCouponType(), this::setCouponType);
            merger.mergeBasic((Object)this.getIssuerName(), (Object)o.getIssuerName(), this::setIssuerName, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCouponRate(), (Object)o.getCouponRate(), this::setCouponRate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getMaturity(), (Object)o.getMaturity(), this::setMaturity, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            FixedIncomeSecurityContentModel _that = this.getType().cast(o);
            if (!Objects.equals(this.issuerName, _that.getIssuerName())) {
                return false;
            }
            if (!Objects.equals(this.issuerPartyReference, _that.getIssuerPartyReference())) {
                return false;
            }
            if (!Objects.equals(this.seniority, _that.getSeniority())) {
                return false;
            }
            if (!ListEquals.listEquals(this.creditQuality, _that.getCreditQuality())) {
                return false;
            }
            if (!ListEquals.listEquals(this.creditRating, _that.getCreditRating())) {
                return false;
            }
            if (!Objects.equals(this.couponType, _that.getCouponType())) {
                return false;
            }
            if (!Objects.equals(this.couponRate, _that.getCouponRate())) {
                return false;
            }
            return Objects.equals(this.maturity, _that.getMaturity());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.issuerName != null ? this.issuerName.hashCode() : 0);
            _result = 31 * _result + (this.issuerPartyReference != null ? this.issuerPartyReference.hashCode() : 0);
            _result = 31 * _result + (this.seniority != null ? this.seniority.hashCode() : 0);
            _result = 31 * _result + (this.creditQuality != null ? this.creditQuality.hashCode() : 0);
            _result = 31 * _result + (this.creditRating != null ? this.creditRating.hashCode() : 0);
            _result = 31 * _result + (this.couponType != null ? this.couponType.hashCode() : 0);
            _result = 31 * _result + (this.couponRate != null ? this.couponRate.hashCode() : 0);
            _result = 31 * _result + (this.maturity != null ? this.maturity.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "FixedIncomeSecurityContentModelBuilder {issuerName=" + this.issuerName + ", issuerPartyReference=" + this.issuerPartyReference + ", seniority=" + this.seniority + ", creditQuality=" + this.creditQuality + ", creditRating=" + this.creditRating + ", couponType=" + this.couponType + ", couponRate=" + this.couponRate + ", maturity=" + this.maturity + '}';
        }
    }

    public static interface FixedIncomeSecurityContentModelBuilder
    extends FixedIncomeSecurityContentModel,
    RosettaModelObjectBuilder {
        public PartyReference.PartyReferenceBuilder getOrCreateIssuerPartyReference();

        @Override
        public PartyReference.PartyReferenceBuilder getIssuerPartyReference();

        public CreditSeniority.CreditSeniorityBuilder getOrCreateSeniority();

        @Override
        public CreditSeniority.CreditSeniorityBuilder getSeniority();

        public CreditQuality.CreditQualityBuilder getOrCreateCreditQuality(int var1);

        public List<? extends CreditQuality.CreditQualityBuilder> getCreditQuality();

        public CreditRating.CreditRatingBuilder getOrCreateCreditRating(int var1);

        public List<? extends CreditRating.CreditRatingBuilder> getCreditRating();

        public CouponType.CouponTypeBuilder getOrCreateCouponType();

        @Override
        public CouponType.CouponTypeBuilder getCouponType();

        public FixedIncomeSecurityContentModelBuilder setIssuerName(String var1);

        public FixedIncomeSecurityContentModelBuilder setIssuerPartyReference(PartyReference var1);

        public FixedIncomeSecurityContentModelBuilder setSeniority(CreditSeniority var1);

        public FixedIncomeSecurityContentModelBuilder addCreditQuality(CreditQuality var1);

        public FixedIncomeSecurityContentModelBuilder addCreditQuality(CreditQuality var1, int var2);

        public FixedIncomeSecurityContentModelBuilder addCreditQuality(List<? extends CreditQuality> var1);

        public FixedIncomeSecurityContentModelBuilder setCreditQuality(List<? extends CreditQuality> var1);

        public FixedIncomeSecurityContentModelBuilder addCreditRating(CreditRating var1);

        public FixedIncomeSecurityContentModelBuilder addCreditRating(CreditRating var1, int var2);

        public FixedIncomeSecurityContentModelBuilder addCreditRating(List<? extends CreditRating> var1);

        public FixedIncomeSecurityContentModelBuilder setCreditRating(List<? extends CreditRating> var1);

        public FixedIncomeSecurityContentModelBuilder setCouponType(CouponType var1);

        public FixedIncomeSecurityContentModelBuilder setCouponRate(BigDecimal var1);

        public FixedIncomeSecurityContentModelBuilder setMaturity(ZonedDateTime var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("issuerName"), String.class, (Object)this.getIssuerName(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("issuerPartyReference"), processor, PartyReference.PartyReferenceBuilder.class, this.getIssuerPartyReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("seniority"), processor, CreditSeniority.CreditSeniorityBuilder.class, this.getSeniority(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("creditQuality"), processor, CreditQuality.CreditQualityBuilder.class, this.getCreditQuality(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("creditRating"), processor, CreditRating.CreditRatingBuilder.class, this.getCreditRating(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("couponType"), processor, CouponType.CouponTypeBuilder.class, this.getCouponType(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("couponRate"), BigDecimal.class, (Object)this.getCouponRate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("maturity"), ZonedDateTime.class, (Object)this.getMaturity(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public FixedIncomeSecurityContentModelBuilder prune();
    }

    public static class FixedIncomeSecurityContentModelImpl
    implements FixedIncomeSecurityContentModel {
        private final String issuerName;
        private final PartyReference issuerPartyReference;
        private final CreditSeniority seniority;
        private final List<? extends CreditQuality> creditQuality;
        private final List<? extends CreditRating> creditRating;
        private final CouponType couponType;
        private final BigDecimal couponRate;
        private final ZonedDateTime maturity;

        protected FixedIncomeSecurityContentModelImpl(FixedIncomeSecurityContentModelBuilder builder) {
            this.issuerName = builder.getIssuerName();
            this.issuerPartyReference = Optional.ofNullable(builder.getIssuerPartyReference()).map(f -> f.build()).orElse(null);
            this.seniority = Optional.ofNullable(builder.getSeniority()).map(f -> f.build()).orElse(null);
            this.creditQuality = Optional.ofNullable(builder.getCreditQuality()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.creditRating = Optional.ofNullable(builder.getCreditRating()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.couponType = Optional.ofNullable(builder.getCouponType()).map(f -> f.build()).orElse(null);
            this.couponRate = builder.getCouponRate();
            this.maturity = builder.getMaturity();
        }

        @Override
        @RosettaAttribute(value="issuerName")
        @RuneAttribute(value="issuerName")
        public String getIssuerName() {
            return this.issuerName;
        }

        @Override
        @RosettaAttribute(value="issuerPartyReference")
        @RuneAttribute(value="issuerPartyReference")
        public PartyReference getIssuerPartyReference() {
            return this.issuerPartyReference;
        }

        @Override
        @RosettaAttribute(value="seniority")
        @RuneAttribute(value="seniority")
        public CreditSeniority getSeniority() {
            return this.seniority;
        }

        @Override
        @RosettaAttribute(value="creditQuality")
        @RuneAttribute(value="creditQuality")
        public List<? extends CreditQuality> getCreditQuality() {
            return this.creditQuality;
        }

        @Override
        @RosettaAttribute(value="creditRating")
        @RuneAttribute(value="creditRating")
        public List<? extends CreditRating> getCreditRating() {
            return this.creditRating;
        }

        @Override
        @RosettaAttribute(value="couponType")
        @RuneAttribute(value="couponType")
        public CouponType getCouponType() {
            return this.couponType;
        }

        @Override
        @RosettaAttribute(value="couponRate")
        @RuneAttribute(value="couponRate")
        public BigDecimal getCouponRate() {
            return this.couponRate;
        }

        @Override
        @RosettaAttribute(value="maturity")
        @RuneAttribute(value="maturity")
        public ZonedDateTime getMaturity() {
            return this.maturity;
        }

        @Override
        public FixedIncomeSecurityContentModel build() {
            return this;
        }

        @Override
        public FixedIncomeSecurityContentModelBuilder toBuilder() {
            FixedIncomeSecurityContentModelBuilder builder = FixedIncomeSecurityContentModel.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(FixedIncomeSecurityContentModelBuilder builder) {
            Optional.ofNullable(this.getIssuerName()).ifPresent(builder::setIssuerName);
            Optional.ofNullable(this.getIssuerPartyReference()).ifPresent(builder::setIssuerPartyReference);
            Optional.ofNullable(this.getSeniority()).ifPresent(builder::setSeniority);
            Optional.ofNullable(this.getCreditQuality()).ifPresent(builder::setCreditQuality);
            Optional.ofNullable(this.getCreditRating()).ifPresent(builder::setCreditRating);
            Optional.ofNullable(this.getCouponType()).ifPresent(builder::setCouponType);
            Optional.ofNullable(this.getCouponRate()).ifPresent(builder::setCouponRate);
            Optional.ofNullable(this.getMaturity()).ifPresent(builder::setMaturity);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            FixedIncomeSecurityContentModel _that = this.getType().cast(o);
            if (!Objects.equals(this.issuerName, _that.getIssuerName())) {
                return false;
            }
            if (!Objects.equals(this.issuerPartyReference, _that.getIssuerPartyReference())) {
                return false;
            }
            if (!Objects.equals(this.seniority, _that.getSeniority())) {
                return false;
            }
            if (!ListEquals.listEquals(this.creditQuality, _that.getCreditQuality())) {
                return false;
            }
            if (!ListEquals.listEquals(this.creditRating, _that.getCreditRating())) {
                return false;
            }
            if (!Objects.equals(this.couponType, _that.getCouponType())) {
                return false;
            }
            if (!Objects.equals(this.couponRate, _that.getCouponRate())) {
                return false;
            }
            return Objects.equals(this.maturity, _that.getMaturity());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.issuerName != null ? this.issuerName.hashCode() : 0);
            _result = 31 * _result + (this.issuerPartyReference != null ? this.issuerPartyReference.hashCode() : 0);
            _result = 31 * _result + (this.seniority != null ? this.seniority.hashCode() : 0);
            _result = 31 * _result + (this.creditQuality != null ? this.creditQuality.hashCode() : 0);
            _result = 31 * _result + (this.creditRating != null ? this.creditRating.hashCode() : 0);
            _result = 31 * _result + (this.couponType != null ? this.couponType.hashCode() : 0);
            _result = 31 * _result + (this.couponRate != null ? this.couponRate.hashCode() : 0);
            _result = 31 * _result + (this.maturity != null ? this.maturity.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "FixedIncomeSecurityContentModel {issuerName=" + this.issuerName + ", issuerPartyReference=" + this.issuerPartyReference + ", seniority=" + this.seniority + ", creditQuality=" + this.creditQuality + ", creditRating=" + this.creditRating + ", couponType=" + this.couponType + ", couponRate=" + this.couponRate + ", maturity=" + this.maturity + '}';
        }
    }
}

