/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.asset;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.asset.meta.ActualPriceMeta;
import fpml.consolidated.fpmlenum.PriceExpressionEnum;
import fpml.consolidated.shared.Currency;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="ActualPrice", builder=ActualPriceBuilderImpl.class, version="1.1.0")
@RuneDataType(value="ActualPrice", model="fpml", builder=ActualPriceBuilderImpl.class, version="1.1.0")
public interface ActualPrice
extends RosettaModelObject {
    public static final ActualPriceMeta metaData = new ActualPriceMeta();

    public Currency getCurrency();

    public BigDecimal getAmount();

    public PriceExpressionEnum getPriceExpression();

    public String getId();

    public ActualPrice build();

    public ActualPriceBuilder toBuilder();

    public static ActualPriceBuilder builder() {
        return new ActualPriceBuilderImpl();
    }

    default public RosettaMetaData<? extends ActualPrice> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends ActualPrice> getType() {
        return ActualPrice.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("currency"), processor, Currency.class, this.getCurrency(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("amount"), BigDecimal.class, (Object)this.getAmount(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("priceExpression"), PriceExpressionEnum.class, (Object)this.getPriceExpression(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class ActualPriceBuilderImpl
    implements ActualPriceBuilder {
        protected Currency.CurrencyBuilder currency;
        protected BigDecimal amount;
        protected PriceExpressionEnum priceExpression;
        protected String id;

        @Override
        @RosettaAttribute(value="currency")
        @RuneAttribute(value="currency")
        public Currency.CurrencyBuilder getCurrency() {
            return this.currency;
        }

        @Override
        public Currency.CurrencyBuilder getOrCreateCurrency() {
            Currency.CurrencyBuilder result = this.currency != null ? this.currency : (this.currency = Currency.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="amount")
        @RuneAttribute(value="amount")
        public BigDecimal getAmount() {
            return this.amount;
        }

        @Override
        @RosettaAttribute(value="priceExpression")
        @RuneAttribute(value="priceExpression")
        public PriceExpressionEnum getPriceExpression() {
            return this.priceExpression;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public String getId() {
            return this.id;
        }

        @Override
        @RosettaAttribute(value="currency")
        @RuneAttribute(value="currency")
        public ActualPriceBuilder setCurrency(Currency _currency) {
            this.currency = _currency == null ? null : _currency.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="amount")
        @RuneAttribute(value="amount")
        public ActualPriceBuilder setAmount(BigDecimal _amount) {
            this.amount = _amount == null ? null : _amount;
            return this;
        }

        @Override
        @RosettaAttribute(value="priceExpression")
        @RuneAttribute(value="priceExpression")
        public ActualPriceBuilder setPriceExpression(PriceExpressionEnum _priceExpression) {
            this.priceExpression = _priceExpression == null ? null : _priceExpression;
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public ActualPriceBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        public ActualPrice build() {
            return new ActualPriceImpl(this);
        }

        @Override
        public ActualPriceBuilder toBuilder() {
            return this;
        }

        @Override
        public ActualPriceBuilder prune() {
            if (this.currency != null && !this.currency.prune().hasData()) {
                this.currency = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getCurrency() != null && this.getCurrency().hasData()) {
                return true;
            }
            if (this.getAmount() != null) {
                return true;
            }
            if (this.getPriceExpression() != null) {
                return true;
            }
            return this.getId() != null;
        }

        public ActualPriceBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            ActualPriceBuilder o = (ActualPriceBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCurrency(), (RosettaModelObjectBuilder)o.getCurrency(), this::setCurrency);
            merger.mergeBasic((Object)this.getAmount(), (Object)o.getAmount(), this::setAmount, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPriceExpression(), (Object)o.getPriceExpression(), this::setPriceExpression, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getId(), (Object)o.getId(), this::setId, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ActualPrice _that = this.getType().cast(o);
            if (!Objects.equals(this.currency, _that.getCurrency())) {
                return false;
            }
            if (!Objects.equals(this.amount, _that.getAmount())) {
                return false;
            }
            if (!Objects.equals((Object)this.priceExpression, (Object)_that.getPriceExpression())) {
                return false;
            }
            return Objects.equals(this.id, _that.getId());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.currency != null ? this.currency.hashCode() : 0);
            _result = 31 * _result + (this.amount != null ? this.amount.hashCode() : 0);
            _result = 31 * _result + (this.priceExpression != null ? ((Object)((Object)this.priceExpression)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.id != null ? this.id.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ActualPriceBuilder {currency=" + this.currency + ", amount=" + this.amount + ", priceExpression=" + (Object)((Object)this.priceExpression) + ", id=" + this.id + '}';
        }
    }

    public static interface ActualPriceBuilder
    extends ActualPrice,
    RosettaModelObjectBuilder {
        public Currency.CurrencyBuilder getOrCreateCurrency();

        @Override
        public Currency.CurrencyBuilder getCurrency();

        public ActualPriceBuilder setCurrency(Currency var1);

        public ActualPriceBuilder setAmount(BigDecimal var1);

        public ActualPriceBuilder setPriceExpression(PriceExpressionEnum var1);

        public ActualPriceBuilder setId(String var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("currency"), processor, Currency.CurrencyBuilder.class, this.getCurrency(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("amount"), BigDecimal.class, (Object)this.getAmount(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("priceExpression"), PriceExpressionEnum.class, (Object)this.getPriceExpression(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public ActualPriceBuilder prune();
    }

    public static class ActualPriceImpl
    implements ActualPrice {
        private final Currency currency;
        private final BigDecimal amount;
        private final PriceExpressionEnum priceExpression;
        private final String id;

        protected ActualPriceImpl(ActualPriceBuilder builder) {
            this.currency = Optional.ofNullable(builder.getCurrency()).map(f -> f.build()).orElse(null);
            this.amount = builder.getAmount();
            this.priceExpression = builder.getPriceExpression();
            this.id = builder.getId();
        }

        @Override
        @RosettaAttribute(value="currency")
        @RuneAttribute(value="currency")
        public Currency getCurrency() {
            return this.currency;
        }

        @Override
        @RosettaAttribute(value="amount")
        @RuneAttribute(value="amount")
        public BigDecimal getAmount() {
            return this.amount;
        }

        @Override
        @RosettaAttribute(value="priceExpression")
        @RuneAttribute(value="priceExpression")
        public PriceExpressionEnum getPriceExpression() {
            return this.priceExpression;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public String getId() {
            return this.id;
        }

        @Override
        public ActualPrice build() {
            return this;
        }

        @Override
        public ActualPriceBuilder toBuilder() {
            ActualPriceBuilder builder = ActualPrice.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ActualPriceBuilder builder) {
            Optional.ofNullable(this.getCurrency()).ifPresent(builder::setCurrency);
            Optional.ofNullable(this.getAmount()).ifPresent(builder::setAmount);
            Optional.ofNullable(this.getPriceExpression()).ifPresent(builder::setPriceExpression);
            Optional.ofNullable(this.getId()).ifPresent(builder::setId);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ActualPrice _that = this.getType().cast(o);
            if (!Objects.equals(this.currency, _that.getCurrency())) {
                return false;
            }
            if (!Objects.equals(this.amount, _that.getAmount())) {
                return false;
            }
            if (!Objects.equals((Object)this.priceExpression, (Object)_that.getPriceExpression())) {
                return false;
            }
            return Objects.equals(this.id, _that.getId());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.currency != null ? this.currency.hashCode() : 0);
            _result = 31 * _result + (this.amount != null ? this.amount.hashCode() : 0);
            _result = 31 * _result + (this.priceExpression != null ? ((Object)((Object)this.priceExpression)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.id != null ? this.id.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ActualPrice {currency=" + this.currency + ", amount=" + this.amount + ", priceExpression=" + (Object)((Object)this.priceExpression) + ", id=" + this.id + '}';
        }
    }
}

