/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.meta.PGPDataTypeSequence1Meta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="PGPDataTypeSequence1", builder=PGPDataTypeSequence1BuilderImpl.class, version="1.1.0")
@RuneDataType(value="PGPDataTypeSequence1", model="fpml", builder=PGPDataTypeSequence1BuilderImpl.class, version="1.1.0")
public interface PGPDataTypeSequence1
extends RosettaModelObject {
    public static final PGPDataTypeSequence1Meta metaData = new PGPDataTypeSequence1Meta();

    public String getPgpKeyPacket();

    public List<String> getAnyContents();

    public PGPDataTypeSequence1 build();

    public PGPDataTypeSequence1Builder toBuilder();

    public static PGPDataTypeSequence1Builder builder() {
        return new PGPDataTypeSequence1BuilderImpl();
    }

    default public RosettaMetaData<? extends PGPDataTypeSequence1> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends PGPDataTypeSequence1> getType() {
        return PGPDataTypeSequence1.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("pgpKeyPacket"), String.class, (Object)this.getPgpKeyPacket(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("anyContents"), String.class, this.getAnyContents(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class PGPDataTypeSequence1BuilderImpl
    implements PGPDataTypeSequence1Builder {
        protected String pgpKeyPacket;
        protected List<String> anyContents = new ArrayList<String>();

        @Override
        @RosettaAttribute(value="pgpKeyPacket", isRequired=true)
        @RuneAttribute(value="pgpKeyPacket", isRequired=true)
        public String getPgpKeyPacket() {
            return this.pgpKeyPacket;
        }

        @Override
        @RosettaAttribute(value="anyContents")
        @RuneAttribute(value="anyContents")
        public List<String> getAnyContents() {
            return this.anyContents;
        }

        @Override
        @RosettaAttribute(value="pgpKeyPacket", isRequired=true)
        @RuneAttribute(value="pgpKeyPacket", isRequired=true)
        public PGPDataTypeSequence1Builder setPgpKeyPacket(String _pgpKeyPacket) {
            this.pgpKeyPacket = _pgpKeyPacket == null ? null : _pgpKeyPacket;
            return this;
        }

        @Override
        @RosettaAttribute(value="anyContents")
        @RuneAttribute(value="anyContents")
        public PGPDataTypeSequence1Builder addAnyContents(String _anyContents) {
            if (_anyContents != null) {
                this.anyContents.add(_anyContents);
            }
            return this;
        }

        @Override
        public PGPDataTypeSequence1Builder addAnyContents(String _anyContents, int idx) {
            this.getIndex(this.anyContents, idx, () -> _anyContents);
            return this;
        }

        @Override
        public PGPDataTypeSequence1Builder addAnyContents(List<String> anyContentss) {
            if (anyContentss != null) {
                for (String toAdd : anyContentss) {
                    this.anyContents.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="anyContents")
        public PGPDataTypeSequence1Builder setAnyContents(List<String> anyContentss) {
            this.anyContents = anyContentss == null ? new ArrayList<String>() : (List)anyContentss.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public PGPDataTypeSequence1 build() {
            return new PGPDataTypeSequence1Impl(this);
        }

        @Override
        public PGPDataTypeSequence1Builder toBuilder() {
            return this;
        }

        @Override
        public PGPDataTypeSequence1Builder prune() {
            return this;
        }

        public boolean hasData() {
            if (this.getPgpKeyPacket() != null) {
                return true;
            }
            return this.getAnyContents() != null && !this.getAnyContents().isEmpty();
        }

        public PGPDataTypeSequence1Builder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            PGPDataTypeSequence1Builder o = (PGPDataTypeSequence1Builder)other;
            merger.mergeBasic((Object)this.getPgpKeyPacket(), (Object)o.getPgpKeyPacket(), this::setPgpKeyPacket, new AttributeMeta[0]);
            merger.mergeBasic(this.getAnyContents(), o.getAnyContents(), this::addAnyContents);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PGPDataTypeSequence1 _that = this.getType().cast(o);
            if (!Objects.equals(this.pgpKeyPacket, _that.getPgpKeyPacket())) {
                return false;
            }
            return ListEquals.listEquals(this.anyContents, _that.getAnyContents());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.pgpKeyPacket != null ? this.pgpKeyPacket.hashCode() : 0);
            _result = 31 * _result + (this.anyContents != null ? this.anyContents.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PGPDataTypeSequence1Builder {pgpKeyPacket=" + this.pgpKeyPacket + ", anyContents=" + this.anyContents + '}';
        }
    }

    public static interface PGPDataTypeSequence1Builder
    extends PGPDataTypeSequence1,
    RosettaModelObjectBuilder {
        public PGPDataTypeSequence1Builder setPgpKeyPacket(String var1);

        public PGPDataTypeSequence1Builder addAnyContents(String var1);

        public PGPDataTypeSequence1Builder addAnyContents(String var1, int var2);

        public PGPDataTypeSequence1Builder addAnyContents(List<String> var1);

        public PGPDataTypeSequence1Builder setAnyContents(List<String> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("pgpKeyPacket"), String.class, (Object)this.getPgpKeyPacket(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("anyContents"), String.class, this.getAnyContents(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public PGPDataTypeSequence1Builder prune();
    }

    public static class PGPDataTypeSequence1Impl
    implements PGPDataTypeSequence1 {
        private final String pgpKeyPacket;
        private final List<String> anyContents;

        protected PGPDataTypeSequence1Impl(PGPDataTypeSequence1Builder builder) {
            this.pgpKeyPacket = builder.getPgpKeyPacket();
            this.anyContents = Optional.ofNullable(builder.getAnyContents()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
        }

        @Override
        @RosettaAttribute(value="pgpKeyPacket", isRequired=true)
        @RuneAttribute(value="pgpKeyPacket", isRequired=true)
        public String getPgpKeyPacket() {
            return this.pgpKeyPacket;
        }

        @Override
        @RosettaAttribute(value="anyContents")
        @RuneAttribute(value="anyContents")
        public List<String> getAnyContents() {
            return this.anyContents;
        }

        @Override
        public PGPDataTypeSequence1 build() {
            return this;
        }

        @Override
        public PGPDataTypeSequence1Builder toBuilder() {
            PGPDataTypeSequence1Builder builder = PGPDataTypeSequence1.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(PGPDataTypeSequence1Builder builder) {
            Optional.ofNullable(this.getPgpKeyPacket()).ifPresent(builder::setPgpKeyPacket);
            Optional.ofNullable(this.getAnyContents()).ifPresent(builder::setAnyContents);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PGPDataTypeSequence1 _that = this.getType().cast(o);
            if (!Objects.equals(this.pgpKeyPacket, _that.getPgpKeyPacket())) {
                return false;
            }
            return ListEquals.listEquals(this.anyContents, _that.getAnyContents());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.pgpKeyPacket != null ? this.pgpKeyPacket.hashCode() : 0);
            _result = 31 * _result + (this.anyContents != null ? this.anyContents.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PGPDataTypeSequence1 {pgpKeyPacket=" + this.pgpKeyPacket + ", anyContents=" + this.anyContents + '}';
        }
    }
}

