/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template.validation.datarule;

import cdm.product.asset.ReturnTypeEnum;
import cdm.product.template.EconomicTerms;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="EconomicTermsReturnType_Total_Requires_Dividends")
@ImplementedBy(value=Default.class)
public interface EconomicTermsReturnType_Total_Requires_Dividends
extends Validator<EconomicTerms> {
    public static final String NAME = "EconomicTermsReturnType_Total_Requires_Dividends";
    public static final String DEFINITION = "if payout -> PerformancePayout -> returnTerms -> priceReturnTerms -> returnType all = ReturnTypeEnum -> Total then payout -> PerformancePayout -> returnTerms -> dividendReturnTerms exists";

    public static class NoOp
    implements EconomicTermsReturnType_Total_Requires_Dividends {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, EconomicTerms economicTerms) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements EconomicTermsReturnType_Total_Requires_Dividends {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, EconomicTerms economicTerms) {
            ComparisonResult result = this.executeDataRule(economicTerms);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)EconomicTermsReturnType_Total_Requires_Dividends.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"EconomicTerms", (RosettaPath)path, (String)EconomicTermsReturnType_Total_Requires_Dividends.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)EconomicTermsReturnType_Total_Requires_Dividends.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"EconomicTerms", (RosettaPath)path, (String)EconomicTermsReturnType_Total_Requires_Dividends.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(EconomicTerms economicTerms) {
            try {
                if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)economicTerms).mapC("getPayout", _economicTerms -> _economicTerms.getPayout()).map("getPerformancePayout", payout -> payout.getPerformancePayout()).map("getReturnTerms", performancePayout -> performancePayout.getReturnTerms()).map("getPriceReturnTerms", returnTerms -> returnTerms.getPriceReturnTerms()).map("getReturnType", priceReturnTerms -> priceReturnTerms.getReturnType()), (Mapper)MapperS.of((Object)((Object)ReturnTypeEnum.TOTAL)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperators.exists((Mapper)MapperS.of((Object)economicTerms).mapC("getPayout", _economicTerms -> _economicTerms.getPayout()).map("getPerformancePayout", payout -> payout.getPerformancePayout()).map("getReturnTerms", performancePayout -> performancePayout.getReturnTerms()).map("getDividendReturnTerms", returnTerms -> returnTerms.getDividendReturnTerms()));
                }
                return ComparisonResult.successEmptyOperand((String)"");
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

