/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template;

import cdm.base.staticdata.asset.common.Asset;
import cdm.base.staticdata.asset.common.Cash;
import cdm.base.staticdata.asset.common.Commodity;
import cdm.base.staticdata.asset.common.DigitalAsset;
import cdm.base.staticdata.asset.common.Instrument;
import cdm.product.template.EconomicTerms;
import cdm.product.template.meta.TransferableProductMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="TransferableProduct", builder=TransferableProductBuilderImpl.class, version="7.0.0-dev.52")
@RuneDataType(value="TransferableProduct", model="cdm", builder=TransferableProductBuilderImpl.class, version="7.0.0-dev.52")
public interface TransferableProduct
extends Asset {
    public static final TransferableProductMeta metaData = new TransferableProductMeta();

    public EconomicTerms getEconomicTerms();

    @Override
    public TransferableProduct build();

    @Override
    public TransferableProductBuilder toBuilder();

    public static TransferableProductBuilder builder() {
        return new TransferableProductBuilderImpl();
    }

    default public RosettaMetaData<? extends TransferableProduct> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends TransferableProduct> getType() {
        return TransferableProduct.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("Cash"), processor, Cash.class, this.getCash(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("Commodity"), processor, Commodity.class, this.getCommodity(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("DigitalAsset"), processor, DigitalAsset.class, this.getDigitalAsset(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("Instrument"), processor, Instrument.class, this.getInstrument(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("economicTerms"), processor, EconomicTerms.class, this.getEconomicTerms(), new AttributeMeta[0]);
    }

    public static class TransferableProductBuilderImpl
    extends Asset.AssetBuilderImpl
    implements TransferableProductBuilder {
        protected EconomicTerms.EconomicTermsBuilder economicTerms;

        @Override
        @RosettaAttribute(value="economicTerms", isRequired=true)
        @RuneAttribute(value="economicTerms", isRequired=true)
        public EconomicTerms.EconomicTermsBuilder getEconomicTerms() {
            return this.economicTerms;
        }

        @Override
        public EconomicTerms.EconomicTermsBuilder getOrCreateEconomicTerms() {
            EconomicTerms.EconomicTermsBuilder result = this.economicTerms != null ? this.economicTerms : (this.economicTerms = EconomicTerms.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="Cash")
        @RuneAttribute(value="Cash")
        public TransferableProductBuilder setCash(Cash _cash) {
            this.cash = _cash == null ? null : _cash.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="Commodity")
        @RuneAttribute(value="Commodity")
        public TransferableProductBuilder setCommodity(Commodity _commodity) {
            this.commodity = _commodity == null ? null : _commodity.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="DigitalAsset")
        @RuneAttribute(value="DigitalAsset")
        public TransferableProductBuilder setDigitalAsset(DigitalAsset _digitalAsset) {
            this.digitalAsset = _digitalAsset == null ? null : _digitalAsset.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="Instrument")
        @RuneAttribute(value="Instrument")
        public TransferableProductBuilder setInstrument(Instrument _instrument) {
            this.instrument = _instrument == null ? null : _instrument.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="economicTerms", isRequired=true)
        @RuneAttribute(value="economicTerms", isRequired=true)
        public TransferableProductBuilder setEconomicTerms(EconomicTerms _economicTerms) {
            this.economicTerms = _economicTerms == null ? null : _economicTerms.toBuilder();
            return this;
        }

        @Override
        public TransferableProduct build() {
            return new TransferableProductImpl(this);
        }

        @Override
        public TransferableProductBuilder toBuilder() {
            return this;
        }

        @Override
        public TransferableProductBuilder prune() {
            super.prune();
            if (this.economicTerms != null && !this.economicTerms.prune().hasData()) {
                this.economicTerms = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            return this.getEconomicTerms() != null && this.getEconomicTerms().hasData();
        }

        @Override
        public TransferableProductBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            TransferableProductBuilder o = (TransferableProductBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getEconomicTerms(), (RosettaModelObjectBuilder)o.getEconomicTerms(), this::setEconomicTerms);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            TransferableProduct _that = (TransferableProduct)this.getType().cast(o);
            return Objects.equals(this.economicTerms, _that.getEconomicTerms());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.economicTerms != null ? this.economicTerms.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "TransferableProductBuilder {economicTerms=" + this.economicTerms + '}' + " " + super.toString();
        }
    }

    public static interface TransferableProductBuilder
    extends TransferableProduct,
    Asset.AssetBuilder {
        public EconomicTerms.EconomicTermsBuilder getOrCreateEconomicTerms();

        @Override
        public EconomicTerms.EconomicTermsBuilder getEconomicTerms();

        @Override
        public TransferableProductBuilder setCash(Cash var1);

        @Override
        public TransferableProductBuilder setCommodity(Commodity var1);

        @Override
        public TransferableProductBuilder setDigitalAsset(DigitalAsset var1);

        @Override
        public TransferableProductBuilder setInstrument(Instrument var1);

        public TransferableProductBuilder setEconomicTerms(EconomicTerms var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("Cash"), processor, Cash.CashBuilder.class, (RosettaModelObjectBuilder)this.getCash(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("Commodity"), processor, Commodity.CommodityBuilder.class, (RosettaModelObjectBuilder)this.getCommodity(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("DigitalAsset"), processor, DigitalAsset.DigitalAssetBuilder.class, (RosettaModelObjectBuilder)this.getDigitalAsset(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("Instrument"), processor, Instrument.InstrumentBuilder.class, (RosettaModelObjectBuilder)this.getInstrument(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("economicTerms"), processor, EconomicTerms.EconomicTermsBuilder.class, this.getEconomicTerms(), new AttributeMeta[0]);
        }

        @Override
        public TransferableProductBuilder prune();
    }

    public static class TransferableProductImpl
    extends Asset.AssetImpl
    implements TransferableProduct {
        private final EconomicTerms economicTerms;

        protected TransferableProductImpl(TransferableProductBuilder builder) {
            super(builder);
            this.economicTerms = Optional.ofNullable(builder.getEconomicTerms()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="economicTerms", isRequired=true)
        @RuneAttribute(value="economicTerms", isRequired=true)
        public EconomicTerms getEconomicTerms() {
            return this.economicTerms;
        }

        @Override
        public TransferableProduct build() {
            return this;
        }

        @Override
        public TransferableProductBuilder toBuilder() {
            TransferableProductBuilder builder = TransferableProduct.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(TransferableProductBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getEconomicTerms()).ifPresent(builder::setEconomicTerms);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            TransferableProduct _that = (TransferableProduct)this.getType().cast(o);
            return Objects.equals(this.economicTerms, _that.getEconomicTerms());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.economicTerms != null ? this.economicTerms.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "TransferableProduct {economicTerms=" + this.economicTerms + '}' + " " + super.toString();
        }
    }
}

