/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template;

import cdm.base.staticdata.party.BuyerSeller;
import cdm.base.staticdata.party.PayerReceiver;
import cdm.product.asset.AssetDeliveryInformation;
import cdm.product.common.schedule.ObservationTerms;
import cdm.product.common.settlement.PayoutBase;
import cdm.product.common.settlement.PrincipalPayments;
import cdm.product.common.settlement.ResolvablePriceQuantity;
import cdm.product.common.settlement.SettlementTerms;
import cdm.product.template.CalculationSchedule;
import cdm.product.template.ExerciseTerms;
import cdm.product.template.OptionFeature;
import cdm.product.template.OptionStrike;
import cdm.product.template.OptionTypeEnum;
import cdm.product.template.Underlier;
import cdm.product.template.meta.OptionPayoutMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="OptionPayout", builder=OptionPayoutBuilderImpl.class, version="7.0.0-dev.52")
@RuneDataType(value="OptionPayout", model="cdm", builder=OptionPayoutBuilderImpl.class, version="7.0.0-dev.52")
public interface OptionPayout
extends PayoutBase {
    public static final OptionPayoutMeta metaData = new OptionPayoutMeta();

    public BuyerSeller getBuyerSeller();

    public OptionFeature getFeature();

    public ObservationTerms getObservationTerms();

    public CalculationSchedule getSchedule();

    public AssetDeliveryInformation getDelivery();

    public Underlier getUnderlier();

    public OptionTypeEnum getOptionType();

    public ExerciseTerms getExerciseTerms();

    public OptionStrike getStrike();

    @Override
    public OptionPayout build();

    @Override
    public OptionPayoutBuilder toBuilder();

    public static OptionPayoutBuilder builder() {
        return new OptionPayoutBuilderImpl();
    }

    default public RosettaMetaData<? extends OptionPayout> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends OptionPayout> getType() {
        return OptionPayout.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("payerReceiver"), processor, PayerReceiver.class, this.getPayerReceiver(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("priceQuantity"), processor, ResolvablePriceQuantity.class, this.getPriceQuantity(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("principalPayment"), processor, PrincipalPayments.class, this.getPrincipalPayment(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("settlementTerms"), processor, SettlementTerms.class, this.getSettlementTerms(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("buyerSeller"), processor, BuyerSeller.class, this.getBuyerSeller(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("feature"), processor, OptionFeature.class, this.getFeature(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("observationTerms"), processor, ObservationTerms.class, this.getObservationTerms(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("schedule"), processor, CalculationSchedule.class, this.getSchedule(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("delivery"), processor, AssetDeliveryInformation.class, this.getDelivery(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("underlier"), processor, Underlier.class, this.getUnderlier(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("optionType"), OptionTypeEnum.class, (Object)this.getOptionType(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("exerciseTerms"), processor, ExerciseTerms.class, this.getExerciseTerms(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("strike"), processor, OptionStrike.class, this.getStrike(), new AttributeMeta[0]);
    }

    public static class OptionPayoutBuilderImpl
    extends PayoutBase.PayoutBaseBuilderImpl
    implements OptionPayoutBuilder {
        protected BuyerSeller.BuyerSellerBuilder buyerSeller;
        protected OptionFeature.OptionFeatureBuilder feature;
        protected ObservationTerms.ObservationTermsBuilder observationTerms;
        protected CalculationSchedule.CalculationScheduleBuilder schedule;
        protected AssetDeliveryInformation.AssetDeliveryInformationBuilder delivery;
        protected Underlier.UnderlierBuilder underlier;
        protected OptionTypeEnum optionType;
        protected ExerciseTerms.ExerciseTermsBuilder exerciseTerms;
        protected OptionStrike.OptionStrikeBuilder strike;

        @Override
        @RosettaAttribute(value="buyerSeller", isRequired=true)
        @RuneAttribute(value="buyerSeller", isRequired=true)
        public BuyerSeller.BuyerSellerBuilder getBuyerSeller() {
            return this.buyerSeller;
        }

        @Override
        public BuyerSeller.BuyerSellerBuilder getOrCreateBuyerSeller() {
            BuyerSeller.BuyerSellerBuilder result = this.buyerSeller != null ? this.buyerSeller : (this.buyerSeller = BuyerSeller.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="feature")
        @RuneAttribute(value="feature")
        public OptionFeature.OptionFeatureBuilder getFeature() {
            return this.feature;
        }

        @Override
        public OptionFeature.OptionFeatureBuilder getOrCreateFeature() {
            OptionFeature.OptionFeatureBuilder result = this.feature != null ? this.feature : (this.feature = OptionFeature.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="observationTerms")
        @RuneAttribute(value="observationTerms")
        public ObservationTerms.ObservationTermsBuilder getObservationTerms() {
            return this.observationTerms;
        }

        @Override
        public ObservationTerms.ObservationTermsBuilder getOrCreateObservationTerms() {
            ObservationTerms.ObservationTermsBuilder result = this.observationTerms != null ? this.observationTerms : (this.observationTerms = ObservationTerms.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="schedule")
        @RuneAttribute(value="schedule")
        public CalculationSchedule.CalculationScheduleBuilder getSchedule() {
            return this.schedule;
        }

        @Override
        public CalculationSchedule.CalculationScheduleBuilder getOrCreateSchedule() {
            CalculationSchedule.CalculationScheduleBuilder result = this.schedule != null ? this.schedule : (this.schedule = CalculationSchedule.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="delivery")
        @RuneAttribute(value="delivery")
        public AssetDeliveryInformation.AssetDeliveryInformationBuilder getDelivery() {
            return this.delivery;
        }

        @Override
        public AssetDeliveryInformation.AssetDeliveryInformationBuilder getOrCreateDelivery() {
            AssetDeliveryInformation.AssetDeliveryInformationBuilder result = this.delivery != null ? this.delivery : (this.delivery = AssetDeliveryInformation.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="underlier", isRequired=true)
        @RuneAttribute(value="underlier", isRequired=true)
        public Underlier.UnderlierBuilder getUnderlier() {
            return this.underlier;
        }

        @Override
        public Underlier.UnderlierBuilder getOrCreateUnderlier() {
            Underlier.UnderlierBuilder result = this.underlier != null ? this.underlier : (this.underlier = Underlier.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="optionType")
        @RuneAttribute(value="optionType")
        public OptionTypeEnum getOptionType() {
            return this.optionType;
        }

        @Override
        @RosettaAttribute(value="exerciseTerms", isRequired=true)
        @RuneAttribute(value="exerciseTerms", isRequired=true)
        public ExerciseTerms.ExerciseTermsBuilder getExerciseTerms() {
            return this.exerciseTerms;
        }

        @Override
        public ExerciseTerms.ExerciseTermsBuilder getOrCreateExerciseTerms() {
            ExerciseTerms.ExerciseTermsBuilder result = this.exerciseTerms != null ? this.exerciseTerms : (this.exerciseTerms = ExerciseTerms.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="strike")
        @RuneAttribute(value="strike")
        public OptionStrike.OptionStrikeBuilder getStrike() {
            return this.strike;
        }

        @Override
        public OptionStrike.OptionStrikeBuilder getOrCreateStrike() {
            OptionStrike.OptionStrikeBuilder result = this.strike != null ? this.strike : (this.strike = OptionStrike.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="payerReceiver", isRequired=true)
        @RuneAttribute(value="payerReceiver", isRequired=true)
        public OptionPayoutBuilder setPayerReceiver(PayerReceiver _payerReceiver) {
            this.payerReceiver = _payerReceiver == null ? null : _payerReceiver.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="priceQuantity")
        @RuneAttribute(value="priceQuantity")
        public OptionPayoutBuilder setPriceQuantity(ResolvablePriceQuantity _priceQuantity) {
            this.priceQuantity = _priceQuantity == null ? null : _priceQuantity.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="principalPayment")
        @RuneAttribute(value="principalPayment")
        public OptionPayoutBuilder setPrincipalPayment(PrincipalPayments _principalPayment) {
            this.principalPayment = _principalPayment == null ? null : _principalPayment.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="settlementTerms")
        @RuneAttribute(value="settlementTerms")
        public OptionPayoutBuilder setSettlementTerms(SettlementTerms _settlementTerms) {
            this.settlementTerms = _settlementTerms == null ? null : _settlementTerms.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="buyerSeller", isRequired=true)
        @RuneAttribute(value="buyerSeller", isRequired=true)
        public OptionPayoutBuilder setBuyerSeller(BuyerSeller _buyerSeller) {
            this.buyerSeller = _buyerSeller == null ? null : _buyerSeller.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="feature")
        @RuneAttribute(value="feature")
        public OptionPayoutBuilder setFeature(OptionFeature _feature) {
            this.feature = _feature == null ? null : _feature.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="observationTerms")
        @RuneAttribute(value="observationTerms")
        public OptionPayoutBuilder setObservationTerms(ObservationTerms _observationTerms) {
            this.observationTerms = _observationTerms == null ? null : _observationTerms.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="schedule")
        @RuneAttribute(value="schedule")
        public OptionPayoutBuilder setSchedule(CalculationSchedule _schedule) {
            this.schedule = _schedule == null ? null : _schedule.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="delivery")
        @RuneAttribute(value="delivery")
        public OptionPayoutBuilder setDelivery(AssetDeliveryInformation _delivery) {
            this.delivery = _delivery == null ? null : _delivery.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="underlier", isRequired=true)
        @RuneAttribute(value="underlier", isRequired=true)
        public OptionPayoutBuilder setUnderlier(Underlier _underlier) {
            this.underlier = _underlier == null ? null : _underlier.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="optionType")
        @RuneAttribute(value="optionType")
        public OptionPayoutBuilder setOptionType(OptionTypeEnum _optionType) {
            this.optionType = _optionType == null ? null : _optionType;
            return this;
        }

        @Override
        @RosettaAttribute(value="exerciseTerms", isRequired=true)
        @RuneAttribute(value="exerciseTerms", isRequired=true)
        public OptionPayoutBuilder setExerciseTerms(ExerciseTerms _exerciseTerms) {
            this.exerciseTerms = _exerciseTerms == null ? null : _exerciseTerms.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="strike")
        @RuneAttribute(value="strike")
        public OptionPayoutBuilder setStrike(OptionStrike _strike) {
            this.strike = _strike == null ? null : _strike.toBuilder();
            return this;
        }

        @Override
        public OptionPayout build() {
            return new OptionPayoutImpl(this);
        }

        @Override
        public OptionPayoutBuilder toBuilder() {
            return this;
        }

        @Override
        public OptionPayoutBuilder prune() {
            super.prune();
            if (this.buyerSeller != null && !this.buyerSeller.prune().hasData()) {
                this.buyerSeller = null;
            }
            if (this.feature != null && !this.feature.prune().hasData()) {
                this.feature = null;
            }
            if (this.observationTerms != null && !this.observationTerms.prune().hasData()) {
                this.observationTerms = null;
            }
            if (this.schedule != null && !this.schedule.prune().hasData()) {
                this.schedule = null;
            }
            if (this.delivery != null && !this.delivery.prune().hasData()) {
                this.delivery = null;
            }
            if (this.underlier != null && !this.underlier.prune().hasData()) {
                this.underlier = null;
            }
            if (this.exerciseTerms != null && !this.exerciseTerms.prune().hasData()) {
                this.exerciseTerms = null;
            }
            if (this.strike != null && !this.strike.prune().hasData()) {
                this.strike = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getBuyerSeller() != null && this.getBuyerSeller().hasData()) {
                return true;
            }
            if (this.getFeature() != null && this.getFeature().hasData()) {
                return true;
            }
            if (this.getObservationTerms() != null && this.getObservationTerms().hasData()) {
                return true;
            }
            if (this.getSchedule() != null && this.getSchedule().hasData()) {
                return true;
            }
            if (this.getDelivery() != null && this.getDelivery().hasData()) {
                return true;
            }
            if (this.getUnderlier() != null && this.getUnderlier().hasData()) {
                return true;
            }
            if (this.getOptionType() != null) {
                return true;
            }
            if (this.getExerciseTerms() != null && this.getExerciseTerms().hasData()) {
                return true;
            }
            return this.getStrike() != null && this.getStrike().hasData();
        }

        @Override
        public OptionPayoutBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            OptionPayoutBuilder o = (OptionPayoutBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getBuyerSeller(), (RosettaModelObjectBuilder)o.getBuyerSeller(), this::setBuyerSeller);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFeature(), (RosettaModelObjectBuilder)o.getFeature(), this::setFeature);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getObservationTerms(), (RosettaModelObjectBuilder)o.getObservationTerms(), this::setObservationTerms);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSchedule(), (RosettaModelObjectBuilder)o.getSchedule(), this::setSchedule);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDelivery(), (RosettaModelObjectBuilder)o.getDelivery(), this::setDelivery);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getUnderlier(), (RosettaModelObjectBuilder)o.getUnderlier(), this::setUnderlier);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getExerciseTerms(), (RosettaModelObjectBuilder)o.getExerciseTerms(), this::setExerciseTerms);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getStrike(), (RosettaModelObjectBuilder)o.getStrike(), this::setStrike);
            merger.mergeBasic((Object)this.getOptionType(), (Object)o.getOptionType(), this::setOptionType, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            OptionPayout _that = (OptionPayout)this.getType().cast(o);
            if (!Objects.equals(this.buyerSeller, _that.getBuyerSeller())) {
                return false;
            }
            if (!Objects.equals(this.feature, _that.getFeature())) {
                return false;
            }
            if (!Objects.equals(this.observationTerms, _that.getObservationTerms())) {
                return false;
            }
            if (!Objects.equals(this.schedule, _that.getSchedule())) {
                return false;
            }
            if (!Objects.equals(this.delivery, _that.getDelivery())) {
                return false;
            }
            if (!Objects.equals(this.underlier, _that.getUnderlier())) {
                return false;
            }
            if (!Objects.equals((Object)this.optionType, (Object)_that.getOptionType())) {
                return false;
            }
            if (!Objects.equals(this.exerciseTerms, _that.getExerciseTerms())) {
                return false;
            }
            return Objects.equals(this.strike, _that.getStrike());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.buyerSeller != null ? this.buyerSeller.hashCode() : 0);
            _result = 31 * _result + (this.feature != null ? this.feature.hashCode() : 0);
            _result = 31 * _result + (this.observationTerms != null ? this.observationTerms.hashCode() : 0);
            _result = 31 * _result + (this.schedule != null ? this.schedule.hashCode() : 0);
            _result = 31 * _result + (this.delivery != null ? this.delivery.hashCode() : 0);
            _result = 31 * _result + (this.underlier != null ? this.underlier.hashCode() : 0);
            _result = 31 * _result + (this.optionType != null ? ((Object)((Object)this.optionType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.exerciseTerms != null ? this.exerciseTerms.hashCode() : 0);
            _result = 31 * _result + (this.strike != null ? this.strike.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "OptionPayoutBuilder {buyerSeller=" + this.buyerSeller + ", feature=" + this.feature + ", observationTerms=" + this.observationTerms + ", schedule=" + this.schedule + ", delivery=" + this.delivery + ", underlier=" + this.underlier + ", optionType=" + (Object)((Object)this.optionType) + ", exerciseTerms=" + this.exerciseTerms + ", strike=" + this.strike + '}' + " " + super.toString();
        }
    }

    public static interface OptionPayoutBuilder
    extends OptionPayout,
    PayoutBase.PayoutBaseBuilder {
        public BuyerSeller.BuyerSellerBuilder getOrCreateBuyerSeller();

        @Override
        public BuyerSeller.BuyerSellerBuilder getBuyerSeller();

        public OptionFeature.OptionFeatureBuilder getOrCreateFeature();

        @Override
        public OptionFeature.OptionFeatureBuilder getFeature();

        public ObservationTerms.ObservationTermsBuilder getOrCreateObservationTerms();

        @Override
        public ObservationTerms.ObservationTermsBuilder getObservationTerms();

        public CalculationSchedule.CalculationScheduleBuilder getOrCreateSchedule();

        @Override
        public CalculationSchedule.CalculationScheduleBuilder getSchedule();

        public AssetDeliveryInformation.AssetDeliveryInformationBuilder getOrCreateDelivery();

        @Override
        public AssetDeliveryInformation.AssetDeliveryInformationBuilder getDelivery();

        public Underlier.UnderlierBuilder getOrCreateUnderlier();

        @Override
        public Underlier.UnderlierBuilder getUnderlier();

        public ExerciseTerms.ExerciseTermsBuilder getOrCreateExerciseTerms();

        @Override
        public ExerciseTerms.ExerciseTermsBuilder getExerciseTerms();

        public OptionStrike.OptionStrikeBuilder getOrCreateStrike();

        @Override
        public OptionStrike.OptionStrikeBuilder getStrike();

        @Override
        public OptionPayoutBuilder setPayerReceiver(PayerReceiver var1);

        @Override
        public OptionPayoutBuilder setPriceQuantity(ResolvablePriceQuantity var1);

        @Override
        public OptionPayoutBuilder setPrincipalPayment(PrincipalPayments var1);

        @Override
        public OptionPayoutBuilder setSettlementTerms(SettlementTerms var1);

        public OptionPayoutBuilder setBuyerSeller(BuyerSeller var1);

        public OptionPayoutBuilder setFeature(OptionFeature var1);

        public OptionPayoutBuilder setObservationTerms(ObservationTerms var1);

        public OptionPayoutBuilder setSchedule(CalculationSchedule var1);

        public OptionPayoutBuilder setDelivery(AssetDeliveryInformation var1);

        public OptionPayoutBuilder setUnderlier(Underlier var1);

        public OptionPayoutBuilder setOptionType(OptionTypeEnum var1);

        public OptionPayoutBuilder setExerciseTerms(ExerciseTerms var1);

        public OptionPayoutBuilder setStrike(OptionStrike var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("payerReceiver"), processor, PayerReceiver.PayerReceiverBuilder.class, (RosettaModelObjectBuilder)this.getPayerReceiver(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("priceQuantity"), processor, ResolvablePriceQuantity.ResolvablePriceQuantityBuilder.class, (RosettaModelObjectBuilder)this.getPriceQuantity(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("principalPayment"), processor, PrincipalPayments.PrincipalPaymentsBuilder.class, (RosettaModelObjectBuilder)this.getPrincipalPayment(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("settlementTerms"), processor, SettlementTerms.SettlementTermsBuilder.class, (RosettaModelObjectBuilder)this.getSettlementTerms(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("buyerSeller"), processor, BuyerSeller.BuyerSellerBuilder.class, this.getBuyerSeller(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("feature"), processor, OptionFeature.OptionFeatureBuilder.class, this.getFeature(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("observationTerms"), processor, ObservationTerms.ObservationTermsBuilder.class, this.getObservationTerms(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("schedule"), processor, CalculationSchedule.CalculationScheduleBuilder.class, this.getSchedule(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("delivery"), processor, AssetDeliveryInformation.AssetDeliveryInformationBuilder.class, this.getDelivery(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("underlier"), processor, Underlier.UnderlierBuilder.class, this.getUnderlier(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("optionType"), OptionTypeEnum.class, (Object)this.getOptionType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("exerciseTerms"), processor, ExerciseTerms.ExerciseTermsBuilder.class, this.getExerciseTerms(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("strike"), processor, OptionStrike.OptionStrikeBuilder.class, this.getStrike(), new AttributeMeta[0]);
        }

        @Override
        public OptionPayoutBuilder prune();
    }

    public static class OptionPayoutImpl
    extends PayoutBase.PayoutBaseImpl
    implements OptionPayout {
        private final BuyerSeller buyerSeller;
        private final OptionFeature feature;
        private final ObservationTerms observationTerms;
        private final CalculationSchedule schedule;
        private final AssetDeliveryInformation delivery;
        private final Underlier underlier;
        private final OptionTypeEnum optionType;
        private final ExerciseTerms exerciseTerms;
        private final OptionStrike strike;

        protected OptionPayoutImpl(OptionPayoutBuilder builder) {
            super(builder);
            this.buyerSeller = Optional.ofNullable(builder.getBuyerSeller()).map(f -> f.build()).orElse(null);
            this.feature = Optional.ofNullable(builder.getFeature()).map(f -> f.build()).orElse(null);
            this.observationTerms = Optional.ofNullable(builder.getObservationTerms()).map(f -> f.build()).orElse(null);
            this.schedule = Optional.ofNullable(builder.getSchedule()).map(f -> f.build()).orElse(null);
            this.delivery = Optional.ofNullable(builder.getDelivery()).map(f -> f.build()).orElse(null);
            this.underlier = Optional.ofNullable(builder.getUnderlier()).map(f -> f.build()).orElse(null);
            this.optionType = builder.getOptionType();
            this.exerciseTerms = Optional.ofNullable(builder.getExerciseTerms()).map(f -> f.build()).orElse(null);
            this.strike = Optional.ofNullable(builder.getStrike()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="buyerSeller", isRequired=true)
        @RuneAttribute(value="buyerSeller", isRequired=true)
        public BuyerSeller getBuyerSeller() {
            return this.buyerSeller;
        }

        @Override
        @RosettaAttribute(value="feature")
        @RuneAttribute(value="feature")
        public OptionFeature getFeature() {
            return this.feature;
        }

        @Override
        @RosettaAttribute(value="observationTerms")
        @RuneAttribute(value="observationTerms")
        public ObservationTerms getObservationTerms() {
            return this.observationTerms;
        }

        @Override
        @RosettaAttribute(value="schedule")
        @RuneAttribute(value="schedule")
        public CalculationSchedule getSchedule() {
            return this.schedule;
        }

        @Override
        @RosettaAttribute(value="delivery")
        @RuneAttribute(value="delivery")
        public AssetDeliveryInformation getDelivery() {
            return this.delivery;
        }

        @Override
        @RosettaAttribute(value="underlier", isRequired=true)
        @RuneAttribute(value="underlier", isRequired=true)
        public Underlier getUnderlier() {
            return this.underlier;
        }

        @Override
        @RosettaAttribute(value="optionType")
        @RuneAttribute(value="optionType")
        public OptionTypeEnum getOptionType() {
            return this.optionType;
        }

        @Override
        @RosettaAttribute(value="exerciseTerms", isRequired=true)
        @RuneAttribute(value="exerciseTerms", isRequired=true)
        public ExerciseTerms getExerciseTerms() {
            return this.exerciseTerms;
        }

        @Override
        @RosettaAttribute(value="strike")
        @RuneAttribute(value="strike")
        public OptionStrike getStrike() {
            return this.strike;
        }

        @Override
        public OptionPayout build() {
            return this;
        }

        @Override
        public OptionPayoutBuilder toBuilder() {
            OptionPayoutBuilder builder = OptionPayout.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(OptionPayoutBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getBuyerSeller()).ifPresent(builder::setBuyerSeller);
            Optional.ofNullable(this.getFeature()).ifPresent(builder::setFeature);
            Optional.ofNullable(this.getObservationTerms()).ifPresent(builder::setObservationTerms);
            Optional.ofNullable(this.getSchedule()).ifPresent(builder::setSchedule);
            Optional.ofNullable(this.getDelivery()).ifPresent(builder::setDelivery);
            Optional.ofNullable(this.getUnderlier()).ifPresent(builder::setUnderlier);
            Optional.ofNullable(this.getOptionType()).ifPresent(builder::setOptionType);
            Optional.ofNullable(this.getExerciseTerms()).ifPresent(builder::setExerciseTerms);
            Optional.ofNullable(this.getStrike()).ifPresent(builder::setStrike);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            OptionPayout _that = (OptionPayout)this.getType().cast(o);
            if (!Objects.equals(this.buyerSeller, _that.getBuyerSeller())) {
                return false;
            }
            if (!Objects.equals(this.feature, _that.getFeature())) {
                return false;
            }
            if (!Objects.equals(this.observationTerms, _that.getObservationTerms())) {
                return false;
            }
            if (!Objects.equals(this.schedule, _that.getSchedule())) {
                return false;
            }
            if (!Objects.equals(this.delivery, _that.getDelivery())) {
                return false;
            }
            if (!Objects.equals(this.underlier, _that.getUnderlier())) {
                return false;
            }
            if (!Objects.equals((Object)this.optionType, (Object)_that.getOptionType())) {
                return false;
            }
            if (!Objects.equals(this.exerciseTerms, _that.getExerciseTerms())) {
                return false;
            }
            return Objects.equals(this.strike, _that.getStrike());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.buyerSeller != null ? this.buyerSeller.hashCode() : 0);
            _result = 31 * _result + (this.feature != null ? this.feature.hashCode() : 0);
            _result = 31 * _result + (this.observationTerms != null ? this.observationTerms.hashCode() : 0);
            _result = 31 * _result + (this.schedule != null ? this.schedule.hashCode() : 0);
            _result = 31 * _result + (this.delivery != null ? this.delivery.hashCode() : 0);
            _result = 31 * _result + (this.underlier != null ? this.underlier.hashCode() : 0);
            _result = 31 * _result + (this.optionType != null ? ((Object)((Object)this.optionType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.exerciseTerms != null ? this.exerciseTerms.hashCode() : 0);
            _result = 31 * _result + (this.strike != null ? this.strike.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "OptionPayout {buyerSeller=" + this.buyerSeller + ", feature=" + this.feature + ", observationTerms=" + this.observationTerms + ", schedule=" + this.schedule + ", delivery=" + this.delivery + ", underlier=" + this.underlier + ", optionType=" + (Object)((Object)this.optionType) + ", exerciseTerms=" + this.exerciseTerms + ", strike=" + this.strike + '}' + " " + super.toString();
        }
    }
}

