/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template;

import cdm.base.staticdata.asset.common.ProductIdentifier;
import cdm.base.staticdata.asset.common.ProductTaxonomy;
import cdm.product.template.EconomicTerms;
import cdm.product.template.meta.NonTransferableProductMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.GlobalKey;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.annotations.RuneMetaType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.metafields.MetaFields;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="NonTransferableProduct", builder=NonTransferableProductBuilderImpl.class, version="7.0.0-dev.52")
@RuneDataType(value="NonTransferableProduct", model="cdm", builder=NonTransferableProductBuilderImpl.class, version="7.0.0-dev.52")
public interface NonTransferableProduct
extends RosettaModelObject,
GlobalKey {
    public static final NonTransferableProductMeta metaData = new NonTransferableProductMeta();

    public List<? extends ProductIdentifier> getIdentifier();

    public List<? extends ProductTaxonomy> getTaxonomy();

    public EconomicTerms getEconomicTerms();

    public MetaFields getMeta();

    public NonTransferableProduct build();

    public NonTransferableProductBuilder toBuilder();

    public static NonTransferableProductBuilder builder() {
        return new NonTransferableProductBuilderImpl();
    }

    default public RosettaMetaData<? extends NonTransferableProduct> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends NonTransferableProduct> getType() {
        return NonTransferableProduct.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("identifier"), processor, ProductIdentifier.class, this.getIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("taxonomy"), processor, ProductTaxonomy.class, this.getTaxonomy(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("economicTerms"), processor, EconomicTerms.class, this.getEconomicTerms(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("meta"), processor, MetaFields.class, (RosettaModelObject)this.getMeta(), new AttributeMeta[0]);
    }

    public static class NonTransferableProductBuilderImpl
    implements NonTransferableProductBuilder {
        protected List<ProductIdentifier.ProductIdentifierBuilder> identifier = new ArrayList<ProductIdentifier.ProductIdentifierBuilder>();
        protected List<ProductTaxonomy.ProductTaxonomyBuilder> taxonomy = new ArrayList<ProductTaxonomy.ProductTaxonomyBuilder>();
        protected EconomicTerms.EconomicTermsBuilder economicTerms;
        protected MetaFields.MetaFieldsBuilder meta;

        @Override
        @RosettaAttribute(value="identifier")
        @RuneAttribute(value="identifier")
        public List<? extends ProductIdentifier.ProductIdentifierBuilder> getIdentifier() {
            return this.identifier;
        }

        @Override
        public ProductIdentifier.ProductIdentifierBuilder getOrCreateIdentifier(int index) {
            if (this.identifier == null) {
                this.identifier = new ArrayList<ProductIdentifier.ProductIdentifierBuilder>();
            }
            return (ProductIdentifier.ProductIdentifierBuilder)this.getIndex(this.identifier, index, () -> {
                ProductIdentifier.ProductIdentifierBuilder newIdentifier = ProductIdentifier.builder();
                return newIdentifier;
            });
        }

        @Override
        @RosettaAttribute(value="taxonomy")
        @RuneAttribute(value="taxonomy")
        public List<? extends ProductTaxonomy.ProductTaxonomyBuilder> getTaxonomy() {
            return this.taxonomy;
        }

        @Override
        public ProductTaxonomy.ProductTaxonomyBuilder getOrCreateTaxonomy(int index) {
            if (this.taxonomy == null) {
                this.taxonomy = new ArrayList<ProductTaxonomy.ProductTaxonomyBuilder>();
            }
            return (ProductTaxonomy.ProductTaxonomyBuilder)this.getIndex(this.taxonomy, index, () -> {
                ProductTaxonomy.ProductTaxonomyBuilder newTaxonomy = ProductTaxonomy.builder();
                return newTaxonomy;
            });
        }

        @Override
        @RosettaAttribute(value="economicTerms", isRequired=true)
        @RuneAttribute(value="economicTerms", isRequired=true)
        public EconomicTerms.EconomicTermsBuilder getEconomicTerms() {
            return this.economicTerms;
        }

        @Override
        public EconomicTerms.EconomicTermsBuilder getOrCreateEconomicTerms() {
            EconomicTerms.EconomicTermsBuilder result = this.economicTerms != null ? this.economicTerms : (this.economicTerms = EconomicTerms.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="meta")
        @RuneAttribute(value="meta")
        @RuneMetaType
        public MetaFields.MetaFieldsBuilder getMeta() {
            return this.meta;
        }

        @Override
        public MetaFields.MetaFieldsBuilder getOrCreateMeta() {
            MetaFields.MetaFieldsBuilder result = this.meta != null ? this.meta : (this.meta = MetaFields.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="identifier")
        @RuneAttribute(value="identifier")
        public NonTransferableProductBuilder addIdentifier(ProductIdentifier _identifier) {
            if (_identifier != null) {
                this.identifier.add(_identifier.toBuilder());
            }
            return this;
        }

        @Override
        public NonTransferableProductBuilder addIdentifier(ProductIdentifier _identifier, int idx) {
            this.getIndex(this.identifier, idx, () -> _identifier.toBuilder());
            return this;
        }

        @Override
        public NonTransferableProductBuilder addIdentifier(List<? extends ProductIdentifier> identifiers) {
            if (identifiers != null) {
                for (ProductIdentifier productIdentifier : identifiers) {
                    this.identifier.add(productIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="identifier")
        public NonTransferableProductBuilder setIdentifier(List<? extends ProductIdentifier> identifiers) {
            this.identifier = identifiers == null ? new ArrayList<ProductIdentifier.ProductIdentifierBuilder>() : (List)identifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="taxonomy")
        @RuneAttribute(value="taxonomy")
        public NonTransferableProductBuilder addTaxonomy(ProductTaxonomy _taxonomy) {
            if (_taxonomy != null) {
                this.taxonomy.add(_taxonomy.toBuilder());
            }
            return this;
        }

        @Override
        public NonTransferableProductBuilder addTaxonomy(ProductTaxonomy _taxonomy, int idx) {
            this.getIndex(this.taxonomy, idx, () -> _taxonomy.toBuilder());
            return this;
        }

        @Override
        public NonTransferableProductBuilder addTaxonomy(List<? extends ProductTaxonomy> taxonomys) {
            if (taxonomys != null) {
                for (ProductTaxonomy productTaxonomy : taxonomys) {
                    this.taxonomy.add(productTaxonomy.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="taxonomy")
        public NonTransferableProductBuilder setTaxonomy(List<? extends ProductTaxonomy> taxonomys) {
            this.taxonomy = taxonomys == null ? new ArrayList<ProductTaxonomy.ProductTaxonomyBuilder>() : (List)taxonomys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="economicTerms", isRequired=true)
        @RuneAttribute(value="economicTerms", isRequired=true)
        public NonTransferableProductBuilder setEconomicTerms(EconomicTerms _economicTerms) {
            this.economicTerms = _economicTerms == null ? null : _economicTerms.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="meta")
        @RuneAttribute(value="meta")
        @RuneMetaType
        public NonTransferableProductBuilder setMeta(MetaFields _meta) {
            this.meta = _meta == null ? null : _meta.toBuilder();
            return this;
        }

        @Override
        public NonTransferableProduct build() {
            return new NonTransferableProductImpl(this);
        }

        @Override
        public NonTransferableProductBuilder toBuilder() {
            return this;
        }

        @Override
        public NonTransferableProductBuilder prune() {
            this.identifier = this.identifier.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.taxonomy = this.taxonomy.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.economicTerms != null && !this.economicTerms.prune().hasData()) {
                this.economicTerms = null;
            }
            if (this.meta != null && !this.meta.prune().hasData()) {
                this.meta = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getIdentifier() != null && this.getIdentifier().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getTaxonomy() != null && this.getTaxonomy().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getEconomicTerms() != null && this.getEconomicTerms().hasData();
        }

        public NonTransferableProductBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            NonTransferableProductBuilder o = (NonTransferableProductBuilder)other;
            merger.mergeRosetta(this.getIdentifier(), o.getIdentifier(), this::getOrCreateIdentifier);
            merger.mergeRosetta(this.getTaxonomy(), o.getTaxonomy(), this::getOrCreateTaxonomy);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getEconomicTerms(), (RosettaModelObjectBuilder)o.getEconomicTerms(), this::setEconomicTerms);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMeta(), (RosettaModelObjectBuilder)o.getMeta(), this::setMeta);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            NonTransferableProduct _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.identifier, _that.getIdentifier())) {
                return false;
            }
            if (!ListEquals.listEquals(this.taxonomy, _that.getTaxonomy())) {
                return false;
            }
            if (!Objects.equals(this.economicTerms, _that.getEconomicTerms())) {
                return false;
            }
            return Objects.equals(this.meta, _that.getMeta());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.identifier != null ? this.identifier.hashCode() : 0);
            _result = 31 * _result + (this.taxonomy != null ? this.taxonomy.hashCode() : 0);
            _result = 31 * _result + (this.economicTerms != null ? this.economicTerms.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "NonTransferableProductBuilder {identifier=" + this.identifier + ", taxonomy=" + this.taxonomy + ", economicTerms=" + this.economicTerms + ", meta=" + this.meta + '}';
        }
    }

    public static interface NonTransferableProductBuilder
    extends NonTransferableProduct,
    RosettaModelObjectBuilder,
    GlobalKey.GlobalKeyBuilder {
        public ProductIdentifier.ProductIdentifierBuilder getOrCreateIdentifier(int var1);

        public List<? extends ProductIdentifier.ProductIdentifierBuilder> getIdentifier();

        public ProductTaxonomy.ProductTaxonomyBuilder getOrCreateTaxonomy(int var1);

        public List<? extends ProductTaxonomy.ProductTaxonomyBuilder> getTaxonomy();

        public EconomicTerms.EconomicTermsBuilder getOrCreateEconomicTerms();

        @Override
        public EconomicTerms.EconomicTermsBuilder getEconomicTerms();

        public MetaFields.MetaFieldsBuilder getOrCreateMeta();

        public MetaFields.MetaFieldsBuilder getMeta();

        public NonTransferableProductBuilder addIdentifier(ProductIdentifier var1);

        public NonTransferableProductBuilder addIdentifier(ProductIdentifier var1, int var2);

        public NonTransferableProductBuilder addIdentifier(List<? extends ProductIdentifier> var1);

        public NonTransferableProductBuilder setIdentifier(List<? extends ProductIdentifier> var1);

        public NonTransferableProductBuilder addTaxonomy(ProductTaxonomy var1);

        public NonTransferableProductBuilder addTaxonomy(ProductTaxonomy var1, int var2);

        public NonTransferableProductBuilder addTaxonomy(List<? extends ProductTaxonomy> var1);

        public NonTransferableProductBuilder setTaxonomy(List<? extends ProductTaxonomy> var1);

        public NonTransferableProductBuilder setEconomicTerms(EconomicTerms var1);

        public NonTransferableProductBuilder setMeta(MetaFields var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("identifier"), processor, ProductIdentifier.ProductIdentifierBuilder.class, this.getIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("taxonomy"), processor, ProductTaxonomy.ProductTaxonomyBuilder.class, this.getTaxonomy(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("economicTerms"), processor, EconomicTerms.EconomicTermsBuilder.class, this.getEconomicTerms(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("meta"), processor, MetaFields.MetaFieldsBuilder.class, (RosettaModelObjectBuilder)this.getMeta(), new AttributeMeta[0]);
        }

        public NonTransferableProductBuilder prune();
    }

    public static class NonTransferableProductImpl
    implements NonTransferableProduct {
        private final List<? extends ProductIdentifier> identifier;
        private final List<? extends ProductTaxonomy> taxonomy;
        private final EconomicTerms economicTerms;
        private final MetaFields meta;

        protected NonTransferableProductImpl(NonTransferableProductBuilder builder) {
            this.identifier = Optional.ofNullable(builder.getIdentifier()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.taxonomy = Optional.ofNullable(builder.getTaxonomy()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.economicTerms = Optional.ofNullable(builder.getEconomicTerms()).map(f -> f.build()).orElse(null);
            this.meta = Optional.ofNullable(builder.getMeta()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="identifier")
        @RuneAttribute(value="identifier")
        public List<? extends ProductIdentifier> getIdentifier() {
            return this.identifier;
        }

        @Override
        @RosettaAttribute(value="taxonomy")
        @RuneAttribute(value="taxonomy")
        public List<? extends ProductTaxonomy> getTaxonomy() {
            return this.taxonomy;
        }

        @Override
        @RosettaAttribute(value="economicTerms", isRequired=true)
        @RuneAttribute(value="economicTerms", isRequired=true)
        public EconomicTerms getEconomicTerms() {
            return this.economicTerms;
        }

        @Override
        @RosettaAttribute(value="meta")
        @RuneAttribute(value="meta")
        @RuneMetaType
        public MetaFields getMeta() {
            return this.meta;
        }

        @Override
        public NonTransferableProduct build() {
            return this;
        }

        @Override
        public NonTransferableProductBuilder toBuilder() {
            NonTransferableProductBuilder builder = NonTransferableProduct.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(NonTransferableProductBuilder builder) {
            Optional.ofNullable(this.getIdentifier()).ifPresent(builder::setIdentifier);
            Optional.ofNullable(this.getTaxonomy()).ifPresent(builder::setTaxonomy);
            Optional.ofNullable(this.getEconomicTerms()).ifPresent(builder::setEconomicTerms);
            Optional.ofNullable(this.getMeta()).ifPresent(builder::setMeta);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            NonTransferableProduct _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.identifier, _that.getIdentifier())) {
                return false;
            }
            if (!ListEquals.listEquals(this.taxonomy, _that.getTaxonomy())) {
                return false;
            }
            if (!Objects.equals(this.economicTerms, _that.getEconomicTerms())) {
                return false;
            }
            return Objects.equals(this.meta, _that.getMeta());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.identifier != null ? this.identifier.hashCode() : 0);
            _result = 31 * _result + (this.taxonomy != null ? this.taxonomy.hashCode() : 0);
            _result = 31 * _result + (this.economicTerms != null ? this.economicTerms.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "NonTransferableProduct {identifier=" + this.identifier + ", taxonomy=" + this.taxonomy + ", economicTerms=" + this.economicTerms + ", meta=" + this.meta + '}';
        }
    }
}

