/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.common.settlement.validation.datarule;

import cdm.product.common.settlement.PayoutBase;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="PayoutBaseFinalPrincipalAmountExists")
@ImplementedBy(value=Default.class)
public interface PayoutBaseFinalPrincipalAmountExists
extends Validator<PayoutBase> {
    public static final String NAME = "PayoutBaseFinalPrincipalAmountExists";
    public static final String DEFINITION = "if principalPayment -> principalPaymentSchedule -> finalPrincipalPayment exists and priceQuantity -> quantitySchedule exists and priceQuantity -> reset is absent then principalPayment -> principalPaymentSchedule -> finalPrincipalPayment -> principalAmount exists or principalPayment -> principalPaymentSchedule -> finalPrincipalPayment -> presentValuePrincipalAmount exists";

    public static class NoOp
    implements PayoutBaseFinalPrincipalAmountExists {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, PayoutBase payoutBase) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements PayoutBaseFinalPrincipalAmountExists {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, PayoutBase payoutBase) {
            ComparisonResult result = this.executeDataRule(payoutBase);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)PayoutBaseFinalPrincipalAmountExists.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"PayoutBase", (RosettaPath)path, (String)PayoutBaseFinalPrincipalAmountExists.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)PayoutBaseFinalPrincipalAmountExists.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"PayoutBase", (RosettaPath)path, (String)PayoutBaseFinalPrincipalAmountExists.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(PayoutBase payoutBase) {
            try {
                if (ExpressionOperators.exists((Mapper)MapperS.of((Object)payoutBase).map("getPrincipalPayment", _payoutBase -> _payoutBase.getPrincipalPayment()).map("getPrincipalPaymentSchedule", principalPayments -> principalPayments.getPrincipalPaymentSchedule()).map("getFinalPrincipalPayment", principalPaymentSchedule -> principalPaymentSchedule.getFinalPrincipalPayment())).and(ExpressionOperators.exists((Mapper)MapperS.of((Object)payoutBase).map("getPriceQuantity", _payoutBase -> _payoutBase.getPriceQuantity()).map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule()))).and(ExpressionOperators.notExists((Mapper)MapperS.of((Object)payoutBase).map("getPriceQuantity", _payoutBase -> _payoutBase.getPriceQuantity()).map("getReset", resolvablePriceQuantity -> resolvablePriceQuantity.getReset()))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperators.exists((Mapper)MapperS.of((Object)payoutBase).map("getPrincipalPayment", _payoutBase -> _payoutBase.getPrincipalPayment()).map("getPrincipalPaymentSchedule", principalPayments -> principalPayments.getPrincipalPaymentSchedule()).map("getFinalPrincipalPayment", principalPaymentSchedule -> principalPaymentSchedule.getFinalPrincipalPayment()).map("getPrincipalAmount", principalPayment -> principalPayment.getPrincipalAmount())).or(ExpressionOperators.exists((Mapper)MapperS.of((Object)payoutBase).map("getPrincipalPayment", _payoutBase -> _payoutBase.getPrincipalPayment()).map("getPrincipalPaymentSchedule", principalPayments -> principalPayments.getPrincipalPaymentSchedule()).map("getFinalPrincipalPayment", principalPaymentSchedule -> principalPaymentSchedule.getFinalPrincipalPayment()).map("getPresentValuePrincipalAmount", principalPayment -> principalPayment.getPresentValuePrincipalAmount())));
                }
                return ComparisonResult.successEmptyOperand((String)"");
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

