/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.common.settlement;

import cdm.base.datetime.AdjustableDate;
import cdm.base.staticdata.party.PayerReceiver;
import cdm.observable.asset.Money;
import cdm.product.common.settlement.meta.PrincipalPaymentMeta;
import com.rosetta.model.lib.GlobalKey;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.annotations.RuneMetaType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.metafields.MetaFields;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="PrincipalPayment", builder=PrincipalPaymentBuilderImpl.class, version="7.0.0-dev.52")
@RuneDataType(value="PrincipalPayment", model="cdm", builder=PrincipalPaymentBuilderImpl.class, version="7.0.0-dev.52")
public interface PrincipalPayment
extends RosettaModelObject,
GlobalKey {
    public static final PrincipalPaymentMeta metaData = new PrincipalPaymentMeta();

    public AdjustableDate getPrincipalPaymentDate();

    public PayerReceiver getPayerReceiver();

    public Money getPrincipalAmount();

    public BigDecimal getDiscountFactor();

    public Money getPresentValuePrincipalAmount();

    public MetaFields getMeta();

    public PrincipalPayment build();

    public PrincipalPaymentBuilder toBuilder();

    public static PrincipalPaymentBuilder builder() {
        return new PrincipalPaymentBuilderImpl();
    }

    default public RosettaMetaData<? extends PrincipalPayment> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends PrincipalPayment> getType() {
        return PrincipalPayment.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("principalPaymentDate"), processor, AdjustableDate.class, this.getPrincipalPaymentDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("payerReceiver"), processor, PayerReceiver.class, this.getPayerReceiver(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("principalAmount"), processor, Money.class, this.getPrincipalAmount(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("discountFactor"), BigDecimal.class, (Object)this.getDiscountFactor(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("presentValuePrincipalAmount"), processor, Money.class, this.getPresentValuePrincipalAmount(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("meta"), processor, MetaFields.class, (RosettaModelObject)this.getMeta(), new AttributeMeta[0]);
    }

    public static class PrincipalPaymentBuilderImpl
    implements PrincipalPaymentBuilder {
        protected AdjustableDate.AdjustableDateBuilder principalPaymentDate;
        protected PayerReceiver.PayerReceiverBuilder payerReceiver;
        protected Money.MoneyBuilder principalAmount;
        protected BigDecimal discountFactor;
        protected Money.MoneyBuilder presentValuePrincipalAmount;
        protected MetaFields.MetaFieldsBuilder meta;

        @Override
        @RosettaAttribute(value="principalPaymentDate")
        @RuneAttribute(value="principalPaymentDate")
        public AdjustableDate.AdjustableDateBuilder getPrincipalPaymentDate() {
            return this.principalPaymentDate;
        }

        @Override
        public AdjustableDate.AdjustableDateBuilder getOrCreatePrincipalPaymentDate() {
            AdjustableDate.AdjustableDateBuilder result = this.principalPaymentDate != null ? this.principalPaymentDate : (this.principalPaymentDate = AdjustableDate.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="payerReceiver")
        @RuneAttribute(value="payerReceiver")
        public PayerReceiver.PayerReceiverBuilder getPayerReceiver() {
            return this.payerReceiver;
        }

        @Override
        public PayerReceiver.PayerReceiverBuilder getOrCreatePayerReceiver() {
            PayerReceiver.PayerReceiverBuilder result = this.payerReceiver != null ? this.payerReceiver : (this.payerReceiver = PayerReceiver.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="principalAmount")
        @RuneAttribute(value="principalAmount")
        public Money.MoneyBuilder getPrincipalAmount() {
            return this.principalAmount;
        }

        @Override
        public Money.MoneyBuilder getOrCreatePrincipalAmount() {
            Money.MoneyBuilder result = this.principalAmount != null ? this.principalAmount : (this.principalAmount = Money.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="discountFactor")
        @RuneAttribute(value="discountFactor")
        public BigDecimal getDiscountFactor() {
            return this.discountFactor;
        }

        @Override
        @RosettaAttribute(value="presentValuePrincipalAmount")
        @RuneAttribute(value="presentValuePrincipalAmount")
        public Money.MoneyBuilder getPresentValuePrincipalAmount() {
            return this.presentValuePrincipalAmount;
        }

        @Override
        public Money.MoneyBuilder getOrCreatePresentValuePrincipalAmount() {
            Money.MoneyBuilder result = this.presentValuePrincipalAmount != null ? this.presentValuePrincipalAmount : (this.presentValuePrincipalAmount = Money.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="meta")
        @RuneAttribute(value="meta")
        @RuneMetaType
        public MetaFields.MetaFieldsBuilder getMeta() {
            return this.meta;
        }

        @Override
        public MetaFields.MetaFieldsBuilder getOrCreateMeta() {
            MetaFields.MetaFieldsBuilder result = this.meta != null ? this.meta : (this.meta = MetaFields.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="principalPaymentDate")
        @RuneAttribute(value="principalPaymentDate")
        public PrincipalPaymentBuilder setPrincipalPaymentDate(AdjustableDate _principalPaymentDate) {
            this.principalPaymentDate = _principalPaymentDate == null ? null : _principalPaymentDate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="payerReceiver")
        @RuneAttribute(value="payerReceiver")
        public PrincipalPaymentBuilder setPayerReceiver(PayerReceiver _payerReceiver) {
            this.payerReceiver = _payerReceiver == null ? null : _payerReceiver.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="principalAmount")
        @RuneAttribute(value="principalAmount")
        public PrincipalPaymentBuilder setPrincipalAmount(Money _principalAmount) {
            this.principalAmount = _principalAmount == null ? null : _principalAmount.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="discountFactor")
        @RuneAttribute(value="discountFactor")
        public PrincipalPaymentBuilder setDiscountFactor(BigDecimal _discountFactor) {
            this.discountFactor = _discountFactor == null ? null : _discountFactor;
            return this;
        }

        @Override
        @RosettaAttribute(value="presentValuePrincipalAmount")
        @RuneAttribute(value="presentValuePrincipalAmount")
        public PrincipalPaymentBuilder setPresentValuePrincipalAmount(Money _presentValuePrincipalAmount) {
            this.presentValuePrincipalAmount = _presentValuePrincipalAmount == null ? null : _presentValuePrincipalAmount.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="meta")
        @RuneAttribute(value="meta")
        @RuneMetaType
        public PrincipalPaymentBuilder setMeta(MetaFields _meta) {
            this.meta = _meta == null ? null : _meta.toBuilder();
            return this;
        }

        @Override
        public PrincipalPayment build() {
            return new PrincipalPaymentImpl(this);
        }

        @Override
        public PrincipalPaymentBuilder toBuilder() {
            return this;
        }

        @Override
        public PrincipalPaymentBuilder prune() {
            if (this.principalPaymentDate != null && !this.principalPaymentDate.prune().hasData()) {
                this.principalPaymentDate = null;
            }
            if (this.payerReceiver != null && !this.payerReceiver.prune().hasData()) {
                this.payerReceiver = null;
            }
            if (this.principalAmount != null && !this.principalAmount.prune().hasData()) {
                this.principalAmount = null;
            }
            if (this.presentValuePrincipalAmount != null && !this.presentValuePrincipalAmount.prune().hasData()) {
                this.presentValuePrincipalAmount = null;
            }
            if (this.meta != null && !this.meta.prune().hasData()) {
                this.meta = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getPrincipalPaymentDate() != null && this.getPrincipalPaymentDate().hasData()) {
                return true;
            }
            if (this.getPayerReceiver() != null && this.getPayerReceiver().hasData()) {
                return true;
            }
            if (this.getPrincipalAmount() != null && this.getPrincipalAmount().hasData()) {
                return true;
            }
            if (this.getDiscountFactor() != null) {
                return true;
            }
            return this.getPresentValuePrincipalAmount() != null && this.getPresentValuePrincipalAmount().hasData();
        }

        public PrincipalPaymentBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            PrincipalPaymentBuilder o = (PrincipalPaymentBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPrincipalPaymentDate(), (RosettaModelObjectBuilder)o.getPrincipalPaymentDate(), this::setPrincipalPaymentDate);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPayerReceiver(), (RosettaModelObjectBuilder)o.getPayerReceiver(), this::setPayerReceiver);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPrincipalAmount(), (RosettaModelObjectBuilder)o.getPrincipalAmount(), this::setPrincipalAmount);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPresentValuePrincipalAmount(), (RosettaModelObjectBuilder)o.getPresentValuePrincipalAmount(), this::setPresentValuePrincipalAmount);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMeta(), (RosettaModelObjectBuilder)o.getMeta(), this::setMeta);
            merger.mergeBasic((Object)this.getDiscountFactor(), (Object)o.getDiscountFactor(), this::setDiscountFactor, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PrincipalPayment _that = this.getType().cast(o);
            if (!Objects.equals(this.principalPaymentDate, _that.getPrincipalPaymentDate())) {
                return false;
            }
            if (!Objects.equals(this.payerReceiver, _that.getPayerReceiver())) {
                return false;
            }
            if (!Objects.equals(this.principalAmount, _that.getPrincipalAmount())) {
                return false;
            }
            if (!Objects.equals(this.discountFactor, _that.getDiscountFactor())) {
                return false;
            }
            if (!Objects.equals(this.presentValuePrincipalAmount, _that.getPresentValuePrincipalAmount())) {
                return false;
            }
            return Objects.equals(this.meta, _that.getMeta());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.principalPaymentDate != null ? this.principalPaymentDate.hashCode() : 0);
            _result = 31 * _result + (this.payerReceiver != null ? this.payerReceiver.hashCode() : 0);
            _result = 31 * _result + (this.principalAmount != null ? this.principalAmount.hashCode() : 0);
            _result = 31 * _result + (this.discountFactor != null ? this.discountFactor.hashCode() : 0);
            _result = 31 * _result + (this.presentValuePrincipalAmount != null ? this.presentValuePrincipalAmount.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PrincipalPaymentBuilder {principalPaymentDate=" + this.principalPaymentDate + ", payerReceiver=" + this.payerReceiver + ", principalAmount=" + this.principalAmount + ", discountFactor=" + this.discountFactor + ", presentValuePrincipalAmount=" + this.presentValuePrincipalAmount + ", meta=" + this.meta + '}';
        }
    }

    public static interface PrincipalPaymentBuilder
    extends PrincipalPayment,
    RosettaModelObjectBuilder,
    GlobalKey.GlobalKeyBuilder {
        public AdjustableDate.AdjustableDateBuilder getOrCreatePrincipalPaymentDate();

        @Override
        public AdjustableDate.AdjustableDateBuilder getPrincipalPaymentDate();

        public PayerReceiver.PayerReceiverBuilder getOrCreatePayerReceiver();

        @Override
        public PayerReceiver.PayerReceiverBuilder getPayerReceiver();

        public Money.MoneyBuilder getOrCreatePrincipalAmount();

        @Override
        public Money.MoneyBuilder getPrincipalAmount();

        public Money.MoneyBuilder getOrCreatePresentValuePrincipalAmount();

        @Override
        public Money.MoneyBuilder getPresentValuePrincipalAmount();

        public MetaFields.MetaFieldsBuilder getOrCreateMeta();

        public MetaFields.MetaFieldsBuilder getMeta();

        public PrincipalPaymentBuilder setPrincipalPaymentDate(AdjustableDate var1);

        public PrincipalPaymentBuilder setPayerReceiver(PayerReceiver var1);

        public PrincipalPaymentBuilder setPrincipalAmount(Money var1);

        public PrincipalPaymentBuilder setDiscountFactor(BigDecimal var1);

        public PrincipalPaymentBuilder setPresentValuePrincipalAmount(Money var1);

        public PrincipalPaymentBuilder setMeta(MetaFields var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("principalPaymentDate"), processor, AdjustableDate.AdjustableDateBuilder.class, this.getPrincipalPaymentDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("payerReceiver"), processor, PayerReceiver.PayerReceiverBuilder.class, this.getPayerReceiver(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("principalAmount"), processor, Money.MoneyBuilder.class, this.getPrincipalAmount(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("discountFactor"), BigDecimal.class, (Object)this.getDiscountFactor(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("presentValuePrincipalAmount"), processor, Money.MoneyBuilder.class, this.getPresentValuePrincipalAmount(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("meta"), processor, MetaFields.MetaFieldsBuilder.class, (RosettaModelObjectBuilder)this.getMeta(), new AttributeMeta[0]);
        }

        public PrincipalPaymentBuilder prune();
    }

    public static class PrincipalPaymentImpl
    implements PrincipalPayment {
        private final AdjustableDate principalPaymentDate;
        private final PayerReceiver payerReceiver;
        private final Money principalAmount;
        private final BigDecimal discountFactor;
        private final Money presentValuePrincipalAmount;
        private final MetaFields meta;

        protected PrincipalPaymentImpl(PrincipalPaymentBuilder builder) {
            this.principalPaymentDate = Optional.ofNullable(builder.getPrincipalPaymentDate()).map(f -> f.build()).orElse(null);
            this.payerReceiver = Optional.ofNullable(builder.getPayerReceiver()).map(f -> f.build()).orElse(null);
            this.principalAmount = Optional.ofNullable(builder.getPrincipalAmount()).map(f -> f.build()).orElse(null);
            this.discountFactor = builder.getDiscountFactor();
            this.presentValuePrincipalAmount = Optional.ofNullable(builder.getPresentValuePrincipalAmount()).map(f -> f.build()).orElse(null);
            this.meta = Optional.ofNullable(builder.getMeta()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="principalPaymentDate")
        @RuneAttribute(value="principalPaymentDate")
        public AdjustableDate getPrincipalPaymentDate() {
            return this.principalPaymentDate;
        }

        @Override
        @RosettaAttribute(value="payerReceiver")
        @RuneAttribute(value="payerReceiver")
        public PayerReceiver getPayerReceiver() {
            return this.payerReceiver;
        }

        @Override
        @RosettaAttribute(value="principalAmount")
        @RuneAttribute(value="principalAmount")
        public Money getPrincipalAmount() {
            return this.principalAmount;
        }

        @Override
        @RosettaAttribute(value="discountFactor")
        @RuneAttribute(value="discountFactor")
        public BigDecimal getDiscountFactor() {
            return this.discountFactor;
        }

        @Override
        @RosettaAttribute(value="presentValuePrincipalAmount")
        @RuneAttribute(value="presentValuePrincipalAmount")
        public Money getPresentValuePrincipalAmount() {
            return this.presentValuePrincipalAmount;
        }

        @Override
        @RosettaAttribute(value="meta")
        @RuneAttribute(value="meta")
        @RuneMetaType
        public MetaFields getMeta() {
            return this.meta;
        }

        @Override
        public PrincipalPayment build() {
            return this;
        }

        @Override
        public PrincipalPaymentBuilder toBuilder() {
            PrincipalPaymentBuilder builder = PrincipalPayment.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(PrincipalPaymentBuilder builder) {
            Optional.ofNullable(this.getPrincipalPaymentDate()).ifPresent(builder::setPrincipalPaymentDate);
            Optional.ofNullable(this.getPayerReceiver()).ifPresent(builder::setPayerReceiver);
            Optional.ofNullable(this.getPrincipalAmount()).ifPresent(builder::setPrincipalAmount);
            Optional.ofNullable(this.getDiscountFactor()).ifPresent(builder::setDiscountFactor);
            Optional.ofNullable(this.getPresentValuePrincipalAmount()).ifPresent(builder::setPresentValuePrincipalAmount);
            Optional.ofNullable(this.getMeta()).ifPresent(builder::setMeta);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PrincipalPayment _that = this.getType().cast(o);
            if (!Objects.equals(this.principalPaymentDate, _that.getPrincipalPaymentDate())) {
                return false;
            }
            if (!Objects.equals(this.payerReceiver, _that.getPayerReceiver())) {
                return false;
            }
            if (!Objects.equals(this.principalAmount, _that.getPrincipalAmount())) {
                return false;
            }
            if (!Objects.equals(this.discountFactor, _that.getDiscountFactor())) {
                return false;
            }
            if (!Objects.equals(this.presentValuePrincipalAmount, _that.getPresentValuePrincipalAmount())) {
                return false;
            }
            return Objects.equals(this.meta, _that.getMeta());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.principalPaymentDate != null ? this.principalPaymentDate.hashCode() : 0);
            _result = 31 * _result + (this.payerReceiver != null ? this.payerReceiver.hashCode() : 0);
            _result = 31 * _result + (this.principalAmount != null ? this.principalAmount.hashCode() : 0);
            _result = 31 * _result + (this.discountFactor != null ? this.discountFactor.hashCode() : 0);
            _result = 31 * _result + (this.presentValuePrincipalAmount != null ? this.presentValuePrincipalAmount.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PrincipalPayment {principalPaymentDate=" + this.principalPaymentDate + ", payerReceiver=" + this.payerReceiver + ", principalAmount=" + this.principalAmount + ", discountFactor=" + this.discountFactor + ", presentValuePrincipalAmount=" + this.presentValuePrincipalAmount + ", meta=" + this.meta + '}';
        }
    }
}

