/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.collateral.validation.exists;

import cdm.product.collateral.ListingExchange;
import com.google.common.collect.ImmutableMap;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ExistenceChecker;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class ListingExchangeOnlyExistsValidator
implements ValidatorWithArg<ListingExchange, Set<String>> {
    public <T2 extends ListingExchange> ValidationResult<ListingExchange> validate(RosettaPath path, T2 o, Set<String> fields) {
        ImmutableMap fieldExistenceMap = ImmutableMap.builder().put((Object)"exchange", (Object)ExistenceChecker.isSet(o.getExchange())).build();
        Set setFields = fieldExistenceMap.entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).collect(Collectors.toSet());
        if (setFields.equals(fields)) {
            return ValidationResult.success((String)"ListingExchange", (ValidationResult.ValidationType)ValidationResult.ValidationType.ONLY_EXISTS, (String)"ListingExchange", (RosettaPath)path, (String)"");
        }
        return ValidationResult.failure((String)"ListingExchange", (ValidationResult.ValidationType)ValidationResult.ValidationType.ONLY_EXISTS, (String)"ListingExchange", (RosettaPath)path, (String)"", (String)String.format("[%s] should only be set.  Set fields: %s", fields, setFields));
    }
}

