/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.collateral;

import cdm.base.datetime.PeriodRange;
import cdm.base.staticdata.asset.common.MaturityTypeEnum;
import cdm.product.collateral.meta.AssetMaturityMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="AssetMaturity", builder=AssetMaturityBuilderImpl.class, version="7.0.0-dev.52")
@RuneDataType(value="AssetMaturity", model="cdm", builder=AssetMaturityBuilderImpl.class, version="7.0.0-dev.52")
public interface AssetMaturity
extends RosettaModelObject {
    public static final AssetMaturityMeta metaData = new AssetMaturityMeta();

    public MaturityTypeEnum getMaturityType();

    public PeriodRange getMaturityRange();

    public AssetMaturity build();

    public AssetMaturityBuilder toBuilder();

    public static AssetMaturityBuilder builder() {
        return new AssetMaturityBuilderImpl();
    }

    default public RosettaMetaData<? extends AssetMaturity> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends AssetMaturity> getType() {
        return AssetMaturity.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("maturityType"), MaturityTypeEnum.class, (Object)this.getMaturityType(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("maturityRange"), processor, PeriodRange.class, this.getMaturityRange(), new AttributeMeta[0]);
    }

    public static class AssetMaturityBuilderImpl
    implements AssetMaturityBuilder {
        protected MaturityTypeEnum maturityType;
        protected PeriodRange.PeriodRangeBuilder maturityRange;

        @Override
        @RosettaAttribute(value="maturityType", isRequired=true)
        @RuneAttribute(value="maturityType", isRequired=true)
        public MaturityTypeEnum getMaturityType() {
            return this.maturityType;
        }

        @Override
        @RosettaAttribute(value="maturityRange", isRequired=true)
        @RuneAttribute(value="maturityRange", isRequired=true)
        public PeriodRange.PeriodRangeBuilder getMaturityRange() {
            return this.maturityRange;
        }

        @Override
        public PeriodRange.PeriodRangeBuilder getOrCreateMaturityRange() {
            PeriodRange.PeriodRangeBuilder result = this.maturityRange != null ? this.maturityRange : (this.maturityRange = PeriodRange.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="maturityType", isRequired=true)
        @RuneAttribute(value="maturityType", isRequired=true)
        public AssetMaturityBuilder setMaturityType(MaturityTypeEnum _maturityType) {
            this.maturityType = _maturityType == null ? null : _maturityType;
            return this;
        }

        @Override
        @RosettaAttribute(value="maturityRange", isRequired=true)
        @RuneAttribute(value="maturityRange", isRequired=true)
        public AssetMaturityBuilder setMaturityRange(PeriodRange _maturityRange) {
            this.maturityRange = _maturityRange == null ? null : _maturityRange.toBuilder();
            return this;
        }

        @Override
        public AssetMaturity build() {
            return new AssetMaturityImpl(this);
        }

        @Override
        public AssetMaturityBuilder toBuilder() {
            return this;
        }

        @Override
        public AssetMaturityBuilder prune() {
            if (this.maturityRange != null && !this.maturityRange.prune().hasData()) {
                this.maturityRange = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getMaturityType() != null) {
                return true;
            }
            return this.getMaturityRange() != null && this.getMaturityRange().hasData();
        }

        public AssetMaturityBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            AssetMaturityBuilder o = (AssetMaturityBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMaturityRange(), (RosettaModelObjectBuilder)o.getMaturityRange(), this::setMaturityRange);
            merger.mergeBasic((Object)this.getMaturityType(), (Object)o.getMaturityType(), this::setMaturityType, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            AssetMaturity _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.maturityType, (Object)_that.getMaturityType())) {
                return false;
            }
            return Objects.equals(this.maturityRange, _that.getMaturityRange());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.maturityType != null ? ((Object)((Object)this.maturityType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.maturityRange != null ? this.maturityRange.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "AssetMaturityBuilder {maturityType=" + (Object)((Object)this.maturityType) + ", maturityRange=" + this.maturityRange + '}';
        }
    }

    public static interface AssetMaturityBuilder
    extends AssetMaturity,
    RosettaModelObjectBuilder {
        public PeriodRange.PeriodRangeBuilder getOrCreateMaturityRange();

        @Override
        public PeriodRange.PeriodRangeBuilder getMaturityRange();

        public AssetMaturityBuilder setMaturityType(MaturityTypeEnum var1);

        public AssetMaturityBuilder setMaturityRange(PeriodRange var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("maturityType"), MaturityTypeEnum.class, (Object)this.getMaturityType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("maturityRange"), processor, PeriodRange.PeriodRangeBuilder.class, this.getMaturityRange(), new AttributeMeta[0]);
        }

        public AssetMaturityBuilder prune();
    }

    public static class AssetMaturityImpl
    implements AssetMaturity {
        private final MaturityTypeEnum maturityType;
        private final PeriodRange maturityRange;

        protected AssetMaturityImpl(AssetMaturityBuilder builder) {
            this.maturityType = builder.getMaturityType();
            this.maturityRange = Optional.ofNullable(builder.getMaturityRange()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="maturityType", isRequired=true)
        @RuneAttribute(value="maturityType", isRequired=true)
        public MaturityTypeEnum getMaturityType() {
            return this.maturityType;
        }

        @Override
        @RosettaAttribute(value="maturityRange", isRequired=true)
        @RuneAttribute(value="maturityRange", isRequired=true)
        public PeriodRange getMaturityRange() {
            return this.maturityRange;
        }

        @Override
        public AssetMaturity build() {
            return this;
        }

        @Override
        public AssetMaturityBuilder toBuilder() {
            AssetMaturityBuilder builder = AssetMaturity.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(AssetMaturityBuilder builder) {
            Optional.ofNullable(this.getMaturityType()).ifPresent(builder::setMaturityType);
            Optional.ofNullable(this.getMaturityRange()).ifPresent(builder::setMaturityRange);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            AssetMaturity _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.maturityType, (Object)_that.getMaturityType())) {
                return false;
            }
            return Objects.equals(this.maturityRange, _that.getMaturityRange());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.maturityType != null ? ((Object)((Object)this.maturityType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.maturityRange != null ? this.maturityRange.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "AssetMaturity {maturityType=" + (Object)((Object)this.maturityType) + ", maturityRange=" + this.maturityRange + '}';
        }
    }
}

