/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.asset.calculation.functions;

import cdm.base.datetime.daycount.metafields.FieldWithMetaDayCountFractionEnum;
import cdm.product.asset.InterestRatePayout;
import cdm.product.asset.calculation.functions.CalculateYearFraction;
import cdm.product.asset.floatingrate.FloatingAmountCalculationDetails;
import cdm.product.asset.floatingrate.FloatingRateProcessingDetails;
import cdm.product.asset.floatingrate.FloatingRateSettingDetails;
import cdm.product.common.schedule.CalculationPeriodBase;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.expression.MapperMaths;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.metafields.FieldWithMetaString;
import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=CalculateFloatingCashFlowDefault.class)
public abstract class CalculateFloatingCashFlow
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected CalculateYearFraction calculateYearFraction;

    public FloatingAmountCalculationDetails evaluate(InterestRatePayout interestRatePayout, CalculationPeriodBase calculationPeriod, BigDecimal notional, String currency, FloatingRateSettingDetails floatingRateSetting, FloatingRateProcessingDetails processedRateDetails) {
        FloatingAmountCalculationDetails result;
        FloatingAmountCalculationDetails.FloatingAmountCalculationDetailsBuilder resultBuilder = this.doEvaluate(interestRatePayout, calculationPeriod, notional, currency, floatingRateSetting, processedRateDetails);
        if (resultBuilder == null) {
            result = null;
        } else {
            result = resultBuilder.build();
            this.objectValidator.validate(FloatingAmountCalculationDetails.class, (RosettaModelObject)result);
        }
        return result;
    }

    protected abstract FloatingAmountCalculationDetails.FloatingAmountCalculationDetailsBuilder doEvaluate(InterestRatePayout var1, CalculationPeriodBase var2, BigDecimal var3, String var4, FloatingRateSettingDetails var5, FloatingRateProcessingDetails var6);

    protected abstract MapperS<BigDecimal> appliedRate(InterestRatePayout var1, CalculationPeriodBase var2, BigDecimal var3, String var4, FloatingRateSettingDetails var5, FloatingRateProcessingDetails var6);

    protected abstract MapperS<BigDecimal> spreadExclusiveRate(InterestRatePayout var1, CalculationPeriodBase var2, BigDecimal var3, String var4, FloatingRateSettingDetails var5, FloatingRateProcessingDetails var6);

    protected abstract MapperS<? extends FieldWithMetaDayCountFractionEnum> dcf(InterestRatePayout var1, CalculationPeriodBase var2, BigDecimal var3, String var4, FloatingRateSettingDetails var5, FloatingRateProcessingDetails var6);

    protected abstract MapperS<BigDecimal> yearFraction(InterestRatePayout var1, CalculationPeriodBase var2, BigDecimal var3, String var4, FloatingRateSettingDetails var5, FloatingRateProcessingDetails var6);

    protected abstract MapperS<BigDecimal> annualAccrual(InterestRatePayout var1, CalculationPeriodBase var2, BigDecimal var3, String var4, FloatingRateSettingDetails var5, FloatingRateProcessingDetails var6);

    protected abstract MapperS<BigDecimal> notionalAccrual(InterestRatePayout var1, CalculationPeriodBase var2, BigDecimal var3, String var4, FloatingRateSettingDetails var5, FloatingRateProcessingDetails var6);

    protected abstract MapperS<BigDecimal> cashflow(InterestRatePayout var1, CalculationPeriodBase var2, BigDecimal var3, String var4, FloatingRateSettingDetails var5, FloatingRateProcessingDetails var6);

    protected abstract MapperS<BigDecimal> spreadExclusiveCashflow(InterestRatePayout var1, CalculationPeriodBase var2, BigDecimal var3, String var4, FloatingRateSettingDetails var5, FloatingRateProcessingDetails var6);

    public static class CalculateFloatingCashFlowDefault
    extends CalculateFloatingCashFlow {
        @Override
        protected FloatingAmountCalculationDetails.FloatingAmountCalculationDetailsBuilder doEvaluate(InterestRatePayout interestRatePayout, CalculationPeriodBase calculationPeriod, BigDecimal notional, String currency, FloatingRateSettingDetails floatingRateSetting, FloatingRateProcessingDetails processedRateDetails) {
            FloatingAmountCalculationDetails.FloatingAmountCalculationDetailsBuilder result = FloatingAmountCalculationDetails.builder();
            return this.assignOutput(result, interestRatePayout, calculationPeriod, notional, currency, floatingRateSetting, processedRateDetails);
        }

        protected FloatingAmountCalculationDetails.FloatingAmountCalculationDetailsBuilder assignOutput(FloatingAmountCalculationDetails.FloatingAmountCalculationDetailsBuilder result, InterestRatePayout interestRatePayout, CalculationPeriodBase calculationPeriod, BigDecimal notional, String currency, FloatingRateSettingDetails floatingRateSetting, FloatingRateProcessingDetails processedRateDetails) {
            result.setCalculationPeriod(calculationPeriod);
            result.getOrCreateCalculationPeriodNotionalAmount().setValue(notional);
            result.getOrCreateCalculationPeriodNotionalAmount().getOrCreateUnit().setCurrency(currency == null ? FieldWithMetaString.builder().build() : FieldWithMetaString.builder().setValue(currency).build());
            FloatingRateSettingDetails ifThenElseResult = null;
            if (ExpressionOperators.exists((Mapper)MapperS.of((Object)floatingRateSetting)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                ifThenElseResult = floatingRateSetting;
            }
            result.setFloatingRate(ifThenElseResult);
            result.setProcessingDetails(processedRateDetails);
            result.setAppliedRate((BigDecimal)this.appliedRate(interestRatePayout, calculationPeriod, notional, currency, floatingRateSetting, processedRateDetails).get());
            result.setYearFraction((BigDecimal)this.yearFraction(interestRatePayout, calculationPeriod, notional, currency, floatingRateSetting, processedRateDetails).get());
            result.setCalculatedAmount((BigDecimal)this.cashflow(interestRatePayout, calculationPeriod, notional, currency, floatingRateSetting, processedRateDetails).get());
            result.setSpreadExclusiveCalculatedAMount((BigDecimal)this.spreadExclusiveCashflow(interestRatePayout, calculationPeriod, notional, currency, floatingRateSetting, processedRateDetails).get());
            return Optional.ofNullable(result).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected MapperS<BigDecimal> appliedRate(InterestRatePayout interestRatePayout, CalculationPeriodBase calculationPeriod, BigDecimal notional, String currency, FloatingRateSettingDetails floatingRateSetting, FloatingRateProcessingDetails processedRateDetails) {
            return MapperS.of((Object)processedRateDetails).map("getProcessedRate", floatingRateProcessingDetails -> floatingRateProcessingDetails.getProcessedRate());
        }

        @Override
        protected MapperS<BigDecimal> spreadExclusiveRate(InterestRatePayout interestRatePayout, CalculationPeriodBase calculationPeriod, BigDecimal notional, String currency, FloatingRateSettingDetails floatingRateSetting, FloatingRateProcessingDetails processedRateDetails) {
            return MapperS.of((Object)processedRateDetails).map("getSpreadExclusiveRate", floatingRateProcessingDetails -> floatingRateProcessingDetails.getSpreadExclusiveRate());
        }

        @Override
        protected MapperS<? extends FieldWithMetaDayCountFractionEnum> dcf(InterestRatePayout interestRatePayout, CalculationPeriodBase calculationPeriod, BigDecimal notional, String currency, FloatingRateSettingDetails floatingRateSetting, FloatingRateProcessingDetails processedRateDetails) {
            return MapperS.of((Object)interestRatePayout).map("getDayCountFraction", _interestRatePayout -> _interestRatePayout.getDayCountFraction());
        }

        @Override
        protected MapperS<BigDecimal> yearFraction(InterestRatePayout interestRatePayout, CalculationPeriodBase calculationPeriod, BigDecimal notional, String currency, FloatingRateSettingDetails floatingRateSetting, FloatingRateProcessingDetails processedRateDetails) {
            FieldWithMetaDayCountFractionEnum fieldWithMetaDayCountFractionEnum = (FieldWithMetaDayCountFractionEnum)this.dcf(interestRatePayout, calculationPeriod, notional, currency, floatingRateSetting, processedRateDetails).get();
            return MapperS.of((Object)this.calculateYearFraction.evaluate(interestRatePayout, fieldWithMetaDayCountFractionEnum == null ? null : fieldWithMetaDayCountFractionEnum.getValue(), calculationPeriod));
        }

        @Override
        protected MapperS<BigDecimal> annualAccrual(InterestRatePayout interestRatePayout, CalculationPeriodBase calculationPeriod, BigDecimal notional, String currency, FloatingRateSettingDetails floatingRateSetting, FloatingRateProcessingDetails processedRateDetails) {
            return MapperMaths.multiply((Mapper)MapperS.of((Object)notional), this.appliedRate(interestRatePayout, calculationPeriod, notional, currency, floatingRateSetting, processedRateDetails));
        }

        @Override
        protected MapperS<BigDecimal> notionalAccrual(InterestRatePayout interestRatePayout, CalculationPeriodBase calculationPeriod, BigDecimal notional, String currency, FloatingRateSettingDetails floatingRateSetting, FloatingRateProcessingDetails processedRateDetails) {
            return MapperMaths.multiply((Mapper)MapperS.of((Object)notional), this.yearFraction(interestRatePayout, calculationPeriod, notional, currency, floatingRateSetting, processedRateDetails));
        }

        @Override
        protected MapperS<BigDecimal> cashflow(InterestRatePayout interestRatePayout, CalculationPeriodBase calculationPeriod, BigDecimal notional, String currency, FloatingRateSettingDetails floatingRateSetting, FloatingRateProcessingDetails processedRateDetails) {
            return MapperMaths.multiply(this.notionalAccrual(interestRatePayout, calculationPeriod, notional, currency, floatingRateSetting, processedRateDetails), this.appliedRate(interestRatePayout, calculationPeriod, notional, currency, floatingRateSetting, processedRateDetails));
        }

        @Override
        protected MapperS<BigDecimal> spreadExclusiveCashflow(InterestRatePayout interestRatePayout, CalculationPeriodBase calculationPeriod, BigDecimal notional, String currency, FloatingRateSettingDetails floatingRateSetting, FloatingRateProcessingDetails processedRateDetails) {
            return MapperMaths.multiply(this.notionalAccrual(interestRatePayout, calculationPeriod, notional, currency, floatingRateSetting, processedRateDetails), this.spreadExclusiveRate(interestRatePayout, calculationPeriod, notional, currency, floatingRateSetting, processedRateDetails));
        }
    }
}

