/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset.calculatedrate.functions;

import cdm.base.datetime.daycount.DayCountFractionEnum;
import cdm.base.datetime.daycount.functions.YearFractionForOneDay;
import cdm.observable.asset.InterestRateIndex;
import cdm.observable.asset.calculatedrate.CalculatedRateDetails;
import cdm.observable.asset.calculatedrate.CalculatedRateObservationDatesAndWeights;
import cdm.observable.asset.calculatedrate.CalculationMethodEnum;
import cdm.observable.asset.calculatedrate.FloatingRateCalculationParameters;
import cdm.observable.asset.calculatedrate.functions.ApplyAveragingFormula;
import cdm.observable.asset.calculatedrate.functions.ApplyCompoundingFormula;
import cdm.observable.asset.calculatedrate.functions.GenerateObservationDatesAndWeights;
import cdm.observable.asset.calculatedrate.functions.IndexValueObservationMultiple;
import cdm.observable.asset.calculatedrate.functions.ProcessObservations;
import cdm.product.asset.floatingrate.FloatingRateSettingDetails;
import cdm.product.common.schedule.CalculationPeriodBase;
import cdm.product.common.schedule.ResetDates;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=EvaluateCalculatedRateDefault.class)
public abstract class EvaluateCalculatedRate
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected ApplyAveragingFormula applyAveragingFormula;
    @Inject
    protected ApplyCompoundingFormula applyCompoundingFormula;
    @Inject
    protected GenerateObservationDatesAndWeights generateObservationDatesAndWeights;
    @Inject
    protected IndexValueObservationMultiple indexValueObservationMultiple;
    @Inject
    protected ProcessObservations processObservations;
    @Inject
    protected YearFractionForOneDay yearFractionForOneDay;

    public FloatingRateSettingDetails evaluate(InterestRateIndex interestRateIndex, FloatingRateCalculationParameters calculationParameters, ResetDates resetDates, CalculationPeriodBase calculationPeriod, CalculationPeriodBase priorCalculationPeriod, DayCountFractionEnum dayCount) {
        FloatingRateSettingDetails results;
        FloatingRateSettingDetails.FloatingRateSettingDetailsBuilder resultsBuilder = this.doEvaluate(interestRateIndex, calculationParameters, resetDates, calculationPeriod, priorCalculationPeriod, dayCount);
        if (resultsBuilder == null) {
            results = null;
        } else {
            results = resultsBuilder.build();
            this.objectValidator.validate(FloatingRateSettingDetails.class, (RosettaModelObject)results);
        }
        return results;
    }

    protected abstract FloatingRateSettingDetails.FloatingRateSettingDetailsBuilder doEvaluate(InterestRateIndex var1, FloatingRateCalculationParameters var2, ResetDates var3, CalculationPeriodBase var4, CalculationPeriodBase var5, DayCountFractionEnum var6);

    protected abstract MapperS<? extends InterestRateIndex> rate(InterestRateIndex var1, FloatingRateCalculationParameters var2, ResetDates var3, CalculationPeriodBase var4, CalculationPeriodBase var5, DayCountFractionEnum var6);

    protected abstract MapperS<? extends CalculatedRateObservationDatesAndWeights> datesAndWeights(InterestRateIndex var1, FloatingRateCalculationParameters var2, ResetDates var3, CalculationPeriodBase var4, CalculationPeriodBase var5, DayCountFractionEnum var6);

    protected abstract MapperC<Date> observationDates(InterestRateIndex var1, FloatingRateCalculationParameters var2, ResetDates var3, CalculationPeriodBase var4, CalculationPeriodBase var5, DayCountFractionEnum var6);

    protected abstract MapperC<BigDecimal> observations(InterestRateIndex var1, FloatingRateCalculationParameters var2, ResetDates var3, CalculationPeriodBase var4, CalculationPeriodBase var5, DayCountFractionEnum var6);

    protected abstract MapperC<BigDecimal> processedObservations(InterestRateIndex var1, FloatingRateCalculationParameters var2, ResetDates var3, CalculationPeriodBase var4, CalculationPeriodBase var5, DayCountFractionEnum var6);

    protected abstract MapperS<CalculationMethodEnum> calculationMethod(InterestRateIndex var1, FloatingRateCalculationParameters var2, ResetDates var3, CalculationPeriodBase var4, CalculationPeriodBase var5, DayCountFractionEnum var6);

    protected abstract MapperS<Boolean> isCompounding(InterestRateIndex var1, FloatingRateCalculationParameters var2, ResetDates var3, CalculationPeriodBase var4, CalculationPeriodBase var5, DayCountFractionEnum var6);

    protected abstract MapperC<BigDecimal> weights(InterestRateIndex var1, FloatingRateCalculationParameters var2, ResetDates var3, CalculationPeriodBase var4, CalculationPeriodBase var5, DayCountFractionEnum var6);

    protected abstract MapperS<BigDecimal> yearFraction(InterestRateIndex var1, FloatingRateCalculationParameters var2, ResetDates var3, CalculationPeriodBase var4, CalculationPeriodBase var5, DayCountFractionEnum var6);

    protected abstract MapperS<? extends CalculatedRateDetails> calculationResults(InterestRateIndex var1, FloatingRateCalculationParameters var2, ResetDates var3, CalculationPeriodBase var4, CalculationPeriodBase var5, DayCountFractionEnum var6);

    public static class EvaluateCalculatedRateDefault
    extends EvaluateCalculatedRate {
        @Override
        protected FloatingRateSettingDetails.FloatingRateSettingDetailsBuilder doEvaluate(InterestRateIndex interestRateIndex, FloatingRateCalculationParameters calculationParameters, ResetDates resetDates, CalculationPeriodBase calculationPeriod, CalculationPeriodBase priorCalculationPeriod, DayCountFractionEnum dayCount) {
            FloatingRateSettingDetails.FloatingRateSettingDetailsBuilder results = FloatingRateSettingDetails.builder();
            return this.assignOutput(results, interestRateIndex, calculationParameters, resetDates, calculationPeriod, priorCalculationPeriod, dayCount);
        }

        protected FloatingRateSettingDetails.FloatingRateSettingDetailsBuilder assignOutput(FloatingRateSettingDetails.FloatingRateSettingDetailsBuilder results, InterestRateIndex interestRateIndex, FloatingRateCalculationParameters calculationParameters, ResetDates resetDates, CalculationPeriodBase calculationPeriod, CalculationPeriodBase priorCalculationPeriod, DayCountFractionEnum dayCount) {
            results.setCalculationDetails((CalculatedRateDetails)this.calculationResults(interestRateIndex, calculationParameters, resetDates, calculationPeriod, priorCalculationPeriod, dayCount).get());
            results.getOrCreateCalculationDetails().getOrCreateObservations().addObservationDates(this.datesAndWeights(interestRateIndex, calculationParameters, resetDates, calculationPeriod, priorCalculationPeriod, dayCount).mapC("getObservationDates", calculatedRateObservationDatesAndWeights -> calculatedRateObservationDatesAndWeights.getObservationDates()).getMulti());
            results.getOrCreateCalculationDetails().getOrCreateObservations().addWeights(this.datesAndWeights(interestRateIndex, calculationParameters, resetDates, calculationPeriod, priorCalculationPeriod, dayCount).mapC("getWeights", calculatedRateObservationDatesAndWeights -> calculatedRateObservationDatesAndWeights.getWeights()).getMulti());
            results.getOrCreateCalculationDetails().getOrCreateObservations().addObservedRates(this.observations(interestRateIndex, calculationParameters, resetDates, calculationPeriod, priorCalculationPeriod, dayCount).getMulti());
            results.getOrCreateCalculationDetails().getOrCreateObservations().addProcessedRates(this.processedObservations(interestRateIndex, calculationParameters, resetDates, calculationPeriod, priorCalculationPeriod, dayCount).getMulti());
            results.setFloatingRate((BigDecimal)this.calculationResults(interestRateIndex, calculationParameters, resetDates, calculationPeriod, priorCalculationPeriod, dayCount).map("getCalculatedRate", calculatedRateDetails -> calculatedRateDetails.getCalculatedRate()).get());
            return Optional.ofNullable(results).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected MapperS<? extends InterestRateIndex> rate(InterestRateIndex interestRateIndex, FloatingRateCalculationParameters calculationParameters, ResetDates resetDates, CalculationPeriodBase calculationPeriod, CalculationPeriodBase priorCalculationPeriod, DayCountFractionEnum dayCount) {
            return MapperS.of((Object)interestRateIndex);
        }

        @Override
        protected MapperS<? extends CalculatedRateObservationDatesAndWeights> datesAndWeights(InterestRateIndex interestRateIndex, FloatingRateCalculationParameters calculationParameters, ResetDates resetDates, CalculationPeriodBase calculationPeriod, CalculationPeriodBase priorCalculationPeriod, DayCountFractionEnum dayCount) {
            return MapperS.of((Object)this.generateObservationDatesAndWeights.evaluate(calculationParameters, resetDates, calculationPeriod, priorCalculationPeriod));
        }

        @Override
        protected MapperC<Date> observationDates(InterestRateIndex interestRateIndex, FloatingRateCalculationParameters calculationParameters, ResetDates resetDates, CalculationPeriodBase calculationPeriod, CalculationPeriodBase priorCalculationPeriod, DayCountFractionEnum dayCount) {
            return this.datesAndWeights(interestRateIndex, calculationParameters, resetDates, calculationPeriod, priorCalculationPeriod, dayCount).mapC("getObservationDates", calculatedRateObservationDatesAndWeights -> calculatedRateObservationDatesAndWeights.getObservationDates());
        }

        @Override
        protected MapperC<BigDecimal> observations(InterestRateIndex interestRateIndex, FloatingRateCalculationParameters calculationParameters, ResetDates resetDates, CalculationPeriodBase calculationPeriod, CalculationPeriodBase priorCalculationPeriod, DayCountFractionEnum dayCount) {
            return MapperC.of(this.indexValueObservationMultiple.evaluate(this.observationDates(interestRateIndex, calculationParameters, resetDates, calculationPeriod, priorCalculationPeriod, dayCount).getMulti(), (InterestRateIndex)this.rate(interestRateIndex, calculationParameters, resetDates, calculationPeriod, priorCalculationPeriod, dayCount).get()));
        }

        @Override
        protected MapperC<BigDecimal> processedObservations(InterestRateIndex interestRateIndex, FloatingRateCalculationParameters calculationParameters, ResetDates resetDates, CalculationPeriodBase calculationPeriod, CalculationPeriodBase priorCalculationPeriod, DayCountFractionEnum dayCount) {
            return MapperC.of(this.processObservations.evaluate(calculationParameters, this.observations(interestRateIndex, calculationParameters, resetDates, calculationPeriod, priorCalculationPeriod, dayCount).getMulti()));
        }

        @Override
        protected MapperS<CalculationMethodEnum> calculationMethod(InterestRateIndex interestRateIndex, FloatingRateCalculationParameters calculationParameters, ResetDates resetDates, CalculationPeriodBase calculationPeriod, CalculationPeriodBase priorCalculationPeriod, DayCountFractionEnum dayCount) {
            return MapperS.of((Object)calculationParameters).map("getCalculationMethod", floatingRateCalculationParameters -> floatingRateCalculationParameters.getCalculationMethod());
        }

        @Override
        protected MapperS<Boolean> isCompounding(InterestRateIndex interestRateIndex, FloatingRateCalculationParameters calculationParameters, ResetDates resetDates, CalculationPeriodBase calculationPeriod, CalculationPeriodBase priorCalculationPeriod, DayCountFractionEnum dayCount) {
            return ExpressionOperators.areEqual(this.calculationMethod(interestRateIndex, calculationParameters, resetDates, calculationPeriod, priorCalculationPeriod, dayCount), (Mapper)MapperS.of((Object)((Object)CalculationMethodEnum.COMPOUNDING)), (CardinalityOperator)CardinalityOperator.All).asMapper();
        }

        @Override
        protected MapperC<BigDecimal> weights(InterestRateIndex interestRateIndex, FloatingRateCalculationParameters calculationParameters, ResetDates resetDates, CalculationPeriodBase calculationPeriod, CalculationPeriodBase priorCalculationPeriod, DayCountFractionEnum dayCount) {
            return this.datesAndWeights(interestRateIndex, calculationParameters, resetDates, calculationPeriod, priorCalculationPeriod, dayCount).mapC("getWeights", calculatedRateObservationDatesAndWeights -> calculatedRateObservationDatesAndWeights.getWeights());
        }

        @Override
        protected MapperS<BigDecimal> yearFraction(InterestRateIndex interestRateIndex, FloatingRateCalculationParameters calculationParameters, ResetDates resetDates, CalculationPeriodBase calculationPeriod, CalculationPeriodBase priorCalculationPeriod, DayCountFractionEnum dayCount) {
            return MapperS.of((Object)this.yearFractionForOneDay.evaluate(dayCount));
        }

        @Override
        protected MapperS<? extends CalculatedRateDetails> calculationResults(InterestRateIndex interestRateIndex, FloatingRateCalculationParameters calculationParameters, ResetDates resetDates, CalculationPeriodBase calculationPeriod, CalculationPeriodBase priorCalculationPeriod, DayCountFractionEnum dayCount) {
            if (((Boolean)this.isCompounding(interestRateIndex, calculationParameters, resetDates, calculationPeriod, priorCalculationPeriod, dayCount).getOrDefault((Object)false)).booleanValue()) {
                return MapperS.of((Object)this.applyCompoundingFormula.evaluate(this.processedObservations(interestRateIndex, calculationParameters, resetDates, calculationPeriod, priorCalculationPeriod, dayCount).getMulti(), this.weights(interestRateIndex, calculationParameters, resetDates, calculationPeriod, priorCalculationPeriod, dayCount).getMulti(), (BigDecimal)this.yearFraction(interestRateIndex, calculationParameters, resetDates, calculationPeriod, priorCalculationPeriod, dayCount).get()));
            }
            return MapperS.of((Object)this.applyAveragingFormula.evaluate(this.observations(interestRateIndex, calculationParameters, resetDates, calculationPeriod, priorCalculationPeriod, dayCount).getMulti(), this.weights(interestRateIndex, calculationParameters, resetDates, calculationPeriod, priorCalculationPeriod, dayCount).getMulti()));
        }
    }
}

