/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset;

import cdm.base.staticdata.asset.common.Asset;
import cdm.observable.asset.Basket;
import cdm.observable.asset.Index;
import cdm.observable.asset.meta.ObservableMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="Observable", builder=ObservableBuilderImpl.class, version="7.0.0-dev.52")
@RuneDataType(value="Observable", model="cdm", builder=ObservableBuilderImpl.class, version="7.0.0-dev.52")
public interface Observable
extends RosettaModelObject {
    public static final ObservableMeta metaData = new ObservableMeta();

    public Asset getAsset();

    public Basket getBasket();

    public Index getIndex();

    public Observable build();

    public ObservableBuilder toBuilder();

    public static ObservableBuilder builder() {
        return new ObservableBuilderImpl();
    }

    default public RosettaMetaData<? extends Observable> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends Observable> getType() {
        return Observable.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("Asset"), processor, Asset.class, this.getAsset(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("Basket"), processor, Basket.class, this.getBasket(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("Index"), processor, Index.class, this.getIndex(), new AttributeMeta[0]);
    }

    public static class ObservableBuilderImpl
    implements ObservableBuilder {
        protected Asset.AssetBuilder asset;
        protected Basket.BasketBuilder basket;
        protected Index.IndexBuilder index;

        @Override
        @RosettaAttribute(value="Asset")
        @RuneAttribute(value="Asset")
        public Asset.AssetBuilder getAsset() {
            return this.asset;
        }

        @Override
        public Asset.AssetBuilder getOrCreateAsset() {
            Asset.AssetBuilder result = this.asset != null ? this.asset : (this.asset = Asset.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="Basket")
        @RuneAttribute(value="Basket")
        public Basket.BasketBuilder getBasket() {
            return this.basket;
        }

        @Override
        public Basket.BasketBuilder getOrCreateBasket() {
            Basket.BasketBuilder result = this.basket != null ? this.basket : (this.basket = Basket.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="Index")
        @RuneAttribute(value="Index")
        public Index.IndexBuilder getIndex() {
            return this.index;
        }

        @Override
        public Index.IndexBuilder getOrCreateIndex() {
            Index.IndexBuilder result = this.index != null ? this.index : (this.index = Index.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="Asset")
        @RuneAttribute(value="Asset")
        public ObservableBuilder setAsset(Asset _asset) {
            this.asset = _asset == null ? null : _asset.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="Basket")
        @RuneAttribute(value="Basket")
        public ObservableBuilder setBasket(Basket _basket) {
            this.basket = _basket == null ? null : _basket.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="Index")
        @RuneAttribute(value="Index")
        public ObservableBuilder setIndex(Index _index) {
            this.index = _index == null ? null : _index.toBuilder();
            return this;
        }

        @Override
        public Observable build() {
            return new ObservableImpl(this);
        }

        @Override
        public ObservableBuilder toBuilder() {
            return this;
        }

        @Override
        public ObservableBuilder prune() {
            if (this.asset != null && !this.asset.prune().hasData()) {
                this.asset = null;
            }
            if (this.basket != null && !this.basket.prune().hasData()) {
                this.basket = null;
            }
            if (this.index != null && !this.index.prune().hasData()) {
                this.index = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getAsset() != null && this.getAsset().hasData()) {
                return true;
            }
            if (this.getBasket() != null && this.getBasket().hasData()) {
                return true;
            }
            return this.getIndex() != null && this.getIndex().hasData();
        }

        public ObservableBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            ObservableBuilder o = (ObservableBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAsset(), (RosettaModelObjectBuilder)o.getAsset(), this::setAsset);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getBasket(), (RosettaModelObjectBuilder)o.getBasket(), this::setBasket);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getIndex(), (RosettaModelObjectBuilder)o.getIndex(), this::setIndex);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Observable _that = this.getType().cast(o);
            if (!Objects.equals(this.asset, _that.getAsset())) {
                return false;
            }
            if (!Objects.equals(this.basket, _that.getBasket())) {
                return false;
            }
            return Objects.equals(this.index, _that.getIndex());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.asset != null ? this.asset.hashCode() : 0);
            _result = 31 * _result + (this.basket != null ? this.basket.hashCode() : 0);
            _result = 31 * _result + (this.index != null ? this.index.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ObservableBuilder {Asset=" + this.asset + ", Basket=" + this.basket + ", Index=" + this.index + '}';
        }
    }

    public static interface ObservableBuilder
    extends Observable,
    RosettaModelObjectBuilder {
        public Asset.AssetBuilder getOrCreateAsset();

        @Override
        public Asset.AssetBuilder getAsset();

        public Basket.BasketBuilder getOrCreateBasket();

        @Override
        public Basket.BasketBuilder getBasket();

        public Index.IndexBuilder getOrCreateIndex();

        @Override
        public Index.IndexBuilder getIndex();

        public ObservableBuilder setAsset(Asset var1);

        public ObservableBuilder setBasket(Basket var1);

        public ObservableBuilder setIndex(Index var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("Asset"), processor, Asset.AssetBuilder.class, this.getAsset(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("Basket"), processor, Basket.BasketBuilder.class, this.getBasket(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("Index"), processor, Index.IndexBuilder.class, this.getIndex(), new AttributeMeta[0]);
        }

        public ObservableBuilder prune();
    }

    public static class ObservableImpl
    implements Observable {
        private final Asset asset;
        private final Basket basket;
        private final Index index;

        protected ObservableImpl(ObservableBuilder builder) {
            this.asset = Optional.ofNullable(builder.getAsset()).map(f -> f.build()).orElse(null);
            this.basket = Optional.ofNullable(builder.getBasket()).map(f -> f.build()).orElse(null);
            this.index = Optional.ofNullable(builder.getIndex()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="Asset")
        @RuneAttribute(value="Asset")
        public Asset getAsset() {
            return this.asset;
        }

        @Override
        @RosettaAttribute(value="Basket")
        @RuneAttribute(value="Basket")
        public Basket getBasket() {
            return this.basket;
        }

        @Override
        @RosettaAttribute(value="Index")
        @RuneAttribute(value="Index")
        public Index getIndex() {
            return this.index;
        }

        @Override
        public Observable build() {
            return this;
        }

        @Override
        public ObservableBuilder toBuilder() {
            ObservableBuilder builder = Observable.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ObservableBuilder builder) {
            Optional.ofNullable(this.getAsset()).ifPresent(builder::setAsset);
            Optional.ofNullable(this.getBasket()).ifPresent(builder::setBasket);
            Optional.ofNullable(this.getIndex()).ifPresent(builder::setIndex);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Observable _that = this.getType().cast(o);
            if (!Objects.equals(this.asset, _that.getAsset())) {
                return false;
            }
            if (!Objects.equals(this.basket, _that.getBasket())) {
                return false;
            }
            return Objects.equals(this.index, _that.getIndex());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.asset != null ? this.asset.hashCode() : 0);
            _result = 31 * _result + (this.basket != null ? this.basket.hashCode() : 0);
            _result = 31 * _result + (this.index != null ? this.index.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "Observable {Asset=" + this.asset + ", Basket=" + this.basket + ", Index=" + this.index + '}';
        }
    }
}

