/*
 * Decompiled with CFR 0.152.
 */
package cdm.legaldocumentation.csa.validation.datarule;

import cdm.legaldocumentation.csa.ResolutionValue;
import cdm.legaldocumentation.csa.ValueCashEnum;
import cdm.legaldocumentation.csa.ValueSecuritiesEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="ResolutionValueOtherValues")
@ImplementedBy(value=Default.class)
public interface ResolutionValueOtherValues
extends Validator<ResolutionValue> {
    public static final String NAME = "ResolutionValueOtherValues";
    public static final String DEFINITION = "if cash = ValueCashEnum -> Other or securities = ValueSecuritiesEnum -> Other then additionalLanguage exists";

    public static class NoOp
    implements ResolutionValueOtherValues {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ResolutionValue resolutionValue) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements ResolutionValueOtherValues {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ResolutionValue resolutionValue) {
            ComparisonResult result = this.executeDataRule(resolutionValue);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)ResolutionValueOtherValues.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ResolutionValue", (RosettaPath)path, (String)ResolutionValueOtherValues.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)ResolutionValueOtherValues.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ResolutionValue", (RosettaPath)path, (String)ResolutionValueOtherValues.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(ResolutionValue resolutionValue) {
            try {
                if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)resolutionValue).map("getCash", _resolutionValue -> _resolutionValue.getCash()), (Mapper)MapperS.of((Object)((Object)ValueCashEnum.OTHER)), (CardinalityOperator)CardinalityOperator.All).or(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)resolutionValue).map("getSecurities", _resolutionValue -> _resolutionValue.getSecurities()), (Mapper)MapperS.of((Object)((Object)ValueSecuritiesEnum.OTHER)), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperators.exists((Mapper)MapperS.of((Object)resolutionValue).map("getAdditionalLanguage", _resolutionValue -> _resolutionValue.getAdditionalLanguage()));
                }
                return ComparisonResult.successEmptyOperand((String)"");
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

